/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.esql.Column;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.core.type.DataType;

public class ParseTables {
    public static final Set<DataType> SUPPORTED_TYPES = Set.of(DataType.INTEGER, DataType.KEYWORD, DataType.LONG);
    private static final int MAX_LENGTH = (int)ByteSizeValue.ofMb((long)1L).getBytes();
    private final BlockFactory blockFactory = new BlockFactory((CircuitBreaker)new NoopCircuitBreaker("request"), BigArrays.NON_RECYCLING_INSTANCE);
    private final EsqlQueryRequest request;
    private final XContentParser p;
    private int length;

    ParseTables(EsqlQueryRequest request, XContentParser p) {
        this.request = request;
        this.p = p;
    }

    void parseTables() throws IOException {
        if (this.p.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new XContentParseException(this.p.getTokenLocation(), "expected " + XContentParser.Token.START_OBJECT);
        }
        while (true) {
            switch (this.p.nextToken()) {
                case END_OBJECT: {
                    return;
                }
                case FIELD_NAME: {
                    String name = this.p.currentName();
                    this.p.nextToken();
                    this.request.addTable(name, this.parseTable());
                }
            }
        }
    }

    private Map<String, Column> parseTable() throws IOException {
        LinkedHashMap<String, Column> columns = new LinkedHashMap<String, Column>();
        boolean success = false;
        try {
            if (this.p.currentToken() != XContentParser.Token.START_OBJECT) {
                throw new XContentParseException(this.p.getTokenLocation(), "expected " + XContentParser.Token.START_OBJECT);
            }
            block8: while (true) {
                switch (this.p.nextToken()) {
                    case END_OBJECT: {
                        success = true;
                        LinkedHashMap<String, Column> linkedHashMap = columns;
                        return linkedHashMap;
                    }
                    case FIELD_NAME: {
                        String name = this.p.currentName();
                        if (columns.containsKey(name)) {
                            throw new XContentParseException(this.p.getTokenLocation(), "duplicate column name [" + name + "]");
                        }
                        columns.put(name, this.parseColumn());
                        continue block8;
                    }
                }
                break;
            }
            throw new XContentParseException(this.p.getTokenLocation(), "expected " + XContentParser.Token.END_OBJECT + " or " + XContentParser.Token.FIELD_NAME);
        }
        finally {
            if (!success) {
                Releasables.close(columns.values());
            }
        }
    }

    private Column parseColumn() throws IOException {
        String type;
        if (this.p.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new XContentParseException(this.p.getTokenLocation(), "expected " + XContentParser.Token.START_OBJECT);
        }
        if (this.p.nextToken() != XContentParser.Token.FIELD_NAME) {
            throw new XContentParseException(this.p.getTokenLocation(), "expected " + XContentParser.Token.FIELD_NAME);
        }
        Column result = switch (type = this.p.currentName()) {
            case "integer" -> this.parseIntColumn();
            case "keyword" -> this.parseKeywordColumn();
            case "long" -> this.parseLongColumn();
            case "double" -> this.parseDoubleColumn();
            default -> throw new XContentParseException(this.p.getTokenLocation(), "unsupported type [" + type + "]");
        };
        if (this.p.nextToken() != XContentParser.Token.END_OBJECT) {
            result.close();
            throw new XContentParseException(this.p.getTokenLocation(), "expected " + XContentParser.Token.END_OBJECT);
        }
        return result;
    }

    private Column parseKeywordColumn() throws IOException {
        try (BytesRefBlock.Builder builder = this.blockFactory.newBytesRefBlockBuilder(100);){
            XContentParser.Token token = this.p.nextToken();
            if (token != XContentParser.Token.START_ARRAY) {
                throw new XContentParseException(this.p.getTokenLocation(), "expected " + XContentParser.Token.START_ARRAY);
            }
            BytesRefBuilder scratch = new BytesRefBuilder();
            block12: while (true) {
                switch (this.p.nextToken()) {
                    case END_ARRAY: {
                        Column column = new Column(DataType.KEYWORD, (Block)builder.build());
                        return column;
                    }
                    case START_ARRAY: {
                        this.parseTextArray(builder, scratch);
                        continue block12;
                    }
                    case VALUE_NULL: {
                        builder.appendNull();
                        continue block12;
                    }
                    case VALUE_STRING: 
                    case VALUE_NUMBER: 
                    case VALUE_BOOLEAN: {
                        this.appendText(builder, scratch);
                        continue block12;
                    }
                }
                break;
            }
            throw new XContentParseException(this.p.getTokenLocation(), "expected string, array of strings, or null");
        }
    }

    private void parseTextArray(BytesRefBlock.Builder builder, BytesRefBuilder scratch) throws IOException {
        builder.beginPositionEntry();
        block4: while (true) {
            switch (this.p.nextToken()) {
                case END_ARRAY: {
                    builder.endPositionEntry();
                    return;
                }
                case VALUE_STRING: {
                    this.appendText(builder, scratch);
                    continue block4;
                }
            }
            break;
        }
        throw new XContentParseException(this.p.getTokenLocation(), "expected string");
    }

    private void appendText(BytesRefBlock.Builder builder, BytesRefBuilder scratch) throws IOException {
        scratch.clear();
        String v = this.p.text();
        scratch.copyChars((CharSequence)v, 0, v.length());
        this.length += scratch.length();
        if (this.length > MAX_LENGTH) {
            throw new XContentParseException(this.p.getTokenLocation(), "tables too big");
        }
        builder.appendBytesRef(scratch.get());
    }

    private Column parseIntColumn() throws IOException {
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(100);){
            XContentParser.Token token = this.p.nextToken();
            if (token != XContentParser.Token.START_ARRAY) {
                throw new XContentParseException(this.p.getTokenLocation(), "expected " + XContentParser.Token.START_ARRAY);
            }
            block12: while (true) {
                switch (this.p.nextToken()) {
                    case END_ARRAY: {
                        Column column = new Column(DataType.INTEGER, (Block)builder.build());
                        return column;
                    }
                    case START_ARRAY: {
                        this.parseIntArray(builder);
                        continue block12;
                    }
                    case VALUE_NULL: {
                        builder.appendNull();
                        continue block12;
                    }
                    case VALUE_STRING: 
                    case VALUE_NUMBER: {
                        this.appendInt(builder);
                        continue block12;
                    }
                }
                break;
            }
            throw new XContentParseException(this.p.getTokenLocation(), "expected number, array of numbers, or null");
        }
    }

    private void parseIntArray(IntBlock.Builder builder) throws IOException {
        builder.beginPositionEntry();
        block4: while (true) {
            switch (this.p.nextToken()) {
                case END_ARRAY: {
                    builder.endPositionEntry();
                    return;
                }
                case VALUE_STRING: 
                case VALUE_NUMBER: {
                    this.appendInt(builder);
                    continue block4;
                }
            }
            break;
        }
        throw new XContentParseException(this.p.getTokenLocation(), "expected number");
    }

    private void appendInt(IntBlock.Builder builder) throws IOException {
        this.length += 4;
        if (this.length > MAX_LENGTH) {
            throw new XContentParseException(this.p.getTokenLocation(), "tables too big");
        }
        builder.appendInt(this.p.intValue());
    }

    private Column parseLongColumn() throws IOException {
        try (LongBlock.Builder builder = this.blockFactory.newLongBlockBuilder(100);){
            XContentParser.Token token = this.p.nextToken();
            if (token != XContentParser.Token.START_ARRAY) {
                throw new XContentParseException(this.p.getTokenLocation(), "expected " + XContentParser.Token.START_ARRAY);
            }
            block12: while (true) {
                switch (this.p.nextToken()) {
                    case END_ARRAY: {
                        Column column = new Column(DataType.LONG, (Block)builder.build());
                        return column;
                    }
                    case START_ARRAY: {
                        this.parseLongArray(builder);
                        continue block12;
                    }
                    case VALUE_NULL: {
                        builder.appendNull();
                        continue block12;
                    }
                    case VALUE_STRING: 
                    case VALUE_NUMBER: {
                        this.appendLong(builder);
                        continue block12;
                    }
                }
                break;
            }
            throw new XContentParseException(this.p.getTokenLocation(), "expected number, array of numbers, or null");
        }
    }

    private void parseLongArray(LongBlock.Builder builder) throws IOException {
        builder.beginPositionEntry();
        block4: while (true) {
            switch (this.p.nextToken()) {
                case END_ARRAY: {
                    builder.endPositionEntry();
                    return;
                }
                case VALUE_STRING: 
                case VALUE_NUMBER: {
                    this.appendLong(builder);
                    continue block4;
                }
            }
            break;
        }
        throw new XContentParseException(this.p.getTokenLocation(), "expected number");
    }

    private void appendLong(LongBlock.Builder builder) throws IOException {
        this.length += 8;
        if (this.length > MAX_LENGTH) {
            throw new XContentParseException(this.p.getTokenLocation(), "tables too big");
        }
        builder.appendLong(this.p.longValue());
    }

    private Column parseDoubleColumn() throws IOException {
        try (DoubleBlock.Builder builder = this.blockFactory.newDoubleBlockBuilder(100);){
            XContentParser.Token token = this.p.nextToken();
            if (token != XContentParser.Token.START_ARRAY) {
                throw new XContentParseException(this.p.getTokenLocation(), "expected " + XContentParser.Token.START_ARRAY);
            }
            block12: while (true) {
                switch (this.p.nextToken()) {
                    case END_ARRAY: {
                        Column column = new Column(DataType.DOUBLE, (Block)builder.build());
                        return column;
                    }
                    case START_ARRAY: {
                        this.parseDoubleArray(builder);
                        continue block12;
                    }
                    case VALUE_NULL: {
                        builder.appendNull();
                        continue block12;
                    }
                    case VALUE_STRING: 
                    case VALUE_NUMBER: {
                        this.appendDouble(builder);
                        continue block12;
                    }
                }
                break;
            }
            throw new XContentParseException(this.p.getTokenLocation(), "expected number, array of numbers, or null");
        }
    }

    private void parseDoubleArray(DoubleBlock.Builder builder) throws IOException {
        builder.beginPositionEntry();
        block4: while (true) {
            switch (this.p.nextToken()) {
                case END_ARRAY: {
                    builder.endPositionEntry();
                    return;
                }
                case VALUE_STRING: 
                case VALUE_NUMBER: {
                    this.appendDouble(builder);
                    continue block4;
                }
            }
            break;
        }
        throw new XContentParseException(this.p.getTokenLocation(), "expected number");
    }

    private void appendDouble(DoubleBlock.Builder builder) throws IOException {
        this.length += 8;
        if (this.length > MAX_LENGTH) {
            throw new XContentParseException(this.p.getTokenLocation(), "tables too big");
        }
        builder.appendDouble(this.p.doubleValue());
    }
}

