/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.Build;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.xpack.esql.plugin.EsqlFeatures;

public class EsqlCapabilities {
    public static final Set<String> CAPABILITIES = EsqlCapabilities.capabilities();

    private static Set<String> capabilities() {
        ArrayList<String> caps = new ArrayList<String>();
        for (Cap cap : Cap.values()) {
            if (!Build.current().isSnapshot() && cap.snapshotOnly) continue;
            caps.add(cap.capabilityName());
        }
        for (NodeFeature feature : new EsqlFeatures().getFeatures()) {
            caps.add(EsqlCapabilities.cap(feature));
        }
        for (NodeFeature feature : new EsqlFeatures().getHistoricalFeatures().keySet()) {
            caps.add(EsqlCapabilities.cap(feature));
        }
        return Set.copyOf(caps);
    }

    public static String cap(NodeFeature feature) {
        assert (feature.id().startsWith("esql."));
        return feature.id().substring("esql.".length());
    }

    public static enum Cap {
        FN_CBRT,
        FN_MV_APPEND,
        FN_IP_PREFIX,
        FN_SUBSTRING_EMPTY_NULL,
        AGG_TOP,
        ST_CENTROID_AGG_OPTIMIZED,
        METADATA_IGNORED_FIELD,
        LOOKUP_V4(true),
        REPEAT,
        STRING_LITERAL_AUTO_CASTING_TO_DATETIME_ADD_SUB,
        NAMED_POSITIONAL_PARAMETER,
        UNION_TYPES,
        ST_DISTANCE,
        GROK_DISSECT_MASKING,
        DOUBLE_QUOTES_SOURCE_ENCLOSING,
        AGG_WEIGHTED_AVG,
        UNION_TYPES_AGG_CAST,
        UNION_TYPES_INLINE_FIX,
        UNION_TYPES_REMOVE_FIELDS,
        FIX_PARSING_LARGE_NEGATIVE_NUMBERS,
        FIX_COUNT_DISTINCT_SOURCE_ERROR,
        UNIQUE_NAMES,
        FIXED_PUSHDOWN_PAST_PROJECT;

        private final boolean snapshotOnly;

        private Cap() {
            this.snapshotOnly = false;
        }

        private Cap(boolean snapshotOnly) {
            this.snapshotOnly = snapshotOnly;
        }

        public String capabilityName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean snapshotOnly() {
            return this.snapshotOnly;
        }
    }
}

