/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.shutdown.DeleteShutdownNodeAction;

public class TransportDeleteShutdownNodeAction
extends AcknowledgedTransportMasterNodeAction<DeleteShutdownNodeAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteShutdownNodeAction.class);
    private final RerouteService rerouteService;
    private final MasterServiceTaskQueue<DeleteShutdownNodeTask> taskQueue;

    private static boolean deleteShutdownNodeState(Map<String, SingleNodeShutdownMetadata> shutdownMetadata, DeleteShutdownNodeAction.Request request) {
        if (!shutdownMetadata.containsKey(request.getNodeId())) {
            return false;
        }
        logger.info("removing shutdown record for node [{}]", (Object)request.getNodeId());
        shutdownMetadata.remove(request.getNodeId());
        return true;
    }

    private static void ackAndReroute(final DeleteShutdownNodeAction.Request request, ActionListener<AcknowledgedResponse> listener, RerouteService rerouteService) {
        rerouteService.reroute("node registered for removal from cluster", Priority.URGENT, (ActionListener)new ActionListener<Void>(){

            public void onResponse(Void ignored) {
            }

            public void onFailure(Exception e) {
                logger.warn(() -> "failed to reroute after deleting node [" + request.getNodeId() + "] shutdown", (Throwable)e);
            }
        });
        listener.onResponse((Object)AcknowledgedResponse.TRUE);
    }

    @Inject
    public TransportDeleteShutdownNodeAction(TransportService transportService, ClusterService clusterService, RerouteService rerouteService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/shutdown/delete", false, transportService, clusterService, threadPool, actionFilters, DeleteShutdownNodeAction.Request::readFrom, indexNameExpressionResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.rerouteService = rerouteService;
        this.taskQueue = clusterService.createTaskQueue("delete-node-shutdown", Priority.URGENT, (ClusterStateTaskExecutor)new DeleteShutdownNodeExecutor());
    }

    protected void masterOperation(Task task, DeleteShutdownNodeAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        NodesShutdownMetadata nodesShutdownMetadata = (NodesShutdownMetadata)state.metadata().custom("node_shutdown");
        if (nodesShutdownMetadata == null || nodesShutdownMetadata.get(request.getNodeId()) == null) {
            throw new ResourceNotFoundException("node [" + request.getNodeId() + "] is not currently shutting down", new Object[0]);
        }
        this.taskQueue.submitTask("delete-node-shutdown-" + request.getNodeId(), (ClusterStateTaskListener)new DeleteShutdownNodeTask(request, listener), request.masterNodeTimeout());
    }

    protected ClusterBlockException checkBlock(DeleteShutdownNodeAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    class DeleteShutdownNodeExecutor
    implements ClusterStateTaskExecutor<DeleteShutdownNodeTask> {
        DeleteShutdownNodeExecutor() {
        }

        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<DeleteShutdownNodeTask> batchExecutionContext) throws Exception {
            HashMap<String, SingleNodeShutdownMetadata> shutdownMetadata = new HashMap<String, SingleNodeShutdownMetadata>(batchExecutionContext.initialState().metadata().nodeShutdowns().getAll());
            boolean changed = false;
            for (ClusterStateTaskExecutor.TaskContext taskContext : batchExecutionContext.taskContexts()) {
                DeleteShutdownNodeAction.Request request = ((DeleteShutdownNodeTask)taskContext.getTask()).request();
                try (Releasable ignored = taskContext.captureResponseHeaders();){
                    changed |= TransportDeleteShutdownNodeAction.deleteShutdownNodeState(shutdownMetadata, request);
                }
                catch (Exception e) {
                    taskContext.onFailure(e);
                    continue;
                }
                taskContext.success(() -> TransportDeleteShutdownNodeAction.ackAndReroute(request, ((DeleteShutdownNodeTask)taskContext.getTask()).listener(), TransportDeleteShutdownNodeAction.this.rerouteService));
            }
            if (!changed) {
                return batchExecutionContext.initialState();
            }
            return ClusterState.builder((ClusterState)batchExecutionContext.initialState()).metadata(Metadata.builder((Metadata)batchExecutionContext.initialState().metadata()).putCustom("node_shutdown", (Metadata.Custom)new NodesShutdownMetadata(shutdownMetadata))).build();
        }
    }

    record DeleteShutdownNodeTask(DeleteShutdownNodeAction.Request request, ActionListener<AcknowledgedResponse> listener) implements ClusterStateTaskListener
    {
        public void onFailure(Exception e) {
            logger.error(() -> "failed to delete shutdown for node [" + this.request.getNodeId() + "]", (Throwable)e);
            this.listener.onFailure(e);
        }
    }
}

