/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.shutdown.ShutdownPlugin;

public class PutShutdownNodeAction
extends ActionType<AcknowledgedResponse> {
    public static final PutShutdownNodeAction INSTANCE = new PutShutdownNodeAction();
    public static final String NAME = "cluster:admin/shutdown/create";

    public PutShutdownNodeAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String nodeId;
        private final SingleNodeShutdownMetadata.Type type;
        private final String reason;
        @Nullable
        private final TimeValue allocationDelay;
        @Nullable
        private final String targetNodeName;
        @Nullable
        private final TimeValue gracePeriod;
        private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
        private static final ParseField REASON_FIELD = new ParseField("reason", new String[0]);
        private static final ParseField ALLOCATION_DELAY_FIELD = new ParseField("allocation_delay", new String[0]);
        private static final ParseField TARGET_NODE_FIELD = new ParseField("target_node_name", new String[0]);
        public static final ParseField GRACE_PERIOD_FIELD = new ParseField("grace_period", new String[0]);
        private static final ConstructingObjectParser<Request, Factory> PARSER = new ConstructingObjectParser("put_node_shutdown_request", false, (a, factory) -> factory.create(SingleNodeShutdownMetadata.Type.parse((String)((String)a[0])), (String)a[1], a[2] == null ? null : TimeValue.parseTimeValue((String)((String)a[2]), (String)factory.toString()), (String)a[3], a[4] == null ? null : TimeValue.parseTimeValue((String)((String)a[4]), (String)factory.toString())));

        public static Request parseRequest(Factory factory, XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, (Object)factory));
        }

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String nodeId, SingleNodeShutdownMetadata.Type type, String reason, @Nullable TimeValue allocationDelay, @Nullable String targetNodeName, @Nullable TimeValue gracePeriod) {
            super(masterNodeTimeout, ackTimeout);
            this.nodeId = nodeId;
            this.type = type;
            this.reason = reason;
            this.allocationDelay = allocationDelay;
            this.targetNodeName = targetNodeName;
            this.gracePeriod = gracePeriod;
        }

        public static Request readFrom(StreamInput in) throws IOException {
            if (ShutdownPlugin.serializesWithParentTaskAndTimeouts(in.getTransportVersion())) {
                return new Request(in);
            }
            return new Request(TimeValue.THIRTY_SECONDS, TimeValue.THIRTY_SECONDS, in);
        }

        private Request(StreamInput in) throws IOException {
            super(in);
            assert (ShutdownPlugin.serializesWithParentTaskAndTimeouts(in.getTransportVersion()));
            this.nodeId = in.readString();
            this.type = (SingleNodeShutdownMetadata.Type)in.readEnum(SingleNodeShutdownMetadata.Type.class);
            this.reason = in.readString();
            this.allocationDelay = in.readOptionalTimeValue();
            this.targetNodeName = in.readOptionalString();
            this.gracePeriod = in.readOptionalTimeValue();
        }

        private Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, StreamInput in) throws IOException {
            super(masterNodeTimeout, ackTimeout);
            assert (!ShutdownPlugin.serializesWithParentTaskAndTimeouts(in.getTransportVersion()));
            this.nodeId = in.readString();
            this.type = (SingleNodeShutdownMetadata.Type)in.readEnum(SingleNodeShutdownMetadata.Type.class);
            this.reason = in.readString();
            this.allocationDelay = in.readOptionalTimeValue();
            this.targetNodeName = in.getTransportVersion().onOrAfter((VersionId)SingleNodeShutdownMetadata.REPLACE_SHUTDOWN_TYPE_ADDED_VERSION) ? in.readOptionalString() : null;
            this.gracePeriod = in.getTransportVersion().onOrAfter((VersionId)SingleNodeShutdownMetadata.GRACE_PERIOD_ADDED_VERSION) ? in.readOptionalTimeValue() : null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (ShutdownPlugin.serializesWithParentTaskAndTimeouts(out.getTransportVersion())) {
                super.writeTo(out);
            }
            out.writeString(this.nodeId);
            if (out.getTransportVersion().before((VersionId)SingleNodeShutdownMetadata.REPLACE_SHUTDOWN_TYPE_ADDED_VERSION) && this.type == SingleNodeShutdownMetadata.Type.REPLACE) {
                out.writeEnum((Enum)SingleNodeShutdownMetadata.Type.REMOVE);
            } else {
                out.writeEnum((Enum)this.type);
            }
            out.writeString(this.reason);
            out.writeOptionalTimeValue(this.allocationDelay);
            if (out.getTransportVersion().onOrAfter((VersionId)SingleNodeShutdownMetadata.REPLACE_SHUTDOWN_TYPE_ADDED_VERSION)) {
                out.writeOptionalString(this.targetNodeName);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)SingleNodeShutdownMetadata.GRACE_PERIOD_ADDED_VERSION)) {
                out.writeOptionalTimeValue(this.gracePeriod);
            }
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public SingleNodeShutdownMetadata.Type getType() {
            return this.type;
        }

        public String getReason() {
            return this.reason;
        }

        public TimeValue getAllocationDelay() {
            return this.allocationDelay;
        }

        public String getTargetNodeName() {
            return this.targetNodeName;
        }

        public TimeValue getGracePeriod() {
            return this.gracePeriod;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException arve = new ActionRequestValidationException();
            if (!org.elasticsearch.common.Strings.hasText((String)this.nodeId)) {
                arve.addValidationError("the node id to shutdown is required");
            }
            if (this.type == null) {
                arve.addValidationError("the shutdown type is required");
            }
            if (!org.elasticsearch.common.Strings.hasText((String)this.nodeId)) {
                arve.addValidationError("the reason for shutdown is required");
            }
            if (this.allocationDelay != null && !SingleNodeShutdownMetadata.Type.RESTART.equals((Object)this.type)) {
                arve.addValidationError(ALLOCATION_DELAY_FIELD + " is only allowed for RESTART-type shutdown requests");
            }
            if (this.targetNodeName != null && this.type != SingleNodeShutdownMetadata.Type.REPLACE) {
                arve.addValidationError(Strings.format((String)"target node name is only valid for REPLACE type shutdowns, but was given type [%s] and target node name [%s]", (Object[])new Object[]{this.type, this.targetNodeName}));
            } else if (this.targetNodeName == null && this.type == SingleNodeShutdownMetadata.Type.REPLACE) {
                arve.addValidationError("target node name is required for REPLACE type shutdowns");
            }
            if (SingleNodeShutdownMetadata.Type.SIGTERM.equals((Object)this.type)) {
                if (this.gracePeriod == null) {
                    arve.addValidationError("grace period is required for SIGTERM shutdowns");
                }
            } else if (this.gracePeriod != null) {
                arve.addValidationError(Strings.format((String)"grace period is only valid for SIGTERM type shutdowns, but was given type [%s] and target node name [%s]", (Object[])new Object[]{this.type, this.targetNodeName}));
            }
            if (!arve.validationErrors().isEmpty()) {
                return arve;
            }
            return null;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), REASON_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ALLOCATION_DELAY_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TARGET_NODE_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), GRACE_PERIOD_FIELD);
        }

        public static interface Factory {
            public Request create(SingleNodeShutdownMetadata.Type var1, String var2, @Nullable TimeValue var3, @Nullable String var4, @Nullable TimeValue var5);
        }
    }
}

