/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.direct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.ingest.geoip.IngestGeoIpMetadata;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfigurationMetadata;
import org.elasticsearch.ingest.geoip.direct.GetDatabaseConfigurationAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDatabaseConfigurationAction
extends TransportMasterNodeAction<GetDatabaseConfigurationAction.Request, GetDatabaseConfigurationAction.Response> {
    @Inject
    public TransportGetDatabaseConfigurationAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/ingest/geoip/database/get", transportService, clusterService, threadPool, actionFilters, GetDatabaseConfigurationAction.Request::new, indexNameExpressionResolver, GetDatabaseConfigurationAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void masterOperation(Task task, GetDatabaseConfigurationAction.Request request, ClusterState state, ActionListener<GetDatabaseConfigurationAction.Response> listener) {
        Set<String> ids = request.getDatabaseIds().length == 0 ? Set.of("*") : new LinkedHashSet<String>(Arrays.asList(request.getDatabaseIds()));
        if (ids.size() > 1 && ids.stream().anyMatch(Regex::isSimpleMatchPattern)) {
            throw new IllegalArgumentException("wildcard only supports a single value, please use comma-separated values or a single wildcard value");
        }
        IngestGeoIpMetadata geoIpMeta = (IngestGeoIpMetadata)state.metadata().custom("ingest_geoip", (Metadata.Custom)IngestGeoIpMetadata.EMPTY);
        ArrayList<DatabaseConfigurationMetadata> results = new ArrayList<DatabaseConfigurationMetadata>();
        for (String id : ids) {
            if (Regex.isSimpleMatchPattern((String)id)) {
                for (Map.Entry<String, DatabaseConfigurationMetadata> entry : geoIpMeta.getDatabases().entrySet()) {
                    if (!Regex.simpleMatch((String)id, (String)entry.getKey())) continue;
                    results.add(entry.getValue());
                }
                continue;
            }
            DatabaseConfigurationMetadata meta = geoIpMeta.getDatabases().get(id);
            if (meta == null) {
                listener.onFailure((Exception)new ResourceNotFoundException("database configuration not found: {}", new Object[]{id}));
                return;
            }
            results.add(meta);
        }
        listener.onResponse((Object)new GetDatabaseConfigurationAction.Response(results));
    }

    protected ClusterBlockException checkBlock(GetDatabaseConfigurationAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

