/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.direct;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfiguration;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class PutDatabaseConfigurationAction
extends ActionType<AcknowledgedResponse> {
    public static final PutDatabaseConfigurationAction INSTANCE = new PutDatabaseConfigurationAction();
    public static final String NAME = "cluster:admin/ingest/geoip/database/put";

    protected PutDatabaseConfigurationAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final DatabaseConfiguration database;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, DatabaseConfiguration database) {
            super(masterNodeTimeout, ackTimeout);
            this.database = database;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.database = new DatabaseConfiguration(in);
        }

        public DatabaseConfiguration getDatabase() {
            return this.database;
        }

        public static Request parseRequest(TimeValue masterNodeTimeout, TimeValue ackTimeout, String id, XContentParser parser) {
            return new Request(masterNodeTimeout, ackTimeout, DatabaseConfiguration.parse(parser, id));
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.database.writeTo(out);
        }

        public ActionRequestValidationException validate() {
            return this.database.validate();
        }

        public int hashCode() {
            return Objects.hash(this.database);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return this.database.equals(other.database);
        }

        public String toString() {
            return Strings.toString((b, p) -> b.field(this.database.id(), (ToXContent)this.database));
        }
    }
}

