/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.direct;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfiguration;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfigurationMetadata;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDatabaseConfigurationAction
extends ActionType<Response> {
    public static final GetDatabaseConfigurationAction INSTANCE = new GetDatabaseConfigurationAction();
    public static final String NAME = "cluster:admin/ingest/geoip/database/get";

    protected GetDatabaseConfigurationAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<DatabaseConfigurationMetadata> databases;

        public Response(List<DatabaseConfigurationMetadata> databases) {
            this.databases = List.copyOf(databases);
        }

        public Response(StreamInput in) throws IOException {
            this(in.readCollectionAsList(DatabaseConfigurationMetadata::new));
        }

        public List<DatabaseConfigurationMetadata> getDatabases() {
            return this.databases;
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("databases");
            for (DatabaseConfigurationMetadata item : this.databases) {
                DatabaseConfiguration database = item.database();
                builder.startObject();
                builder.field("id", database.id());
                builder.field(DatabaseConfigurationMetadata.VERSION.getPreferredName(), item.version());
                builder.timeField(DatabaseConfigurationMetadata.MODIFIED_DATE_MILLIS.getPreferredName(), DatabaseConfigurationMetadata.MODIFIED_DATE.getPreferredName(), item.modifiedDate());
                builder.field(DatabaseConfigurationMetadata.DATABASE.getPreferredName(), (ToXContent)database);
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.databases);
        }

        public int hashCode() {
            return Objects.hash(this.databases);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return this.databases.equals(other.databases);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String[] databaseIds;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String ... databaseIds) {
            super(masterNodeTimeout, ackTimeout);
            this.databaseIds = Objects.requireNonNull(databaseIds, "ids may not be null");
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.databaseIds = in.readStringArray();
        }

        public String[] getDatabaseIds() {
            return this.databaseIds;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.databaseIds);
        }

        public int hashCode() {
            return Arrays.hashCode(this.databaseIds);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Arrays.equals(this.databaseIds, other.databaseIds);
        }
    }
}

