/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.direct;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DatabaseConfiguration(String id, String name, Maxmind maxmind) implements Writeable,
ToXContentObject
{
    private static final Pattern ID_PATTERN = Pattern.compile("\\p{Alnum}[_\\-\\p{Alnum}]{0,126}");
    public static final Set<String> MAXMIND_NAMES = Set.of("GeoIP2-Anonymous-IP", "GeoIP2-City", "GeoIP2-Connection-Type", "GeoIP2-Country", "GeoIP2-Domain", "GeoIP2-Enterprise", "GeoIP2-ISP");
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField MAXMIND = new ParseField("maxmind", new String[0]);
    private static final ConstructingObjectParser<DatabaseConfiguration, String> PARSER = new ConstructingObjectParser("database", false, (a, id) -> {
        String name = (String)a[0];
        Maxmind maxmind = (Maxmind)a[1];
        return new DatabaseConfiguration((String)id, name, maxmind);
    });

    public DatabaseConfiguration {
        Objects.requireNonNull(id);
        Objects.requireNonNull(name);
        Objects.requireNonNull(maxmind);
    }

    public DatabaseConfiguration(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), new Maxmind(in));
    }

    public static DatabaseConfiguration parse(XContentParser parser, String id) {
        return (DatabaseConfiguration)PARSER.apply(parser, (Object)id);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.name);
        this.maxmind.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("maxmind", (ToXContent)this.maxmind);
        builder.endObject();
        return builder;
    }

    static void validateId(String id) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)id)) {
            throw new IllegalArgumentException("invalid database configuration id [" + id + "]: must not be null or empty");
        }
        MetadataCreateIndexService.validateIndexOrAliasName((String)id, (id1, description) -> new IllegalArgumentException("invalid database configuration id [" + id1 + "]: " + description));
        int byteCount = id.getBytes(StandardCharsets.UTF_8).length;
        if (byteCount > 127) {
            throw new IllegalArgumentException("invalid database configuration id [" + id + "]: id is too long, (" + byteCount + " > 127)");
        }
        if (!ID_PATTERN.matcher(id).matches()) {
            throw new IllegalArgumentException("invalid database configuration id [" + id + "]: id doesn't match required rules (alphanumerics, dashes, and underscores, only)");
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException err = new ActionRequestValidationException();
        if (!Strings.hasText((String)this.name)) {
            err.addValidationError("invalid name [" + this.name + "]: cannot be empty");
        }
        if (!MAXMIND_NAMES.contains(this.name)) {
            err.addValidationError("invalid name [" + this.name + "]: must be a supported name ([" + MAXMIND_NAMES + "])");
        }
        try {
            DatabaseConfiguration.validateId(this.id);
        }
        catch (IllegalArgumentException e) {
            err.addValidationError(e.getMessage());
        }
        return err.validationErrors().isEmpty() ? null : err;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, id) -> (Maxmind)Maxmind.PARSER.apply(parser, null), MAXMIND);
    }

    public record Maxmind(String accountId) implements Writeable,
    ToXContentObject
    {
        private static final ParseField ACCOUNT_ID = new ParseField("account_id", new String[0]);
        private static final ConstructingObjectParser<Maxmind, Void> PARSER = new ConstructingObjectParser("database", false, (a, id) -> {
            String accountId = (String)a[0];
            return new Maxmind(accountId);
        });

        public Maxmind {
            Objects.requireNonNull(accountId);
        }

        public Maxmind(StreamInput in) throws IOException {
            this(in.readString());
        }

        public static Maxmind parse(XContentParser parser) {
            return (Maxmind)PARSER.apply(parser, null);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.accountId);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("account_id", this.accountId);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), ACCOUNT_ID);
        }
    }
}

