/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.db.Network;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.ConnectionTypeResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.DomainResponse;
import com.maxmind.geoip2.model.EnterpriseResponse;
import com.maxmind.geoip2.model.IspResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Subdivision;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.geoip.Database;
import org.elasticsearch.ingest.geoip.GeoIpDatabase;
import org.elasticsearch.ingest.geoip.GeoIpDatabaseProvider;

public final class GeoIpProcessor
extends AbstractProcessor {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(GeoIpProcessor.class);
    static final String DEFAULT_DATABASES_DEPRECATION_MESSAGE = "the [fallback_to_default_databases] has been deprecated, because Elasticsearch no longer includes the default Maxmind geoip databases. This setting will be removed in Elasticsearch 9.0";
    public static final String TYPE = "geoip";
    private final String field;
    private final Supplier<Boolean> isValid;
    private final String targetField;
    private final CheckedSupplier<GeoIpDatabase, IOException> supplier;
    private final Set<Database.Property> properties;
    private final boolean ignoreMissing;
    private final boolean firstOnly;
    private final String databaseFile;

    GeoIpProcessor(String tag, String description, String field, CheckedSupplier<GeoIpDatabase, IOException> supplier, Supplier<Boolean> isValid, String targetField, Set<Database.Property> properties, boolean ignoreMissing, boolean firstOnly, String databaseFile) {
        super(tag, description);
        this.field = field;
        this.isValid = isValid;
        this.targetField = targetField;
        this.supplier = supplier;
        this.properties = properties;
        this.ignoreMissing = ignoreMissing;
        this.firstOnly = firstOnly;
        this.databaseFile = databaseFile;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IngestDocument execute(IngestDocument ingestDocument) throws IOException {
        block17: {
            Object ip = ingestDocument.getFieldValue(this.field, Object.class, this.ignoreMissing);
            if (!this.isValid.get().booleanValue()) {
                ingestDocument.appendFieldValue("tags", (Object)"_geoip_expired_database", false);
                return ingestDocument;
            }
            if (ip == null && this.ignoreMissing) {
                return ingestDocument;
            }
            if (ip == null) {
                throw new IllegalArgumentException("field [" + this.field + "] is null, cannot extract geoip information.");
            }
            GeoIpDatabase geoIpDatabase = (GeoIpDatabase)this.supplier.get();
            if (geoIpDatabase == null) {
                if (!this.ignoreMissing) {
                    GeoIpProcessor.tag(ingestDocument, this.databaseFile);
                }
                return ingestDocument;
            }
            try {
                if (ip instanceof String) {
                    String ipString = (String)ip;
                    Map<String, Object> geoData = this.getGeoData(geoIpDatabase, ipString);
                    if (!geoData.isEmpty()) {
                        ingestDocument.setFieldValue(this.targetField, geoData);
                    }
                    break block17;
                }
                if (ip instanceof List) {
                    List ipList = (List)ip;
                    boolean match = false;
                    ArrayList<Map<String, Object>> geoDataList = new ArrayList<Map<String, Object>>(ipList.size());
                    for (Object ipAddr : ipList) {
                        if (!(ipAddr instanceof String)) {
                            throw new IllegalArgumentException("array in field [" + this.field + "] should only contain strings");
                        }
                        Map<String, Object> geoData = this.getGeoData(geoIpDatabase, (String)ipAddr);
                        if (geoData.isEmpty()) {
                            geoDataList.add(null);
                            continue;
                        }
                        if (this.firstOnly) {
                            ingestDocument.setFieldValue(this.targetField, geoData);
                            IngestDocument ingestDocument2 = ingestDocument;
                            return ingestDocument2;
                        }
                        match = true;
                        geoDataList.add(geoData);
                    }
                    if (match) {
                        ingestDocument.setFieldValue(this.targetField, geoDataList);
                    }
                    break block17;
                }
                throw new IllegalArgumentException("field [" + this.field + "] should contain only string or array of strings");
            }
            finally {
                geoIpDatabase.release();
            }
        }
        return ingestDocument;
    }

    private Map<String, Object> getGeoData(GeoIpDatabase geoIpDatabase, String ip) throws IOException {
        Database database;
        String databaseType = geoIpDatabase.getDatabaseType();
        try {
            database = Database.getDatabase(databaseType, this.databaseFile);
        }
        catch (IllegalArgumentException e) {
            throw new ElasticsearchParseException(e.getMessage(), (Throwable)e, new Object[0]);
        }
        InetAddress ipAddress = InetAddresses.forString((String)ip);
        return switch (database) {
            default -> throw new IncompatibleClassChangeError();
            case Database.City -> this.retrieveCityGeoData(geoIpDatabase, ipAddress);
            case Database.Country -> this.retrieveCountryGeoData(geoIpDatabase, ipAddress);
            case Database.Asn -> this.retrieveAsnGeoData(geoIpDatabase, ipAddress);
            case Database.AnonymousIp -> this.retrieveAnonymousIpGeoData(geoIpDatabase, ipAddress);
            case Database.ConnectionType -> this.retrieveConnectionTypeGeoData(geoIpDatabase, ipAddress);
            case Database.Domain -> this.retrieveDomainGeoData(geoIpDatabase, ipAddress);
            case Database.Enterprise -> this.retrieveEnterpriseGeoData(geoIpDatabase, ipAddress);
            case Database.Isp -> this.retrieveIspGeoData(geoIpDatabase, ipAddress);
        };
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    String getDatabaseType() throws IOException {
        return ((GeoIpDatabase)this.supplier.get()).getDatabaseType();
    }

    Set<Database.Property> getProperties() {
        return this.properties;
    }

    private Map<String, Object> retrieveCityGeoData(GeoIpDatabase geoIpDatabase, InetAddress ipAddress) {
        CityResponse response = geoIpDatabase.getCity(ipAddress);
        if (response == null) {
            return Map.of();
        }
        Country country = response.getCountry();
        City city = response.getCity();
        Location location = response.getLocation();
        Continent continent = response.getContinent();
        Subdivision subdivision = response.getMostSpecificSubdivision();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        block12: for (Database.Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case COUNTRY_ISO_CODE: {
                    String countryIsoCode = country.getIsoCode();
                    if (countryIsoCode == null) continue block12;
                    geoData.put("country_iso_code", countryIsoCode);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = country.getName();
                    if (countryName == null) continue block12;
                    geoData.put("country_name", countryName);
                    break;
                }
                case CONTINENT_CODE: {
                    String continentCode = continent.getCode();
                    if (continentCode == null) continue block12;
                    geoData.put("continent_code", continentCode);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = continent.getName();
                    if (continentName == null) continue block12;
                    geoData.put("continent_name", continentName);
                    break;
                }
                case REGION_ISO_CODE: {
                    String countryIso = country.getIsoCode();
                    String subdivisionIso = subdivision.getIsoCode();
                    if (countryIso == null || subdivisionIso == null) continue block12;
                    String regionIsoCode = countryIso + "-" + subdivisionIso;
                    geoData.put("region_iso_code", regionIsoCode);
                    break;
                }
                case REGION_NAME: {
                    String subdivisionName = subdivision.getName();
                    if (subdivisionName == null) continue block12;
                    geoData.put("region_name", subdivisionName);
                    break;
                }
                case CITY_NAME: {
                    String cityName = city.getName();
                    if (cityName == null) continue block12;
                    geoData.put("city_name", cityName);
                    break;
                }
                case TIMEZONE: {
                    String locationTimeZone = location.getTimeZone();
                    if (locationTimeZone == null) continue block12;
                    geoData.put("timezone", locationTimeZone);
                    break;
                }
                case LOCATION: {
                    Double latitude = location.getLatitude();
                    Double longitude = location.getLongitude();
                    if (latitude == null || longitude == null) break;
                    HashMap<String, Double> locationObject = new HashMap<String, Double>();
                    locationObject.put("lat", latitude);
                    locationObject.put("lon", longitude);
                    geoData.put("location", locationObject);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveCountryGeoData(GeoIpDatabase geoIpDatabase, InetAddress ipAddress) {
        CountryResponse response = geoIpDatabase.getCountry(ipAddress);
        if (response == null) {
            return Map.of();
        }
        Country country = response.getCountry();
        Continent continent = response.getContinent();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        block7: for (Database.Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case COUNTRY_ISO_CODE: {
                    String countryIsoCode = country.getIsoCode();
                    if (countryIsoCode == null) continue block7;
                    geoData.put("country_iso_code", countryIsoCode);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = country.getName();
                    if (countryName == null) continue block7;
                    geoData.put("country_name", countryName);
                    break;
                }
                case CONTINENT_CODE: {
                    String continentCode = continent.getCode();
                    if (continentCode == null) continue block7;
                    geoData.put("continent_code", continentCode);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = continent.getName();
                    if (continentName == null) break;
                    geoData.put("continent_name", continentName);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveAsnGeoData(GeoIpDatabase geoIpDatabase, InetAddress ipAddress) {
        AsnResponse response = geoIpDatabase.getAsn(ipAddress);
        if (response == null) {
            return Map.of();
        }
        Long asn = response.getAutonomousSystemNumber();
        String organizationName = response.getAutonomousSystemOrganization();
        Network network = response.getNetwork();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Database.Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case ASN: {
                    if (asn == null) break;
                    geoData.put("asn", asn);
                    break;
                }
                case ORGANIZATION_NAME: {
                    if (organizationName == null) break;
                    geoData.put("organization_name", organizationName);
                    break;
                }
                case NETWORK: {
                    if (network == null) break;
                    geoData.put("network", network.toString());
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveAnonymousIpGeoData(GeoIpDatabase geoIpDatabase, InetAddress ipAddress) {
        AnonymousIpResponse response = geoIpDatabase.getAnonymousIp(ipAddress);
        if (response == null) {
            return Map.of();
        }
        boolean isHostingProvider = response.isHostingProvider();
        boolean isTorExitNode = response.isTorExitNode();
        boolean isAnonymousVpn = response.isAnonymousVpn();
        boolean isAnonymous = response.isAnonymous();
        boolean isPublicProxy = response.isPublicProxy();
        boolean isResidentialProxy = response.isResidentialProxy();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Database.Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case HOSTING_PROVIDER: {
                    geoData.put("hosting_provider", isHostingProvider);
                    break;
                }
                case TOR_EXIT_NODE: {
                    geoData.put("tor_exit_node", isTorExitNode);
                    break;
                }
                case ANONYMOUS_VPN: {
                    geoData.put("anonymous_vpn", isAnonymousVpn);
                    break;
                }
                case ANONYMOUS: {
                    geoData.put("anonymous", isAnonymous);
                    break;
                }
                case PUBLIC_PROXY: {
                    geoData.put("public_proxy", isPublicProxy);
                    break;
                }
                case RESIDENTIAL_PROXY: {
                    geoData.put("residential_proxy", isResidentialProxy);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveConnectionTypeGeoData(GeoIpDatabase geoIpDatabase, InetAddress ipAddress) {
        ConnectionTypeResponse response = geoIpDatabase.getConnectionType(ipAddress);
        if (response == null) {
            return Map.of();
        }
        ConnectionTypeResponse.ConnectionType connectionType = response.getConnectionType();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Database.Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case CONNECTION_TYPE: {
                    if (connectionType == null) break;
                    geoData.put("connection_type", connectionType.toString());
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveDomainGeoData(GeoIpDatabase geoIpDatabase, InetAddress ipAddress) {
        DomainResponse response = geoIpDatabase.getDomain(ipAddress);
        if (response == null) {
            return Map.of();
        }
        String domain = response.getDomain();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Database.Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case DOMAIN: {
                    if (domain == null) break;
                    geoData.put("domain", domain);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveEnterpriseGeoData(GeoIpDatabase geoIpDatabase, InetAddress ipAddress) {
        EnterpriseResponse response = geoIpDatabase.getEnterprise(ipAddress);
        if (response == null) {
            return Map.of();
        }
        Country country = response.getCountry();
        City city = response.getCity();
        Location location = response.getLocation();
        Continent continent = response.getContinent();
        Subdivision subdivision = response.getMostSpecificSubdivision();
        Long asn = response.getTraits().getAutonomousSystemNumber();
        String organizationName = response.getTraits().getAutonomousSystemOrganization();
        Network network = response.getTraits().getNetwork();
        String isp = response.getTraits().getIsp();
        String ispOrganization = response.getTraits().getOrganization();
        String mobileCountryCode = response.getTraits().getMobileCountryCode();
        String mobileNetworkCode = response.getTraits().getMobileNetworkCode();
        boolean isHostingProvider = response.getTraits().isHostingProvider();
        boolean isTorExitNode = response.getTraits().isTorExitNode();
        boolean isAnonymousVpn = response.getTraits().isAnonymousVpn();
        boolean isAnonymous = response.getTraits().isAnonymous();
        boolean isPublicProxy = response.getTraits().isPublicProxy();
        boolean isResidentialProxy = response.getTraits().isResidentialProxy();
        String userType = response.getTraits().getUserType();
        String domain = response.getTraits().getDomain();
        ConnectionTypeResponse.ConnectionType connectionType = response.getTraits().getConnectionType();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        block28: for (Database.Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case COUNTRY_ISO_CODE: {
                    String countryIsoCode = country.getIsoCode();
                    if (countryIsoCode == null) continue block28;
                    geoData.put("country_iso_code", countryIsoCode);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = country.getName();
                    if (countryName == null) continue block28;
                    geoData.put("country_name", countryName);
                    break;
                }
                case CONTINENT_CODE: {
                    String continentCode = continent.getCode();
                    if (continentCode == null) continue block28;
                    geoData.put("continent_code", continentCode);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = continent.getName();
                    if (continentName == null) continue block28;
                    geoData.put("continent_name", continentName);
                    break;
                }
                case REGION_ISO_CODE: {
                    String countryIso = country.getIsoCode();
                    String subdivisionIso = subdivision.getIsoCode();
                    if (countryIso == null || subdivisionIso == null) continue block28;
                    String regionIsoCode = countryIso + "-" + subdivisionIso;
                    geoData.put("region_iso_code", regionIsoCode);
                    break;
                }
                case REGION_NAME: {
                    String subdivisionName = subdivision.getName();
                    if (subdivisionName == null) continue block28;
                    geoData.put("region_name", subdivisionName);
                    break;
                }
                case CITY_NAME: {
                    String cityName = city.getName();
                    if (cityName == null) continue block28;
                    geoData.put("city_name", cityName);
                    break;
                }
                case TIMEZONE: {
                    String locationTimeZone = location.getTimeZone();
                    if (locationTimeZone == null) continue block28;
                    geoData.put("timezone", locationTimeZone);
                    break;
                }
                case LOCATION: {
                    Double latitude = location.getLatitude();
                    Double longitude = location.getLongitude();
                    if (latitude == null || longitude == null) continue block28;
                    HashMap<String, Double> locationObject = new HashMap<String, Double>();
                    locationObject.put("lat", latitude);
                    locationObject.put("lon", longitude);
                    geoData.put("location", locationObject);
                    break;
                }
                case ASN: {
                    if (asn == null) break;
                    geoData.put("asn", asn);
                    break;
                }
                case ORGANIZATION_NAME: {
                    if (organizationName == null) break;
                    geoData.put("organization_name", organizationName);
                    break;
                }
                case NETWORK: {
                    if (network == null) break;
                    geoData.put("network", network.toString());
                    break;
                }
                case HOSTING_PROVIDER: {
                    geoData.put("hosting_provider", isHostingProvider);
                    break;
                }
                case TOR_EXIT_NODE: {
                    geoData.put("tor_exit_node", isTorExitNode);
                    break;
                }
                case ANONYMOUS_VPN: {
                    geoData.put("anonymous_vpn", isAnonymousVpn);
                    break;
                }
                case ANONYMOUS: {
                    geoData.put("anonymous", isAnonymous);
                    break;
                }
                case PUBLIC_PROXY: {
                    geoData.put("public_proxy", isPublicProxy);
                    break;
                }
                case RESIDENTIAL_PROXY: {
                    geoData.put("residential_proxy", isResidentialProxy);
                    break;
                }
                case DOMAIN: {
                    if (domain == null) break;
                    geoData.put("domain", domain);
                    break;
                }
                case ISP: {
                    if (isp == null) break;
                    geoData.put("isp", isp);
                    break;
                }
                case ISP_ORGANIZATION_NAME: {
                    if (ispOrganization == null) break;
                    geoData.put("isp_organization_name", ispOrganization);
                    break;
                }
                case MOBILE_COUNTRY_CODE: {
                    if (mobileCountryCode == null) break;
                    geoData.put("mobile_country_code", mobileCountryCode);
                    break;
                }
                case MOBILE_NETWORK_CODE: {
                    if (mobileNetworkCode == null) break;
                    geoData.put("mobile_network_code", mobileNetworkCode);
                    break;
                }
                case USER_TYPE: {
                    if (userType == null) break;
                    geoData.put("user_type", userType);
                    break;
                }
                case CONNECTION_TYPE: {
                    if (connectionType == null) break;
                    geoData.put("connection_type", connectionType.toString());
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveIspGeoData(GeoIpDatabase geoIpDatabase, InetAddress ipAddress) {
        IspResponse response = geoIpDatabase.getIsp(ipAddress);
        if (response == null) {
            return Map.of();
        }
        String isp = response.getIsp();
        String ispOrganization = response.getOrganization();
        String mobileNetworkCode = response.getMobileNetworkCode();
        String mobileCountryCode = response.getMobileCountryCode();
        Long asn = response.getAutonomousSystemNumber();
        String organizationName = response.getAutonomousSystemOrganization();
        Network network = response.getNetwork();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Database.Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case ASN: {
                    if (asn == null) break;
                    geoData.put("asn", asn);
                    break;
                }
                case ORGANIZATION_NAME: {
                    if (organizationName == null) break;
                    geoData.put("organization_name", organizationName);
                    break;
                }
                case NETWORK: {
                    if (network == null) break;
                    geoData.put("network", network.toString());
                    break;
                }
                case ISP: {
                    if (isp == null) break;
                    geoData.put("isp", isp);
                    break;
                }
                case ISP_ORGANIZATION_NAME: {
                    if (ispOrganization == null) break;
                    geoData.put("isp_organization_name", ispOrganization);
                    break;
                }
                case MOBILE_COUNTRY_CODE: {
                    if (mobileCountryCode == null) break;
                    geoData.put("mobile_country_code", mobileCountryCode);
                    break;
                }
                case MOBILE_NETWORK_CODE: {
                    if (mobileNetworkCode == null) break;
                    geoData.put("mobile_network_code", mobileNetworkCode);
                }
            }
        }
        return geoData;
    }

    private static void tag(IngestDocument ingestDocument, String databaseName) {
        ingestDocument.appendFieldValue("tags", (Object)("_geoip_database_unavailable_" + databaseName), true);
    }

    static class DatabaseUnavailableProcessor
    extends AbstractProcessor {
        private final String databaseName;

        DatabaseUnavailableProcessor(String tag, String description, String databaseName) {
            super(tag, description);
            this.databaseName = databaseName;
        }

        public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
            GeoIpProcessor.tag(ingestDocument, this.databaseName);
            return ingestDocument;
        }

        public String getType() {
            return GeoIpProcessor.TYPE;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }
    }

    public static final class Factory
    implements Processor.Factory {
        private final GeoIpDatabaseProvider geoIpDatabaseProvider;

        public Factory(GeoIpDatabaseProvider geoIpDatabaseProvider) {
            this.geoIpDatabaseProvider = geoIpDatabaseProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Processor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws IOException {
            Set<Database.Property> properties;
            Database database;
            String databaseType;
            GeoIpDatabase geoIpDatabase;
            String ipField = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)GeoIpProcessor.TYPE);
            String databaseFile = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"database_file", (String)"GeoLite2-City.mmdb");
            List propertyNames = ConfigurationUtils.readOptionalList((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"properties");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            boolean firstOnly = ConfigurationUtils.readBooleanProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"first_only", (boolean)true);
            Factory.downloadDatabaseOnPipelineCreation(config, processorTag);
            Object value = config.remove("fallback_to_default_databases");
            if (value != null) {
                deprecationLogger.warn(DeprecationCategory.OTHER, "default_databases_message", GeoIpProcessor.DEFAULT_DATABASES_DEPRECATION_MESSAGE, new Object[0]);
            }
            if ((geoIpDatabase = this.geoIpDatabaseProvider.getDatabase(databaseFile)) == null) {
                return new DatabaseUnavailableProcessor(processorTag, description, databaseFile);
            }
            try {
                databaseType = geoIpDatabase.getDatabaseType();
            }
            finally {
                geoIpDatabase.release();
            }
            try {
                database = Database.getDatabase(databaseType, databaseFile);
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"database_file", (String)e.getMessage());
            }
            try {
                properties = database.parseProperties(propertyNames);
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"properties", (String)e.getMessage());
            }
            return new GeoIpProcessor(processorTag, description, ipField, new DatabaseVerifyingSupplier(this.geoIpDatabaseProvider, databaseFile, databaseType), () -> this.geoIpDatabaseProvider.isValid(databaseFile), targetField, properties, ignoreMissing, firstOnly, databaseFile);
        }

        public static boolean downloadDatabaseOnPipelineCreation(Map<String, Object> config) {
            return Factory.downloadDatabaseOnPipelineCreation(config, null);
        }

        public static boolean downloadDatabaseOnPipelineCreation(Map<String, Object> config, String processorTag) {
            return ConfigurationUtils.readBooleanProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"download_database_on_pipeline_creation", (boolean)true);
        }
    }

    public static final class DatabaseVerifyingSupplier
    implements CheckedSupplier<GeoIpDatabase, IOException> {
        private final GeoIpDatabaseProvider geoIpDatabaseProvider;
        private final String databaseFile;
        private final String databaseType;

        public DatabaseVerifyingSupplier(GeoIpDatabaseProvider geoIpDatabaseProvider, String databaseFile, String databaseType) {
            this.geoIpDatabaseProvider = geoIpDatabaseProvider;
            this.databaseFile = databaseFile;
            this.databaseType = databaseType;
        }

        public GeoIpDatabase get() throws IOException {
            GeoIpDatabase loader = this.geoIpDatabaseProvider.getDatabase(this.databaseFile);
            if (loader == null) {
                return null;
            }
            if (Assertions.ENABLED) {
                String expectedSuffix = this.databaseType.substring(this.databaseType.lastIndexOf(45));
                assert (loader.getDatabaseType().endsWith(expectedSuffix)) : "database type [" + loader.getDatabaseType() + "] doesn't match with expected suffix [" + expectedSuffix + "]";
            }
            return loader;
        }
    }
}

