/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.percolator.PercolatorFieldMapper;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class PercolateQueryBuilder
extends AbstractQueryBuilder<PercolateQueryBuilder> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ParseField.class);
    static final String DOCUMENT_TYPE_DEPRECATION_MESSAGE = "[types removal] Types are deprecated in [percolate] queries. The [document_type] should no longer be specified.";
    static final String TYPE_DEPRECATION_MESSAGE = "[types removal] Types are deprecated in [percolate] queries. The [type] of the indexed document should no longer be specified.";
    public static final String NAME = "percolate";
    static final ParseField DOCUMENT_FIELD = new ParseField("document", new String[0]);
    static final ParseField DOCUMENTS_FIELD = new ParseField("documents", new String[0]);
    private static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("field", new String[0]);
    private static final ParseField DOCUMENT_TYPE_FIELD = new ParseField("document_type", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_TYPE = new ParseField("type", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_INDEX = new ParseField("index", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ID = new ParseField("id", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_PREFERENCE = new ParseField("preference", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_VERSION = new ParseField("version", new String[0]);
    private final String field;
    private String name;
    private final List<BytesReference> documents;
    private final XContentType documentXContentType;
    private final String indexedDocumentIndex;
    private final String indexedDocumentId;
    private final String indexedDocumentRouting;
    private final String indexedDocumentPreference;
    private final Long indexedDocumentVersion;
    private final Supplier<BytesReference> documentSupplier;
    private static final ConstructingObjectParser<PercolateQueryBuilder, Void> PARSER = new ConstructingObjectParser("percolate", args -> {
        String field = (String)args[0];
        BytesReference document = (BytesReference)args[1];
        List documents = (List)args[2];
        String indexedDocId = (String)args[3];
        String indexedDocIndex = (String)args[4];
        String indexDocRouting = (String)args[5];
        String indexDocPreference = (String)args[6];
        Long indexedDocVersion = (Long)args[7];
        if (indexedDocId != null) {
            return new PercolateQueryBuilder(field, indexedDocIndex, indexedDocId, indexDocRouting, indexDocPreference, indexedDocVersion);
        }
        if (document != null) {
            return new PercolateQueryBuilder(field, List.of(document), XContentType.JSON);
        }
        return new PercolateQueryBuilder(field, documents, XContentType.JSON);
    });

    public PercolateQueryBuilder(String field, BytesReference document, XContentType documentXContentType) {
        this(field, Collections.singletonList(document), documentXContentType);
    }

    public PercolateQueryBuilder(String field, List<BytesReference> documents, XContentType documentXContentType) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (documents == null) {
            throw new IllegalArgumentException("[document] is a required argument");
        }
        this.field = field;
        this.documents = documents;
        this.documentXContentType = Objects.requireNonNull(documentXContentType);
        this.indexedDocumentIndex = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
        this.documentSupplier = null;
    }

    public PercolateQueryBuilder(String field, String indexedDocumentIndex, String indexedDocumentId, String indexedDocumentRouting, String indexedDocumentPreference, Long indexedDocumentVersion) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (indexedDocumentIndex == null) {
            throw new IllegalArgumentException("[index] is a required argument");
        }
        if (indexedDocumentId == null) {
            throw new IllegalArgumentException("[id] is a required argument");
        }
        this.field = field;
        this.indexedDocumentIndex = indexedDocumentIndex;
        this.indexedDocumentId = indexedDocumentId;
        this.indexedDocumentRouting = indexedDocumentRouting;
        this.indexedDocumentPreference = indexedDocumentPreference;
        this.indexedDocumentVersion = indexedDocumentVersion;
        this.documents = Collections.emptyList();
        this.documentXContentType = null;
        this.documentSupplier = null;
    }

    protected PercolateQueryBuilder(String field, Supplier<BytesReference> documentSupplier) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        this.field = field;
        this.documents = Collections.emptyList();
        this.documentXContentType = null;
        this.documentSupplier = documentSupplier;
        this.indexedDocumentIndex = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
    }

    PercolateQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        this.name = in.readOptionalString();
        if (in.getTransportVersion().before((VersionId)TransportVersions.V_8_0_0)) {
            String documentType = in.readOptionalString();
            assert (documentType == null);
        }
        this.indexedDocumentIndex = in.readOptionalString();
        if (in.getTransportVersion().before((VersionId)TransportVersions.V_8_0_0)) {
            String indexedDocumentType = in.readOptionalString();
            assert (indexedDocumentType == null);
        }
        this.indexedDocumentId = in.readOptionalString();
        this.indexedDocumentRouting = in.readOptionalString();
        this.indexedDocumentPreference = in.readOptionalString();
        this.indexedDocumentVersion = in.readBoolean() ? Long.valueOf(in.readVLong()) : null;
        this.documents = in.readCollectionAsImmutableList(StreamInput::readBytesReference);
        this.documentXContentType = !this.documents.isEmpty() ? (XContentType)in.readEnum(XContentType.class) : null;
        this.documentSupplier = null;
    }

    public PercolateQueryBuilder setName(String name) {
        this.name = name;
        return this;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.documentSupplier != null) {
            throw new IllegalStateException("supplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeString(this.field);
        out.writeOptionalString(this.name);
        if (out.getTransportVersion().before((VersionId)TransportVersions.V_8_0_0)) {
            out.writeOptionalString(null);
        }
        out.writeOptionalString(this.indexedDocumentIndex);
        if (out.getTransportVersion().before((VersionId)TransportVersions.V_8_0_0)) {
            out.writeOptionalString(null);
        }
        out.writeOptionalString(this.indexedDocumentId);
        out.writeOptionalString(this.indexedDocumentRouting);
        out.writeOptionalString(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            out.writeBoolean(true);
            out.writeVLong(this.indexedDocumentVersion.longValue());
        } else {
            out.writeBoolean(false);
        }
        out.writeCollection(this.documents, StreamOutput::writeBytesReference);
        if (!this.documents.isEmpty()) {
            XContentHelper.writeTo((StreamOutput)out, (XContentType)this.documentXContentType);
        }
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.field);
        if (this.name != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.name);
        }
        if (!this.documents.isEmpty()) {
            builder.startArray(DOCUMENTS_FIELD.getPreferredName());
            for (BytesReference document : this.documents) {
                XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)document);
                try {
                    parser.nextToken();
                    builder.generator().copyCurrentStructure(parser);
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
            builder.endArray();
        }
        if (this.indexedDocumentIndex != null || this.indexedDocumentId != null) {
            if (this.indexedDocumentIndex != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_INDEX.getPreferredName(), this.indexedDocumentIndex);
            }
            if (builder.getRestApiVersion() == RestApiVersion.V_7) {
                builder.field(INDEXED_DOCUMENT_FIELD_TYPE.getPreferredName(), "_doc");
            }
            if (this.indexedDocumentId != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ID.getPreferredName(), this.indexedDocumentId);
            }
            if (this.indexedDocumentRouting != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ROUTING.getPreferredName(), this.indexedDocumentRouting);
            }
            if (this.indexedDocumentPreference != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_PREFERENCE.getPreferredName(), this.indexedDocumentPreference);
            }
            if (this.indexedDocumentVersion != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_VERSION.getPreferredName(), this.indexedDocumentVersion);
            }
        }
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    private static BiConsumer<PercolateQueryBuilder, String> deprecateAndIgnoreType(String key, String message) {
        return (target, type) -> deprecationLogger.compatibleCritical(key, message, new Object[0]);
    }

    private static BytesReference parseDocument(XContentParser parser) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.copyCurrentStructure(parser);
            builder.flush();
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
    }

    public static PercolateQueryBuilder fromXContent(XContentParser parser) throws IOException {
        return (PercolateQueryBuilder)((Object)PARSER.parse(parser, null));
    }

    protected boolean doEquals(PercolateQueryBuilder other) {
        return Objects.equals(this.field, other.field) && Objects.equals(this.documents, other.documents) && Objects.equals(this.indexedDocumentIndex, other.indexedDocumentIndex) && Objects.equals(this.documentSupplier, other.documentSupplier) && Objects.equals(this.indexedDocumentId, other.indexedDocumentId);
    }

    protected int doHashCode() {
        return Objects.hash(this.field, this.documents, this.indexedDocumentIndex, this.indexedDocumentId, this.documentSupplier);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) {
        if (!this.documents.isEmpty()) {
            return this;
        }
        if (this.documentSupplier != null) {
            BytesReference source = this.documentSupplier.get();
            if (source == null) {
                return this;
            }
            PercolateQueryBuilder rewritten = new PercolateQueryBuilder(this.field, Collections.singletonList(source), XContentHelper.xContentType((BytesReference)source));
            if (this.name != null) {
                rewritten.setName(this.name);
            }
            return rewritten;
        }
        GetRequest getRequest = new GetRequest(this.indexedDocumentIndex, this.indexedDocumentId);
        getRequest.preference("_local");
        getRequest.routing(this.indexedDocumentRouting);
        getRequest.preference(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            getRequest.version(this.indexedDocumentVersion.longValue());
        }
        SetOnce docSupplier = new SetOnce();
        queryRewriteContext.registerAsyncAction((client, listener) -> client.get(getRequest, listener.delegateFailureAndWrap((l, getResponse) -> {
            if (!getResponse.isExists()) {
                throw new ResourceNotFoundException("indexed document [{}/{}] couldn't be found", new Object[]{this.indexedDocumentIndex, this.indexedDocumentId});
            }
            if (getResponse.isSourceEmpty()) {
                throw new IllegalArgumentException("indexed document [" + this.indexedDocumentIndex + "/" + this.indexedDocumentId + "] source disabled");
            }
            docSupplier.set((Object)getResponse.getSourceAsBytesRef());
            l.onResponse(null);
        })));
        PercolateQueryBuilder rewritten = new PercolateQueryBuilder(this.field, () -> ((SetOnce)docSupplier).get());
        if (this.name != null) {
            rewritten.setName(this.name);
        }
        return rewritten;
    }

    protected Query doToQuery(final SearchExecutionContext context) throws IOException {
        boolean excludeNestedDocuments;
        IndexSearcher docSearcher;
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[percolate] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        context.nowInMillis();
        if (this.indexedDocumentIndex != null || this.indexedDocumentId != null || this.documentSupplier != null) {
            throw new IllegalStateException("query builder must be rewritten first");
        }
        if (this.documents.isEmpty()) {
            throw new IllegalStateException("no document to percolate");
        }
        MappedFieldType fieldType = context.getFieldType(this.field);
        if (fieldType == null) {
            throw new QueryShardException((QueryRewriteContext)context, "field [" + this.field + "] does not exist", new Object[0]);
        }
        if (!(fieldType instanceof PercolatorFieldMapper.PercolatorFieldType)) {
            throw new QueryShardException((QueryRewriteContext)context, "expected field [" + this.field + "] to be of type [percolator], but is of type [" + fieldType.typeName() + "]", new Object[0]);
        }
        ArrayList<ParsedDocument> docs = new ArrayList<ParsedDocument>();
        for (BytesReference document : this.documents) {
            docs.add(context.parseDocument(new SourceToParse("_temp_id", document, this.documentXContentType)));
        }
        DelegatingAnalyzerWrapper analyzer = new DelegatingAnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            protected Analyzer getWrappedAnalyzer(String fieldName) {
                return context.getIndexAnalyzer(f -> context.getIndexAnalyzers().getDefaultIndexAnalyzer());
            }
        };
        if (docs.size() > 1 || ((ParsedDocument)docs.get(0)).docs().size() > 1) {
            assert (docs.size() != 1 || context.nestedLookup() != NestedLookup.EMPTY);
            docSearcher = PercolateQueryBuilder.createMultiDocumentSearcher((Analyzer)analyzer, docs);
            excludeNestedDocuments = context.nestedLookup() != NestedLookup.EMPTY && docs.stream().map(ParsedDocument::docs).mapToInt(List::size).anyMatch(size -> size > 1);
        } else {
            MemoryIndex memoryIndex = MemoryIndex.fromDocument((Iterable)((ParsedDocument)docs.get(0)).rootDoc(), (Analyzer)analyzer, (boolean)true, (boolean)false);
            docSearcher = memoryIndex.createSearcher();
            docSearcher.setQueryCache(null);
            excludeNestedDocuments = false;
        }
        PercolatorFieldMapper.PercolatorFieldType pft = (PercolatorFieldMapper.PercolatorFieldType)fieldType;
        String queryName = this.name != null ? this.name : pft.name();
        SearchExecutionContext percolateShardContext = PercolateQueryBuilder.wrap(context);
        percolateShardContext = PercolatorFieldMapper.configureContext(percolateShardContext, pft.mapUnmappedFieldsAsText);
        PercolateQuery.QueryStore queryStore = PercolateQueryBuilder.createStore(pft.queryBuilderField, percolateShardContext);
        return pft.percolateQuery(queryName, queryStore, this.documents, docSearcher, excludeNestedDocuments, context.indexVersionCreated());
    }

    public String getField() {
        return this.field;
    }

    public List<BytesReference> getDocuments() {
        return this.documents;
    }

    XContentType getXContentType() {
        return this.documentXContentType;
    }

    public String getQueryName() {
        return this.name;
    }

    static IndexSearcher createMultiDocumentSearcher(Analyzer analyzer, Collection<ParsedDocument> docs) {
        IndexSearcher indexSearcher;
        ByteBuffersDirectory directory = new ByteBuffersDirectory();
        IndexWriter indexWriter = new IndexWriter((Directory)directory, new IndexWriterConfig(analyzer));
        try {
            Iterable iterable = () -> docs.stream().map(ParsedDocument::docs).flatMap(Collection::stream).iterator();
            indexWriter.addDocuments(iterable);
            DirectoryReader directoryReader = DirectoryReader.open((IndexWriter)indexWriter);
            assert (directoryReader.leaves().size() == 1) : "Expected single leaf, but got [" + directoryReader.leaves().size() + "]";
            IndexSearcher slowSearcher = new IndexSearcher((IndexReader)directoryReader);
            slowSearcher.setQueryCache(null);
            indexSearcher = slowSearcher;
        }
        catch (Throwable throwable) {
            try {
                try {
                    indexWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to create index for percolator with nested document ", (Throwable)e, new Object[0]);
            }
        }
        indexWriter.close();
        return indexSearcher;
    }

    static PercolateQuery.QueryStore createStore(MappedFieldType queryBuilderFieldType, SearchExecutionContext context) {
        IndexVersion indexVersion = context.indexVersionCreated();
        NamedWriteableRegistry registry = context.getWriteableRegistry();
        return ctx -> {
            LeafReader leafReader = ctx.reader();
            BinaryDocValues binaryDocValues = leafReader.getBinaryDocValues(queryBuilderFieldType.name());
            if (binaryDocValues == null) {
                return docId -> null;
            }
            return docId -> {
                if (binaryDocValues.advanceExact(docId.intValue())) {
                    BytesRef qbSource = binaryDocValues.binaryValue();
                    try (ByteArrayInputStream in = new ByteArrayInputStream(qbSource.bytes, qbSource.offset, qbSource.length);){
                        Query query;
                        try (NamedWriteableAwareStreamInput input = new NamedWriteableAwareStreamInput((StreamInput)new InputStreamStreamInput((InputStream)in, (long)qbSource.length), registry);){
                            int numValues = input.readVInt();
                            assert (numValues == 1);
                            int valueLength = input.readVInt();
                            assert (valueLength > 0);
                            TransportVersion transportVersion = indexVersion.before((VersionId)IndexVersions.V_8_8_0) ? TransportVersion.fromId((int)indexVersion.id()) : TransportVersion.readVersion((StreamInput)input);
                            input.setTransportVersion(transportVersion);
                            QueryBuilder queryBuilder = (QueryBuilder)input.readNamedWriteable(QueryBuilder.class);
                            assert (((InputStream)in).read() == -1);
                            queryBuilder = (QueryBuilder)Rewriteable.rewrite((Rewriteable)queryBuilder, (QueryRewriteContext)context);
                            query = queryBuilder.toQuery(context);
                        }
                        return query;
                    }
                }
                return null;
            };
        };
    }

    static SearchExecutionContext wrap(final SearchExecutionContext delegate) {
        return new SearchExecutionContext(delegate){

            public IndexReader getIndexReader() {
                return null;
            }

            public BitSetProducer bitsetFilter(Query query) {
                return context -> {
                    IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
                    IndexSearcher searcher = new IndexSearcher(topLevelContext);
                    searcher.setQueryCache(null);
                    Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                    Scorer s = weight.scorer(context);
                    if (s != null) {
                        return new BitDocIdSet(BitSet.of((DocIdSetIterator)s.iterator(), (int)context.reader().maxDoc())).bits();
                    }
                    return null;
                };
            }

            public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType, MappedFieldType.FielddataOperation fielddataOperation) {
                IndexFieldData.Builder builder = fieldType.fielddataBuilder(new FieldDataContext(delegate.getFullyQualifiedIndex().getName(), () -> ((SearchExecutionContext)delegate).lookup(), arg_0 -> (this).sourcePath(arg_0), fielddataOperation));
                IndexFieldDataCache.None cache = new IndexFieldDataCache.None();
                NoneCircuitBreakerService circuitBreaker = new NoneCircuitBreakerService();
                return (IFD)builder.build((IndexFieldDataCache)cache, (CircuitBreakerService)circuitBreaker);
            }

            public void addNamedQuery(String name, Query query) {
                delegate.addNamedQuery(name, query);
            }
        };
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), QUERY_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PercolateQueryBuilder.parseDocument(p), DOCUMENT_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PercolateQueryBuilder.parseDocument(p), DOCUMENTS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_ID);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_INDEX);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_ROUTING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_PREFERENCE);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_VERSION);
        PARSER.declareString(PercolateQueryBuilder::setName, NAME_FIELD);
        PARSER.declareString(AbstractQueryBuilder::queryName, AbstractQueryBuilder.NAME_FIELD);
        PARSER.declareFloat(AbstractQueryBuilder::boost, BOOST_FIELD);
        PARSER.declareRequiredFieldSet(new String[]{DOCUMENT_FIELD.getPreferredName(), DOCUMENTS_FIELD.getPreferredName(), INDEXED_DOCUMENT_FIELD_ID.getPreferredName()});
        PARSER.declareExclusiveFieldSet(new String[]{DOCUMENT_FIELD.getPreferredName(), DOCUMENTS_FIELD.getPreferredName(), INDEXED_DOCUMENT_FIELD_ID.getPreferredName()});
        PARSER.declareString(PercolateQueryBuilder.deprecateAndIgnoreType("percolate_with_type", TYPE_DEPRECATION_MESSAGE), INDEXED_DOCUMENT_FIELD_TYPE.forRestApiVersion(RestApiVersion.equalTo((RestApiVersion)RestApiVersion.V_7)));
        PARSER.declareString(PercolateQueryBuilder.deprecateAndIgnoreType("percolate_with_document_type", DOCUMENT_TYPE_DEPRECATION_MESSAGE), DOCUMENT_TYPE_FIELD.forRestApiVersion(RestApiVersion.equalTo((RestApiVersion)RestApiVersion.V_7)));
    }
}

