/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.transport;

import java.io.InputStream;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.textstructure.action.AbstractFindStructureRequest;
import org.elasticsearch.xpack.core.textstructure.action.FindStructureAction;
import org.elasticsearch.xpack.core.textstructure.action.FindStructureResponse;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinderManager;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureOverrides;
import org.elasticsearch.xpack.textstructure.transport.TextStructExecutor;

public class TransportFindStructureAction
extends HandledTransportAction<FindStructureAction.Request, FindStructureResponse> {
    private final ThreadPool threadPool;
    private final TextStructExecutor executor;

    @Inject
    public TransportFindStructureAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, TextStructExecutor executor) {
        super("cluster:monitor/text_structure/findstructure", transportService, actionFilters, FindStructureAction.Request::new, (Executor)executor.handledTransportActionExecutorService());
        this.threadPool = threadPool;
        this.executor = executor;
    }

    protected void doExecute(Task task, FindStructureAction.Request request, ActionListener<FindStructureResponse> listener) {
        this.executor.execute(listener, () -> this.buildTextStructureResponse(request));
    }

    private FindStructureResponse buildTextStructureResponse(FindStructureAction.Request request) throws Exception {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
        TextStructureFinderManager structureFinderManager = new TextStructureFinderManager(this.threadPool.scheduler());
        try (StreamInput sampleStream = request.getSample().streamInput();){
            TextStructureFinder textStructureFinder = structureFinderManager.findTextStructure(request.getLinesToSample(), request.getLineMergeSizeLimit(), (InputStream)sampleStream, new TextStructureOverrides((AbstractFindStructureRequest)request), request.getTimeout());
            FindStructureResponse findStructureResponse = new FindStructureResponse(textStructureFinder.getStructure());
            return findStructureResponse;
        }
    }
}

