/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.MeteredBlobStoreRepository;
import org.elasticsearch.repositories.s3.S3BlobStore;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3RepositoriesMetrics;
import org.elasticsearch.repositories.s3.S3Service;
import org.elasticsearch.snapshots.SnapshotDeleteListener;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.xcontent.NamedXContentRegistry;

class S3Repository
extends MeteredBlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(S3Repository.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger((String)logger.getName());
    static final String TYPE = "s3";
    static final Setting<SecureString> ACCESS_KEY_SETTING = SecureSetting.insecureString((String)"access_key");
    static final Setting<SecureString> SECRET_KEY_SETTING = SecureSetting.insecureString((String)"secret_key");
    private static final ByteSizeValue DEFAULT_BUFFER_SIZE = ByteSizeValue.ofBytes((long)Math.max(ByteSizeUnit.MB.toBytes(5L), Math.min(ByteSizeUnit.MB.toBytes(100L), JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 20L)));
    static final Setting<String> BUCKET_SETTING = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[0]);
    static final Setting<Boolean> SERVER_SIDE_ENCRYPTION_SETTING = Setting.boolSetting((String)"server_side_encryption", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    static final ByteSizeValue MAX_FILE_SIZE = new ByteSizeValue(5L, ByteSizeUnit.GB);
    static final ByteSizeValue MIN_PART_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.MB);
    static final ByteSizeValue MAX_PART_SIZE_USING_MULTIPART = MAX_FILE_SIZE;
    static final ByteSizeValue MAX_FILE_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.TB);
    static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting((String)"buffer_size", (ByteSizeValue)DEFAULT_BUFFER_SIZE, (ByteSizeValue)MIN_PART_SIZE_USING_MULTIPART, (ByteSizeValue)MAX_PART_SIZE_USING_MULTIPART, (Setting.Property[])new Setting.Property[0]);
    static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)MAX_FILE_SIZE_USING_MULTIPART, (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.MB), (ByteSizeValue)MAX_FILE_SIZE_USING_MULTIPART, (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> STORAGE_CLASS_SETTING = Setting.simpleString((String)"storage_class", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CANNED_ACL_SETTING = Setting.simpleString((String)"canned_acl", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    static final Setting<TimeValue> COOLDOWN_PERIOD = Setting.timeSetting((String)"cooldown_period", (TimeValue)new TimeValue(3L, TimeUnit.MINUTES), (TimeValue)new TimeValue(0L, TimeUnit.MILLISECONDS), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic});
    static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[0]);
    static final Setting<Integer> DELETION_BATCH_SIZE_SETTING = Setting.intSetting((String)"delete_objects_max_size", (int)1000, (int)1, (int)1000, (Setting.Property[])new Setting.Property[0]);
    private final S3Service service;
    private final String bucket;
    private final ByteSizeValue bufferSize;
    private final ByteSizeValue chunkSize;
    private final boolean serverSideEncryption;
    private final String storageClass;
    private final String cannedACL;
    private final TimeValue coolDown;
    private final Executor snapshotExecutor;
    private final S3RepositoriesMetrics s3RepositoriesMetrics;
    private final AtomicReference<Scheduler.Cancellable> finalizationFuture = new AtomicReference();

    S3Repository(RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, S3Service service, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, S3RepositoriesMetrics s3RepositoriesMetrics) {
        super(metadata, namedXContentRegistry, clusterService, bigArrays, recoverySettings, S3Repository.buildBasePath(metadata), S3Repository.buildLocation(metadata));
        this.service = service;
        this.s3RepositoriesMetrics = s3RepositoriesMetrics;
        this.snapshotExecutor = this.threadPool().executor("snapshot");
        this.bucket = (String)BUCKET_SETTING.get(metadata.settings());
        if (!Strings.hasLength((String)this.bucket)) {
            throw new IllegalArgumentException("Invalid S3 bucket name, cannot be null or empty");
        }
        this.bufferSize = (ByteSizeValue)BUFFER_SIZE_SETTING.get(metadata.settings());
        this.chunkSize = (ByteSizeValue)CHUNK_SIZE_SETTING.get(metadata.settings());
        if (this.chunkSize.getBytes() < this.bufferSize.getBytes()) {
            throw new RepositoryException(metadata.name(), CHUNK_SIZE_SETTING.getKey() + " (" + this.chunkSize + ") can't be lower than " + BUFFER_SIZE_SETTING.getKey() + " (" + this.bufferSize + ").", new Object[0]);
        }
        this.serverSideEncryption = (Boolean)SERVER_SIDE_ENCRYPTION_SETTING.get(metadata.settings());
        this.storageClass = (String)STORAGE_CLASS_SETTING.get(metadata.settings());
        this.cannedACL = (String)CANNED_ACL_SETTING.get(metadata.settings());
        if (S3ClientSettings.checkDeprecatedCredentials(metadata.settings())) {
            deprecationLogger.critical(DeprecationCategory.SECURITY, "s3_repository_secret_settings", "Using s3 access/secret key from repository settings. Instead store these in named clients and the elasticsearch keystore for secure settings.", new Object[0]);
        }
        this.coolDown = (TimeValue)COOLDOWN_PERIOD.get(metadata.settings());
        logger.debug("using bucket [{}], chunk_size [{}], server_side_encryption [{}], buffer_size [{}], cannedACL [{}], storageClass [{}]", (Object)this.bucket, (Object)this.chunkSize, (Object)this.serverSideEncryption, (Object)this.bufferSize, (Object)this.cannedACL, (Object)this.storageClass);
    }

    private static Map<String, String> buildLocation(RepositoryMetadata metadata) {
        return Map.of("base_path", (String)BASE_PATH_SETTING.get(metadata.settings()), "bucket", (String)BUCKET_SETTING.get(metadata.settings()));
    }

    public void finalizeSnapshot(final FinalizeSnapshotContext finalizeSnapshotContext) {
        FinalizeSnapshotContext wrappedFinalizeContext;
        if (!SnapshotsService.useShardGenerations((IndexVersion)finalizeSnapshotContext.repositoryMetaVersion())) {
            ListenableFuture metadataDone = new ListenableFuture();
            wrappedFinalizeContext = new FinalizeSnapshotContext(finalizeSnapshotContext.updatedShardGenerations(), finalizeSnapshotContext.repositoryStateId(), finalizeSnapshotContext.clusterMetadata(), finalizeSnapshotContext.snapshotInfo(), finalizeSnapshotContext.repositoryMetaVersion(), this.delayedListener(ActionListener.runAfter((ActionListener)finalizeSnapshotContext, () -> metadataDone.onResponse(null))), info -> metadataDone.addListener((ActionListener)new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    finalizeSnapshotContext.onDone(info);
                }

                public void onFailure(Exception e) {
                    assert (false) : e;
                }
            }));
        } else {
            wrappedFinalizeContext = finalizeSnapshotContext;
        }
        super.finalizeSnapshot(wrappedFinalizeContext);
    }

    protected SnapshotDeleteListener wrapWithWeakConsistencyProtection(final SnapshotDeleteListener listener) {
        return new SnapshotDeleteListener(){

            public void onDone() {
                listener.onDone();
            }

            public void onRepositoryDataWritten(RepositoryData repositoryData) {
                S3Repository.this.logCooldownInfo();
                Scheduler.Cancellable existing = S3Repository.this.finalizationFuture.getAndSet((Scheduler.Cancellable)S3Repository.this.threadPool.schedule(() -> {
                    Scheduler.Cancellable cancellable = S3Repository.this.finalizationFuture.getAndSet(null);
                    assert (cancellable != null);
                    listener.onRepositoryDataWritten(repositoryData);
                }, S3Repository.this.coolDown, S3Repository.this.snapshotExecutor));
                assert (existing == null) : "Already have an ongoing finalization " + S3Repository.this.finalizationFuture;
            }

            public void onFailure(Exception e) {
                S3Repository.this.logCooldownInfo();
                Scheduler.Cancellable existing = S3Repository.this.finalizationFuture.getAndSet((Scheduler.Cancellable)S3Repository.this.threadPool.schedule(() -> {
                    Scheduler.Cancellable cancellable = S3Repository.this.finalizationFuture.getAndSet(null);
                    assert (cancellable != null);
                    listener.onFailure(e);
                }, S3Repository.this.coolDown, S3Repository.this.snapshotExecutor));
                assert (existing == null) : "Already have an ongoing finalization " + S3Repository.this.finalizationFuture;
            }
        };
    }

    private <T> ActionListener<T> delayedListener(ActionListener<T> listener) {
        final ActionListener wrappedListener = ActionListener.runBefore(listener, () -> {
            Scheduler.Cancellable cancellable = this.finalizationFuture.getAndSet(null);
            assert (cancellable != null);
        });
        return new ActionListener<T>(){

            public void onResponse(T response) {
                S3Repository.this.logCooldownInfo();
                Scheduler.Cancellable existing = S3Repository.this.finalizationFuture.getAndSet((Scheduler.Cancellable)S3Repository.this.threadPool.schedule((Runnable)ActionRunnable.wrap((ActionListener)wrappedListener, l -> l.onResponse(response)), S3Repository.this.coolDown, S3Repository.this.snapshotExecutor));
                assert (existing == null) : "Already have an ongoing finalization " + S3Repository.this.finalizationFuture;
            }

            public void onFailure(Exception e) {
                S3Repository.this.logCooldownInfo();
                Scheduler.Cancellable existing = S3Repository.this.finalizationFuture.getAndSet((Scheduler.Cancellable)S3Repository.this.threadPool.schedule((Runnable)ActionRunnable.wrap((ActionListener)wrappedListener, l -> l.onFailure(e)), S3Repository.this.coolDown, S3Repository.this.snapshotExecutor));
                assert (existing == null) : "Already have an ongoing finalization " + S3Repository.this.finalizationFuture;
            }
        };
    }

    private void logCooldownInfo() {
        logger.info("Sleeping for [{}] after modifying repository [{}] because it contains snapshots older than version [{}] and therefore is using a backwards compatible metadata format that requires this cooldown period to avoid repository corruption. To get rid of this message and move to the new repository metadata format, either remove all snapshots older than version [{}] from the repository or create a new repository at an empty location.", (Object)this.coolDown, (Object)this.metadata.name(), (Object)SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION, (Object)SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION);
    }

    private static BlobPath buildBasePath(RepositoryMetadata metadata) {
        String basePath = (String)BASE_PATH_SETTING.get(metadata.settings());
        if (Strings.hasLength((String)basePath)) {
            return BlobPath.EMPTY.add(basePath);
        }
        return BlobPath.EMPTY;
    }

    protected S3BlobStore createBlobStore() {
        return new S3BlobStore(this.service, this.bucket, this.serverSideEncryption, this.bufferSize, this.cannedACL, this.storageClass, this.metadata, this.bigArrays, this.threadPool, this.s3RepositoriesMetrics);
    }

    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    protected void doClose() {
        Scheduler.Cancellable cancellable = this.finalizationFuture.getAndSet(null);
        if (cancellable != null) {
            logger.debug("Repository [{}] closed during cool-down period", (Object)this.metadata.name());
            cancellable.cancel();
        }
        super.doClose();
    }
}

