/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.search.vectors.ExactKnnQueryBuilder;
import org.elasticsearch.search.vectors.QueryVectorBuilder;
import org.elasticsearch.search.vectors.VectorData;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class KnnVectorQueryBuilder
extends AbstractQueryBuilder<KnnVectorQueryBuilder> {
    public static final NodeFeature K_PARAM_SUPPORTED = new NodeFeature("search.vectors.k_param_supported");
    public static final String NAME = "knn";
    private static final int NUM_CANDS_LIMIT = 10000;
    private static final float NUM_CANDS_MULTIPLICATIVE_FACTOR = 1.5f;
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField K_FIELD = new ParseField("k", new String[0]);
    public static final ParseField NUM_CANDS_FIELD = new ParseField("num_candidates", new String[0]);
    public static final ParseField QUERY_VECTOR_FIELD = new ParseField("query_vector", new String[0]);
    public static final ParseField VECTOR_SIMILARITY_FIELD = new ParseField("similarity", new String[0]);
    public static final ParseField FILTER_FIELD = new ParseField("filter", new String[0]);
    public static final ParseField QUERY_VECTOR_BUILDER_FIELD = new ParseField("query_vector_builder", new String[0]);
    public static final ConstructingObjectParser<KnnVectorQueryBuilder, Void> PARSER = new ConstructingObjectParser("knn", args -> new KnnVectorQueryBuilder((String)args[0], (VectorData)args[1], (QueryVectorBuilder)args[5], null, (Integer)args[2], (Integer)args[3], (Float)args[4]));
    private final String fieldName;
    private final VectorData queryVector;
    private final Integer k;
    private Integer numCands;
    private final List<QueryBuilder> filterQueries = new ArrayList<QueryBuilder>();
    private final Float vectorSimilarity;
    private final QueryVectorBuilder queryVectorBuilder;
    private final Supplier<float[]> queryVectorSupplier;

    public static KnnVectorQueryBuilder fromXContent(XContentParser parser) {
        return (KnnVectorQueryBuilder)PARSER.apply(parser, null);
    }

    public KnnVectorQueryBuilder(String fieldName, float[] queryVector, Integer k, Integer numCands, Float vectorSimilarity) {
        this(fieldName, VectorData.fromFloats(queryVector), null, null, k, numCands, vectorSimilarity);
    }

    protected KnnVectorQueryBuilder(String fieldName, QueryVectorBuilder queryVectorBuilder, Integer k, Integer numCands, Float vectorSimilarity) {
        this(fieldName, null, queryVectorBuilder, null, k, numCands, vectorSimilarity);
    }

    public KnnVectorQueryBuilder(String fieldName, byte[] queryVector, Integer k, Integer numCands, Float vectorSimilarity) {
        this(fieldName, VectorData.fromBytes(queryVector), null, null, k, numCands, vectorSimilarity);
    }

    public KnnVectorQueryBuilder(String fieldName, VectorData queryVector, Integer k, Integer numCands, Float vectorSimilarity) {
        this(fieldName, queryVector, null, null, k, numCands, vectorSimilarity);
    }

    private KnnVectorQueryBuilder(String fieldName, VectorData queryVector, QueryVectorBuilder queryVectorBuilder, Supplier<float[]> queryVectorSupplier, Integer k, Integer numCands, Float vectorSimilarity) {
        if (k != null && k < 1) {
            throw new IllegalArgumentException("[" + K_FIELD.getPreferredName() + "] must be greater than 0");
        }
        if (numCands != null && numCands > 10000) {
            throw new IllegalArgumentException("[" + NUM_CANDS_FIELD.getPreferredName() + "] cannot exceed [10000]");
        }
        if (k != null && numCands != null && numCands < k) {
            throw new IllegalArgumentException("[" + NUM_CANDS_FIELD.getPreferredName() + "] cannot be less than [" + K_FIELD.getPreferredName() + "]");
        }
        if (queryVector == null && queryVectorBuilder == null) {
            throw new IllegalArgumentException(Strings.format("either [%s] or [%s] must be provided", QUERY_VECTOR_FIELD.getPreferredName(), QUERY_VECTOR_BUILDER_FIELD.getPreferredName()));
        }
        if (queryVector != null && queryVectorBuilder != null) {
            throw new IllegalArgumentException(Strings.format("only one of [%s] and [%s] must be provided", QUERY_VECTOR_FIELD.getPreferredName(), QUERY_VECTOR_BUILDER_FIELD.getPreferredName()));
        }
        this.fieldName = fieldName;
        this.queryVector = queryVector;
        this.k = k;
        this.numCands = numCands;
        this.vectorSimilarity = vectorSimilarity;
        this.queryVectorBuilder = queryVectorBuilder;
        this.queryVectorSupplier = queryVectorSupplier;
    }

    public KnnVectorQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.k = in.getTransportVersion().onOrAfter(TransportVersions.K_FOR_KNN_QUERY_ADDED) ? in.readOptionalVInt() : null;
        this.numCands = in.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0) ? in.readOptionalVInt() : Integer.valueOf(in.readVInt());
        if (in.getTransportVersion().onOrAfter(TransportVersions.KNN_EXPLICIT_BYTE_QUERY_VECTOR_PARSING)) {
            this.queryVector = in.readOptionalWriteable(VectorData::new);
        } else if (in.getTransportVersion().before(TransportVersions.V_8_7_0) || in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            this.queryVector = VectorData.fromFloats(in.readFloatArray());
        } else {
            in.readBoolean();
            this.queryVector = VectorData.fromFloats(in.readFloatArray());
            in.readBoolean();
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_2_0)) {
            this.filterQueries.addAll(KnnVectorQueryBuilder.readQueries(in));
        }
        this.vectorSimilarity = in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) ? in.readOptionalFloat() : null;
        this.queryVectorBuilder = in.getTransportVersion().onOrAfter(TransportVersions.KNN_QUERY_VECTOR_BUILDER) ? in.readOptionalNamedWriteable(QueryVectorBuilder.class) : null;
        this.queryVectorSupplier = null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Nullable
    public VectorData queryVector() {
        return this.queryVector;
    }

    @Nullable
    public Float getVectorSimilarity() {
        return this.vectorSimilarity;
    }

    public Integer k() {
        return this.k;
    }

    public Integer numCands() {
        return this.numCands;
    }

    public List<QueryBuilder> filterQueries() {
        return this.filterQueries;
    }

    @Nullable
    public QueryVectorBuilder queryVectorBuilder() {
        return this.queryVectorBuilder;
    }

    public KnnVectorQueryBuilder addFilterQuery(QueryBuilder filterQuery) {
        Objects.requireNonNull(filterQuery);
        this.filterQueries.add(filterQuery);
        return this;
    }

    public KnnVectorQueryBuilder addFilterQueries(List<QueryBuilder> filterQueries) {
        Objects.requireNonNull(filterQueries);
        this.filterQueries.addAll(filterQueries);
        return this;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.queryVectorSupplier != null) {
            throw new IllegalStateException("missing a rewriteAndFetch?");
        }
        out.writeString(this.fieldName);
        if (out.getTransportVersion().onOrAfter(TransportVersions.K_FOR_KNN_QUERY_ADDED)) {
            out.writeOptionalVInt(this.k);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
            out.writeOptionalVInt(this.numCands);
        } else {
            if (this.numCands == null) {
                throw new IllegalArgumentException("[" + NUM_CANDS_FIELD.getPreferredName() + "] field was mandatory in previous releases and is required to be non-null by some nodes. Please make sure to provide the parameter as part of the request.");
            }
            out.writeVInt(this.numCands);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.KNN_EXPLICIT_BYTE_QUERY_VECTOR_PARSING)) {
            out.writeOptionalWriteable(this.queryVector);
        } else if (out.getTransportVersion().before(TransportVersions.V_8_7_0) || out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeFloatArray(this.queryVector.asFloatVector());
        } else {
            out.writeBoolean(true);
            out.writeFloatArray(this.queryVector.asFloatVector());
            out.writeBoolean(false);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_2_0)) {
            KnnVectorQueryBuilder.writeQueries(out, this.filterQueries);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            out.writeOptionalFloat(this.vectorSimilarity);
        }
        if (out.getTransportVersion().before(TransportVersions.KNN_QUERY_VECTOR_BUILDER) && this.queryVectorBuilder != null) {
            throw new IllegalArgumentException(Strings.format("cannot serialize [%s] to older node of version [%s]", QUERY_VECTOR_BUILDER_FIELD.getPreferredName(), out.getTransportVersion()));
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.KNN_QUERY_VECTOR_BUILDER)) {
            out.writeOptionalNamedWriteable(this.queryVectorBuilder);
        }
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.queryVectorSupplier != null) {
            throw new IllegalStateException("missing a rewriteAndFetch?");
        }
        builder.startObject(NAME);
        builder.field(FIELD_FIELD.getPreferredName(), this.fieldName);
        if (this.queryVector != null) {
            builder.field(QUERY_VECTOR_FIELD.getPreferredName(), (ToXContent)this.queryVector);
        }
        if (this.k != null) {
            builder.field(K_FIELD.getPreferredName(), this.k);
        }
        if (this.numCands != null) {
            builder.field(NUM_CANDS_FIELD.getPreferredName(), this.numCands);
        }
        if (this.vectorSimilarity != null) {
            builder.field(VECTOR_SIMILARITY_FIELD.getPreferredName(), this.vectorSimilarity);
        }
        if (this.queryVectorBuilder != null) {
            builder.startObject(QUERY_VECTOR_BUILDER_FIELD.getPreferredName());
            builder.field(this.queryVectorBuilder.getWriteableName(), (ToXContent)this.queryVectorBuilder);
            builder.endObject();
        }
        if (!this.filterQueries.isEmpty()) {
            builder.startArray(FILTER_FIELD.getPreferredName());
            for (QueryBuilder filterQuery : this.filterQueries) {
                filterQuery.toXContent(builder, params);
            }
            builder.endArray();
        }
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext ctx) throws IOException {
        if (this.queryVectorSupplier != null) {
            if (this.queryVectorSupplier.get() == null) {
                return this;
            }
            return ((KnnVectorQueryBuilder)((KnnVectorQueryBuilder)new KnnVectorQueryBuilder(this.fieldName, this.queryVectorSupplier.get(), this.k, this.numCands, this.vectorSimilarity).boost(this.boost)).queryName(this.queryName)).addFilterQueries(this.filterQueries);
        }
        if (this.queryVectorBuilder != null) {
            SetOnce toSet = new SetOnce();
            ctx.registerAsyncAction((c, l) -> this.queryVectorBuilder.buildVector((Client)c, l.delegateFailureAndWrap((ll, v) -> {
                toSet.set(v);
                if (v == null) {
                    ll.onFailure(new IllegalArgumentException(Strings.format("[%s] with name [%s] returned null query_vector", QUERY_VECTOR_BUILDER_FIELD.getPreferredName(), this.queryVectorBuilder.getWriteableName())));
                    return;
                }
                ll.onResponse(null);
            })));
            return ((KnnVectorQueryBuilder)((KnnVectorQueryBuilder)new KnnVectorQueryBuilder(this.fieldName, this.queryVector, this.queryVectorBuilder, () -> ((SetOnce)toSet).get(), this.k, this.numCands, this.vectorSimilarity).boost(this.boost)).queryName(this.queryName)).addFilterQueries(this.filterQueries);
        }
        if (ctx.convertToInnerHitsRewriteContext() != null) {
            return ((ExactKnnQueryBuilder)new ExactKnnQueryBuilder(this.queryVector, this.fieldName, this.vectorSimilarity).boost(this.boost)).queryName(this.queryName);
        }
        boolean changed = false;
        ArrayList<QueryBuilder> rewrittenQueries = new ArrayList<QueryBuilder>(this.filterQueries.size());
        for (QueryBuilder query : this.filterQueries) {
            QueryBuilder rewrittenQuery = query.rewrite(ctx);
            if (rewrittenQuery instanceof MatchNoneQueryBuilder) {
                return rewrittenQuery;
            }
            if (rewrittenQuery != query) {
                changed = true;
            }
            rewrittenQueries.add(rewrittenQuery);
        }
        if (changed) {
            return ((KnnVectorQueryBuilder)((KnnVectorQueryBuilder)new KnnVectorQueryBuilder(this.fieldName, this.queryVector, this.queryVectorBuilder, this.queryVectorSupplier, this.k, this.numCands, this.vectorSimilarity).boost(this.boost)).queryName(this.queryName)).addFilterQueries(rewrittenQueries);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        BooleanQuery booleanQuery;
        int adjustedNumCands;
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        int requestSize = this.k != null ? this.k : (context.requestSize() == null || context.requestSize() < 0 ? 10 : context.requestSize());
        int n = adjustedNumCands = this.numCands == null ? Math.round(Math.min(1.5f * (float)requestSize, 10000.0f)) : this.numCands;
        if (fieldType == null) {
            throw new IllegalArgumentException("field [" + this.fieldName + "] does not exist in the mapping");
        }
        if (!(fieldType instanceof DenseVectorFieldMapper.DenseVectorFieldType)) {
            throw new IllegalArgumentException("[knn] queries are only supported on [dense_vector] fields");
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (QueryBuilder query : this.filterQueries) {
            builder.add(query.toQuery(context), BooleanClause.Occur.FILTER);
        }
        if (context.getAliasFilter() != null) {
            builder.add(context.getAliasFilter().toQuery(context), BooleanClause.Occur.FILTER);
        }
        BooleanQuery filterQuery = (booleanQuery = builder.build()).clauses().isEmpty() ? null : booleanQuery;
        DenseVectorFieldMapper.DenseVectorFieldType vectorFieldType = (DenseVectorFieldMapper.DenseVectorFieldType)fieldType;
        String parentPath = context.nestedLookup().getNestedParent(this.fieldName);
        if (parentPath != null) {
            Query parentFilter;
            NestedObjectMapper originalObjectMapper = context.nestedScope().getObjectMapper();
            if (originalObjectMapper != null) {
                try {
                    context.nestedScope().previousLevel();
                    NestedObjectMapper objectMapper = context.nestedScope().getObjectMapper();
                    parentFilter = objectMapper == null ? Queries.newNonNestedFilter(context.indexVersionCreated()) : objectMapper.nestedTypeFilter();
                }
                finally {
                    context.nestedScope().nextLevel(originalObjectMapper);
                }
            } else {
                parentFilter = Queries.newNonNestedFilter(context.indexVersionCreated());
            }
            BitSetProducer parentBitSet = context.bitsetFilter(parentFilter);
            if (filterQuery != null) {
                NestedHelper nestedHelper = new NestedHelper(context.nestedLookup(), context::isFieldMapped);
                if (nestedHelper.mightMatchNestedDocs((Query)filterQuery)) {
                    filterQuery = Queries.filtered((Query)filterQuery, parentFilter);
                }
                filterQuery = new ToChildBlockJoinQuery((Query)filterQuery, parentBitSet);
            }
            return vectorFieldType.createKnnQuery(this.queryVector, this.k, adjustedNumCands, (Query)filterQuery, this.vectorSimilarity, parentBitSet);
        }
        return vectorFieldType.createKnnQuery(this.queryVector, this.k, adjustedNumCands, (Query)filterQuery, this.vectorSimilarity, null);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, Objects.hashCode(this.queryVector), this.k, this.numCands, this.filterQueries, this.vectorSimilarity, this.queryVectorBuilder);
    }

    @Override
    protected boolean doEquals(KnnVectorQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.queryVector, other.queryVector) && Objects.equals(this.k, other.k) && Objects.equals(this.numCands, other.numCands) && Objects.equals(this.filterQueries, other.filterQueries) && Objects.equals(this.vectorSimilarity, other.vectorSimilarity) && Objects.equals(this.queryVectorBuilder, other.queryVectorBuilder);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_0_0;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> VectorData.parseXContent(p), QUERY_VECTOR_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_STRING_OR_NUMBER);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), K_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_CANDS_FIELD);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), VECTOR_SIMILARITY_FIELD);
        PARSER.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (QueryVectorBuilder)p.namedObject(QueryVectorBuilder.class, n, c), QUERY_VECTOR_BUILDER_FIELD);
        PARSER.declareFieldArray(KnnVectorQueryBuilder::addFilterQueries, (p, c) -> AbstractQueryBuilder.parseTopLevelQuery(p), FILTER_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        KnnVectorQueryBuilder.declareStandardFields(PARSER);
    }
}

