/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.DiversifyingChildrenByteKnnVectorQuery;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.vectors.ProfilingQuery;

public class ESDiversifyingChildrenByteKnnVectorQuery
extends DiversifyingChildrenByteKnnVectorQuery
implements ProfilingQuery {
    private final Integer kParam;
    private long vectorOpsCount;

    public ESDiversifyingChildrenByteKnnVectorQuery(String field, byte[] query, Query childFilter, Integer k, int numCands, BitSetProducer parentsFilter) {
        super(field, query, childFilter, numCands, parentsFilter);
        this.kParam = k;
    }

    protected TopDocs mergeLeafResults(TopDocs[] perLeafResults) {
        TopDocs topK = this.kParam == null ? super.mergeLeafResults(perLeafResults) : TopDocs.merge((int)this.kParam, (TopDocs[])perLeafResults);
        this.vectorOpsCount = topK.totalHits.value;
        return topK;
    }

    @Override
    public void profile(QueryProfiler queryProfiler) {
        queryProfiler.setVectorOpsCount(this.vectorOpsCount);
    }
}

