/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.PercentilesConfig;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

abstract class AbstractHDRPercentilesAggregator
extends NumericMetricsAggregator.MultiDoubleValue {
    protected final double[] keys;
    protected final DocValueFormat format;
    protected ObjectArray<DoubleHistogram> states;
    protected final int numberOfSignificantValueDigits;
    protected final boolean keyed;

    AbstractHDRPercentilesAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double[] keys, int numberOfSignificantValueDigits, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, metadata);
        assert (config.hasValues());
        this.keyed = keyed;
        this.format = formatter;
        this.states = context.bigArrays().newObjectArray(1L);
        this.keys = keys;
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
    }

    @Override
    protected LeafBucketCollector getLeafCollector(final SortedNumericDoubleValues values, LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    DoubleHistogram state = AbstractHDRPercentilesAggregator.this.getExistingOrNewHistogram(AbstractHDRPercentilesAggregator.this.bigArrays(), bucket);
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        state.recordValue(values.nextValue());
                    }
                }
            }
        };
    }

    @Override
    protected LeafBucketCollector getLeafCollector(final NumericDoubleValues values, LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, (Object)values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    DoubleHistogram state = AbstractHDRPercentilesAggregator.this.getExistingOrNewHistogram(AbstractHDRPercentilesAggregator.this.bigArrays(), bucket);
                    state.recordValue(values.doubleValue());
                }
            }
        };
    }

    private DoubleHistogram getExistingOrNewHistogram(BigArrays bigArrays, long bucket) {
        this.states = bigArrays.grow(this.states, bucket + 1L);
        DoubleHistogram state = this.states.get(bucket);
        if (state == null) {
            state = new DoubleHistogram(this.numberOfSignificantValueDigits);
            state.setAutoResize(true);
            this.states.set(bucket, state);
        }
        return state;
    }

    @Override
    public boolean hasMetric(String name) {
        return PercentilesConfig.indexOfKey(this.keys, Double.parseDouble(name)) >= 0;
    }

    protected DoubleHistogram getState(long bucketOrd) {
        if (bucketOrd >= this.states.size()) {
            return null;
        }
        DoubleHistogram state = this.states.get(bucketOrd);
        return state;
    }

    @Override
    protected void doClose() {
        Releasables.close(this.states);
    }
}

