/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.common.util.SetBackedScalingCuckooFilter;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BestBucketsDeferringCollector;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractRareTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.elasticsearch.search.aggregations.bucket.terms.LongRareTerms;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class LongRareTermsAggregator
extends AbstractRareTermsAggregator {
    private final ValuesSource.Numeric valuesSource;
    private final IncludeExclude.LongFilter filter;
    private final LongKeyedBucketOrds bucketOrds;

    LongRareTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, AggregationContext aggregationContext, Aggregator parent, IncludeExclude.LongFilter filter, int maxDocCount, double precision, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, metadata, maxDocCount, precision, format);
        this.valuesSource = valuesSource;
        this.filter = filter;
        this.bucketOrds = LongKeyedBucketOrds.build(this.bigArrays(), cardinality);
    }

    protected static SortedNumericDocValues getValues(ValuesSource.Numeric valuesSource, LeafReaderContext ctx) throws IOException {
        return valuesSource.longValues(ctx);
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        SortedNumericDocValues values = LongRareTermsAggregator.getValues(this.valuesSource, aggCtx.getLeafReaderContext());
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        return singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(values, sub);
    }

    private LeafBucketCollector getLeafCollector(final SortedNumericDocValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int docId, long owningBucketOrd) throws IOException {
                if (values.advanceExact(docId)) {
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        long val = values.nextValue();
                        if (i == 0 && previous == val) continue;
                        LongRareTermsAggregator.this.collectValue(val, docId, owningBucketOrd, sub);
                        previous = val;
                    }
                }
            }
        };
    }

    private LeafBucketCollector getLeafCollector(final NumericDocValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int docId, long owningBucketOrd) throws IOException {
                if (values.advanceExact(docId)) {
                    LongRareTermsAggregator.this.collectValue(values.longValue(), docId, owningBucketOrd, sub);
                }
            }
        };
    }

    private void collectValue(long val, int docId, long owningBucketOrd, LeafBucketCollector sub) throws IOException {
        if (this.filter == null || this.filter.accept(val)) {
            long bucketOrdinal = this.bucketOrds.add(owningBucketOrd, val);
            if (bucketOrdinal < 0L) {
                bucketOrdinal = -1L - bucketOrdinal;
                this.collectExistingBucket(sub, docId, bucketOrdinal);
            } else {
                this.collectBucket(sub, docId, bucketOrdinal);
            }
        }
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        LongRareTerms.Bucket[][] rarestPerOrd = new LongRareTerms.Bucket[owningBucketOrds.length][];
        SetBackedScalingCuckooFilter[] filters = new SetBackedScalingCuckooFilter[owningBucketOrds.length];
        long keepCount = 0L;
        long[] mergeMap = new long[(int)this.bucketOrds.size()];
        Arrays.fill(mergeMap, -1L);
        long offset = 0L;
        for (int owningOrdIdx = 0; owningOrdIdx < owningBucketOrds.length; ++owningOrdIdx) {
            try (LongHash bucketsInThisOwningBucketToCollect = new LongHash(1L, this.bigArrays());){
                filters[owningOrdIdx] = this.newFilter();
                ArrayList<LongRareTerms.Bucket> builtBuckets = new ArrayList<LongRareTerms.Bucket>();
                LongKeyedBucketOrds.BucketOrdsEnum collectedBuckets = this.bucketOrds.ordsEnum(owningBucketOrds[owningOrdIdx]);
                while (collectedBuckets.next()) {
                    long docCount = this.bucketDocCount(collectedBuckets.ord());
                    if (docCount <= this.maxDocCount) {
                        LongRareTerms.Bucket bucket = new LongRareTerms.Bucket(collectedBuckets.value(), docCount, null, this.format);
                        mergeMap[(int)collectedBuckets.ord()] = bucket.bucketOrd = offset + bucketsInThisOwningBucketToCollect.add(collectedBuckets.value());
                        builtBuckets.add(bucket);
                        ++keepCount;
                        continue;
                    }
                    filters[owningOrdIdx].add(collectedBuckets.value());
                }
                rarestPerOrd[owningOrdIdx] = (LongRareTerms.Bucket[])builtBuckets.toArray(LongRareTerms.Bucket[]::new);
                offset += bucketsInThisOwningBucketToCollect.size();
                continue;
            }
        }
        if (keepCount != (long)mergeMap.length) {
            LongUnaryOperator howToMerge = b -> mergeMap[(int)b];
            this.rewriteBuckets(offset, howToMerge);
            if (this.deferringCollector() != null) {
                ((BestBucketsDeferringCollector)this.deferringCollector()).rewriteBuckets(howToMerge);
            }
        }
        this.buildSubAggsForAllBuckets(rarestPerOrd, b -> b.bucketOrd, (b, aggs) -> {
            b.aggregations = aggs;
        });
        InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            Arrays.sort(rarestPerOrd[ordIdx], ORDER.comparator());
            result[ordIdx] = new LongRareTerms(this.name, ORDER, this.metadata(), this.format, Arrays.asList(rarestPerOrd[ordIdx]), this.maxDocCount, filters[ordIdx]);
        }
        return result;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new LongRareTerms(this.name, ORDER, this.metadata(), this.format, Collections.emptyList(), 0L, this.newFilter());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }
}

