/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AdaptingAggregator;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.SizedBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.range.InternalDateRange;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregatorSupplier;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

class DateHistogramAggregator
extends BucketsAggregator
implements SizedBucketAggregator {
    private static final Logger logger = LogManager.getLogger(DateHistogramAggregator.class);
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat formatter;
    private final Rounding rounding;
    private final Rounding.Prepared preparedRounding;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final boolean downsampledResultsOffset;
    private final LongBounds extendedBounds;
    private final LongBounds hardBounds;
    private final LongKeyedBucketOrds bucketOrds;

    public static Aggregator build(String name, AggregatorFactories factories, Rounding rounding, BucketOrder order, boolean keyed, long minDocCount, boolean downsampledResultsOffset, @Nullable LongBounds extendedBounds, @Nullable LongBounds hardBounds, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        Rounding.Prepared preparedRounding = valuesSourceConfig.roundingPreparer(context).apply(rounding);
        FromDateRange asRange = DateHistogramAggregator.adaptIntoRangeOrNull(name, factories, rounding, preparedRounding, order, keyed, minDocCount, downsampledResultsOffset, extendedBounds, hardBounds, valuesSourceConfig, context, parent, cardinality, metadata);
        if (asRange != null) {
            return asRange;
        }
        return new DateHistogramAggregator(name, factories, rounding, preparedRounding, order, keyed, minDocCount, downsampledResultsOffset, extendedBounds, hardBounds, valuesSourceConfig, context, parent, cardinality, metadata);
    }

    private static FromDateRange adaptIntoRangeOrNull(String name, AggregatorFactories factories, Rounding rounding, Rounding.Prepared preparedRounding, BucketOrder order, boolean keyed, long minDocCount, boolean downsampledResultsOffset, @Nullable LongBounds extendedBounds, @Nullable LongBounds hardBounds, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        long[] fixedRoundingPoints = preparedRounding.fixedRoundingPoints();
        if (fixedRoundingPoints == null) {
            logger.trace("couldn't adapt [{}], no fixed rounding points in [{}]", (Object)name, (Object)preparedRounding);
            return null;
        }
        long min = fixedRoundingPoints[0];
        long max = fixedRoundingPoints[fixedRoundingPoints.length - 1];
        if (min < -9007199254740992L || min > 0x20000000000000L) {
            logger.trace("couldn't adapt [{}], min outside accurate bounds", (Object)name);
            return null;
        }
        if (max < -9007199254740992L || max > 0x20000000000000L) {
            logger.trace("couldn't adapt [{}], max outside accurate bounds", (Object)name);
            return null;
        }
        RangeAggregatorSupplier rangeSupplier = context.getValuesSourceRegistry().getAggregator(RangeAggregationBuilder.REGISTRY_KEY, valuesSourceConfig);
        if (rangeSupplier == null) {
            logger.trace("couldn't adapt [{}], no range for [{}/{}]", (Object)name, (Object)valuesSourceConfig.fieldContext().field(), (Object)valuesSourceConfig.fieldType());
            return null;
        }
        RangeAggregator.Range[] ranges = DateHistogramAggregator.ranges(hardBounds, fixedRoundingPoints);
        return new FromDateRange(parent, factories, (CheckedFunction<AggregatorFactories, Aggregator, IOException>)((CheckedFunction)subAggregators -> rangeSupplier.build(name, (AggregatorFactories)subAggregators, valuesSourceConfig, InternalDateRange.FACTORY, ranges, false, context, parent, cardinality, metadata)), valuesSourceConfig.format(), rounding, preparedRounding, order, minDocCount, extendedBounds, keyed, downsampledResultsOffset, fixedRoundingPoints);
    }

    private static RangeAggregator.Range[] ranges(LongBounds hardBounds, long[] fixedRoundingPoints) {
        if (hardBounds == null) {
            RangeAggregator.Range[] ranges = new RangeAggregator.Range[fixedRoundingPoints.length];
            for (int i = 0; i < fixedRoundingPoints.length - 1; ++i) {
                ranges[i] = new RangeAggregator.Range(null, Double.valueOf(fixedRoundingPoints[i]), Double.valueOf(fixedRoundingPoints[i + 1]));
            }
            ranges[ranges.length - 1] = new RangeAggregator.Range(null, Double.valueOf(fixedRoundingPoints[fixedRoundingPoints.length - 1]), null);
            return ranges;
        }
        ArrayList<RangeAggregator.Range> ranges = new ArrayList<RangeAggregator.Range>(fixedRoundingPoints.length);
        for (int i = 0; i < fixedRoundingPoints.length - 1; ++i) {
            if (!hardBounds.contain(fixedRoundingPoints[i])) continue;
            ranges.add(new RangeAggregator.Range(null, Double.valueOf(fixedRoundingPoints[i]), Double.valueOf(fixedRoundingPoints[i + 1])));
        }
        if (hardBounds.contain(fixedRoundingPoints[fixedRoundingPoints.length - 1])) {
            ranges.add(new RangeAggregator.Range(null, Double.valueOf(fixedRoundingPoints[fixedRoundingPoints.length - 1]), null));
        }
        return (RangeAggregator.Range[])ranges.toArray(RangeAggregator.Range[]::new);
    }

    DateHistogramAggregator(String name, AggregatorFactories factories, Rounding rounding, Rounding.Prepared preparedRounding, BucketOrder order, boolean keyed, long minDocCount, boolean downsampledResultsOffset, @Nullable LongBounds extendedBounds, @Nullable LongBounds hardBounds, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, CardinalityUpperBound.MANY, metadata);
        this.rounding = rounding;
        this.preparedRounding = preparedRounding;
        this.order = order;
        order.validate(this);
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.downsampledResultsOffset = downsampledResultsOffset;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
        this.formatter = valuesSourceConfig.format();
        this.bucketOrds = LongKeyedBucketOrds.build(this.bigArrays(), cardinality);
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        SortedNumericDocValues values = this.valuesSource.longValues(aggCtx.getLeafReaderContext());
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        return singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(values, sub);
    }

    private LeafBucketCollector getLeafCollector(final SortedNumericDocValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    long previousRounded = Long.MIN_VALUE;
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        long rounded = DateHistogramAggregator.this.preparedRounding.round(values.nextValue());
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        DateHistogramAggregator.this.addRoundedValue(rounded, doc, owningBucketOrd, sub);
                        previousRounded = rounded;
                    }
                }
            }
        };
    }

    private LeafBucketCollector getLeafCollector(final NumericDocValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    DateHistogramAggregator.this.addRoundedValue(DateHistogramAggregator.this.preparedRounding.round(values.longValue()), doc, owningBucketOrd, sub);
                }
            }
        };
    }

    private void addRoundedValue(long rounded, int doc, long owningBucketOrd, LeafBucketCollector sub) throws IOException {
        if (this.hardBounds == null || this.hardBounds.contain(rounded)) {
            long bucketOrd = this.bucketOrds.add(owningBucketOrd, rounded);
            if (bucketOrd < 0L) {
                bucketOrd = -1L - bucketOrd;
                this.collectExistingBucket(sub, doc, bucketOrd);
            } else {
                this.collectBucket(sub, doc, bucketOrd);
            }
        }
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForVariableBuckets(owningBucketOrds, this.bucketOrds, (bucketValue, docCount, subAggregationResults) -> new InternalDateHistogram.Bucket(bucketValue, docCount, this.keyed, this.formatter, subAggregationResults), (owningBucketOrd, buckets) -> {
            if (buckets.isEmpty()) {
                return this.buildEmptyAggregation();
            }
            CollectionUtil.introSort((List)buckets, BucketOrder.key(true).comparator());
            InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding.withoutOffset(), this.buildEmptySubAggregations(), this.extendedBounds) : null;
            return new InternalDateHistogram(this.name, buckets, this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.downsampledResultsOffset, this.metadata());
        });
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding.withoutOffset(), this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return new InternalDateHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.downsampledResultsOffset, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        add.accept("total_buckets", this.bucketOrds.size());
    }

    @Override
    public double bucketSize(long bucket, Rounding.DateTimeUnit unitSize) {
        if (unitSize != null) {
            return this.preparedRounding.roundingSize(this.bucketOrds.get(bucket), unitSize);
        }
        return 1.0;
    }

    @Override
    public double bucketSize(Rounding.DateTimeUnit unitSize) {
        if (unitSize != null) {
            return this.preparedRounding.roundingSize(unitSize);
        }
        return 1.0;
    }

    static class FromDateRange
    extends AdaptingAggregator
    implements SizedBucketAggregator {
        private final DocValueFormat format;
        private final Rounding rounding;
        private final Rounding.Prepared preparedRounding;
        private final BucketOrder order;
        private final long minDocCount;
        private final LongBounds extendedBounds;
        private final boolean keyed;
        private final boolean downsampledResultsOffset;
        private final long[] fixedRoundingPoints;

        FromDateRange(Aggregator parent, AggregatorFactories subAggregators, CheckedFunction<AggregatorFactories, Aggregator, IOException> delegate, DocValueFormat format, Rounding rounding, Rounding.Prepared preparedRounding, BucketOrder order, long minDocCount, LongBounds extendedBounds, boolean keyed, boolean downsampledResultsOffset, long[] fixedRoundingPoints) throws IOException {
            super(parent, subAggregators, delegate);
            this.format = format;
            this.rounding = rounding;
            this.preparedRounding = preparedRounding;
            this.order = order;
            order.validate(this);
            this.minDocCount = minDocCount;
            this.extendedBounds = extendedBounds;
            this.keyed = keyed;
            this.downsampledResultsOffset = downsampledResultsOffset;
            this.fixedRoundingPoints = fixedRoundingPoints;
        }

        @Override
        protected InternalAggregation adapt(InternalAggregation delegateResult) {
            InternalDateRange range = (InternalDateRange)delegateResult;
            ArrayList<InternalDateHistogram.Bucket> buckets = new ArrayList<InternalDateHistogram.Bucket>(range.getBuckets().size());
            range.getBuckets().stream().forEach(rangeBucket -> {
                if (rangeBucket.getDocCount() > 0L) {
                    buckets.add(new InternalDateHistogram.Bucket(rangeBucket.getFrom().toInstant().toEpochMilli(), rangeBucket.getDocCount(), this.keyed, this.format, rangeBucket.getAggregations()));
                }
            });
            CollectionUtil.introSort(buckets, BucketOrder.key(true).comparator());
            InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding.withoutOffset(), this.buildEmptySubAggregations(), this.extendedBounds) : null;
            return new InternalDateHistogram(range.getName(), buckets, this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.format, this.keyed, this.downsampledResultsOffset, range.getMetadata());
        }

        public final InternalAggregations buildEmptySubAggregations() {
            ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
            for (Aggregator aggregator : this.subAggregators()) {
                aggs.add(aggregator.buildEmptyAggregation());
            }
            return InternalAggregations.from(aggs);
        }

        @Override
        public double bucketSize(long bucket, Rounding.DateTimeUnit unitSize) {
            if (unitSize != null) {
                long startPoint = bucket < (long)this.fixedRoundingPoints.length ? this.fixedRoundingPoints[(int)bucket] : Long.MIN_VALUE;
                return this.preparedRounding.roundingSize(startPoint, unitSize);
            }
            return 1.0;
        }

        @Override
        public double bucketSize(Rounding.DateTimeUnit unitSize) {
            if (unitSize != null) {
                return this.preparedRounding.roundingSize(unitSize);
            }
            return 1.0;
        }
    }
}

