/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.AggregatorsReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.sort.SortValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class InternalSingleBucketAggregation
extends InternalAggregation
implements SingleBucketAggregation {
    private final long docCount;
    private final InternalAggregations aggregations;

    protected InternalSingleBucketAggregation(String name, long docCount, InternalAggregations aggregations, Map<String, Object> metadata) {
        super(name, metadata);
        this.docCount = docCount;
        this.aggregations = aggregations;
    }

    protected InternalSingleBucketAggregation(StreamInput in) throws IOException {
        super(in);
        this.docCount = in.readVLong();
        this.aggregations = InternalAggregations.readFrom(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVLong(this.docCount);
        this.aggregations.writeTo(out);
    }

    @Override
    public long getDocCount() {
        return this.docCount;
    }

    @Override
    public InternalAggregations getAggregations() {
        return this.aggregations;
    }

    public InternalSingleBucketAggregation create(InternalAggregations subAggregations) {
        return this.newAggregation(this.getName(), this.getDocCount(), subAggregations);
    }

    protected abstract InternalSingleBucketAggregation newAggregation(String var1, long var2, InternalAggregations var4);

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            long docCount = 0L;
            final AggregatorsReducer subAggregatorReducer = new AggregatorsReducer(reduceContext, size);

            @Override
            public void accept(InternalAggregation aggregation) {
                this.docCount += ((InternalSingleBucketAggregation)aggregation).docCount;
                this.subAggregatorReducer.accept(((InternalSingleBucketAggregation)aggregation).aggregations);
            }

            @Override
            public InternalAggregation get() {
                return InternalSingleBucketAggregation.this.newAggregation(InternalSingleBucketAggregation.this.getName(), this.docCount, this.subAggregatorReducer.get());
            }

            @Override
            public void close() {
                Releasables.close((Releasable)this.subAggregatorReducer);
            }
        };
    }

    @Override
    public final InternalAggregation reducePipelines(InternalAggregation reducedAggs, AggregationReduceContext reduceContext, PipelineAggregator.PipelineTree pipelineTree) {
        assert (reduceContext.isFinalReduce());
        InternalSingleBucketAggregation reduced = this;
        if (pipelineTree.hasSubTrees()) {
            ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
            for (InternalAggregation agg : this.getAggregations()) {
                PipelineAggregator.PipelineTree subTree = pipelineTree.subTree(agg.getName());
                aggs.add(agg.reducePipelines(agg, reduceContext, subTree));
            }
            InternalAggregations reducedSubAggs = InternalAggregations.from(aggs);
            reduced = this.create(reducedSubAggs);
        }
        return super.reducePipelines(reduced, reduceContext, pipelineTree);
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        String aggName = path.get(0);
        if (aggName.equals("_count")) {
            if (path.size() > 1) {
                throw new IllegalArgumentException("_count must be the last element in the path");
            }
            return this.getDocCount();
        }
        Object aggregation = this.aggregations.get(aggName);
        if (aggregation == null) {
            throw new IllegalArgumentException("Cannot find an aggregation named [" + aggName + "] in [" + this.getName() + "]");
        }
        return ((InternalAggregation)aggregation).getProperty(path.subList(1, path.size()));
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
        this.aggregations.toXContentInternal(builder, params);
        return builder;
    }

    @Override
    public final SortValue sortValue(String key) {
        if (key != null && !key.equals("doc_count")) {
            throw new IllegalArgumentException("Unknown value key [" + key + "] for single-bucket aggregation [" + this.getName() + "]. Either use [doc_count] as key or drop the key all together.");
        }
        return SortValue.from(this.docCount);
    }

    @Override
    public final SortValue sortValue(AggregationPath.PathElement head, Iterator<AggregationPath.PathElement> tail) {
        return this.aggregations.sortValue(head, tail);
    }

    @Override
    protected boolean mustReduceOnSingleInternalAgg() {
        return true;
    }

    @Override
    public InternalAggregation copyWithRewritenBuckets(Function<InternalAggregations, InternalAggregations> rewriter) {
        InternalAggregations rewritten = rewriter.apply(this.aggregations);
        if (rewritten == null) {
            return this;
        }
        return this.create(rewritten);
    }

    @Override
    public void forEachBucket(Consumer<InternalAggregations> consumer) {
        consumer.accept(this.aggregations);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalSingleBucketAggregation other = (InternalSingleBucketAggregation)obj;
        return Objects.equals(this.docCount, other.docCount) && Objects.equals(this.aggregations, other.aggregations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.docCount, this.aggregations);
    }
}

