/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InvalidAggregationPathException;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class InternalMultiBucketAggregation<A extends InternalMultiBucketAggregation, B extends InternalBucket>
extends InternalAggregation
implements MultiBucketsAggregation {
    public static final int REPORT_EMPTY_EVERY = 10000;

    public InternalMultiBucketAggregation(String name, Map<String, Object> metadata) {
        super(name, metadata);
    }

    protected InternalMultiBucketAggregation(StreamInput in) throws IOException {
        super(in);
    }

    public abstract A create(List<B> var1);

    public abstract B createBucket(InternalAggregations var1, B var2);

    public abstract List<B> getBuckets();

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        return InternalMultiBucketAggregation.resolvePropertyFromPath(path, this.getBuckets(), this.getName());
    }

    /*
     * WARNING - void declaration
     */
    static Object resolvePropertyFromPath(List<String> path, List<? extends InternalBucket> buckets, String name) {
        void var5_8;
        String aggName = path.get(0);
        if (aggName.equals("_bucket_count")) {
            return buckets.size();
        }
        if (aggName.startsWith("'") && aggName.endsWith("'")) {
            for (InternalBucket internalBucket : buckets) {
                if (!internalBucket.getKeyAsString().equals(aggName.substring(1, aggName.length() - 1))) continue;
                return internalBucket.getProperty(name, path.subList(1, path.size()));
            }
            throw new InvalidAggregationPathException("Cannot find an key [" + aggName + "] in [" + name + "]");
        }
        Object[] propertyArray = new Object[buckets.size()];
        boolean bl = false;
        while (var5_8 < buckets.size()) {
            propertyArray[var5_8] = buckets.get((int)var5_8).getProperty(name, path);
            ++var5_8;
        }
        return propertyArray;
    }

    public static int countInnerBucket(InternalBucket bucket) {
        int count = 0;
        for (Aggregation agg : bucket.getAggregations()) {
            count += InternalMultiBucketAggregation.countInnerBucket(agg);
        }
        return count;
    }

    public static int countInnerBucket(Aggregation agg) {
        int size;
        block4: {
            block3: {
                size = 0;
                if (!(agg instanceof MultiBucketsAggregation)) break block3;
                MultiBucketsAggregation multi = (MultiBucketsAggregation)agg;
                for (MultiBucketsAggregation.Bucket bucket : multi.getBuckets()) {
                    ++size;
                    for (Aggregation bucketAgg : bucket.getAggregations()) {
                        size += InternalMultiBucketAggregation.countInnerBucket(bucketAgg);
                    }
                }
                break block4;
            }
            if (!(agg instanceof SingleBucketAggregation)) break block4;
            SingleBucketAggregation single = (SingleBucketAggregation)agg;
            for (Aggregation aggregation : single.getAggregations()) {
                size += InternalMultiBucketAggregation.countInnerBucket(aggregation);
            }
        }
        return size;
    }

    @Override
    public final InternalAggregation reducePipelines(InternalAggregation reducedAggs, AggregationReduceContext reduceContext, PipelineAggregator.PipelineTree pipelineTree) {
        assert (reduceContext.isFinalReduce());
        InternalMultiBucketAggregation<A, B> reduced = this;
        if (pipelineTree.hasSubTrees()) {
            List<B> materializedBuckets = this.reducePipelineBuckets(reduceContext, pipelineTree);
            reduced = this.create(materializedBuckets);
        }
        return super.reducePipelines(reduced, reduceContext, pipelineTree);
    }

    @Override
    public InternalAggregation copyWithRewritenBuckets(Function<InternalAggregations, InternalAggregations> rewriter) {
        boolean modified = false;
        ArrayList<InternalBucket> newBuckets = new ArrayList<InternalBucket>();
        for (InternalBucket bucket : this.getBuckets()) {
            InternalAggregations rewritten = rewriter.apply(bucket.getAggregations());
            if (rewritten == null) {
                newBuckets.add(bucket);
                continue;
            }
            modified = true;
            InternalBucket newBucket = this.createBucket(rewritten, bucket);
            newBuckets.add(newBucket);
        }
        return modified ? this.create(newBuckets) : this;
    }

    @Override
    protected boolean mustReduceOnSingleInternalAgg() {
        return true;
    }

    @Override
    public void forEachBucket(Consumer<InternalAggregations> consumer) {
        for (InternalBucket bucket : this.getBuckets()) {
            consumer.accept(bucket.getAggregations());
        }
    }

    private List<B> reducePipelineBuckets(AggregationReduceContext reduceContext, PipelineAggregator.PipelineTree pipelineTree) {
        ArrayList<B> reducedBuckets = null;
        List<B> buckets = this.getBuckets();
        for (int bucketIndex = 0; bucketIndex < buckets.size(); ++bucketIndex) {
            InternalBucket bucket = (InternalBucket)buckets.get(bucketIndex);
            List<InternalAggregation> aggs = null;
            int aggIndex = 0;
            for (InternalAggregation agg : bucket.getAggregations()) {
                PipelineAggregator.PipelineTree subTree;
                InternalAggregation reduced = agg.reducePipelines(agg, reduceContext, subTree = pipelineTree.subTree(agg.getName()));
                if (!reduced.equals(agg)) {
                    if (aggs == null) {
                        aggs = bucket.getAggregations().copyResults();
                    }
                    aggs.set(aggIndex, reduced);
                }
                ++aggIndex;
            }
            if (aggs == null) continue;
            if (reducedBuckets == null) {
                reducedBuckets = new ArrayList<B>(buckets);
            }
            reducedBuckets.set(bucketIndex, this.createBucket(InternalAggregations.from(aggs), bucket));
        }
        return reducedBuckets == null ? buckets : reducedBuckets;
    }

    public static abstract class InternalBucket
    implements MultiBucketsAggregation.Bucket,
    Writeable {
        public Object getProperty(String containingAggName, List<String> path) {
            if (path.isEmpty()) {
                return this;
            }
            InternalAggregations aggregations = this.getAggregations();
            String aggName = path.get(0);
            if (aggName.equals("_count")) {
                if (path.size() > 1) {
                    throw new InvalidAggregationPathException("_count must be the last element in the path");
                }
                return this.getDocCount();
            }
            if (aggName.equals("_key")) {
                if (path.size() > 1) {
                    throw new InvalidAggregationPathException("_key must be the last element in the path");
                }
                return this.getKey();
            }
            Object aggregation = aggregations.get(aggName);
            if (aggregation == null) {
                throw new InvalidAggregationPathException("Cannot find an aggregation named [" + aggName + "] in [" + containingAggName + "]");
            }
            return ((InternalAggregation)aggregation).getProperty(path.subList(1, path.size()));
        }
    }

    protected static class BucketAggregationList<B extends MultiBucketsAggregation.Bucket>
    extends AbstractList<InternalAggregations> {
        private final List<B> buckets;

        public BucketAggregationList(List<B> buckets) {
            this.buckets = buckets;
        }

        @Override
        public InternalAggregations get(int index) {
            return ((MultiBucketsAggregation.Bucket)this.buckets.get(index)).getAggregations();
        }

        @Override
        public int size() {
            return this.buckets.size();
        }
    }
}

