/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestRolloverIndexAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestRolloverIndexAction.class);
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Using include_type_name in rollover index requests is deprecated. The parameter will be removed in the next major version.";

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_rollover"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_rollover/{new_index}"));
    }

    @Override
    public String getName() {
        return "rollover_index_action";
    }

    @Override
    public Set<String> supportedCapabilities() {
        if (DataStream.isFailureStoreFeatureFlagEnabled()) {
            return Set.of("lazy-rollover-failure-store");
        }
        return Set.of();
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean failureStore;
        boolean includeTypeName = RestRolloverIndexAction.includeTypeName(request);
        RolloverRequest rolloverIndexRequest = new RolloverRequest(request.param("index"), request.param("new_index"));
        request.applyContentParser((CheckedConsumer<XContentParser, IOException>)((CheckedConsumer)parser -> rolloverIndexRequest.fromXContent(includeTypeName, (XContentParser)parser)));
        rolloverIndexRequest.dryRun(request.paramAsBoolean("dry_run", false));
        rolloverIndexRequest.lazy(request.paramAsBoolean("lazy", false));
        rolloverIndexRequest.ackTimeout(RestUtils.getAckTimeout(request));
        rolloverIndexRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        if (DataStream.isFailureStoreFeatureFlagEnabled() && (failureStore = request.paramAsBoolean("target_failure_store", false))) {
            rolloverIndexRequest.setIndicesOptions(IndicesOptions.builder(rolloverIndexRequest.indicesOptions()).failureStoreOptions(new IndicesOptions.FailureStoreOptions(false, true)).build());
        }
        rolloverIndexRequest.getCreateIndexRequest().waitForActiveShards(ActiveShardCount.parseString(request.param("wait_for_active_shards")));
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).admin().indices().rolloverIndex(rolloverIndexRequest, new RestToXContentListener<RolloverResponse>((RestChannel)channel));
    }

    private static boolean includeTypeName(RestRequest request) {
        boolean includeTypeName = false;
        if (request.getRestApiVersion() == RestApiVersion.V_7) {
            if (request.hasParam("include_type_name")) {
                deprecationLogger.compatibleCritical("index_rollover_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            }
            includeTypeName = request.paramAsBoolean("include_type_name", false);
        }
        return includeTypeName;
    }
}

