/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateAction;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateRequest;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;

@ServerlessScope(value=Scope.INTERNAL)
public class RestResetFeatureStateAction
extends BaseRestHandler {
    @Override
    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_features/_reset"));
    }

    @Override
    public String getName() {
        return "reset_feature_state";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ResetFeatureStateRequest req = new ResetFeatureStateRequest(RestUtils.getMasterNodeTimeout(request));
        return restChannel -> client.execute(ResetFeatureStateAction.INSTANCE, req, new RestToXContentListener<ResetFeatureStateResponse>((RestChannel)restChannel, r -> {
            long failures = r.getFeatureStateResetStatuses().stream().filter(status -> status.getStatus() == ResetFeatureStateResponse.ResetFeatureStateStatus.Status.FAILURE).count();
            if (failures == 0L) {
                return RestStatus.OK;
            }
            if (failures == (long)r.getFeatureStateResetStatuses().size()) {
                return RestStatus.INTERNAL_SERVER_ERROR;
            }
            return RestStatus.MULTI_STATUS;
        }));
    }
}

