/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.script.StoredScriptSource;
import org.elasticsearch.xcontent.XContentType;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutStoredScriptAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_scripts/{id}"), new RestHandler.Route(RestRequest.Method.PUT, "/_scripts/{id}"), new RestHandler.Route(RestRequest.Method.POST, "/_scripts/{id}/{context}"), new RestHandler.Route(RestRequest.Method.PUT, "/_scripts/{id}/{context}"));
    }

    @Override
    public String getName() {
        return "put_stored_script_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id = request.param("id");
        String context = request.param("context");
        BytesReference content = request.requiredContent();
        XContentType xContentType = request.getXContentType();
        StoredScriptSource source = StoredScriptSource.parse(content, xContentType);
        PutStoredScriptRequest putRequest = new PutStoredScriptRequest(id, context, content, request.getXContentType(), source);
        putRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        putRequest.ackTimeout(RestUtils.getAckTimeout(request));
        return channel -> client.admin().cluster().putStoredScript(putRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

