/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.search.uhighlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanNearQuery;
import org.apache.lucene.queries.spans.SpanOrQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.uhighlight.FieldHighlighter;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.NoOpOffsetStrategy;
import org.apache.lucene.search.uhighlight.Passage;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.PassageScorer;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.search.ESToParentBlockJoinQuery;
import org.elasticsearch.lucene.search.uhighlight.CustomFieldHighlighter;
import org.elasticsearch.lucene.search.uhighlight.Snippet;
import org.elasticsearch.search.fetch.subphase.highlight.AbstractHighlighterBuilder;
import org.elasticsearch.search.runtime.AbstractScriptFieldQuery;
import org.elasticsearch.search.vectors.KnnScoreDocQuery;

public final class CustomUnifiedHighlighter
extends UnifiedHighlighter {
    public static final char MULTIVAL_SEP_CHAR = '\u0000';
    private static final Snippet[] EMPTY_SNIPPET = new Snippet[0];
    private final UnifiedHighlighter.OffsetSource offsetSource;
    private final String index;
    private final String field;
    private final Locale breakIteratorLocale;
    private final int noMatchSize;
    private final CustomFieldHighlighter fieldHighlighter;
    private final int maxAnalyzedOffset;
    private final Integer queryMaxAnalyzedOffset;

    public CustomUnifiedHighlighter(UnifiedHighlighter.Builder builder, UnifiedHighlighter.OffsetSource offsetSource, @Nullable Locale breakIteratorLocale, String index, String field, Query query, int noMatchSize, int maxPassages, int maxAnalyzedOffset, Integer queryMaxAnalyzedOffset, boolean requireFieldMatch, boolean weightMatchesEnabled) {
        super(builder);
        this.offsetSource = offsetSource;
        this.breakIteratorLocale = breakIteratorLocale == null ? Locale.ROOT : breakIteratorLocale;
        this.index = index;
        this.field = field;
        this.noMatchSize = noMatchSize;
        this.maxAnalyzedOffset = maxAnalyzedOffset;
        this.queryMaxAnalyzedOffset = queryMaxAnalyzedOffset;
        if (!weightMatchesEnabled || !requireFieldMatch || this.weightMatchesUnsupported(query)) {
            this.getFlags(field).remove(UnifiedHighlighter.HighlightFlag.WEIGHT_MATCHES);
        }
        this.fieldHighlighter = (CustomFieldHighlighter)this.getFieldHighlighter(field, query, CustomUnifiedHighlighter.extractTerms((Query)query), maxPassages);
    }

    public Snippet[] highlightField(LeafReader reader, int docId, CheckedSupplier<String, IOException> loadFieldValue) throws IOException {
        if (this.fieldHighlighter.getFieldOffsetStrategy() == NoOpOffsetStrategy.INSTANCE && this.noMatchSize == 0) {
            return EMPTY_SNIPPET;
        }
        String fieldValue = loadFieldValue.get();
        if (fieldValue == null) {
            return null;
        }
        int fieldValueLength = fieldValue.length();
        if ((this.queryMaxAnalyzedOffset == null || this.queryMaxAnalyzedOffset > this.maxAnalyzedOffset) && this.getOffsetSource(this.field) == UnifiedHighlighter.OffsetSource.ANALYSIS && fieldValueLength > this.maxAnalyzedOffset) {
            throw new IllegalArgumentException("The length [" + fieldValueLength + "] of field [" + this.field + "] in doc[" + docId + "]/index[" + this.index + "] exceeds the [" + IndexSettings.MAX_ANALYZED_OFFSET_SETTING.getKey() + "] limit [" + this.maxAnalyzedOffset + "]. To avoid this error, set the query parameter [" + AbstractHighlighterBuilder.MAX_ANALYZED_OFFSET_FIELD + "] to a value less than index setting [" + this.maxAnalyzedOffset + "] and this will tolerate long field values by truncating them.");
        }
        Snippet[] result = (Snippet[])this.fieldHighlighter.highlightFieldForDoc(reader, docId, fieldValue);
        return result == null ? EMPTY_SNIPPET : result;
    }

    public PassageFormatter getFormatter() {
        return super.getFormatter(this.field);
    }

    protected FieldHighlighter newFieldHighlighter(String field, FieldOffsetStrategy fieldOffsetStrategy, BreakIterator breakIterator, PassageScorer passageScorer, int maxPassages, int maxNoHighlightPassages, PassageFormatter passageFormatter, Comparator<Passage> passageSortComparator) {
        return new CustomFieldHighlighter(field, fieldOffsetStrategy, this.breakIteratorLocale, breakIterator, this.getScorer(field), maxPassages, this.noMatchSize > 0 ? 1 : 0, this.getFormatter(field), passageSortComparator, this.noMatchSize, this.queryMaxAnalyzedOffset);
    }

    protected Collection<Query> preSpanQueryRewrite(Query query) {
        if (query instanceof MultiPhrasePrefixQuery) {
            MultiPhrasePrefixQuery mpq = (MultiPhrasePrefixQuery)query;
            Term[][] terms = mpq.getTerms();
            int[] positions = mpq.getPositions();
            SpanQuery[] positionSpanQueries = new SpanQuery[positions.length];
            int sizeMinus1 = terms.length - 1;
            for (int i = 0; i < positions.length; ++i) {
                SpanQuery[] innerQueries = new SpanQuery[terms[i].length];
                for (int j = 0; j < terms[i].length; ++j) {
                    innerQueries[j] = i == sizeMinus1 ? new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(terms[i][j])) : new SpanTermQuery(terms[i][j]);
                }
                positionSpanQueries[i] = innerQueries.length > 1 ? new SpanOrQuery(innerQueries) : innerQueries[0];
            }
            if (positionSpanQueries.length == 1) {
                return Collections.singletonList(positionSpanQueries[0]);
            }
            int positionGaps = 0;
            if (positions.length >= 2) {
                positionGaps = Math.max(0, positions[positions.length - 1] - positions[0] - positions.length + 1);
            }
            boolean inorder = mpq.getSlop() == 0;
            return Collections.singletonList(new SpanNearQuery(positionSpanQueries, mpq.getSlop() + positionGaps, inorder));
        }
        if (query instanceof ESToParentBlockJoinQuery) {
            return Collections.singletonList(((ESToParentBlockJoinQuery)query).getChildQuery());
        }
        return null;
    }

    protected UnifiedHighlighter.OffsetSource getOffsetSource(String field) {
        if (this.offsetSource == null) {
            return super.getOffsetSource(field);
        }
        return this.offsetSource;
    }

    private boolean weightMatchesUnsupported(final Query query) {
        final boolean[] hasUnknownLeaf = new boolean[1];
        query.visit(new QueryVisitor(){

            public void visitLeaf(Query leafQuery) {
                if (leafQuery.getClass().getSimpleName().equals("LateParsingQuery")) {
                    hasUnknownLeaf[0] = true;
                }
                if (leafQuery instanceof KnnScoreDocQuery) {
                    hasUnknownLeaf[0] = true;
                }
                super.visitLeaf(query);
            }

            public void consumeTerms(Query leafQuery, Term ... terms) {
                if (leafQuery instanceof AbstractScriptFieldQuery) {
                    hasUnknownLeaf[0] = true;
                }
                super.consumeTerms(query, terms);
            }

            public void consumeTermsMatching(Query leafQuery, String field, Supplier<ByteRunAutomaton> automaton) {
                if (leafQuery instanceof AbstractScriptFieldQuery) {
                    hasUnknownLeaf[0] = true;
                }
                super.consumeTermsMatching(query, field, automaton);
            }

            public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
                if (parent instanceof ESToParentBlockJoinQuery) {
                    hasUnknownLeaf[0] = true;
                }
                return this;
            }
        });
        return hasUnknownLeaf[0];
    }
}

