/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;

public class TimestampFieldMapperService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(TimestampFieldMapperService.class);
    private final IndicesService indicesService;
    private final ExecutorService executor;
    private final Map<Index, PlainActionFuture<DateFieldMapper.DateFieldType>> fieldTypesByIndex = ConcurrentCollections.newConcurrentMap();

    public TimestampFieldMapperService(Settings settings, ThreadPool threadPool, IndicesService indicesService) {
        this.indicesService = indicesService;
        String nodeName = Objects.requireNonNull(Node.NODE_NAME_SETTING.get(settings));
        String threadName = "TimestampFieldMapperService#updateTask";
        this.executor = EsExecutors.newScaling(nodeName + "/TimestampFieldMapperService#updateTask", 0, 1, 0L, TimeUnit.MILLISECONDS, true, EsExecutors.daemonThreadFactory(nodeName, "TimestampFieldMapperService#updateTask"), threadPool.getThreadContext());
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        ThreadPool.terminate(this.executor, 10L, TimeUnit.SECONDS);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        Metadata metadata = event.state().metadata();
        Map<String, IndexMetadata> indices = metadata.indices();
        if (indices == event.previousState().metadata().indices()) {
            return;
        }
        this.fieldTypesByIndex.keySet().removeIf(index -> !TimestampFieldMapperService.hasUsefulTimestampField(metadata.index((Index)index)));
        for (final IndexMetadata indexMetadata : indices.values()) {
            final Index index2 = indexMetadata.getIndex();
            if (!TimestampFieldMapperService.hasUsefulTimestampField(indexMetadata) || this.fieldTypesByIndex.containsKey(index2)) continue;
            logger.trace("computing timestamp mapping for {}", (Object)index2);
            final PlainActionFuture<DateFieldMapper.DateFieldType> future = new PlainActionFuture<DateFieldMapper.DateFieldType>();
            this.fieldTypesByIndex.put(index2, future);
            IndexService indexService = this.indicesService.indexService(index2);
            if (indexService == null) {
                logger.trace("computing timestamp mapping for {} async", (Object)index2);
                this.executor.execute(new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        logger.debug(() -> Strings.format((String)"failed to compute mapping for %s", (Object[])new Object[]{index2}), (Throwable)e);
                        future.onResponse(null);
                    }

                    @Override
                    protected void doRun() throws Exception {
                        try (MapperService mapperService = TimestampFieldMapperService.this.indicesService.createIndexMapperServiceForValidation(indexMetadata);){
                            mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
                            logger.trace("computed timestamp field mapping for {}", (Object)index2);
                            future.onResponse(TimestampFieldMapperService.fromMapperService(mapperService));
                        }
                    }
                });
                continue;
            }
            logger.trace("computing timestamp mapping for {} using existing index service", (Object)index2);
            try {
                future.onResponse(TimestampFieldMapperService.fromMapperService(indexService.mapperService()));
            }
            catch (Exception e) {
                assert (false) : e;
                future.onResponse(null);
            }
        }
    }

    private static boolean hasUsefulTimestampField(IndexMetadata indexMetadata) {
        if (indexMetadata == null) {
            return false;
        }
        if (indexMetadata.hasTimeSeriesTimestampRange()) {
            return true;
        }
        IndexLongFieldRange timestampRange = indexMetadata.getTimestampRange();
        return timestampRange.isComplete() && timestampRange != IndexLongFieldRange.UNKNOWN;
    }

    private static DateFieldMapper.DateFieldType fromMapperService(MapperService mapperService) {
        MappedFieldType mappedFieldType = mapperService.fieldType("@timestamp");
        if (mappedFieldType instanceof DateFieldMapper.DateFieldType) {
            return (DateFieldMapper.DateFieldType)mappedFieldType;
        }
        return null;
    }

    @Nullable
    public DateFieldMapper.DateFieldType getTimestampFieldType(Index index) {
        PlainActionFuture<DateFieldMapper.DateFieldType> future = this.fieldTypesByIndex.get(index);
        if (future == null || !future.isDone()) {
            return null;
        }
        try {
            return future.result();
        }
        catch (ExecutionException e) {
            throw new UncategorizedExecutionException("An error occurred fetching timestamp field type for " + index, e);
        }
    }
}

