/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.NativeFSLockFactory;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.allocation.command.AllocateEmptyPrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocateStalePrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommands;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeMetadata;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.RemoveCorruptedLuceneSegmentsAction;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.shard.ShardStateMetadata;
import org.elasticsearch.index.translog.TruncateTranslogAction;
import org.elasticsearch.xcontent.ToXContent;

public class RemoveCorruptedShardDataCommand
extends ElasticsearchNodeCommand {
    private static final Logger logger = LogManager.getLogger(RemoveCorruptedShardDataCommand.class);
    private final OptionSpec<String> folderOption;
    private final OptionSpec<String> indexNameOption;
    private final OptionSpec<Integer> shardIdOption;
    static final String TRUNCATE_CLEAN_TRANSLOG_FLAG = "truncate-clean-translog";

    public RemoveCorruptedShardDataCommand() {
        super("Removes corrupted shard files");
        this.folderOption = this.parser.acceptsAll(Arrays.asList("d", "dir"), "Index directory location on disk").withRequiredArg();
        this.indexNameOption = this.parser.accepts("index", "Index name").withRequiredArg();
        this.shardIdOption = this.parser.accepts("shard-id", "Shard id").withRequiredArg().ofType(Integer.class);
        this.parser.accepts(TRUNCATE_CLEAN_TRANSLOG_FLAG, "Truncate the translog even if it is not corrupt");
    }

    protected void printAdditionalHelp(Terminal terminal) {
        terminal.println((CharSequence)"This tool attempts to detect and remove unrecoverable corrupted data in a shard.");
    }

    public OptionParser getParser() {
        return this.parser;
    }

    @SuppressForbidden(reason="Necessary to use the path passed in")
    protected static Path getPath(String dirValue) {
        return PathUtils.get((String)dirValue, (String[])new String[]{"", ""});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void findAndProcessShardPath(OptionSet options, Environment environment, Path[] dataPaths, ClusterState clusterState, CheckedConsumer<ShardPath, IOException> consumer) throws IOException {
        IndexMetadata indexMetadata;
        int shardId;
        Settings settings = environment.settings();
        if (options.has(this.folderOption)) {
            Path path = RemoveCorruptedShardDataCommand.getPath((String)this.folderOption.value(options)).getParent();
            Path shardParent = path.getParent();
            Path shardParentParent = shardParent.getParent();
            Path indexPath = path.resolve("index");
            if (!Files.exists(indexPath, new LinkOption[0]) || !Files.isDirectory(indexPath, new LinkOption[0])) {
                throw new ElasticsearchException("index directory [" + indexPath + "], must exist and be a directory", new Object[0]);
            }
            String shardIdFileName = path.getFileName().toString();
            String indexUUIDFolderName = shardParent.getFileName().toString();
            if (!Files.isDirectory(path, new LinkOption[0]) || !shardIdFileName.chars().allMatch(Character::isDigit) || !"indices".equals(shardParentParent.getFileName().toString())) throw new ElasticsearchException("Unable to resolve shard id. Wrong folder structure at [ " + path.toString() + " ], expected .../indices/[INDEX-UUID]/[SHARD-ID]", new Object[0]);
            shardId = Integer.parseInt(shardIdFileName);
            indexMetadata = clusterState.metadata().indices().values().stream().filter(imd -> imd.getIndexUUID().equals(indexUUIDFolderName)).findFirst().orElse(null);
        } else {
            String indexName = Objects.requireNonNull((String)this.indexNameOption.value(options), "Index name is required");
            shardId = Objects.requireNonNull((Integer)this.shardIdOption.value(options), "Shard ID is required");
            indexMetadata = clusterState.metadata().index(indexName);
        }
        if (indexMetadata == null) {
            throw new ElasticsearchException("Unable to find index in cluster state", new Object[0]);
        }
        IndexSettings indexSettings = new IndexSettings(indexMetadata, settings);
        Index index = indexMetadata.getIndex();
        ShardId shId = new ShardId(index, shardId);
        for (Path dataPath : dataPaths) {
            ShardPath shardPath;
            Path shardPathLocation = dataPath.resolve("indices").resolve(index.getUUID()).resolve(Integer.toString(shId.id()));
            if (!Files.exists(shardPathLocation, new LinkOption[0]) || (shardPath = ShardPath.loadShardPath(logger, shId, indexSettings.customDataPath(), new Path[]{shardPathLocation}, dataPath)) == null) continue;
            consumer.accept((Object)shardPath);
            return;
        }
    }

    public static boolean isCorruptMarkerFileIsPresent(Directory directory) throws IOException {
        String[] files;
        boolean found = false;
        for (String file : files = directory.listAll()) {
            if (!file.startsWith("corrupted_")) continue;
            found = true;
            break;
        }
        return found;
    }

    protected static void dropCorruptMarkerFiles(Terminal terminal, Path path, Directory directory, boolean clean) throws IOException {
        String[] files;
        if (clean) {
            RemoveCorruptedShardDataCommand.confirm("This shard has been marked as corrupted but no corruption can now be detected.\nThis may indicate an intermittent hardware problem. The corruption marker can be\nremoved, but there is a risk that data has been undetectably lost.\n\nAre you taking a risk of losing documents and proceed with removing a corrupted marker ?", terminal);
        }
        for (String file : files = directory.listAll()) {
            if (!file.startsWith("corrupted_")) continue;
            directory.deleteFile(file);
            terminal.println((CharSequence)("Deleted corrupt marker " + file + " from " + path));
        }
    }

    private static void loseDataDetailsBanner(Terminal terminal, Tuple<CleanStatus, String> cleanStatus) {
        if (cleanStatus.v2() != null) {
            terminal.println((CharSequence)"");
            terminal.println((CharSequence)("  " + (String)cleanStatus.v2()));
            terminal.println((CharSequence)"");
        }
    }

    private static void confirm(String msg, Terminal terminal) {
        terminal.println((CharSequence)msg);
        String text = terminal.readText("Confirm [y/N] ");
        if (!text.equalsIgnoreCase("y")) {
            throw new ElasticsearchException("aborted by user", new Object[0]);
        }
    }

    private static void warnAboutIndexBackup(Terminal terminal) {
        terminal.println((CharSequence)"-----------------------------------------------------------------------");
        terminal.println((CharSequence)"");
        terminal.println((CharSequence)"  Please make a complete backup of your index before using this tool.");
        terminal.println((CharSequence)"");
        terminal.println((CharSequence)"-----------------------------------------------------------------------");
    }

    @Override
    public void processDataPaths(Terminal terminal, Path[] dataPaths, OptionSet options, Environment environment) throws IOException {
        RemoveCorruptedShardDataCommand.warnAboutIndexBackup(terminal);
        ClusterState clusterState = (ClusterState)RemoveCorruptedShardDataCommand.loadTermAndClusterState(RemoveCorruptedShardDataCommand.createPersistedClusterStateService(environment.settings(), dataPaths), environment).v2();
        this.findAndProcessShardPath(options, environment, dataPaths, clusterState, (CheckedConsumer<ShardPath, IOException>)((CheckedConsumer)shardPath -> {
            Directory indexDirectory;
            Path indexPath = shardPath.resolveIndex();
            Path translogPath = shardPath.resolveTranslog();
            if (!Files.exists(translogPath, new LinkOption[0]) || !Files.isDirectory(translogPath, new LinkOption[0])) {
                throw new ElasticsearchException("translog directory [" + translogPath + "], must exist and be a directory", new Object[0]);
            }
            PrintStream printStream = new PrintStream(terminal.asLineOutputStream(StandardCharsets.UTF_8), false, StandardCharsets.UTF_8);
            boolean verbose = terminal.isPrintable(Terminal.Verbosity.VERBOSE);
            try (Directory indexDir = indexDirectory = RemoveCorruptedShardDataCommand.getDirectory(indexPath);){
                Tuple<CleanStatus, String> translogCleanStatus;
                Tuple<CleanStatus, String> indexCleanStatus;
                try (Lock writeIndexLock = indexDir.obtainLock("write.lock");){
                    terminal.println((CharSequence)"");
                    terminal.println((CharSequence)("Opening Lucene index at " + indexPath));
                    terminal.println((CharSequence)"");
                    try {
                        indexCleanStatus = RemoveCorruptedLuceneSegmentsAction.getCleanStatus(indexDir, writeIndexLock, printStream, verbose);
                    }
                    catch (Exception e) {
                        terminal.println((CharSequence)e.getMessage());
                        throw e;
                    }
                    terminal.println((CharSequence)"");
                    terminal.println((CharSequence)(" >> Lucene index is " + ((CleanStatus)((Object)((Object)indexCleanStatus.v1()))).getMessage() + " at " + indexPath));
                    terminal.println((CharSequence)"");
                    if (options.has(TRUNCATE_CLEAN_TRANSLOG_FLAG)) {
                        translogCleanStatus = Tuple.tuple((Object)((Object)CleanStatus.OVERRIDDEN), (Object)"Translog was not analysed and will be truncated due to the --truncate-clean-translog flag");
                    } else if (indexCleanStatus.v1() != CleanStatus.UNRECOVERABLE) {
                        terminal.println((CharSequence)"");
                        terminal.println((CharSequence)("Opening translog at " + translogPath));
                        terminal.println((CharSequence)"");
                        try {
                            translogCleanStatus = TruncateTranslogAction.getCleanStatus(shardPath, clusterState, indexDir);
                        }
                        catch (Exception e) {
                            terminal.println((CharSequence)e.getMessage());
                            throw e;
                        }
                        terminal.println((CharSequence)"");
                        terminal.println((CharSequence)(" >> Translog is " + ((CleanStatus)((Object)((Object)translogCleanStatus.v1()))).getMessage() + " at " + translogPath));
                        terminal.println((CharSequence)"");
                    } else {
                        translogCleanStatus = Tuple.tuple((Object)((Object)CleanStatus.UNRECOVERABLE), null);
                    }
                    CleanStatus indexStatus = (CleanStatus)((Object)((Object)indexCleanStatus.v1()));
                    CleanStatus translogStatus = (CleanStatus)((Object)((Object)translogCleanStatus.v1()));
                    if (indexStatus == CleanStatus.CLEAN && translogStatus == CleanStatus.CLEAN) {
                        throw new ElasticsearchException("Shard does not seem to be corrupted at " + shardPath.getDataPath() + " (pass --truncate-clean-translog to truncate the translog anyway)", new Object[0]);
                    }
                    if (indexStatus == CleanStatus.UNRECOVERABLE) {
                        if (indexCleanStatus.v2() != null) {
                            terminal.println((CharSequence)("Details: " + (String)indexCleanStatus.v2()));
                        }
                        terminal.println((CharSequence)"You can allocate a new, empty, primary shard with the following command:");
                        RemoveCorruptedShardDataCommand.printRerouteCommand(shardPath, terminal, false);
                        throw new ElasticsearchException("Index is unrecoverable", new Object[0]);
                    }
                    terminal.println((CharSequence)"-----------------------------------------------------------------------");
                    if (indexStatus != CleanStatus.CLEAN) {
                        RemoveCorruptedShardDataCommand.loseDataDetailsBanner(terminal, indexCleanStatus);
                    }
                    if (translogStatus != CleanStatus.CLEAN) {
                        RemoveCorruptedShardDataCommand.loseDataDetailsBanner(terminal, translogCleanStatus);
                    }
                    terminal.println((CharSequence)"            WARNING:              YOU MAY LOSE DATA.");
                    terminal.println((CharSequence)"-----------------------------------------------------------------------");
                    RemoveCorruptedShardDataCommand.confirm("Continue and remove corrupted data from the shard ?", terminal);
                    if (indexStatus != CleanStatus.CLEAN) {
                        RemoveCorruptedLuceneSegmentsAction.execute(terminal, indexDir, writeIndexLock, printStream, verbose);
                    }
                    if (translogStatus != CleanStatus.CLEAN) {
                        TruncateTranslogAction.execute(terminal, shardPath, indexDir);
                    }
                }
                catch (LockObtainFailedException lofe) {
                    String msg = "Failed to lock shard's directory at [" + indexPath + "], is Elasticsearch still running?";
                    terminal.println((CharSequence)msg);
                    throw new ElasticsearchException(msg, new Object[0]);
                }
                CleanStatus indexStatus = (CleanStatus)((Object)((Object)indexCleanStatus.v1()));
                CleanStatus translogStatus = (CleanStatus)((Object)((Object)translogCleanStatus.v1()));
                RemoveCorruptedShardDataCommand.addNewHistoryCommit(indexDir, terminal, translogStatus != CleanStatus.CLEAN);
                RemoveCorruptedShardDataCommand.newAllocationId(shardPath, terminal);
                if (indexStatus != CleanStatus.CLEAN) {
                    RemoveCorruptedShardDataCommand.dropCorruptMarkerFiles(terminal, indexPath, indexDir, indexStatus == CleanStatus.CLEAN_WITH_CORRUPTED_MARKER);
                }
            }
        }));
    }

    private static Directory getDirectory(Path indexPath) {
        FSDirectory directory;
        try {
            directory = FSDirectory.open((Path)indexPath, (LockFactory)NativeFSLockFactory.INSTANCE);
        }
        catch (Throwable t) {
            throw new ElasticsearchException("ERROR: could not open directory \"" + indexPath + "\"; exiting", new Object[0]);
        }
        return directory;
    }

    protected static void addNewHistoryCommit(Directory indexDirectory, Terminal terminal, boolean updateLocalCheckpoint) throws IOException {
        String historyUUID = UUIDs.randomBase64UUID();
        terminal.println((CharSequence)("Marking index with the new history uuid : " + historyUUID));
        IndexWriterConfig iwc = Lucene.indexWriterConfigWithNoMerging(null).setCommitOnClose(false).setSoftDeletesField("__soft_deletes").setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        try (IndexWriter indexWriter = new IndexWriter(indexDirectory, iwc);){
            HashMap<String, String> userData = new HashMap<String, String>();
            indexWriter.getLiveCommitData().forEach(e -> userData.put((String)e.getKey(), (String)e.getValue()));
            if (updateLocalCheckpoint) {
                SequenceNumbers.CommitInfo commitInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(userData.entrySet());
                userData.put("local_checkpoint", Long.toString(commitInfo.maxSeqNo));
            }
            userData.put("history_uuid", historyUUID);
            String commitESVersion = (String)userData.get("es_version");
            if (commitESVersion == null || Engine.readIndexVersion(commitESVersion).onOrBefore(IndexVersion.current())) {
                userData.put("es_version", IndexVersion.current().toString());
            }
            indexWriter.setLiveCommitData(userData.entrySet());
            indexWriter.commit();
        }
    }

    private static void newAllocationId(ShardPath shardPath, Terminal terminal) throws IOException {
        Path shardStatePath = shardPath.getShardStatePath();
        ShardStateMetadata shardStateMetadata = ShardStateMetadata.FORMAT.loadLatestState(logger, namedXContentRegistry, shardStatePath);
        if (shardStateMetadata == null) {
            throw new ElasticsearchException("No shard state meta data at " + shardStatePath, new Object[0]);
        }
        AllocationId newAllocationId = AllocationId.newInitializing();
        terminal.println((CharSequence)("Changing allocation id " + shardStateMetadata.allocationId.getId() + " to " + newAllocationId.getId()));
        ShardStateMetadata newShardStateMetadata = new ShardStateMetadata(shardStateMetadata.primary, shardStateMetadata.indexUUID, newAllocationId);
        ShardStateMetadata.FORMAT.writeAndCleanup(newShardStateMetadata, shardStatePath);
        terminal.println((CharSequence)"");
        terminal.println((CharSequence)"You should run the following command to allocate this shard:");
        RemoveCorruptedShardDataCommand.printRerouteCommand(shardPath, terminal, true);
    }

    private static void printRerouteCommand(ShardPath shardPath, Terminal terminal, boolean allocateStale) throws IOException {
        Path dataPath = RemoveCorruptedShardDataCommand.getDataPath(shardPath);
        NodeMetadata nodeMetadata = PersistedClusterStateService.nodeMetadata(dataPath);
        if (nodeMetadata == null) {
            throw new ElasticsearchException("No node meta data at " + dataPath, new Object[0]);
        }
        String nodeId = nodeMetadata.nodeId();
        String index = shardPath.getShardId().getIndexName();
        int id = shardPath.getShardId().id();
        AllocationCommands commands = new AllocationCommands(allocateStale ? new AllocateStalePrimaryAllocationCommand(index, id, nodeId, false) : new AllocateEmptyPrimaryAllocationCommand(index, id, nodeId, false));
        terminal.println((CharSequence)"");
        terminal.println((CharSequence)("POST /_cluster/reroute\n" + Strings.toString((ToXContent)commands, true, true)));
        terminal.println((CharSequence)"");
        terminal.println((CharSequence)"You must accept the possibility of data loss by changing the `accept_data_loss` parameter to `true`.");
        terminal.println((CharSequence)"");
    }

    private static Path getDataPath(ShardPath shardPath) {
        Path dataPath = shardPath.getDataPath().getParent().getParent().getParent();
        if (!Files.exists(dataPath, new LinkOption[0]) || !Files.exists(dataPath.resolve("_state"), new LinkOption[0])) {
            throw new ElasticsearchException("Unable to resolve data path for " + shardPath, new Object[0]);
        }
        return dataPath;
    }

    public static enum CleanStatus {
        CLEAN("clean"),
        CLEAN_WITH_CORRUPTED_MARKER("marked corrupted, but no corruption detected"),
        CORRUPTED("corrupted"),
        UNRECOVERABLE("corrupted and unrecoverable"),
        OVERRIDDEN("to be truncated regardless of whether it is corrupt");

        private final String msg;

        private CleanStatus(String msg) {
            this.msg = msg;
        }

        public String getMessage() {
            return this.msg;
        }
    }
}

