/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.flattened;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.SortedSetDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldSyntheticWriterHelper;
import org.elasticsearch.xcontent.XContentBuilder;

public class FlattenedSortedSetDocValuesSyntheticFieldLoader
extends SortedSetDocValuesSyntheticFieldLoader {
    private DocValuesFieldValues docValues = NO_VALUES;
    private final String fieldFullPath;
    private final String keyedFieldFullPath;
    private final String leafName;
    private static final DocValuesFieldValues NO_VALUES = new DocValuesFieldValues(){

        @Override
        public int count() {
            return 0;
        }

        @Override
        public void write(XContentBuilder b) {
        }
    };

    public FlattenedSortedSetDocValuesSyntheticFieldLoader(String fieldFullPath, String keyedFieldFullPath, String leafName) {
        super(fieldFullPath, leafName, null, false);
        this.fieldFullPath = fieldFullPath;
        this.keyedFieldFullPath = keyedFieldFullPath;
        this.leafName = leafName;
    }

    @Override
    public String fieldName() {
        return this.fieldFullPath;
    }

    @Override
    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader reader, int[] docIdsInLeaf) throws IOException {
        SortedSetDocValues dv = DocValues.getSortedSet((LeafReader)reader, (String)this.keyedFieldFullPath);
        if (dv.getValueCount() == 0L) {
            this.docValues = NO_VALUES;
            return null;
        }
        FlattenedFieldDocValuesLoader loader = new FlattenedFieldDocValuesLoader(dv);
        this.docValues = loader;
        return loader;
    }

    @Override
    public boolean hasValue() {
        return this.docValues.count() > 0;
    }

    @Override
    public void write(XContentBuilder b) throws IOException {
        if (this.docValues.count() == 0) {
            return;
        }
        b.startObject(this.leafName);
        this.docValues.write(b);
        b.endObject();
    }

    @Override
    protected BytesRef convert(BytesRef value) {
        return value;
    }

    @Override
    protected BytesRef preserve(BytesRef value) {
        return BytesRef.deepCopyOf((BytesRef)value);
    }

    private static interface DocValuesFieldValues {
        public int count();

        public void write(XContentBuilder var1) throws IOException;
    }

    private static class FlattenedFieldDocValuesLoader
    implements SourceLoader.SyntheticFieldLoader.DocValuesLoader,
    DocValuesFieldValues {
        private final SortedSetDocValues dv;
        private boolean hasValue;
        private final FlattenedFieldSyntheticWriterHelper writer;

        FlattenedFieldDocValuesLoader(SortedSetDocValues dv) {
            this.dv = dv;
            this.writer = new FlattenedFieldSyntheticWriterHelper(dv);
        }

        @Override
        public boolean advanceToDoc(int docId) throws IOException {
            this.hasValue = this.dv.advanceExact(docId);
            return this.hasValue;
        }

        @Override
        public int count() {
            return this.hasValue ? this.dv.docValueCount() : 0;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            this.writer.write(b);
        }
    }
}

