/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public interface SourceLoader {
    public static final SourceLoader FROM_STORED_SOURCE = new SourceLoader(){

        @Override
        public boolean reordersFieldValues() {
            return false;
        }

        @Override
        public Leaf leaf(LeafReader reader, int[] docIdsInLeaf) {
            return new Leaf(){

                @Override
                public Source source(LeafStoredFieldLoader storedFields, int docId) throws IOException {
                    return Source.fromBytes(storedFields.source());
                }

                @Override
                public void write(LeafStoredFieldLoader storedFields, int docId, XContentBuilder builder) throws IOException {
                    Source source = this.source(storedFields, docId);
                    builder.rawValue((InputStream)source.internalSourceRef().streamInput(), source.sourceContentType());
                }
            };
        }

        @Override
        public Set<String> requiredStoredFields() {
            return Set.of();
        }
    };

    public boolean reordersFieldValues();

    public Leaf leaf(LeafReader var1, int[] var2) throws IOException;

    public Set<String> requiredStoredFields();

    public static interface SyntheticFieldLoader {
        public static final SyntheticFieldLoader NOTHING = new SyntheticFieldLoader(){

            @Override
            public Stream<Map.Entry<String, StoredFieldLoader>> storedFieldLoaders() {
                return Stream.of(new Map.Entry[0]);
            }

            @Override
            public DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
                return null;
            }

            @Override
            public boolean hasValue() {
                return false;
            }

            @Override
            public void write(XContentBuilder b) {
            }

            @Override
            public String fieldName() {
                return "";
            }
        };

        public Stream<Map.Entry<String, StoredFieldLoader>> storedFieldLoaders();

        public DocValuesLoader docValuesLoader(LeafReader var1, int[] var2) throws IOException;

        public boolean hasValue();

        public void write(XContentBuilder var1) throws IOException;

        default public boolean setIgnoredValues(Map<String, List<IgnoredSourceFieldMapper.NameValue>> objectsWithIgnoredFields) {
            return false;
        }

        public String fieldName();

        public static interface DocValuesLoader {
            public boolean advanceToDoc(int var1) throws IOException;
        }

        public static interface StoredFieldLoader {
            public void load(List<Object> var1);
        }
    }

    public static class Synthetic
    implements SourceLoader {
        private final Supplier<SyntheticFieldLoader> syntheticFieldLoaderLeafSupplier;
        private final Set<String> requiredStoredFields;
        private final SourceFieldMetrics metrics;

        public Synthetic(Supplier<SyntheticFieldLoader> fieldLoaderSupplier, SourceFieldMetrics metrics) {
            this.syntheticFieldLoaderLeafSupplier = fieldLoaderSupplier;
            this.requiredStoredFields = this.syntheticFieldLoaderLeafSupplier.get().storedFieldLoaders().map(Map.Entry::getKey).collect(Collectors.toSet());
            this.requiredStoredFields.add("_ignored_source");
            this.metrics = metrics;
        }

        @Override
        public boolean reordersFieldValues() {
            return true;
        }

        @Override
        public Set<String> requiredStoredFields() {
            return this.requiredStoredFields;
        }

        @Override
        public Leaf leaf(LeafReader reader, int[] docIdsInLeaf) throws IOException {
            SyntheticFieldLoader loader = this.syntheticFieldLoaderLeafSupplier.get();
            return new LeafWithMetrics(new SyntheticLeaf(loader, loader.docValuesLoader(reader, docIdsInLeaf)), this.metrics);
        }

        private record LeafWithMetrics(Leaf leaf, SourceFieldMetrics metrics) implements Leaf
        {
            @Override
            public Source source(LeafStoredFieldLoader storedFields, int docId) throws IOException {
                long startTime = this.metrics.getRelativeTimeSupplier().getAsLong();
                Source source = this.leaf.source(storedFields, docId);
                TimeValue duration = TimeValue.timeValueMillis((long)(this.metrics.getRelativeTimeSupplier().getAsLong() - startTime));
                this.metrics.recordSyntheticSourceLoadLatency(duration);
                return source;
            }

            @Override
            public void write(LeafStoredFieldLoader storedFields, int docId, XContentBuilder b) throws IOException {
                long startTime = this.metrics.getRelativeTimeSupplier().getAsLong();
                this.leaf.write(storedFields, docId, b);
                TimeValue duration = TimeValue.timeValueMillis((long)(this.metrics.getRelativeTimeSupplier().getAsLong() - startTime));
                this.metrics.recordSyntheticSourceLoadLatency(duration);
            }
        }

        private static class SyntheticLeaf
        implements Leaf {
            private final SyntheticFieldLoader loader;
            private final SyntheticFieldLoader.DocValuesLoader docValuesLoader;
            private final Map<String, SyntheticFieldLoader.StoredFieldLoader> storedFieldLoaders;

            private SyntheticLeaf(SyntheticFieldLoader loader, SyntheticFieldLoader.DocValuesLoader docValuesLoader) {
                this.loader = loader;
                this.docValuesLoader = docValuesLoader;
                this.storedFieldLoaders = Map.copyOf(loader.storedFieldLoaders().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }

            @Override
            public Source source(LeafStoredFieldLoader storedFieldLoader, int docId) throws IOException {
                try (XContentBuilder b = new XContentBuilder(JsonXContent.jsonXContent, (OutputStream)new ByteArrayOutputStream());){
                    this.write(storedFieldLoader, docId, b);
                    Source source = Source.fromBytes(BytesReference.bytes(b), b.contentType());
                    return source;
                }
            }

            @Override
            public void write(LeafStoredFieldLoader storedFieldLoader, int docId, XContentBuilder b) throws IOException {
                HashMap<String, List> objectsWithIgnoredFields = null;
                for (Map.Entry<String, List<Object>> e : storedFieldLoader.storedFields().entrySet()) {
                    SyntheticFieldLoader.StoredFieldLoader loader = this.storedFieldLoaders.get(e.getKey());
                    if (loader != null) {
                        loader.load(e.getValue());
                    }
                    if (!"_ignored_source".equals(e.getKey())) continue;
                    for (Object value : e.getValue()) {
                        if (objectsWithIgnoredFields == null) {
                            objectsWithIgnoredFields = new HashMap<String, List>();
                        }
                        IgnoredSourceFieldMapper.NameValue nameValue = IgnoredSourceFieldMapper.decode(value);
                        objectsWithIgnoredFields.computeIfAbsent(nameValue.getParentFieldName(), k -> new ArrayList()).add(nameValue);
                    }
                }
                if (objectsWithIgnoredFields != null) {
                    this.loader.setIgnoredValues(objectsWithIgnoredFields);
                }
                if (this.docValuesLoader != null) {
                    this.docValuesLoader.advanceToDoc(docId);
                }
                if (this.loader.hasValue()) {
                    this.loader.write(b);
                } else {
                    b.startObject().endObject();
                }
            }
        }
    }

    public static interface Leaf {
        public Source source(LeafStoredFieldLoader var1, int var2) throws IOException;

        public void write(LeafStoredFieldLoader var1, int var2, XContentBuilder var3) throws IOException;
    }
}

