/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperErrors;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class PassThroughObjectMapper
extends ObjectMapper {
    public static final String CONTENT_TYPE = "passthrough";
    public static final String PRIORITY_PARAM_NAME = "priority";
    static final NodeFeature PASS_THROUGH_PRIORITY = new NodeFeature("mapper.pass_through_priority");
    private final Explicit<Boolean> timeSeriesDimensionSubFields;
    private final int priority;

    PassThroughObjectMapper(String name, String fullPath, Explicit<Boolean> enabled, ObjectMapper.Dynamic dynamic, Map<String, Mapper> mappers, Explicit<Boolean> timeSeriesDimensionSubFields, int priority) {
        super(name, fullPath, enabled, Explicit.IMPLICIT_FALSE, Explicit.IMPLICIT_FALSE, dynamic, mappers);
        this.timeSeriesDimensionSubFields = timeSeriesDimensionSubFields;
        this.priority = priority;
        if (priority < 0) {
            throw new MapperException("Pass-through object [" + fullPath + "] is missing a non-negative value for parameter [priority]");
        }
    }

    @Override
    PassThroughObjectMapper withoutMappers() {
        return new PassThroughObjectMapper(this.leafName(), this.fullPath(), (Explicit<Boolean>)this.enabled, this.dynamic, Map.of(), this.timeSeriesDimensionSubFields, this.priority);
    }

    @Override
    public String typeName() {
        return CONTENT_TYPE;
    }

    public boolean containsDimensions() {
        return this.timeSeriesDimensionSubFields.value();
    }

    public int priority() {
        return this.priority;
    }

    @Override
    public Builder newBuilder(IndexVersion indexVersionCreated) {
        Builder builder = new Builder(this.leafName());
        builder.enabled = this.enabled;
        builder.dynamic = this.dynamic;
        builder.timeSeriesDimensionSubFields = this.timeSeriesDimensionSubFields;
        builder.priority = this.priority;
        return builder;
    }

    @Override
    public PassThroughObjectMapper merge(Mapper mergeWith, MapperMergeContext parentBuilderContext) {
        if (!(mergeWith instanceof PassThroughObjectMapper)) {
            MapperErrors.throwObjectMappingConflictError(mergeWith.fullPath());
        }
        PassThroughObjectMapper mergeWithObject = (PassThroughObjectMapper)mergeWith;
        ObjectMapper.MergeResult mergeResult = ObjectMapper.MergeResult.build(this, mergeWithObject, parentBuilderContext);
        Explicit<Boolean> containsDimensions = mergeWithObject.timeSeriesDimensionSubFields.explicit() ? mergeWithObject.timeSeriesDimensionSubFields : this.timeSeriesDimensionSubFields;
        return new PassThroughObjectMapper(this.leafName(), this.fullPath(), mergeResult.enabled(), mergeResult.dynamic(), mergeResult.mappers(), containsDimensions, Math.max(this.priority, mergeWithObject.priority));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.leafName());
        builder.field("type", CONTENT_TYPE);
        if (this.timeSeriesDimensionSubFields.explicit()) {
            builder.field("time_series_dimension", this.timeSeriesDimensionSubFields.value());
        }
        if (this.priority >= 0) {
            builder.field(PRIORITY_PARAM_NAME, this.priority);
        }
        if (this.dynamic != null) {
            builder.field("dynamic", this.dynamic.name().toLowerCase(Locale.ROOT));
        }
        if (!this.isEnabled()) {
            builder.field("enabled", (Boolean)this.enabled.value());
        }
        this.serializeMappers(builder, params);
        return builder.endObject();
    }

    public static void checkForDuplicatePriorities(Collection<PassThroughObjectMapper> passThroughMappers) {
        HashMap<Integer, String> seen = new HashMap<Integer, String>();
        for (PassThroughObjectMapper mapper : passThroughMappers) {
            String conflict = seen.put(mapper.priority, mapper.fullPath());
            if (conflict == null) continue;
            throw new MapperException("Pass-through object [" + mapper.fullPath() + "] has a conflicting param [priority=" + mapper.priority + "] with object [" + conflict + "]");
        }
    }

    public static class Builder
    extends ObjectMapper.Builder {
        protected Explicit<Boolean> timeSeriesDimensionSubFields = Explicit.IMPLICIT_FALSE;
        protected int priority = -1;

        public Builder(String name) {
            super(name, Explicit.IMPLICIT_FALSE);
        }

        @Override
        public Builder add(Mapper.Builder builder) {
            if (this.timeSeriesDimensionSubFields.value().booleanValue() && builder instanceof FieldMapper.DimensionBuilder) {
                FieldMapper.DimensionBuilder dimensionBuilder = (FieldMapper.DimensionBuilder)builder;
                dimensionBuilder.setInheritDimensionParameterFromParentObject();
            }
            super.add(builder);
            return this;
        }

        public Builder setContainsDimensions() {
            this.timeSeriesDimensionSubFields = Explicit.EXPLICIT_TRUE;
            return this;
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public PassThroughObjectMapper build(MapperBuilderContext context) {
            return new PassThroughObjectMapper(this.leafName(), context.buildFullName(this.leafName()), (Explicit<Boolean>)this.enabled, this.dynamic, this.buildMappers(context.createChildContext(this.leafName(), this.timeSeriesDimensionSubFields.value(), this.dynamic)), this.timeSeriesDimensionSubFields, this.priority);
        }
    }

    public static class TypeParser
    extends ObjectMapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParser.parsePassthrough(name, node, builder);
            TypeParser.parseObjectFields(node, parserContext, builder);
            return builder;
        }

        protected static void parsePassthrough(String name, Map<String, Object> node, Builder builder) {
            Object fieldNode = node.get("time_series_dimension");
            if (fieldNode != null) {
                builder.timeSeriesDimensionSubFields = Explicit.explicitBoolean(XContentMapValues.nodeBooleanValue(fieldNode, name + "time_series_dimension"));
                node.remove("time_series_dimension");
            }
            if ((fieldNode = node.get(PassThroughObjectMapper.PRIORITY_PARAM_NAME)) != null) {
                builder.priority = XContentMapValues.nodeIntegerValue(fieldNode);
                node.remove(PassThroughObjectMapper.PRIORITY_PARAM_NAME);
            }
        }
    }
}

