/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class NodeMappingStats
implements Writeable,
ToXContentFragment {
    private long totalCount;
    private long totalEstimatedOverhead;

    public NodeMappingStats() {
    }

    public NodeMappingStats(StreamInput in) throws IOException {
        this.totalCount = in.readVLong();
        this.totalEstimatedOverhead = in.readVLong();
    }

    public NodeMappingStats(long totalCount, long totalEstimatedOverhead) {
        this.totalCount = totalCount;
        this.totalEstimatedOverhead = totalEstimatedOverhead;
    }

    public void add(@Nullable NodeMappingStats other) {
        if (other == null) {
            return;
        }
        this.totalCount += other.totalCount;
        this.totalEstimatedOverhead += other.totalEstimatedOverhead;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public ByteSizeValue getTotalEstimatedOverhead() {
        return ByteSizeValue.ofBytes(this.totalEstimatedOverhead);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalCount);
        out.writeVLong(this.totalEstimatedOverhead);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("mappings");
        builder.field("total_count", this.getTotalCount());
        builder.humanReadableField("total_estimated_overhead_in_bytes", "total_estimated_overhead", (Object)this.getTotalEstimatedOverhead());
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMappingStats that = (NodeMappingStats)o;
        return this.totalCount == that.totalCount && this.totalEstimatedOverhead == that.totalEstimatedOverhead;
    }

    public int hashCode() {
        return Objects.hash(this.totalCount, this.totalEstimatedOverhead);
    }

    private static final class Fields {
        static final String MAPPINGS = "mappings";
        static final String TOTAL_COUNT = "total_count";
        static final String TOTAL_ESTIMATED_OVERHEAD = "total_estimated_overhead";
        static final String TOTAL_ESTIMATED_OVERHEAD_IN_BYTES = "total_estimated_overhead_in_bytes";

        private Fields() {
        }
    }
}

