/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.lucene.document.FieldType;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.StringLiteralDeduplicator;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;

public abstract class Mapper
implements ToXContentFragment,
Iterable<Mapper> {
    private final String leafName;
    private static final StringLiteralDeduplicator fieldNameStringDeduplicator = new StringLiteralDeduplicator();
    private static final Map<FieldType, FieldType> fieldTypeDeduplicator = new ConcurrentHashMap<FieldType, FieldType>();

    public Mapper(String leafName) {
        Objects.requireNonNull(leafName);
        this.leafName = Mapper.internFieldName(leafName);
    }

    public final String leafName() {
        return this.leafName;
    }

    public abstract String fullPath();

    public abstract String typeName();

    public abstract Mapper merge(Mapper var1, MapperMergeContext var2);

    public abstract void validate(MappingLookup var1);

    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        throw new IllegalArgumentException("field [" + this.fullPath() + "] of type [" + this.typeName() + "] doesn't support synthetic source");
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static String internFieldName(String fieldName) {
        return fieldNameStringDeduplicator.deduplicate(fieldName);
    }

    public static FieldType freezeAndDeduplicateFieldType(FieldType fieldType) {
        fieldType.freeze();
        Map attributes = fieldType.getAttributes();
        if (attributes != null && !attributes.isEmpty() || fieldType.getClass() != FieldType.class) {
            return fieldType;
        }
        if (fieldTypeDeduplicator.size() > 1000) {
            fieldTypeDeduplicator.clear();
        }
        return fieldTypeDeduplicator.computeIfAbsent(fieldType, Function.identity());
    }

    public abstract int getTotalFieldsCount();

    public static interface TypeParser {
        public Builder parse(String var1, Map<String, Object> var2, MappingParserContext var3) throws MapperParsingException;

        default public boolean supportsVersion(IndexVersion indexCreatedVersion) {
            return indexCreatedVersion.onOrAfter(IndexVersions.MINIMUM_COMPATIBLE);
        }
    }

    public static abstract class Builder {
        private String leafName;

        protected Builder(String leafName) {
            this.setLeafName(leafName);
        }

        public final String leafName() {
            return this.leafName;
        }

        public abstract Mapper build(MapperBuilderContext var1);

        void setLeafName(String leafName) {
            this.leafName = Mapper.internFieldName(leafName);
        }
    }
}

