/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.IpPrefixAutomatonUtil;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.SearchAfterTermsEnum;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SortedSetDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SortedSetDocValuesTerms;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.field.IpDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.XContentParser;

public class IpFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(IpFieldMapper.class);
    public static final String CONTENT_TYPE = "ip";
    private static final IndexVersion MINIMUM_COMPATIBILITY_VERSION = IndexVersion.fromId(5000099);
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, c.scriptCompiler(), ignoreMalformedByDefault, c.indexVersionCreated());
    }, MINIMUM_COMPATIBILITY_VERSION);
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final boolean ignoreMalformed;
    private final boolean storeIgnored;
    private final boolean dimension;
    private final InetAddress nullValue;
    private final String nullValueAsString;
    private final boolean ignoreMalformedByDefault;
    private final IndexVersion indexCreatedVersion;
    private final Script script;
    private final FieldValues<InetAddress> scriptValues;
    private final ScriptCompiler scriptCompiler;

    private static IpFieldMapper toType(FieldMapper in) {
        return (IpFieldMapper)in;
    }

    private IpFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, boolean storeIgnored, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo, builder.script.get() != null, builder.onScriptError.get());
        this.ignoreMalformedByDefault = builder.ignoreMalformedByDefault;
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.stored = builder.stored.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.nullValue = builder.parseNullValue();
        this.nullValueAsString = builder.nullValue.getValue();
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.script = builder.script.get();
        this.scriptValues = builder.scriptValues();
        this.scriptCompiler = builder.scriptCompiler;
        this.dimension = builder.dimension.getValue();
        this.storeIgnored = storeIgnored;
    }

    @Override
    public boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Override
    public IpFieldType fieldType() {
        return (IpFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().typeName();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        InetAddress address;
        try {
            address = IpFieldMapper.value(context.parser(), this.nullValue);
        }
        catch (IllegalArgumentException e) {
            if (this.ignoreMalformed) {
                context.addIgnoredField(this.fieldType().name());
                if (this.storeIgnored) {
                    context.doc().add((IndexableField)IgnoreMalformedStoredValues.storedField(this.fullPath(), context.parser()));
                }
                return;
            }
            throw e;
        }
        if (address != null) {
            this.indexValue(context, address);
        }
    }

    private static InetAddress value(XContentParser parser, InetAddress nullValue) throws IOException {
        String value = parser.textOrNull();
        if (value == null) {
            return nullValue;
        }
        return InetAddresses.forString(value);
    }

    private void indexValue(DocumentParserContext context, InetAddress address) {
        if (this.dimension) {
            context.getDimensions().addIp(this.fieldType().name(), address).validate(context.indexSettings());
        }
        if (this.indexed) {
            InetAddressPoint field = new InetAddressPoint(this.fieldType().name(), address);
            context.doc().add((IndexableField)field);
        }
        if (this.hasDocValues) {
            context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        } else if (this.stored || this.indexed) {
            context.addToFieldNames(this.fieldType().name());
        }
        if (this.stored) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, value -> this.indexValue(documentParserContext, (InetAddress)value));
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.scriptCompiler, this.ignoreMalformedByDefault, this.indexCreatedVersion).dimension(this.dimension).init(this);
    }

    @Override
    public void doValidate(MappingLookup lookup) {
        if (this.dimension && null != lookup.nestedLookup().getNestedParent(this.fullPath())) {
            throw new IllegalArgumentException("time_series_dimension can't be configured in nested field [" + this.fullPath() + "]");
        }
    }

    @Override
    protected FieldMapper.SyntheticSourceMode syntheticSourceMode() {
        return FieldMapper.SyntheticSourceMode.NATIVE;
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        if (this.hasScript()) {
            return SourceLoader.SyntheticFieldLoader.NOTHING;
        }
        if (!this.hasDocValues) {
            throw new IllegalArgumentException("field [" + this.fullPath() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it doesn't have doc values");
        }
        if (!this.copyTo.copyToFields().isEmpty()) {
            throw new IllegalArgumentException("field [" + this.fullPath() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it declares copy_to");
        }
        return new SortedSetDocValuesSyntheticFieldLoader(this.fullPath(), this.leafName(), null, this.ignoreMalformed){

            @Override
            protected BytesRef convert(BytesRef value) {
                byte[] bytes = Arrays.copyOfRange(value.bytes, value.offset, value.offset + value.length);
                return new BytesRef((CharSequence)NetworkAddress.format(InetAddressPoint.decode((byte[])bytes)));
            }

            @Override
            protected BytesRef preserve(BytesRef value) {
                return value;
            }
        };
    }

    public static final class Builder
    extends FieldMapper.DimensionBuilder {
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> IpFieldMapper.toType((FieldMapper)m).indexed, true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> IpFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> IpFieldMapper.toType((FieldMapper)m).stored, false);
        private final FieldMapper.Parameter<Boolean> ignoreMalformed;
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> IpFieldMapper.toType((FieldMapper)m).nullValueAsString, null).acceptsNull();
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> IpFieldMapper.toType((FieldMapper)m).script);
        private final FieldMapper.Parameter<OnScriptError> onScriptError = FieldMapper.Parameter.onScriptErrorParam(m -> IpFieldMapper.toType((FieldMapper)m).onScriptError, this.script);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Boolean> dimension;
        private final boolean ignoreMalformedByDefault;
        private final IndexVersion indexCreatedVersion;
        private final ScriptCompiler scriptCompiler;

        public Builder(String name, ScriptCompiler scriptCompiler, boolean ignoreMalformedByDefault, IndexVersion indexCreatedVersion) {
            super(name);
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.ignoreMalformedByDefault = ignoreMalformedByDefault;
            this.indexCreatedVersion = indexCreatedVersion;
            this.ignoreMalformed = FieldMapper.Parameter.boolParam("ignore_malformed", true, m -> IpFieldMapper.toType((FieldMapper)m).ignoreMalformed, ignoreMalformedByDefault);
            this.script.precludesParameters(this.nullValue, this.ignoreMalformed);
            this.addScriptValidation(this.script, this.indexed, this.hasDocValues);
            this.dimension = TimeSeriesParams.dimensionParam(m -> IpFieldMapper.toType((FieldMapper)m).dimension).addValidator(v -> {
                if (!(!v.booleanValue() || this.indexed.getValue().booleanValue() && this.hasDocValues.getValue().booleanValue())) {
                    throw new IllegalArgumentException("Field [time_series_dimension] requires that [" + this.indexed.name + "] and [" + this.hasDocValues.name + "] are true");
                }
            });
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        public Builder dimension(boolean dimension) {
            this.dimension.setValue(dimension);
            return this;
        }

        private InetAddress parseNullValue() {
            String nullValueAsString = this.nullValue.getValue();
            if (nullValueAsString == null) {
                return null;
            }
            try {
                return InetAddresses.forString(nullValueAsString);
            }
            catch (Exception e) {
                if (this.indexCreatedVersion.onOrAfter(IndexVersions.V_8_0_0)) {
                    throw new MapperParsingException("Error parsing [null_value] on field [" + this.leafName() + "]: " + e.getMessage(), e);
                }
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "ip_mapper_null_field", "Error parsing [" + this.nullValue.getValue() + "] as IP in [null_value] on field [" + this.leafName() + "]); [null_value] will be ignored", new Object[0]);
                return null;
            }
        }

        private FieldValues<InetAddress> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            IpFieldScript.Factory factory = this.scriptCompiler.compile(this.script.get(), IpFieldScript.CONTEXT);
            return factory == null ? null : (lookup, ctx, doc, consumer) -> factory.newFactory(this.leafName(), this.script.get().getParams(), lookup, OnScriptError.FAIL).newInstance(ctx).runForDoc(doc, consumer);
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.nullValue, this.script, this.onScriptError, this.meta, this.dimension};
        }

        @Override
        public IpFieldMapper build(MapperBuilderContext context) {
            if (this.inheritDimensionParameterFromParentObject(context)) {
                this.dimension.setValue(true);
            }
            return new IpFieldMapper(this.leafName(), (MappedFieldType)new IpFieldType(context.buildFullName(this.leafName()), this.indexed.getValue() != false && !this.indexCreatedVersion.isLegacyIndexVersion(), this.stored.getValue(), this.hasDocValues.getValue(), this.parseNullValue(), this.scriptValues(), this.meta.getValue(), this.dimension.getValue()), this.multiFieldsBuilder.build(this, context), this.copyTo, context.isSourceSynthetic(), this);
        }
    }

    public static final class IpFieldType
    extends SimpleMappedFieldType {
        private final InetAddress nullValue;
        private final FieldValues<InetAddress> scriptValues;
        private final boolean isDimension;

        public IpFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, InetAddress nullValue, FieldValues<InetAddress> scriptValues, Map<String, String> meta, boolean isDimension) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.nullValue = nullValue;
            this.scriptValues = scriptValues;
            this.isDimension = isDimension;
        }

        public IpFieldType(String name) {
            this(name, true, true);
        }

        public IpFieldType(String name, boolean isIndexed) {
            this(name, isIndexed, true);
        }

        public IpFieldType(String name, boolean isIndexed, boolean hasDocValues) {
            this(name, isIndexed, false, hasDocValues, null, null, Collections.emptyMap(), false);
        }

        @Override
        public String typeName() {
            return IpFieldMapper.CONTENT_TYPE;
        }

        @Override
        public boolean isSearchable() {
            return this.isIndexed() || this.hasDocValues();
        }

        @Override
        public boolean mayExistInIndex(SearchExecutionContext context) {
            return context.fieldExistsInIndex(this.name());
        }

        @Override
        public boolean isDimension() {
            return this.isDimension;
        }

        @Override
        public boolean hasScriptValues() {
            return this.scriptValues != null;
        }

        private static InetAddress parse(Object value) {
            if (value instanceof InetAddress) {
                return (InetAddress)value;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return InetAddresses.forString(value.toString());
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, v -> InetAddresses.toAddrString((InetAddress)v), context);
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected Object parseSourceValue(Object value) {
                    InetAddress address = value instanceof InetAddress ? (InetAddress)value : InetAddresses.forString(value.toString());
                    return InetAddresses.toAddrString(address);
                }
            };
        }

        @Override
        public Query termQuery(Object value, @Nullable SearchExecutionContext context) {
            Query query;
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (value instanceof InetAddress) {
                query = InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)((InetAddress)value));
            } else {
                String term;
                if (value instanceof BytesRef) {
                    value = ((BytesRef)value).utf8ToString();
                }
                if ((term = value.toString()).contains("/")) {
                    Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(term);
                    query = InetAddressPoint.newPrefixQuery((String)this.name(), (InetAddress)((InetAddress)cidr.v1()), (int)((Integer)cidr.v2()));
                } else {
                    InetAddress address = InetAddresses.forString(term);
                    query = InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)address);
                }
            }
            if (this.isIndexed()) {
                return query;
            }
            return IpFieldType.convertToDocValuesQuery(query);
        }

        static Query convertToDocValuesQuery(Query query) {
            assert (query instanceof PointRangeQuery);
            PointRangeQuery pointRangeQuery = (PointRangeQuery)query;
            return SortedSetDocValuesField.newSlowRangeQuery((String)pointRangeQuery.getField(), (BytesRef)new BytesRef(pointRangeQuery.getLowerPoint()), (BytesRef)new BytesRef(pointRangeQuery.getUpperPoint()), (boolean)true, (boolean)true);
        }

        @Override
        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (!this.isIndexed()) {
                return super.termsQuery(values, context);
            }
            InetAddress[] addresses = new InetAddress[values.size()];
            int i = 0;
            for (Object value : values) {
                InetAddress address;
                if (value instanceof InetAddress) {
                    address = (InetAddress)value;
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    if (value.toString().contains("/")) {
                        return super.termsQuery(values, context);
                    }
                    address = InetAddresses.forString(value.toString());
                }
                addresses[i++] = address;
            }
            return InetAddressPoint.newSetQuery((String)this.name(), (InetAddress[])addresses);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            return IpFieldType.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (lower, upper) -> {
                Query query = InetAddressPoint.newRangeQuery((String)this.name(), (InetAddress)lower, (InetAddress)upper);
                if (this.isIndexed()) {
                    if (this.hasDocValues()) {
                        return new IndexOrDocValuesQuery(query, IpFieldType.convertToDocValuesQuery(query));
                    }
                    return query;
                }
                return IpFieldType.convertToDocValuesQuery(query);
            });
        }

        public static Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<InetAddress, InetAddress, Query> builder) {
            InetAddress upper;
            InetAddress lower;
            if (lowerTerm == null) {
                lower = InetAddressPoint.MIN_VALUE;
            } else {
                lower = IpFieldType.parse(lowerTerm);
                if (!includeLower) {
                    if (lower.equals(InetAddressPoint.MAX_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    lower = InetAddressPoint.nextUp((InetAddress)lower);
                }
            }
            if (upperTerm == null) {
                upper = InetAddressPoint.MAX_VALUE;
            } else {
                upper = IpFieldType.parse(upperTerm);
                if (!includeUpper) {
                    if (upper.equals(InetAddressPoint.MIN_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    upper = InetAddressPoint.nextDown((InetAddress)upper);
                }
            }
            return builder.apply(lower, upper);
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.hasDocValues()) {
                return new BlockDocValuesReader.BytesRefsFromOrdsBlockLoader(this.name());
            }
            return null;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.IP, IpDocValuesField::new);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return DocValueFormat.IP.format((BytesRef)value);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            this.checkNoFormat(format);
            this.checkNoTimeZone(timeZone);
            return DocValueFormat.IP;
        }

        @Override
        public TermsEnum getTerms(IndexReader reader, String prefix, boolean caseInsensitive, String searchAfter) throws IOException {
            Terms terms = null;
            if (this.hasDocValues()) {
                terms = SortedSetDocValuesTerms.getTerms(reader, this.name());
            }
            if (terms == null) {
                return null;
            }
            BytesRef searchBytes = searchAfter == null ? null : new BytesRef(InetAddressPoint.encode((InetAddress)InetAddress.getByName(searchAfter)));
            CompiledAutomaton prefixAutomaton = IpPrefixAutomatonUtil.buildIpPrefixAutomaton(prefix);
            if (prefixAutomaton.type == CompiledAutomaton.AUTOMATON_TYPE.ALL) {
                Object result = terms.iterator();
                if (searchAfter != null) {
                    result = new SearchAfterTermsEnum((TermsEnum)result, searchBytes);
                }
                return result;
            }
            return terms.intersect(prefixAutomaton, searchBytes);
        }
    }
}

