/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.StoredValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.XContentDataHelper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class IgnoredSourceFieldMapper
extends MetadataFieldMapper {
    private static final int PARENT_OFFSET_IN_NAME_OFFSET = 65536;
    public static final String NAME = "_ignored_source";
    public static final IgnoredSourceFieldMapper INSTANCE = new IgnoredSourceFieldMapper();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(context -> INSTANCE);
    static final NodeFeature TRACK_IGNORED_SOURCE = new NodeFeature("mapper.track_ignored_source");

    private IgnoredSourceFieldMapper() {
        super(IgnoredValuesFieldMapperType.INSTANCE);
    }

    @Override
    protected String contentType() {
        return NAME;
    }

    @Override
    public void postParse(DocumentParserContext context) {
        assert (context.getIgnoredFieldValues().isEmpty() || context.mappingLookup().isSourceSynthetic());
        ArrayList<NameValue> ignoredFieldValues = new ArrayList<NameValue>(context.getIgnoredFieldValues());
        Collections.sort(ignoredFieldValues, Comparator.comparing(NameValue::name));
        for (NameValue nameValue : ignoredFieldValues) {
            nameValue.doc().add((IndexableField)new StoredField(NAME, IgnoredSourceFieldMapper.encode(nameValue)));
        }
    }

    static byte[] encode(NameValue values) {
        assert (values.parentOffset < 65536);
        assert ((long)values.parentOffset * 65536L < Integer.MAX_VALUE);
        byte[] nameBytes = values.name.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = new byte[4 + nameBytes.length + values.value.length];
        ByteUtils.writeIntLE(values.name.length() + 65536 * values.parentOffset, bytes, 0);
        System.arraycopy(nameBytes, 0, bytes, 4, nameBytes.length);
        System.arraycopy(values.value.bytes, values.value.offset, bytes, 4 + nameBytes.length, values.value.length);
        return bytes;
    }

    static NameValue decode(Object field) {
        byte[] bytes = ((BytesRef)field).bytes;
        int encodedSize = ByteUtils.readIntLE(bytes, 0);
        int nameSize = encodedSize % 65536;
        int parentOffset = encodedSize / 65536;
        String name = new String(bytes, 4, nameSize, StandardCharsets.UTF_8);
        BytesRef value = new BytesRef(bytes, 4 + nameSize, bytes.length - nameSize - 4);
        return new NameValue(name, parentOffset, value, null);
    }

    public static MappedNameValue decodeAsMap(byte[] value) throws IOException {
        BytesRef bytes = new BytesRef(value);
        NameValue nameValue = IgnoredSourceFieldMapper.decode(bytes);
        XContentBuilder xContentBuilder = XContentBuilder.builder((XContent)XContentDataHelper.getXContentType(nameValue.value()).xContent());
        xContentBuilder.startObject().field(nameValue.name());
        XContentDataHelper.decodeAndWrite(xContentBuilder, nameValue.value());
        xContentBuilder.endObject();
        Tuple<XContentType, Map<String, Object>> result = XContentHelper.convertToMap(BytesReference.bytes(xContentBuilder), true);
        return new MappedNameValue(nameValue, (XContentType)result.v1(), (Map)result.v2());
    }

    public static byte[] encodeFromMap(MappedNameValue mappedNameValue, Map<String, Object> map) throws IOException {
        XContentBuilder xContentBuilder;
        assert (map.size() == 1);
        Object content = map.values().iterator().next();
        if (content instanceof Map) {
            Map objectMap = (Map)content;
            xContentBuilder = XContentBuilder.builder((XContent)mappedNameValue.type().xContent()).map(objectMap);
        } else {
            xContentBuilder = XContentBuilder.builder((XContent)mappedNameValue.type().xContent()).value(content);
        }
        XContentBuilder xContentBuilder2 = xContentBuilder;
        NameValue oldNameValue = mappedNameValue.nameValue();
        NameValue filteredNameValue = new NameValue(oldNameValue.name(), oldNameValue.parentOffset(), XContentDataHelper.encodeXContentBuilder(xContentBuilder2), oldNameValue.doc());
        return IgnoredSourceFieldMapper.encode(filteredNameValue);
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    static final class IgnoredValuesFieldMapperType
    extends StringFieldType {
        private static final IgnoredValuesFieldMapperType INSTANCE = new IgnoredValuesFieldMapperType();

        private IgnoredValuesFieldMapperType() {
            super(IgnoredSourceFieldMapper.NAME, false, true, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return IgnoredSourceFieldMapper.NAME;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new StoredValueFetcher(context.lookup(), IgnoredSourceFieldMapper.NAME);
        }
    }

    public record NameValue(String name, int parentOffset, BytesRef value, LuceneDocument doc) {
        public static NameValue fromContext(DocumentParserContext context, String name, BytesRef value) {
            int parentOffset = context.parent() instanceof RootObjectMapper ? 0 : context.parent().fullPath().length() + 1;
            return new NameValue(name, parentOffset, value, context.doc());
        }

        String getParentFieldName() {
            return this.parentOffset == 0 ? "_doc" : this.name.substring(0, this.parentOffset - 1);
        }

        void write(XContentBuilder builder) throws IOException {
            builder.field(this.getFieldName());
            XContentDataHelper.decodeAndWrite(builder, this.value());
        }

        private String getFieldName() {
            return this.parentOffset() == 0 ? this.name() : this.name().substring(this.parentOffset());
        }
    }

    public record MappedNameValue(NameValue nameValue, XContentType type, Map<String, Object> map) {
    }
}

