/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentLeafReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.DotExpandingXContentParser;
import org.elasticsearch.index.mapper.DynamicFieldsBuilder;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.NestedPathFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.StrictDynamicMappingException;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.XContentDataHelper;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.plugins.internal.DocumentSizeObserver;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class DocumentParser {
    public static final IndexVersion DYNAMICALLY_MAP_DENSE_VECTORS_INDEX_VERSION = IndexVersions.FIRST_DETACHED_INDEX_VERSION;
    private final XContentParserConfiguration parserConfiguration;
    private final MappingParserContext mappingParserContext;
    private static final FieldMapper NO_OP_FIELDMAPPER = new FieldMapper("no-op", new MappedFieldType("no-op", false, false, false, TextSearchInfo.NONE, Collections.emptyMap()){

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String typeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new UnsupportedOperationException();
        }
    }, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty()){

        @Override
        protected void parseCreateField(DocumentParserContext context) {
            if (context.dynamic() == ObjectMapper.Dynamic.RUNTIME && context.canAddIgnoredField()) {
                try {
                    context.addIgnoredField(IgnoredSourceFieldMapper.NameValue.fromContext(context, context.path().pathAsText(context.parser().currentName()), XContentDataHelper.encodeToken(context.parser())));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("failed to parse run-time field under [" + context.path().pathAsText("") + " ]", e);
                }
            }
        }

        @Override
        public String fullPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String typeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MappedFieldType fieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldMapper.MultiFields multiFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Mapper> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void doValidate(MappingLookup mappers) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void checkIncomingMergeType(FieldMapper mergeWith) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldMapper.Builder getMergeBuilder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String contentType() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected FieldMapper.SyntheticSourceMode syntheticSourceMode() {
            return FieldMapper.SyntheticSourceMode.NATIVE;
        }

        @Override
        public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
            return SourceLoader.SyntheticFieldLoader.NOTHING;
        }
    };

    DocumentParser(XContentParserConfiguration parserConfiguration, MappingParserContext mappingParserContext) {
        this.mappingParserContext = mappingParserContext;
        this.parserConfiguration = parserConfiguration;
    }

    public ParsedDocument parseDocument(SourceToParse source, final MappingLookup mappingLookup) throws DocumentParsingException {
        RootDocumentParserContext context;
        if (source.source() != null && source.source().length() == 0) {
            throw new DocumentParsingException(new XContentLocation(0, 0), "failed to parse, document is empty");
        }
        XContentType xContentType = source.getXContentType();
        DocumentSizeObserver documentSizeObserver = source.getDocumentSizeObserver();
        try (XContentParser parser = documentSizeObserver.wrapParser(XContentHelper.createParser(this.parserConfiguration, source.source(), xContentType));){
            context = new RootDocumentParserContext(mappingLookup, this.mappingParserContext, source, parser);
            DocumentParser.validateStart(context.parser());
            MetadataFieldMapper[] metadataFieldsMappers = mappingLookup.getMapping().getSortedMetadataMappers();
            DocumentParser.internalParseDocument(metadataFieldsMappers, context);
            DocumentParser.validateEnd(context.parser());
        }
        catch (XContentParseException e) {
            throw new DocumentParsingException(e.getLocation(), e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new DocumentParsingException(XContentLocation.UNKNOWN, "Error parsing document", e);
        }
        assert (context.path.pathAsText("").isEmpty()) : "found leftover path elements: " + context.path.pathAsText("");
        Mapping dynamicUpdate = DocumentParser.createDynamicUpdate(context);
        return new ParsedDocument(context.version(), context.seqID(), context.id(), context.routing(), context.reorderParentAndGetDocs(), context.sourceToParse().source(), context.sourceToParse().getXContentType(), dynamicUpdate, documentSizeObserver){

            @Override
            public String documentDescription() {
                IdFieldMapper idMapper = (IdFieldMapper)mappingLookup.getMapping().getMetadataMapperByName("_id");
                return idMapper.documentDescription(this);
            }
        };
    }

    private static void internalParseDocument(MetadataFieldMapper[] metadataFieldsMappers, DocumentParserContext context) {
        try {
            boolean emptyDoc = DocumentParser.isEmptyDoc(context.root(), context.parser());
            for (MetadataFieldMapper metadataMapper : metadataFieldsMappers) {
                metadataMapper.preParse(context);
            }
            if (!context.root().isEnabled()) {
                if (context.canAddIgnoredField()) {
                    context.addIgnoredField(new IgnoredSourceFieldMapper.NameValue("_doc", 0, XContentDataHelper.encodeToken(context.parser()), context.doc()));
                } else {
                    context.parser().skipChildren();
                }
            } else if (!emptyDoc) {
                DocumentParser.parseObjectOrNested(context);
            }
            DocumentParser.executeIndexTimeScripts(context);
            for (MetadataFieldMapper metadataMapper : metadataFieldsMappers) {
                metadataMapper.postParse(context);
            }
        }
        catch (Exception e) {
            throw DocumentParser.wrapInDocumentParsingException(context, e);
        }
    }

    private static void executeIndexTimeScripts(final DocumentParserContext context) {
        List<FieldMapper> indexTimeScriptMappers = context.mappingLookup().indexTimeScriptMappers();
        if (indexTimeScriptMappers.isEmpty()) {
            return;
        }
        final SearchLookup searchLookup = new SearchLookup(context.mappingLookup().indexTimeLookup()::get, (ft, lookup, fto) -> ft.fielddataBuilder(new FieldDataContext(context.indexSettings().getIndex().getName(), (Supplier<SearchLookup>)lookup, context.mappingLookup()::sourcePaths, (MappedFieldType.FielddataOperation)((Object)fto))).build(new IndexFieldDataCache.None(), new NoneCircuitBreakerService()), (ctx, doc) -> Source.fromBytes(context.sourceToParse().source()));
        HashMap<String, Consumer<LeafReaderContext>> fieldScripts = new HashMap<String, Consumer<LeafReaderContext>>();
        indexTimeScriptMappers.forEach(mapper -> fieldScripts.put(mapper.fullPath(), new Consumer<LeafReaderContext>(){
            boolean executed = false;

            @Override
            public void accept(LeafReaderContext leafReaderContext) {
                if (!this.executed) {
                    mapper.executeScript(searchLookup, leafReaderContext, 0, context);
                    this.executed = true;
                }
            }
        }));
        DocumentLeafReader reader = new DocumentLeafReader(context.rootDoc(), fieldScripts);
        for (Consumer script : fieldScripts.values()) {
            script.accept(reader.getContext());
        }
    }

    private static void validateStart(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            DocumentParser.throwNoStartOnObject();
        }
    }

    private static void throwNoStartOnObject() {
        throw new DocumentParsingException(XContentLocation.UNKNOWN, "Malformed content, must start with an object");
    }

    private static void validateEnd(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != null) {
            DocumentParser.throwNotAtEnd(token);
        }
    }

    private static void throwNotAtEnd(XContentParser.Token token) {
        throw new IllegalArgumentException("Malformed content, found extra data after parsing: " + token);
    }

    private static boolean isEmptyDoc(RootObjectMapper root, XContentParser parser) throws IOException {
        if (root.isEnabled()) {
            XContentParser.Token token = parser.nextToken();
            switch (token) {
                case END_OBJECT: {
                    return true;
                }
                case FIELD_NAME: {
                    return false;
                }
            }
            DocumentParser.throwOnMalformedContent(parser);
        }
        return false;
    }

    private static void throwOnMalformedContent(XContentParser parser) {
        throw new DocumentParsingException(parser.getTokenLocation(), "Malformed content, after first object, either the type field or the actual properties should exist");
    }

    private static DocumentParsingException wrapInDocumentParsingException(DocumentParserContext context, Exception e) {
        if (e instanceof DocumentParsingException) {
            return (DocumentParsingException)e;
        }
        return new DocumentParsingException(context.parser().getTokenLocation(), "failed to parse: " + e.getMessage(), e);
    }

    static Mapping createDynamicUpdate(DocumentParserContext context) {
        if (!context.hasDynamicMappersOrRuntimeFields()) {
            return null;
        }
        RootObjectMapper.Builder rootBuilder = context.updateRoot();
        context.getDynamicMappers().forEach(mapper -> rootBuilder.addDynamic(mapper.fullPath(), null, (Mapper)mapper, context));
        for (RuntimeField runtimeField : context.getDynamicRuntimeFields()) {
            rootBuilder.addRuntimeField(runtimeField);
        }
        RootObjectMapper root = rootBuilder.build(MapperBuilderContext.root(context.mappingLookup().isSourceSynthetic(), false));
        return context.mappingLookup().getMapping().mappingUpdate(root);
    }

    static void parseObjectOrNested(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        String currentFieldName = parser.currentName();
        if (!context.parent().isEnabled()) {
            if (context.canAddIgnoredField()) {
                context.addIgnoredField(new IgnoredSourceFieldMapper.NameValue(context.parent().fullPath(), context.parent().fullPath().indexOf(currentFieldName), XContentDataHelper.encodeToken(parser), context.doc()));
            } else {
                parser.skipChildren();
            }
            return;
        }
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            return;
        }
        if (token.isValue()) {
            DocumentParser.throwOnConcreteValue(context.parent(), currentFieldName, context);
        }
        if (context.parent().isNested()) {
            if (context.parent().storeArraySource() && context.mappingLookup().isSourceSynthetic() && !context.getClonedSource()) {
                Tuple<DocumentParserContext, XContentBuilder> tuple = XContentDataHelper.cloneSubContext(context);
                context.addIgnoredField(new IgnoredSourceFieldMapper.NameValue(context.parent().fullPath(), context.parent().fullPath().indexOf(context.parent().leafName()), XContentDataHelper.encodeXContentBuilder((XContentBuilder)tuple.v2()), context.doc()));
                context = (DocumentParserContext)tuple.v1();
                token = context.parser().currentToken();
                parser = context.parser();
            }
            context = context.createNestedContext((NestedObjectMapper)context.parent());
        }
        if (token == XContentParser.Token.END_OBJECT) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        DocumentParser.innerParseObject(context);
        if (context.parent().isNested()) {
            DocumentParser.copyNestedFields(context, (NestedObjectMapper)context.parent());
        }
    }

    private static void throwOnConcreteValue(ObjectMapper mapper, String currentFieldName, DocumentParserContext context) {
        throw new DocumentParsingException(context.parser().getTokenLocation(), "object mapping for [" + mapper.fullPath() + "] tried to parse field [" + currentFieldName + "] as object, but found a concrete value");
    }

    private static void innerParseObject(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = null;
        assert (token == XContentParser.Token.FIELD_NAME || token == XContentParser.Token.END_OBJECT);
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == null) {
                DocumentParser.throwEOF(context.parent(), context);
            }
            switch (token) {
                case FIELD_NAME: {
                    currentFieldName = parser.currentName();
                    if (currentFieldName.isEmpty()) {
                        throw new IllegalArgumentException("Field name cannot be an empty string");
                    }
                    if (!currentFieldName.isBlank()) break;
                    DocumentParser.throwFieldNameBlank(context, currentFieldName);
                    break;
                }
                case START_OBJECT: {
                    DocumentParser.parseObject(context, currentFieldName);
                    break;
                }
                case START_ARRAY: {
                    DocumentParser.parseArray(context, currentFieldName);
                    break;
                }
                case VALUE_NULL: {
                    DocumentParser.parseNullValue(context, currentFieldName);
                    break;
                }
                default: {
                    if (!token.isValue()) break;
                    DocumentParser.parseValue(context, currentFieldName);
                }
            }
            token = parser.nextToken();
        }
    }

    private static void throwFieldNameBlank(DocumentParserContext context, String currentFieldName) {
        throw new DocumentParsingException(context.parser().getTokenLocation(), "Field name cannot contain only whitespace: [" + context.path().pathAsText(currentFieldName) + "]");
    }

    private static void throwEOF(ObjectMapper mapper, DocumentParserContext context) throws IOException {
        throw new DocumentParsingException(context.parser().getTokenLocation(), "object mapping for [" + mapper.fullPath() + "] tried to parse field [" + context.parser().currentName() + "] as object, but got EOF, has a concrete value been provided to it?");
    }

    private static void copyNestedFields(DocumentParserContext context, NestedObjectMapper nested) {
        if (context.isWithinCopyTo()) {
            return;
        }
        LuceneDocument nestedDoc = context.doc();
        LuceneDocument parentDoc = nestedDoc.getParent();
        IndexVersion indexVersion = context.indexSettings().getIndexVersionCreated();
        if (nested.isIncludeInParent()) {
            DocumentParser.addFields(indexVersion, nestedDoc, parentDoc);
        }
        if (nested.isIncludeInRoot()) {
            LuceneDocument rootDoc = context.rootDoc();
            if (!nested.isIncludeInParent() || parentDoc != rootDoc) {
                DocumentParser.addFields(indexVersion, nestedDoc, rootDoc);
            }
        }
    }

    private static void addFields(IndexVersion indexCreatedVersion, LuceneDocument nestedDoc, LuceneDocument rootDoc) {
        String nestedPathFieldName = NestedPathFieldMapper.name(indexCreatedVersion);
        for (IndexableField field : nestedDoc.getFields()) {
            if (field.name().equals(nestedPathFieldName) || field.name().equals("_id")) continue;
            rootDoc.add(field);
        }
    }

    static void parseObjectOrField(DocumentParserContext context, Mapper mapper) throws IOException {
        if (mapper instanceof ObjectMapper) {
            ObjectMapper objectMapper = (ObjectMapper)mapper;
            DocumentParser.parseObjectOrNested(context.createChildContext(objectMapper));
        } else if (mapper instanceof FieldMapper) {
            List<String> copyToFields;
            FieldMapper fieldMapper = (FieldMapper)mapper;
            if (DocumentParser.shouldFlattenObject(context, fieldMapper)) {
                String currentFieldName = fieldMapper.leafName();
                context.path().remove();
                DocumentParser.parseObjectOrNested(context.createFlattenContext(currentFieldName));
                context.path().add(currentFieldName);
            } else if (context.canAddIgnoredField() && fieldMapper.syntheticSourceMode() == FieldMapper.SyntheticSourceMode.FALLBACK) {
                Tuple<DocumentParserContext, XContentBuilder> contextWithSourceToStore = XContentDataHelper.cloneSubContext(context);
                context.addIgnoredField(IgnoredSourceFieldMapper.NameValue.fromContext(context, fieldMapper.fullPath(), XContentDataHelper.encodeXContentBuilder((XContentBuilder)contextWithSourceToStore.v2())));
                fieldMapper.parse((DocumentParserContext)contextWithSourceToStore.v1());
            } else {
                fieldMapper.parse(context);
            }
            if (!context.isWithinCopyTo() && !(copyToFields = fieldMapper.copyTo().copyToFields()).isEmpty()) {
                XContentParser.Token currentToken = context.parser().currentToken();
                if (!currentToken.isValue() && currentToken != XContentParser.Token.VALUE_NULL) {
                    DocumentParser.throwOnCopyToOnObject(mapper, copyToFields, context);
                }
                DocumentParser.parseCopyFields(context, copyToFields);
            }
        } else if (mapper instanceof FieldAliasMapper) {
            DocumentParser.throwOnCopyToOnFieldAlias(context, mapper);
        } else {
            DocumentParser.throwOnUnrecognizedMapperType(mapper);
        }
    }

    private static boolean shouldFlattenObject(DocumentParserContext context, FieldMapper fieldMapper) {
        return context.parser().currentToken() == XContentParser.Token.START_OBJECT && !context.parent().subobjects() && !fieldMapper.supportsParsingObject();
    }

    private static void throwOnUnrecognizedMapperType(Mapper mapper) {
        throw new IllegalStateException("The provided mapper [" + mapper.fullPath() + "] has an unrecognized type [" + mapper.getClass().getSimpleName() + "].");
    }

    private static void throwOnCopyToOnFieldAlias(DocumentParserContext context, Mapper mapper) {
        throw new DocumentParsingException(context.parser().getTokenLocation(), "Cannot " + (context.isWithinCopyTo() ? "copy" : "write") + " to a field alias [" + mapper.fullPath() + "].");
    }

    private static void throwOnCopyToOnObject(Mapper mapper, List<String> copyToFields, DocumentParserContext context) {
        throw new DocumentParsingException(context.parser().getTokenLocation(), "Cannot copy field [" + mapper.fullPath() + "] to fields " + copyToFields + ". Copy-to currently only works for value-type fields, not objects.");
    }

    private static void parseObject(DocumentParserContext context, String currentFieldName) throws IOException {
        assert (currentFieldName != null);
        Mapper objectMapper = context.getMapper(currentFieldName);
        if (objectMapper != null) {
            DocumentParser.doParseObject(context, currentFieldName, objectMapper);
        } else {
            DocumentParser.parseObjectDynamic(context, currentFieldName);
        }
    }

    private static void doParseObject(DocumentParserContext context, String currentFieldName, Mapper objectMapper) throws IOException {
        ObjectMapper objMapper;
        context.path().add(currentFieldName);
        boolean withinLeafObject = context.path().isWithinLeafObject();
        if (objectMapper instanceof ObjectMapper && !(objMapper = (ObjectMapper)objectMapper).subobjects()) {
            context.path().setWithinLeafObject(true);
        }
        DocumentParser.parseObjectOrField(context, objectMapper);
        context.path().setWithinLeafObject(withinLeafObject);
        context.path().remove();
    }

    private static void parseObjectDynamic(DocumentParserContext context, String currentFieldName) throws IOException {
        DocumentParser.ensureNotStrict(context, currentFieldName);
        if (context.dynamic() == ObjectMapper.Dynamic.FALSE) {
            DocumentParser.failIfMatchesRoutingPath(context, currentFieldName);
            if (context.canAddIgnoredField()) {
                context.addIgnoredField(IgnoredSourceFieldMapper.NameValue.fromContext(context, context.path().pathAsText(currentFieldName), XContentDataHelper.encodeToken(context.parser())));
            } else {
                context.parser().skipChildren();
            }
        } else {
            Mapper dynamicObjectMapper;
            if (context.dynamic() == ObjectMapper.Dynamic.RUNTIME) {
                dynamicObjectMapper = new NoOpObjectMapper(currentFieldName, context.path().pathAsText(currentFieldName));
                if (context.canAddIgnoredField()) {
                    Tuple<DocumentParserContext, XContentBuilder> tuple = XContentDataHelper.cloneSubContext(context);
                    context.addIgnoredField(IgnoredSourceFieldMapper.NameValue.fromContext(context, context.path().pathAsText(currentFieldName), XContentDataHelper.encodeXContentBuilder((XContentBuilder)tuple.v2())));
                    context = (DocumentParserContext)tuple.v1();
                }
            } else {
                dynamicObjectMapper = DynamicFieldsBuilder.createDynamicObjectMapper(context, currentFieldName);
            }
            if (!context.parent().subobjects()) {
                if (dynamicObjectMapper instanceof NestedObjectMapper) {
                    throw new DocumentParsingException(context.parser().getTokenLocation(), "Tried to add nested object [" + dynamicObjectMapper.leafName() + "] to object [" + context.parent().fullPath() + "] which does not support subobjects");
                }
                if (dynamicObjectMapper instanceof ObjectMapper) {
                    DocumentParser.parseObjectOrNested(context.createFlattenContext(currentFieldName));
                    return;
                }
            }
            if (context.dynamic() != ObjectMapper.Dynamic.RUNTIME && !context.addDynamicMapper(dynamicObjectMapper)) {
                DocumentParser.failIfMatchesRoutingPath(context, currentFieldName);
                context.parser().skipChildren();
                return;
            }
            if (dynamicObjectMapper instanceof NestedObjectMapper && context.isWithinCopyTo()) {
                DocumentParser.throwOnCreateDynamicNestedViaCopyTo(dynamicObjectMapper, context);
            }
            DocumentParser.doParseObject(context, currentFieldName, dynamicObjectMapper);
        }
    }

    private static void throwOnCreateDynamicNestedViaCopyTo(Mapper dynamicObjectMapper, DocumentParserContext context) {
        throw new DocumentParsingException(context.parser().getTokenLocation(), "It is forbidden to create dynamic nested objects ([" + dynamicObjectMapper.fullPath() + "]) through `copy_to`");
    }

    private static void parseArray(DocumentParserContext context, String lastFieldName) throws IOException {
        Mapper mapper = DocumentParser.getLeafMapper(context, lastFieldName);
        if (mapper != null) {
            if (DocumentParser.parsesArrayValue(mapper)) {
                DocumentParser.parseObjectOrField(context, mapper);
            } else {
                DocumentParser.parseNonDynamicArray(context, mapper, lastFieldName, lastFieldName);
            }
        } else {
            DocumentParser.parseArrayDynamic(context, lastFieldName);
        }
    }

    private static void parseArrayDynamic(DocumentParserContext context, String currentFieldName) throws IOException {
        DocumentParser.ensureNotStrict(context, currentFieldName);
        if (context.dynamic() == ObjectMapper.Dynamic.FALSE) {
            if (context.canAddIgnoredField()) {
                context.addIgnoredField(IgnoredSourceFieldMapper.NameValue.fromContext(context, context.path().pathAsText(currentFieldName), XContentDataHelper.encodeToken(context.parser())));
            } else {
                context.parser().skipChildren();
            }
            return;
        }
        Mapper objectMapperFromTemplate = DynamicFieldsBuilder.createObjectMapperFromTemplate(context, currentFieldName);
        if (objectMapperFromTemplate == null) {
            if (context.indexSettings().isIgnoreDynamicFieldsBeyondLimit() && context.mappingLookup().exceedsLimit(context.indexSettings().getMappingTotalFieldsLimit(), 1)) {
                if (context.canAddIgnoredField()) {
                    try {
                        context.addIgnoredField(IgnoredSourceFieldMapper.NameValue.fromContext(context, currentFieldName, XContentDataHelper.encodeToken(context.parser())));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("failed to parse field [" + currentFieldName + " ]", e);
                    }
                }
                context.addIgnoredField(currentFieldName);
                return;
            }
            DocumentParser.parseNonDynamicArray(context, objectMapperFromTemplate, currentFieldName, currentFieldName);
        } else if (DocumentParser.parsesArrayValue(objectMapperFromTemplate)) {
            if (!context.addDynamicMapper(objectMapperFromTemplate)) {
                context.parser().skipChildren();
                return;
            }
            context.path().add(currentFieldName);
            DocumentParser.parseObjectOrField(context, objectMapperFromTemplate);
            context.path().remove();
        } else {
            DocumentParser.parseNonDynamicArray(context, objectMapperFromTemplate, currentFieldName, currentFieldName);
        }
    }

    private static boolean parsesArrayValue(Mapper mapper) {
        return mapper instanceof FieldMapper && ((FieldMapper)mapper).parsesArrayValue();
    }

    private static void parseNonDynamicArray(DocumentParserContext context, @Nullable Mapper mapper, String lastFieldName, String arrayFieldName) throws IOException {
        XContentParser.Token token;
        if (context.canAddIgnoredField()) {
            ObjectMapper objectMapper;
            boolean dynamicRuntimeContext;
            FieldMapper fieldMapper;
            ObjectMapper objectMapper2;
            boolean objectRequiresStoringSource = mapper instanceof ObjectMapper && ((objectMapper2 = (ObjectMapper)mapper).storeArraySource() || objectMapper2.dynamic == ObjectMapper.Dynamic.RUNTIME);
            boolean fieldWithFallbackSyntheticSource = mapper instanceof FieldMapper && (fieldMapper = (FieldMapper)mapper).syntheticSourceMode() == FieldMapper.SyntheticSourceMode.FALLBACK;
            boolean bl = dynamicRuntimeContext = context.dynamic() == ObjectMapper.Dynamic.RUNTIME;
            if (objectRequiresStoringSource || fieldWithFallbackSyntheticSource || dynamicRuntimeContext) {
                Tuple<DocumentParserContext, XContentBuilder> tuple = XContentDataHelper.cloneSubContext(context);
                context.addIgnoredField(IgnoredSourceFieldMapper.NameValue.fromContext(context, context.path().pathAsText(arrayFieldName), XContentDataHelper.encodeXContentBuilder((XContentBuilder)tuple.v2())));
                context = (DocumentParserContext)tuple.v1();
            } else if (mapper instanceof ObjectMapper && (!(objectMapper = (ObjectMapper)mapper).isEnabled() || objectMapper.dynamic == ObjectMapper.Dynamic.FALSE)) {
                context.addIgnoredField(IgnoredSourceFieldMapper.NameValue.fromContext(context, context.path().pathAsText(arrayFieldName), XContentDataHelper.encodeToken(context.parser())));
                return;
            }
        }
        XContentParser parser = context.parser();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.START_OBJECT) {
                DocumentParser.parseObject(context, lastFieldName);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                DocumentParser.parseArray(context, lastFieldName);
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                DocumentParser.parseNullValue(context, lastFieldName);
                continue;
            }
            if (token == null) {
                DocumentParser.throwEOFOnParseArray(arrayFieldName, context);
                continue;
            }
            assert (token.isValue());
            DocumentParser.parseValue(context, lastFieldName);
        }
        DocumentParser.postProcessDynamicArrayMapping(context, lastFieldName);
    }

    private static void postProcessDynamicArrayMapping(DocumentParserContext context, String fieldName) {
        if (context.indexSettings().getIndexVersionCreated().onOrAfter(DYNAMICALLY_MAP_DENSE_VECTORS_INDEX_VERSION)) {
            MapperBuilderContext builderContext = context.createDynamicMapperBuilderContext();
            String fullFieldName = builderContext.buildFullName(fieldName);
            List<Mapper> mappers = context.getDynamicMappers(fullFieldName);
            if (mappers == null || context.isFieldAppliedFromTemplate(fullFieldName) || context.isCopyToField(fullFieldName) || mappers.size() < DenseVectorFieldMapper.MIN_DIMS_FOR_DYNAMIC_FLOAT_MAPPING || mappers.size() > DenseVectorFieldMapper.MAX_DIMS_COUNT || mappers.stream().anyMatch(m -> !(m instanceof NumberFieldMapper) || ((NumberFieldMapper)m).type() != NumberFieldMapper.NumberType.FLOAT)) {
                return;
            }
            DenseVectorFieldMapper.Builder builder = new DenseVectorFieldMapper.Builder(fieldName, context.indexSettings().getIndexVersionCreated());
            DenseVectorFieldMapper denseVectorFieldMapper = builder.build(builderContext);
            context.updateDynamicMappers(fullFieldName, List.of(denseVectorFieldMapper));
        }
    }

    private static void throwEOFOnParseArray(String arrayFieldName, DocumentParserContext context) {
        throw new DocumentParsingException(context.parser().getTokenLocation(), "object mapping for [" + context.parent().fullPath() + "] with array for [" + arrayFieldName + "] tried to parse as array, but got EOF, is there a mismatch in types for the same field?");
    }

    private static void parseValue(DocumentParserContext context, String currentFieldName) throws IOException {
        Mapper mapper;
        if (currentFieldName == null) {
            DocumentParser.throwOnNoFieldName(context);
        }
        if ((mapper = DocumentParser.getLeafMapper(context, currentFieldName)) != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else {
            DocumentParser.parseDynamicValue(context, currentFieldName);
        }
    }

    private static void throwOnNoFieldName(DocumentParserContext context) throws IOException {
        throw new DocumentParsingException(context.parser().getTokenLocation(), "object mapping [" + context.parent().fullPath() + "] trying to serialize a value with no field associated with it, current value [" + context.parser().textOrNull() + "]");
    }

    private static void parseNullValue(DocumentParserContext context, String lastFieldName) throws IOException {
        Mapper mapper = DocumentParser.getLeafMapper(context, lastFieldName);
        if (mapper != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else {
            DocumentParser.ensureNotStrict(context, lastFieldName);
        }
    }

    private static void parseDynamicValue(DocumentParserContext context, String currentFieldName) throws IOException {
        DocumentParser.ensureNotStrict(context, currentFieldName);
        if (context.dynamic() == ObjectMapper.Dynamic.FALSE) {
            DocumentParser.failIfMatchesRoutingPath(context, currentFieldName);
            if (context.canAddIgnoredField()) {
                context.addIgnoredField(IgnoredSourceFieldMapper.NameValue.fromContext(context, context.path().pathAsText(currentFieldName), XContentDataHelper.encodeToken(context.parser())));
            }
            return;
        }
        if (context.dynamic() == ObjectMapper.Dynamic.RUNTIME && context.canAddIgnoredField()) {
            context.addIgnoredField(IgnoredSourceFieldMapper.NameValue.fromContext(context, context.path().pathAsText(currentFieldName), XContentDataHelper.encodeToken(context.parser())));
        }
        if (!context.dynamic().getDynamicFieldsBuilder().createDynamicFieldFromValue(context, currentFieldName)) {
            DocumentParser.failIfMatchesRoutingPath(context, currentFieldName);
        }
    }

    private static void ensureNotStrict(DocumentParserContext context, String currentFieldName) {
        if (context.dynamic() == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(context.parser().getTokenLocation(), context.parent().fullPath(), currentFieldName);
        }
    }

    private static void failIfMatchesRoutingPath(DocumentParserContext context, String currentFieldName) {
        String path;
        if (context.indexSettings().getIndexMetadata().getRoutingPaths().isEmpty()) {
            return;
        }
        String string = path = context.parent().fullPath().isEmpty() ? currentFieldName : context.parent().fullPath() + "." + currentFieldName;
        if (Regex.simpleMatch(context.indexSettings().getIndexMetadata().getRoutingPaths(), path)) {
            throw new DocumentParsingException(context.parser().getTokenLocation(), "All fields matching [routing_path] must be mapped but [" + path + "] was declared as [dynamic: false]");
        }
    }

    private static void parseCopyFields(DocumentParserContext context, List<String> copyToFields) throws IOException {
        for (String field : copyToFields) {
            if (context.mappingLookup().inferenceFields().get(field) != null) continue;
            LuceneDocument targetDoc = null;
            for (LuceneDocument doc = context.doc(); doc != null; doc = doc.getParent()) {
                if (!field.startsWith(doc.getPrefix())) continue;
                targetDoc = doc;
                break;
            }
            assert (targetDoc != null);
            DocumentParserContext copyToContext = context.createCopyToContext(field, targetDoc);
            DocumentParser.innerParseObject(copyToContext);
            context.markFieldAsCopyTo(field);
        }
    }

    private static Mapper getLeafMapper(DocumentParserContext context, String fieldName) {
        Mapper mapper = context.getMapper(fieldName);
        if (mapper != null) {
            return mapper;
        }
        String fieldPath = context.path().pathAsText(fieldName);
        MappedFieldType fieldType = context.mappingLookup().getFieldType(fieldPath);
        if (fieldType != null) {
            assert (!fieldType.hasDocValues() && fieldType.isAggregatable() && fieldType.isSearchable());
            return NO_OP_FIELDMAPPER;
        }
        return null;
    }

    private static class RootDocumentParserContext
    extends DocumentParserContext {
        private final ContentPath path = new ContentPath();
        private final XContentParser parser;
        private final LuceneDocument document;
        private final List<LuceneDocument> documents = new ArrayList<LuceneDocument>();
        private final long maxAllowedNumNestedDocs;
        private long numNestedDocs;
        private boolean docsReversed = false;

        RootDocumentParserContext(MappingLookup mappingLookup, MappingParserContext mappingParserContext, SourceToParse source, XContentParser parser) throws IOException {
            super(mappingLookup, mappingParserContext, source, mappingLookup.getMapping().getRoot(), ObjectMapper.Dynamic.getRootDynamic(mappingLookup));
            this.parser = mappingLookup.getMapping().getRoot().subobjects() ? DotExpandingXContentParser.expandDots(parser, this.path) : parser;
            this.document = new LuceneDocument();
            this.documents.add(this.document);
            this.maxAllowedNumNestedDocs = this.indexSettings().getMappingNestedDocsLimit();
            this.numNestedDocs = 0L;
        }

        @Override
        public Mapper getMapper(String name) {
            MetadataFieldMapper mapper = this.getMetadataMapper(name);
            if (mapper != null) {
                return mapper;
            }
            return super.getMapper(name);
        }

        @Override
        public ContentPath path() {
            return this.path;
        }

        @Override
        public XContentParser parser() {
            return this.parser;
        }

        @Override
        public LuceneDocument rootDoc() {
            return this.documents.get(0);
        }

        @Override
        public LuceneDocument doc() {
            return this.document;
        }

        @Override
        protected void addDoc(LuceneDocument doc) {
            ++this.numNestedDocs;
            if (this.numNestedDocs > this.maxAllowedNumNestedDocs) {
                throw new DocumentParsingException(this.parser.getTokenLocation(), "The number of nested documents has exceeded the allowed limit of [" + this.maxAllowedNumNestedDocs + "]. This limit can be set by changing the [" + MapperService.INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING.getKey() + "] index level setting.");
            }
            this.documents.add(doc);
        }

        @Override
        public Iterable<LuceneDocument> nonRootDocuments() {
            if (this.docsReversed) {
                throw new IllegalStateException("documents are already reversed");
            }
            return this.documents.subList(1, this.documents.size());
        }

        private List<LuceneDocument> reorderParentAndGetDocs() {
            if (this.documents.size() > 1 && !this.docsReversed) {
                this.docsReversed = true;
                ArrayList<LuceneDocument> newDocs = new ArrayList<LuceneDocument>(this.documents.size());
                LinkedList<LuceneDocument> parents = new LinkedList<LuceneDocument>();
                for (LuceneDocument doc : this.documents) {
                    while (parents.peek() != doc.getParent()) {
                        newDocs.add((LuceneDocument)parents.poll());
                    }
                    parents.add(0, doc);
                }
                newDocs.addAll(parents);
                this.documents.clear();
                this.documents.addAll(newDocs);
            }
            return this.documents;
        }
    }

    private static class NoOpObjectMapper
    extends ObjectMapper {
        NoOpObjectMapper(String name, String fullPath) {
            super(name, fullPath, Explicit.IMPLICIT_TRUE, Explicit.IMPLICIT_TRUE, Explicit.IMPLICIT_FALSE, ObjectMapper.Dynamic.RUNTIME, Collections.emptyMap());
        }

        @Override
        public ObjectMapper merge(Mapper mergeWith, MapperMergeContext mapperMergeContext) {
            return this;
        }
    }
}

