/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.CustomTermFreqField;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DocCountFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_doc_count";
    public static final String CONTENT_TYPE = "_doc_count";
    private static final DocCountFieldMapper INSTANCE = new DocCountFieldMapper();
    private static final Term TERM = new Term("_doc_count", "_doc_count");
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> INSTANCE);

    private DocCountFieldMapper() {
        super(DocCountFieldType.INSTANCE);
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, parser.currentToken(), parser);
        if (context.doc().getByKey("_doc_count") != null) {
            throw new IllegalArgumentException("Arrays are not allowed for field [" + this.fieldType().name() + "].");
        }
        int value = parser.intValue(false);
        if (value <= 0) {
            throw new IllegalArgumentException("Field [" + this.fieldType().name() + "] must be a positive integer. Value [" + value + "] is not allowed.");
        }
        context.doc().addWithKey("_doc_count", DocCountFieldMapper.field(value));
    }

    @Override
    public DocCountFieldType fieldType() {
        return (DocCountFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return "_doc_count";
    }

    public static IndexableField field(int count) {
        return new CustomTermFreqField("_doc_count", "_doc_count", count);
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return new SyntheticFieldLoader();
    }

    public static PostingsEnum leafLookup(LeafReader reader) throws IOException {
        return reader.postings(TERM);
    }

    public static final class DocCountFieldType
    extends MappedFieldType {
        public static final DocCountFieldType INSTANCE = new DocCountFieldType();
        public static final int DEFAULT_VALUE = 1;

        public DocCountFieldType() {
            super("_doc_count", false, false, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_doc_count";
        }

        @Override
        public String familyTypeName() {
            return NumberFieldMapper.NumberType.INTEGER.typeName();
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, "Field [" + this.name() + "] of type [" + this.typeName() + "] does not support exists queries", new Object[0]);
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, "Field [" + this.name() + "] of type [" + this.typeName() + "] is not searchable", new Object[0]);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, 1){

                @Override
                protected Object parseSourceValue(Object value) {
                    if ("".equals(value)) {
                        return 1;
                    }
                    return NumberFieldMapper.NumberType.INTEGER.parse(value, false);
                }
            };
        }
    }

    private static class SyntheticFieldLoader
    implements SourceLoader.SyntheticFieldLoader {
        private PostingsEnum postings;
        private boolean hasValue;

        private SyntheticFieldLoader() {
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.empty();
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            this.postings = DocCountFieldMapper.leafLookup(leafReader);
            if (this.postings == null) {
                this.hasValue = false;
                return null;
            }
            return docId -> {
                if (docId < this.postings.docID()) {
                    this.hasValue = false;
                    return false;
                }
                if (docId == this.postings.docID()) {
                    this.hasValue = true;
                    return true;
                }
                this.hasValue = docId == this.postings.advance(docId);
                return this.hasValue;
            };
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            b.field("_doc_count", this.postings.freq());
        }

        @Override
        public String fieldName() {
            return "_doc_count";
        }
    }
}

