/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.XContentDataHelper;
import org.elasticsearch.xcontent.XContentBuilder;

public class CompositeSyntheticFieldLoader
implements SourceLoader.SyntheticFieldLoader {
    private final String fieldName;
    private final String fullFieldName;
    private final SyntheticFieldLoaderLayer[] parts;
    private boolean hasValue;

    public CompositeSyntheticFieldLoader(String fieldName, String fullFieldName, SyntheticFieldLoaderLayer ... parts) {
        this.fieldName = fieldName;
        this.fullFieldName = fullFieldName;
        this.parts = parts;
        this.hasValue = false;
    }

    @Override
    public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
        return Arrays.stream(this.parts).flatMap(SourceLoader.SyntheticFieldLoader::storedFieldLoaders).map(e -> Map.entry((String)e.getKey(), values -> {
            this.hasValue = true;
            ((SourceLoader.SyntheticFieldLoader.StoredFieldLoader)e.getValue()).load(values);
        }));
    }

    @Override
    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
        ArrayList<SourceLoader.SyntheticFieldLoader.DocValuesLoader> loaders = new ArrayList<SourceLoader.SyntheticFieldLoader.DocValuesLoader>(this.parts.length);
        for (SyntheticFieldLoaderLayer part : this.parts) {
            SourceLoader.SyntheticFieldLoader.DocValuesLoader partLoader = part.docValuesLoader(leafReader, docIdsInLeaf);
            if (partLoader == null) continue;
            loaders.add(partLoader);
        }
        if (loaders.isEmpty()) {
            return null;
        }
        return docId -> {
            boolean hasDocs = false;
            for (SourceLoader.SyntheticFieldLoader.DocValuesLoader loader : loaders) {
                hasDocs |= loader.advanceToDoc(docId);
            }
            this.hasValue |= hasDocs;
            return hasDocs;
        };
    }

    @Override
    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    public void write(XContentBuilder b) throws IOException {
        long totalCount = Arrays.stream(this.parts).mapToLong(SyntheticFieldLoaderLayer::valueCount).sum();
        if (totalCount == 0L) {
            return;
        }
        if (totalCount == 1L) {
            b.field(this.fieldName);
            for (SyntheticFieldLoaderLayer part : this.parts) {
                part.write(b);
            }
            return;
        }
        b.startArray(this.fieldName);
        for (SyntheticFieldLoaderLayer part : this.parts) {
            part.write(b);
        }
        b.endArray();
    }

    @Override
    public String fieldName() {
        return this.fullFieldName;
    }

    public static interface SyntheticFieldLoaderLayer
    extends SourceLoader.SyntheticFieldLoader {
        public long valueCount();
    }

    public static class MalformedValuesLayer
    implements SyntheticFieldLoaderLayer {
        private final String fieldName;
        private List<Object> values;

        public MalformedValuesLayer(String fieldName) {
            this.fieldName = IgnoreMalformedStoredValues.name(fieldName);
            this.values = Collections.emptyList();
        }

        @Override
        public long valueCount() {
            return this.values.size();
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.of(Map.entry(this.fieldName, values -> {
                this.values = values;
            }));
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            return null;
        }

        @Override
        public boolean hasValue() {
            return !this.values.isEmpty();
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            for (Object v : this.values) {
                if (v instanceof BytesRef) {
                    BytesRef r = (BytesRef)v;
                    XContentDataHelper.decodeAndWrite(b, r);
                    continue;
                }
                b.value(v);
            }
            this.values = Collections.emptyList();
        }

        @Override
        public String fieldName() {
            return this.fieldName;
        }
    }
}

