/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.fieldvisitor.FieldNamesProvidingStoredFieldsVisitor;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Uid;

public class FieldsVisitor
extends FieldNamesProvidingStoredFieldsVisitor {
    static final Set<String> BASE_REQUIRED_FIELDS = Set.of("_id", "_routing");
    private final boolean loadSource;
    final String sourceFieldName;
    private final Set<String> requiredFields;
    protected BytesReference source;
    protected String id;
    protected Map<String, List<Object>> fieldsValues;

    public FieldsVisitor(boolean loadSource) {
        this(loadSource, "_source");
    }

    public FieldsVisitor(boolean loadSource, String sourceFieldName) {
        this.loadSource = loadSource;
        this.sourceFieldName = sourceFieldName;
        this.requiredFields = new HashSet<String>();
        this.reset();
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        if (this.requiredFields.remove(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        if ("_ignored".equals(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        if ("_uid".equals(fieldInfo.name) && (this.requiredFields.remove("_id") || this.requiredFields.remove("_type"))) {
            return StoredFieldVisitor.Status.YES;
        }
        return this.requiredFields.isEmpty() ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
    }

    @Override
    public Set<String> getFieldNames() {
        return this.requiredFields;
    }

    public final void postProcess(Function<String, MappedFieldType> fieldTypeLookup) {
        for (Map.Entry<String, List<Object>> entry : this.fields().entrySet()) {
            MappedFieldType fieldType = fieldTypeLookup.apply(entry.getKey());
            if (fieldType == null) continue;
            List<Object> fieldValues = entry.getValue();
            for (int i = 0; i < fieldValues.size(); ++i) {
                fieldValues.set(i, fieldType.valueForDisplay(fieldValues.get(i)));
            }
        }
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) {
        this.binaryField(fieldInfo, new BytesRef(value));
    }

    private void binaryField(FieldInfo fieldInfo, BytesRef value) {
        if (this.sourceFieldName.equals(fieldInfo.name)) {
            this.source = new BytesArray(value);
        } else if ("_id".equals(fieldInfo.name)) {
            this.id = Uid.decodeId(value.bytes, value.offset, value.length);
        } else {
            this.addValue(fieldInfo.name, value);
        }
    }

    public void stringField(FieldInfo fieldInfo, String value) {
        assert (!this.sourceFieldName.equals(fieldInfo.name)) : "source field must go through binaryField";
        if ("_uid".equals(fieldInfo.name)) {
            int delimiterIndex = value.indexOf(35);
            String type = value.substring(0, delimiterIndex);
            this.id = value.substring(delimiterIndex + 1);
            this.addValue("_type", type);
        } else if ("_id".equals(fieldInfo.name)) {
            this.id = value;
        } else {
            this.addValue(fieldInfo.name, value);
        }
    }

    public void intField(FieldInfo fieldInfo, int value) {
        this.addValue(fieldInfo.name, value);
    }

    public void longField(FieldInfo fieldInfo, long value) {
        this.addValue(fieldInfo.name, value);
    }

    public void floatField(FieldInfo fieldInfo, float value) {
        this.addValue(fieldInfo.name, Float.valueOf(value));
    }

    public void doubleField(FieldInfo fieldInfo, double value) {
        this.addValue(fieldInfo.name, value);
    }

    public BytesReference source() {
        return this.source;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        if (this.fieldsValues == null) {
            return null;
        }
        List<Object> values = this.fieldsValues.get("_routing");
        if (values == null || values.isEmpty()) {
            return null;
        }
        assert (values.size() == 1);
        return values.get(0).toString();
    }

    public Map<String, List<Object>> fields() {
        return this.fieldsValues != null ? this.fieldsValues : Collections.emptyMap();
    }

    public void reset() {
        if (this.fieldsValues != null) {
            this.fieldsValues.clear();
        }
        this.source = null;
        this.id = null;
        this.requiredFields.addAll(BASE_REQUIRED_FIELDS);
        if (this.loadSource) {
            this.requiredFields.add(this.sourceFieldName);
        }
    }

    void addValue(String name, Object value) {
        if (this.fieldsValues == null) {
            this.fieldsValues = new HashMap<String, List<Object>>();
        }
        List values = this.fieldsValues.computeIfAbsent(name, k -> new ArrayList(2));
        values.add(value);
    }
}

