/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.shard.ShardStateMetadata;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class TransportNodesListGatewayStartedShards
extends TransportNodesAction<Request, NodesGatewayStartedShards, NodeRequest, NodeGatewayStartedShards> {
    private static final Logger logger = LogManager.getLogger(TransportNodesListGatewayStartedShards.class);
    public static final String ACTION_NAME = "internal:gateway/local/started_shards";
    public static final ActionType<NodesGatewayStartedShards> TYPE = new ActionType("internal:gateway/local/started_shards");
    private final Settings settings;
    private final NodeEnvironment nodeEnv;
    private final IndicesService indicesService;
    private final NamedXContentRegistry namedXContentRegistry;

    @Inject
    public TransportNodesListGatewayStartedShards(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeEnvironment env, IndicesService indicesService, NamedXContentRegistry namedXContentRegistry) {
        super(ACTION_NAME, clusterService, transportService, actionFilters, NodeRequest::new, threadPool.executor("fetch_shard_started"));
        this.settings = settings;
        this.nodeEnv = env;
        this.indicesService = indicesService;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeGatewayStartedShards newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        NodeGatewayStartedShards response = new NodeGatewayStartedShards(in, node);
        assert (response.getNode() == node);
        return response;
    }

    @Override
    protected NodesGatewayStartedShards newResponse(Request request, List<NodeGatewayStartedShards> responses, List<FailedNodeException> failures) {
        return new NodesGatewayStartedShards(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeGatewayStartedShards nodeOperation(NodeRequest request, Task task) {
        try {
            ShardId shardId = request.getShardId();
            logger.trace("{} loading local shard state info", (Object)shardId);
            ShardStateMetadata shardStateMetadata = ShardStateMetadata.FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.availableShardPaths(request.shardId));
            if (shardStateMetadata != null) {
                if (this.indicesService.getShardOrNull(shardId) == null) {
                    String customDataPath;
                    if (request.getCustomDataPath() != null) {
                        customDataPath = request.getCustomDataPath();
                    } else {
                        IndexMetadata metadata = this.clusterService.state().metadata().index(shardId.getIndex());
                        if (metadata != null) {
                            customDataPath = new IndexSettings(metadata, this.settings).customDataPath();
                        } else {
                            logger.trace("{} node doesn't have meta data for the requests index", (Object)shardId);
                            throw new ElasticsearchException("node doesn't have meta data for index " + shardId.getIndex(), new Object[0]);
                        }
                    }
                    ShardPath shardPath = null;
                    try {
                        shardPath = ShardPath.loadShardPath(logger, this.nodeEnv, shardId, customDataPath);
                        if (shardPath == null) {
                            throw new IllegalStateException(shardId + " no shard path found");
                        }
                        Store.tryOpenIndex(shardPath.resolveIndex(), shardId, this.nodeEnv::shardLock, logger);
                    }
                    catch (Exception exception) {
                        ShardPath finalShardPath = shardPath;
                        logger.trace(() -> Strings.format((String)"%s can't open index for shard [%s] in path [%s]", (Object[])new Object[]{shardId, shardStateMetadata, finalShardPath != null ? finalShardPath.resolveIndex() : ""}), (Throwable)exception);
                        String allocationId = shardStateMetadata.allocationId != null ? shardStateMetadata.allocationId.getId() : null;
                        return new NodeGatewayStartedShards(this.clusterService.localNode(), allocationId, shardStateMetadata.primary, exception);
                    }
                }
                logger.debug("{} shard state info found: [{}]", (Object)shardId, (Object)shardStateMetadata);
                String allocationId = shardStateMetadata.allocationId != null ? shardStateMetadata.allocationId.getId() : null;
                return new NodeGatewayStartedShards(this.clusterService.localNode(), allocationId, shardStateMetadata.primary);
            }
            logger.trace("{} no local shard info found", (Object)shardId);
            return new NodeGatewayStartedShards(this.clusterService.localNode(), null, false);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to load started shards", (Throwable)e, new Object[0]);
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.customDataPath = in.getTransportVersion().onOrAfter(TransportVersions.V_7_6_0) ? in.readString() : null;
        }

        public NodeRequest(Request request) {
            this.shardId = Objects.requireNonNull(request.shardId());
            this.customDataPath = Objects.requireNonNull(request.getCustomDataPath());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_6_0)) {
                assert (this.customDataPath != null);
                out.writeString(this.customDataPath);
            }
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public Request(ShardId shardId, String customDataPath, DiscoveryNode[] nodes) {
            super(nodes);
            this.shardId = Objects.requireNonNull(shardId);
            this.customDataPath = Objects.requireNonNull(customDataPath);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }
    }

    public static class NodeGatewayStartedShards
    extends BaseNodeResponse {
        private final String allocationId;
        private final boolean primary;
        private final Exception storeException;

        public NodeGatewayStartedShards(StreamInput in, DiscoveryNode node) throws IOException {
            super(in, node);
            this.allocationId = in.readOptionalString();
            this.primary = in.readBoolean();
            this.storeException = in.readBoolean() ? in.readException() : null;
        }

        public NodeGatewayStartedShards(DiscoveryNode node, String allocationId, boolean primary) {
            this(node, allocationId, primary, null);
        }

        public NodeGatewayStartedShards(DiscoveryNode node, String allocationId, boolean primary, Exception storeException) {
            super(node);
            this.allocationId = allocationId;
            this.primary = primary;
            this.storeException = storeException;
        }

        public String allocationId() {
            return this.allocationId;
        }

        public boolean primary() {
            return this.primary;
        }

        public Exception storeException() {
            return this.storeException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.allocationId);
            out.writeBoolean(this.primary);
            if (this.storeException != null) {
                out.writeBoolean(true);
                out.writeException(this.storeException);
            } else {
                out.writeBoolean(false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeGatewayStartedShards that = (NodeGatewayStartedShards)o;
            return this.primary == that.primary && Objects.equals(this.allocationId, that.allocationId) && Objects.equals(this.storeException, that.storeException);
        }

        public int hashCode() {
            int result = this.allocationId != null ? this.allocationId.hashCode() : 0;
            result = 31 * result + (this.primary ? 1 : 0);
            result = 31 * result + (this.storeException != null ? this.storeException.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("NodeGatewayStartedShards[").append("allocationId=").append(this.allocationId).append(",primary=").append(this.primary);
            if (this.storeException != null) {
                buf.append(",storeException=").append(this.storeException);
            }
            buf.append("]");
            return buf.toString();
        }
    }

    public static class NodesGatewayStartedShards
    extends BaseNodesResponse<NodeGatewayStartedShards> {
        public NodesGatewayStartedShards(ClusterName clusterName, List<NodeGatewayStartedShards> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeGatewayStartedShards> readNodesFrom(StreamInput in) throws IOException {
            return (List)TransportAction.localOnly();
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeGatewayStartedShards> nodes) throws IOException {
            TransportAction.localOnly();
        }
    }
}

