/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static int binarySearch(double[] array, double value, double tolerance) {
        if (array.length == 0) {
            return -1;
        }
        return ArrayUtils.binarySearch(array, 0, array.length, value, tolerance);
    }

    private static int binarySearch(double[] array, int fromIndex, int toIndex, double value, double tolerance) {
        int index = Arrays.binarySearch(array, fromIndex, toIndex, value);
        if (index < 0) {
            int highIndex = -1 - index;
            int lowIndex = highIndex - 1;
            double lowError = Double.POSITIVE_INFINITY;
            double highError = Double.POSITIVE_INFINITY;
            if (lowIndex >= 0) {
                lowError = value - array[lowIndex];
            }
            if (highIndex < array.length) {
                highError = array[highIndex] - value;
            }
            if (highError < lowError) {
                if (highError < tolerance) {
                    index = highIndex;
                }
            } else {
                index = lowError < tolerance ? lowIndex : -1;
            }
        }
        return index;
    }

    public static <T> T[] concat(T[] one, T[] other) {
        Object[] target = (Object[])Array.newInstance(other.getClass().componentType(), one.length + other.length);
        System.arraycopy(one, 0, target, 0, one.length);
        System.arraycopy(other, 0, target, one.length, other.length);
        return target;
    }

    public static <T> T[] prepend(T added, T[] array) {
        Object[] updated = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        updated[0] = added;
        System.arraycopy(array, 0, updated, 1, array.length);
        return updated;
    }

    public static <T> T[] append(T[] array, T added) {
        T[] updated = Arrays.copyOf(array, array.length + 1);
        updated[array.length] = added;
        return updated;
    }

    public static void reverseSubArray(double[] array, int offset, int length) {
        int start = offset;
        for (int end = offset + length; end > start; ++start, --end) {
            double scratch = array[start];
            array[start] = array[end - 1];
            array[end - 1] = scratch;
        }
    }

    public static void reverseSubArray(long[] array, int offset, int length) {
        int start = offset;
        for (int end = offset + length; end > start; ++start, --end) {
            long scratch = array[start];
            array[start] = array[end - 1];
            array[end - 1] = scratch;
        }
    }
}

