/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.shards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterShardHealth;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.health.Diagnosis;
import org.elasticsearch.health.HealthIndicatorDetails;
import org.elasticsearch.health.HealthIndicatorImpact;
import org.elasticsearch.health.HealthIndicatorResult;
import org.elasticsearch.health.HealthIndicatorService;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.health.ImpactArea;
import org.elasticsearch.health.SimpleHealthIndicatorDetails;
import org.elasticsearch.health.node.HealthIndicatorDisplayValues;
import org.elasticsearch.health.node.HealthInfo;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.snapshots.SnapshotShardSizeInfo;

public class ShardsAvailabilityHealthIndicatorService
implements HealthIndicatorService {
    private static final Logger LOGGER = LogManager.getLogger(ShardsAvailabilityHealthIndicatorService.class);
    public static final String NAME = "shards_availability";
    private static final String DATA_TIER_ALLOCATION_DECIDER_NAME = "data_tier";
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final SystemIndices systemIndices;
    public static final String PRIMARY_UNASSIGNED_IMPACT_ID = "primary_unassigned";
    public static final String READ_ONLY_PRIMARY_UNASSIGNED_IMPACT_ID = "read_only_primary_unassigned";
    public static final String REPLICA_UNASSIGNED_IMPACT_ID = "replica_unassigned";
    public static final String RESTORE_FROM_SNAPSHOT_ACTION_GUIDE = "https://ela.st/restore-snapshot";
    public static final Diagnosis.Definition ACTION_RESTORE_FROM_SNAPSHOT = new Diagnosis.Definition("shards_availability", "restore_from_snapshot", "Elasticsearch isn't allowed to allocate some shards because there are no copies of the shards in the cluster. Elasticsearch will allocate these shards when nodes holding good copies of the data join the cluster.", "If no such node is available, restore these indices from a recent snapshot.", "https://ela.st/restore-snapshot");
    public static final String DIAGNOSE_SHARDS_ACTION_GUIDE = "https://ela.st/diagnose-shards";
    public static final Diagnosis.Definition ACTION_CHECK_ALLOCATION_EXPLAIN_API = new Diagnosis.Definition("shards_availability", "explain_allocations", "Elasticsearch isn't allowed to allocate some shards from these indices to any of the nodes in the cluster.", "Diagnose the issue by calling the allocation explain API for an index [GET _cluster/allocation/explain]. Choose a node to which you expect a shard to be allocated, find this node in the node-by-node explanation, and address the reasons which prevent Elasticsearch from allocating the shard.", "https://ela.st/diagnose-shards");
    public static final String FIX_DELAYED_SHARDS_GUIDE = "https://ela.st/fix-delayed-shard-allocation";
    public static final Diagnosis.Definition DIAGNOSIS_WAIT_FOR_OR_FIX_DELAYED_SHARDS = new Diagnosis.Definition("shards_availability", "delayed_shard_allocations", "Elasticsearch is not allocating some shards because they are marked for delayed allocation. Shards that have become unavailable are usually marked for delayed allocation because it is more efficient to wait and see if the shards return on their own than to recover the shard immediately.", "Elasticsearch will reallocate the shards when the delay has elapsed. No action is required by the user.", "https://ela.st/fix-delayed-shard-allocation");
    public static final String WAIT_FOR_INITIALIZATION_GUIDE = "https://ela.st/wait-for-shard-initialization";
    public static final Diagnosis.Definition DIAGNOSIS_WAIT_FOR_INITIALIZATION = new Diagnosis.Definition("shards_availability", "initializing_shards", "Elasticsearch is currently initializing the unavailable shards. Please wait for the initialization to finish.", "The shards will become available as long as the initialization completes. No action is required by the user, you can monitor the progress of the initializing shards at https://ela.st/wait-for-shard-initialization.", "https://ela.st/wait-for-shard-initialization");
    public static final String ENABLE_INDEX_ALLOCATION_GUIDE = "https://ela.st/fix-index-allocation";
    public static final Diagnosis.Definition ACTION_ENABLE_INDEX_ROUTING_ALLOCATION = new Diagnosis.Definition("shards_availability", "enable_index_allocations", "Elasticsearch isn't allowed to allocate some shards from these indices because allocation for those shards has been disabled at the index level.", "Check that the [" + EnableAllocationDecider.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING.getKey() + "] index settings are set to [" + EnableAllocationDecider.Allocation.ALL.toString().toLowerCase(Locale.getDefault()) + "].", "https://ela.st/fix-index-allocation");
    public static final String ENABLE_CLUSTER_ALLOCATION_ACTION_GUIDE = "https://ela.st/fix-cluster-allocation";
    public static final Diagnosis.Definition ACTION_ENABLE_CLUSTER_ROUTING_ALLOCATION = new Diagnosis.Definition("shards_availability", "enable_cluster_allocations", "Elasticsearch isn't allowed to allocate some shards from these indices because allocation for those shards has been disabled at the cluster level.", "Check that the [" + EnableAllocationDecider.CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING.getKey() + "] cluster setting is set to [" + EnableAllocationDecider.Allocation.ALL.toString().toLowerCase(Locale.getDefault()) + "].", "https://ela.st/fix-cluster-allocation");
    public static final String ENABLE_TIER_ACTION_GUIDE = "https://ela.st/enable-tier";
    private static final Map<String, Diagnosis.Definition> ACTION_ENABLE_TIERS_LOOKUP = DataTier.ALL_DATA_TIERS.stream().collect(Collectors.toUnmodifiableMap(tier -> tier, tier -> new Diagnosis.Definition(NAME, "enable_data_tiers:tier:" + tier, "Elasticsearch isn't allowed to allocate some shards from these indices because the indices expect to be allocated to data tier nodes, but there were not any nodes with the expected tiers found in the cluster.", "Add nodes with the [" + tier + "] role to the cluster.", ENABLE_TIER_ACTION_GUIDE)));
    public static final String INCREASE_SHARD_LIMIT_ACTION_GUIDE = "https://ela.st/index-total-shards";
    public static final Diagnosis.Definition ACTION_INCREASE_SHARD_LIMIT_INDEX_SETTING = new Diagnosis.Definition("shards_availability", "increase_shard_limit_index_setting", "Elasticsearch isn't allowed to allocate some shards from these indices to any data nodes because each node has reached the index shard limit. ", "Increase the values for the [" + ShardsLimitAllocationDecider.INDEX_TOTAL_SHARDS_PER_NODE_SETTING.getKey() + "] index setting on each index or add more nodes to the target tiers.", "https://ela.st/index-total-shards");
    private static final Map<String, Diagnosis.Definition> ACTION_INCREASE_SHARD_LIMIT_INDEX_SETTING_LOOKUP = DataTier.ALL_DATA_TIERS.stream().collect(Collectors.toUnmodifiableMap(tier -> tier, tier -> new Diagnosis.Definition(NAME, "increase_shard_limit_index_setting:tier:" + tier, "Elasticsearch isn't allowed to allocate some shards from these indices because each node in the [" + tier + "] tier has reached the index shard limit. ", "Increase the values for the [" + ShardsLimitAllocationDecider.INDEX_TOTAL_SHARDS_PER_NODE_SETTING.getKey() + "] index setting on each index or add more nodes to the target tiers.", INCREASE_SHARD_LIMIT_ACTION_GUIDE)));
    public static final String INCREASE_CLUSTER_SHARD_LIMIT_ACTION_GUIDE = "https://ela.st/cluster-total-shards";
    public static final Diagnosis.Definition ACTION_INCREASE_SHARD_LIMIT_CLUSTER_SETTING = new Diagnosis.Definition("shards_availability", "increase_shard_limit_cluster_setting", "Elasticsearch isn't allowed to allocate some shards from these indices to any data nodes because each node has reached the cluster shard limit.", "Increase the values for the [" + ShardsLimitAllocationDecider.CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING.getKey() + "] cluster setting or add more nodes to the target tiers.", "https://ela.st/cluster-total-shards");
    private static final Map<String, Diagnosis.Definition> ACTION_INCREASE_SHARD_LIMIT_CLUSTER_SETTING_LOOKUP = DataTier.ALL_DATA_TIERS.stream().collect(Collectors.toUnmodifiableMap(tier -> tier, tier -> new Diagnosis.Definition(NAME, "increase_shard_limit_cluster_setting:tier:" + tier, "Elasticsearch isn't allowed to allocate some shards from these indices because each node in the [" + tier + "] tier has reached the cluster shard limit. ", "Increase the values for the [" + ShardsLimitAllocationDecider.CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING.getKey() + "] cluster setting or add more nodes to the target tiers.", INCREASE_CLUSTER_SHARD_LIMIT_ACTION_GUIDE)));
    public static final String MIGRATE_TO_TIERS_ACTION_GUIDE = "https://ela.st/migrate-to-tiers";
    public static final Diagnosis.Definition ACTION_MIGRATE_TIERS_AWAY_FROM_REQUIRE_DATA = new Diagnosis.Definition("shards_availability", "migrate_data_tiers_require_data", "Elasticsearch isn't allowed to allocate some shards from these indices to any nodes in the desired data tiers because the indices are configured with allocation filter rules that are incompatible with the nodes in this tier.", "Remove [index.routing.allocation.require.data] from the index settings or try migrating to data tiers by first stopping ILM [POST /_ilm/stop] and then using the data tier migration action [POST /_ilm/migrate_to_data_tiers]. Finally, restart ILM [POST /_ilm/start].", "https://ela.st/migrate-to-tiers");
    public static final Map<String, Diagnosis.Definition> ACTION_MIGRATE_TIERS_AWAY_FROM_REQUIRE_DATA_LOOKUP = DataTier.ALL_DATA_TIERS.stream().collect(Collectors.toUnmodifiableMap(tier -> tier, tier -> new Diagnosis.Definition(NAME, "migrate_data_tiers_require_data:tier:" + tier, "Elasticsearch isn't allowed to allocate some shards from these indices to any nodes in the [" + tier + "] data tier because the indices are configured with allocation filter rules that are incompatible with the nodes in this tier.", "Remove [index.routing.allocation.require.data] from the index settings or try migrating to data tiers by first stopping ILM [POST /_ilm/stop] and then using the data tier migration action [POST /_ilm/migrate_to_data_tiers]. Finally, restart ILM [POST /_ilm/start].", MIGRATE_TO_TIERS_ACTION_GUIDE)));
    public static final Diagnosis.Definition ACTION_MIGRATE_TIERS_AWAY_FROM_INCLUDE_DATA = new Diagnosis.Definition("shards_availability", "migrate_data_tiers_include_data", "Elasticsearch isn't allowed to allocate some shards from these indices to any nodes in the desired data tiers because the indices are configured with allocation filter rules that are incompatible with the nodes in this tier. ", "Remove [index.routing.allocation.include.data] from the index settings or try migrating to data tiers by first stopping ILM [POST /_ilm/stop] and then using the data tier migration action [POST /_ilm/migrate_to_data_tiers]. Finally, restart ILM [POST /_ilm/start].", "https://ela.st/migrate-to-tiers");
    public static final Map<String, Diagnosis.Definition> ACTION_MIGRATE_TIERS_AWAY_FROM_INCLUDE_DATA_LOOKUP = DataTier.ALL_DATA_TIERS.stream().collect(Collectors.toUnmodifiableMap(tier -> tier, tier -> new Diagnosis.Definition(NAME, "migrate_data_tiers_include_data:tier:" + tier, "Elasticsearch isn't allowed to allocate some shards from these indices to any nodes in the [" + tier + "] data tier because the indices are configured with allocation filter rules that are incompatible with the nodes in this tier.", "Remove [index.routing.allocation.include.data] from the index settings or try migrating to data tiers by first stopping ILM [POST /_ilm/stop] and then using the data tier migration action [POST /_ilm/migrate_to_data_tiers]. Finally, restart ILM [POST /_ilm/start].", MIGRATE_TO_TIERS_ACTION_GUIDE)));
    public static final String TIER_CAPACITY_ACTION_GUIDE = "https://ela.st/tier-capacity";
    public static final Diagnosis.Definition ACTION_INCREASE_NODE_CAPACITY = new Diagnosis.Definition("shards_availability", "increase_node_capacity_for_allocations", "Elasticsearch isn't allowed to allocate some shards from these indices because there are not enough nodes in the cluster to allocate each shard copy on a different node.", "Increase the number of nodes in the cluster or decrease the number of replica shards in the affected indices.", "https://ela.st/tier-capacity");
    public static final Map<String, Diagnosis.Definition> ACTION_INCREASE_TIER_CAPACITY_LOOKUP = DataTier.ALL_DATA_TIERS.stream().collect(Collectors.toUnmodifiableMap(tier -> tier, tier -> new Diagnosis.Definition(NAME, "increase_tier_capacity_for_allocations:tier:" + tier, "Elasticsearch isn't allowed to allocate some shards from these indices to any of the nodes in the desired data tier because there are not enough nodes in the [" + tier + "] tier to allocate each shard copy on a different node.", "Increase the number of nodes in this tier or decrease the number of replica shards in the affected indices.", TIER_CAPACITY_ACTION_GUIDE)));

    public ShardsAvailabilityHealthIndicatorService(ClusterService clusterService, AllocationService allocationService, SystemIndices systemIndices) {
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.systemIndices = systemIndices;
    }

    @Override
    public String name() {
        return NAME;
    }

    public ShardAllocationStatus createNewStatus(Metadata metadata) {
        return new ShardAllocationStatus(metadata);
    }

    @Override
    public HealthIndicatorResult calculate(boolean verbose, int maxAffectedResourcesCount, HealthInfo healthInfo) {
        ClusterState state = this.clusterService.state();
        NodesShutdownMetadata shutdown = state.getMetadata().custom("node_shutdown", NodesShutdownMetadata.EMPTY);
        ShardAllocationStatus status = this.createNewStatus(state.getMetadata());
        ShardsAvailabilityHealthIndicatorService.updateShardAllocationStatus(status, state, shutdown, verbose);
        return this.createIndicator(status.getStatus(), status.getSymptom(), status.getDetails(verbose), status.getImpacts(), status.getDiagnosis(verbose, maxAffectedResourcesCount));
    }

    static void updateShardAllocationStatus(ShardAllocationStatus status, ClusterState state, NodesShutdownMetadata shutdown, boolean verbose) {
        for (IndexRoutingTable indexShardRouting : state.routingTable()) {
            for (int i = 0; i < indexShardRouting.size(); ++i) {
                IndexShardRoutingTable shardRouting = indexShardRouting.shard(i);
                status.addPrimary(shardRouting.primaryShard(), state, shutdown, verbose);
                for (ShardRouting replicaShard : shardRouting.replicaShards()) {
                    status.addReplica(replicaShard, state, shutdown, verbose);
                }
            }
        }
        status.updateSearchableSnapshotsOfAvailableIndices();
    }

    boolean areAllShardsOfThisTypeUnavailable(ShardRouting routing, ClusterState state) {
        return StreamSupport.stream(state.routingTable().allActiveShardsGrouped(new String[]{routing.getIndexName()}, true).spliterator(), false).flatMap(shardIter -> shardIter.getShardRoutings().stream()).filter(sr -> sr.shardId().equals(routing.shardId())).filter(sr -> sr.primary() == routing.primary()).allMatch(ShardRouting::unassigned);
    }

    static boolean isNewlyCreatedAndInitializingReplica(ShardRouting routing, ClusterState state) {
        if (routing.active()) {
            return false;
        }
        if (routing.primary()) {
            return false;
        }
        ShardRouting primary = state.routingTable().shardRoutingTable(routing.shardId()).primaryShard();
        if (primary.active()) {
            return false;
        }
        return ClusterShardHealth.getInactivePrimaryHealth(primary) == ClusterHealthStatus.YELLOW;
    }

    private static boolean isUnassignedDueToTimelyRestart(ShardRouting routing, NodesShutdownMetadata shutdowns) {
        long restartingAllocationDelayExpiration;
        UnassignedInfo info = routing.unassignedInfo();
        if (info == null || info.reason() != UnassignedInfo.Reason.NODE_RESTARTING) {
            return false;
        }
        SingleNodeShutdownMetadata shutdown = shutdowns.get(info.lastAllocatedNodeId(), SingleNodeShutdownMetadata.Type.RESTART);
        if (shutdown == null) {
            return false;
        }
        long now = System.nanoTime();
        return now - (restartingAllocationDelayExpiration = info.unassignedTimeNanos() + shutdown.getAllocationDelay().nanos()) <= 0L;
    }

    private static boolean isUnassignedDueToNewInitialization(ShardRouting routing, ClusterState state) {
        if (routing.active()) {
            return false;
        }
        ShardRouting primary = routing.primary() ? routing : state.routingTable().shardRoutingTable(routing.shardId()).primaryShard();
        return !primary.active() && ClusterShardHealth.getInactivePrimaryHealth(primary) == ClusterHealthStatus.YELLOW;
    }

    List<Diagnosis.Definition> diagnoseUnassignedShardRouting(ShardRouting shardRouting, ClusterState state) {
        ArrayList<Diagnosis.Definition> diagnosisDefs = new ArrayList<Diagnosis.Definition>();
        LOGGER.trace("Diagnosing unassigned shard [{}] due to reason [{}]", (Object)shardRouting.shardId(), (Object)shardRouting.unassignedInfo());
        switch (shardRouting.unassignedInfo().lastAllocationStatus()) {
            case NO_VALID_SHARD_COPY: {
                diagnosisDefs.add(ACTION_RESTORE_FROM_SNAPSHOT);
                break;
            }
            case NO_ATTEMPT: {
                if (shardRouting.unassignedInfo().delayed()) {
                    diagnosisDefs.add(DIAGNOSIS_WAIT_FOR_OR_FIX_DELAYED_SHARDS);
                    break;
                }
                diagnosisDefs.addAll(this.explainAllocationsAndDiagnoseDeciders(shardRouting, state));
                break;
            }
            case DECIDERS_NO: {
                diagnosisDefs.addAll(this.explainAllocationsAndDiagnoseDeciders(shardRouting, state));
                break;
            }
            case DELAYED_ALLOCATION: {
                diagnosisDefs.add(DIAGNOSIS_WAIT_FOR_OR_FIX_DELAYED_SHARDS);
            }
        }
        if (diagnosisDefs.isEmpty()) {
            diagnosisDefs.add(ACTION_CHECK_ALLOCATION_EXPLAIN_API);
        }
        return diagnosisDefs;
    }

    private List<Diagnosis.Definition> explainAllocationsAndDiagnoseDeciders(ShardRouting shardRouting, ClusterState state) {
        LOGGER.trace("Executing allocation explain on shard [{}]", (Object)shardRouting.shardId());
        RoutingAllocation allocation = new RoutingAllocation(this.allocationService.getAllocationDeciders(), state, ClusterInfo.EMPTY, SnapshotShardSizeInfo.EMPTY, System.nanoTime());
        allocation.setDebugMode(RoutingAllocation.DebugMode.ON);
        ShardAllocationDecision shardAllocationDecision = this.allocationService.explainShardAllocation(shardRouting, allocation);
        AllocateUnassignedDecision allocateDecision = shardAllocationDecision.getAllocateDecision();
        if (LOGGER.isTraceEnabled()) {
            if (allocateDecision.isDecisionTaken()) {
                LOGGER.trace("[{}]: Allocation decision [{}]", (Object)shardRouting.shardId(), (Object)allocateDecision.getAllocationDecision());
            } else {
                LOGGER.trace("[{}]: Decision taken [false]", (Object)shardRouting.shardId());
            }
        }
        if (allocateDecision.isDecisionTaken() && AllocationDecision.NO == allocateDecision.getAllocationDecision()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("[{}]: Working with decisions: [{}]", (Object)shardRouting.shardId(), allocateDecision.getNodeDecisions().stream().map(n -> n.getCanAllocateDecision().getDecisions().stream().map(d -> d.label() + ": " + d.type()).collect(Collectors.toList())).collect(Collectors.toList()));
            }
            List<NodeAllocationResult> nodeAllocationResults = allocateDecision.getNodeDecisions();
            return this.diagnoseAllocationResults(shardRouting, state, nodeAllocationResults);
        }
        return List.of();
    }

    List<Diagnosis.Definition> diagnoseAllocationResults(ShardRouting shardRouting, ClusterState state, List<NodeAllocationResult> nodeAllocationResults) {
        IndexMetadata indexMetadata = state.metadata().index(shardRouting.index());
        ArrayList<Diagnosis.Definition> diagnosisDefs = new ArrayList<Diagnosis.Definition>();
        if (indexMetadata != null) {
            diagnosisDefs.addAll(this.checkIsAllocationDisabled(indexMetadata, nodeAllocationResults));
            diagnosisDefs.addAll(this.checkNodeRoleRelatedIssues(indexMetadata, nodeAllocationResults, state, shardRouting));
        }
        if (diagnosisDefs.isEmpty()) {
            diagnosisDefs.add(ACTION_CHECK_ALLOCATION_EXPLAIN_API);
        }
        return diagnosisDefs;
    }

    protected static Predicate<NodeAllocationResult> hasDeciderResult(String deciderName, Decision.Type outcome) {
        return nodeResult -> {
            Decision decision = nodeResult.getCanAllocateDecision();
            return decision != null && decision.getDecisions().stream().anyMatch(d -> deciderName.equals(d.label()) && outcome == d.type());
        };
    }

    List<Diagnosis.Definition> checkIsAllocationDisabled(IndexMetadata indexMetadata, List<NodeAllocationResult> nodeAllocationResults) {
        ArrayList<Diagnosis.Definition> diagnosisDefs = new ArrayList<Diagnosis.Definition>();
        if (nodeAllocationResults.stream().allMatch(ShardsAvailabilityHealthIndicatorService.hasDeciderResult("enable", Decision.Type.NO))) {
            Settings indexSettings = indexMetadata.getSettings();
            EnableAllocationDecider.Allocation indexLevelAllocation = EnableAllocationDecider.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING.get(indexSettings);
            ClusterSettings clusterSettings = this.clusterService.getClusterSettings();
            EnableAllocationDecider.Allocation clusterLevelAllocation = clusterSettings.get(EnableAllocationDecider.CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING);
            if (EnableAllocationDecider.Allocation.ALL != indexLevelAllocation) {
                diagnosisDefs.add(ACTION_ENABLE_INDEX_ROUTING_ALLOCATION);
            }
            if (EnableAllocationDecider.Allocation.ALL != clusterLevelAllocation) {
                diagnosisDefs.add(ACTION_ENABLE_CLUSTER_ROUTING_ALLOCATION);
            }
        }
        return diagnosisDefs;
    }

    protected List<Diagnosis.Definition> checkNodeRoleRelatedIssues(IndexMetadata indexMetadata, List<NodeAllocationResult> nodeAllocationResults, ClusterState clusterState, ShardRouting shardRouting) {
        ArrayList<Diagnosis.Definition> diagnosisDefs = new ArrayList<Diagnosis.Definition>();
        if (!indexMetadata.getTierPreference().isEmpty()) {
            List<NodeAllocationResult> dataTierAllocationResults = nodeAllocationResults.stream().filter(ShardsAvailabilityHealthIndicatorService.hasDeciderResult(DATA_TIER_ALLOCATION_DECIDER_NAME, Decision.Type.YES)).toList();
            if (dataTierAllocationResults.isEmpty()) {
                for (String tier : indexMetadata.getTierPreference()) {
                    Optional.ofNullable(this.getAddNodesWithRoleAction(tier)).ifPresent(diagnosisDefs::add);
                }
            } else {
                Set<DiscoveryNode> dataTierNodes = dataTierAllocationResults.stream().map(NodeAllocationResult::getNode).collect(Collectors.toSet());
                Set dataTierRolesAvailable = dataTierNodes.stream().map(DiscoveryNode::getRoles).flatMap(Collection::stream).map(DiscoveryNodeRole::roleName).collect(Collectors.toSet());
                String preferredTier = indexMetadata.getTierPreference().stream().filter(dataTierRolesAvailable::contains).findFirst().orElse(null);
                diagnosisDefs.addAll(this.checkNodesWithRoleAtShardLimit(indexMetadata, clusterState, dataTierAllocationResults, dataTierNodes, preferredTier));
                diagnosisDefs.addAll(ShardsAvailabilityHealthIndicatorService.checkDataTierShouldMigrate(indexMetadata, dataTierAllocationResults, preferredTier, dataTierNodes));
                this.checkNotEnoughNodesWithRole(dataTierAllocationResults, preferredTier).ifPresent(diagnosisDefs::add);
            }
        }
        return diagnosisDefs;
    }

    protected List<Diagnosis.Definition> checkNodesWithRoleAtShardLimit(IndexMetadata indexMetadata, ClusterState clusterState, List<NodeAllocationResult> nodeRoleAllocationResults, Set<DiscoveryNode> nodesWithRoles, @Nullable String role) {
        if (nodeRoleAllocationResults.stream().allMatch(ShardsAvailabilityHealthIndicatorService.hasDeciderResult("shards_limit", Decision.Type.NO))) {
            ArrayList<Diagnosis.Definition> diagnosisDefs = new ArrayList<Diagnosis.Definition>();
            List<RoutingNode> candidateNodes = clusterState.getRoutingNodes().stream().filter(routingNode -> nodesWithRoles.contains(routingNode.node())).toList();
            Integer clusterShardsPerNode = this.clusterService.getClusterSettings().get(ShardsLimitAllocationDecider.CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING);
            Integer indexShardsPerNode = ShardsLimitAllocationDecider.INDEX_TOTAL_SHARDS_PER_NODE_SETTING.get(indexMetadata.getSettings());
            assert (clusterShardsPerNode > 0 || indexShardsPerNode > 0) : "shards per node must exist if allocation decision is NO";
            boolean clusterShardsPerNodeShouldChange = false;
            if (clusterShardsPerNode > 0) {
                int minShardCount = candidateNodes.stream().map(RoutingNode::numberOfOwningShards).min(Integer::compareTo).orElse(-1);
                clusterShardsPerNodeShouldChange = minShardCount >= clusterShardsPerNode;
            }
            boolean indexShardsPerNodeShouldChange = false;
            if (indexShardsPerNode > 0) {
                int minShardCount = candidateNodes.stream().map(routingNode -> routingNode.numberOfOwningShardsForIndex(indexMetadata.getIndex())).min(Integer::compareTo).orElse(-1);
                boolean bl = indexShardsPerNodeShouldChange = minShardCount >= indexShardsPerNode;
            }
            if (role != null) {
                if (clusterShardsPerNodeShouldChange) {
                    Optional.ofNullable(this.getIncreaseShardLimitClusterSettingAction(role)).ifPresent(diagnosisDefs::add);
                }
                if (indexShardsPerNodeShouldChange) {
                    Optional.ofNullable(this.getIncreaseShardLimitIndexSettingAction(role)).ifPresent(diagnosisDefs::add);
                }
            } else {
                if (clusterShardsPerNodeShouldChange) {
                    diagnosisDefs.add(ACTION_INCREASE_SHARD_LIMIT_CLUSTER_SETTING);
                }
                if (indexShardsPerNodeShouldChange) {
                    diagnosisDefs.add(ACTION_INCREASE_SHARD_LIMIT_INDEX_SETTING);
                }
            }
            return diagnosisDefs;
        }
        return List.of();
    }

    private static List<Diagnosis.Definition> checkDataTierShouldMigrate(IndexMetadata indexMetadata, List<NodeAllocationResult> dataTierAllocationResults, @Nullable String preferredTier, Set<DiscoveryNode> dataTierNodes) {
        if (dataTierAllocationResults.stream().allMatch(ShardsAvailabilityHealthIndicatorService.hasDeciderResult("filter", Decision.Type.NO))) {
            DiscoveryNodeFilters includeFilter;
            ArrayList<Diagnosis.Definition> diagnosisDefs = new ArrayList<Diagnosis.Definition>();
            Map<String, List<String>> requireAttributes = IndexMetadata.INDEX_ROUTING_REQUIRE_GROUP_SETTING.getAsMap(indexMetadata.getSettings());
            List<String> requireDataAttributes = requireAttributes.get("data");
            DiscoveryNodeFilters requireFilter = requireDataAttributes == null ? null : DiscoveryNodeFilters.buildFromKeyValues(DiscoveryNodeFilters.OpType.AND, Map.of("data", requireDataAttributes));
            Map<String, List<String>> includeAttributes = IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING.getAsMap(indexMetadata.getSettings());
            List<String> includeDataAttributes = includeAttributes.get("data");
            DiscoveryNodeFilters discoveryNodeFilters = includeFilter = includeDataAttributes == null ? null : DiscoveryNodeFilters.buildFromKeyValues(DiscoveryNodeFilters.OpType.OR, Map.of("data", includeDataAttributes));
            if (requireFilter != null || includeFilter != null) {
                if (requireFilter != null) {
                    if (dataTierNodes.stream().noneMatch(requireFilter::match)) {
                        diagnosisDefs.add(Optional.ofNullable(preferredTier).map(ACTION_MIGRATE_TIERS_AWAY_FROM_REQUIRE_DATA_LOOKUP::get).orElse(ACTION_MIGRATE_TIERS_AWAY_FROM_REQUIRE_DATA));
                    }
                }
                if (includeFilter != null) {
                    if (dataTierNodes.stream().noneMatch(includeFilter::match)) {
                        diagnosisDefs.add(Optional.ofNullable(preferredTier).map(ACTION_MIGRATE_TIERS_AWAY_FROM_INCLUDE_DATA_LOOKUP::get).orElse(ACTION_MIGRATE_TIERS_AWAY_FROM_INCLUDE_DATA));
                    }
                }
            }
            return diagnosisDefs;
        }
        return List.of();
    }

    protected Optional<Diagnosis.Definition> checkNotEnoughNodesWithRole(List<NodeAllocationResult> nodeAllocationResults, @Nullable String role) {
        if (nodeAllocationResults.stream().allMatch(ShardsAvailabilityHealthIndicatorService.hasDeciderResult("same_shard", Decision.Type.NO))) {
            if (role != null) {
                return Optional.ofNullable(this.getIncreaseNodeWithRoleCapacityAction(role));
            }
            return Optional.of(ACTION_INCREASE_NODE_CAPACITY);
        }
        return Optional.empty();
    }

    @Nullable
    public Diagnosis.Definition getAddNodesWithRoleAction(String role) {
        return ACTION_ENABLE_TIERS_LOOKUP.get(role);
    }

    @Nullable
    public Diagnosis.Definition getIncreaseShardLimitIndexSettingAction(String role) {
        return ACTION_INCREASE_SHARD_LIMIT_INDEX_SETTING_LOOKUP.get(role);
    }

    @Nullable
    public Diagnosis.Definition getIncreaseShardLimitClusterSettingAction(String role) {
        return ACTION_INCREASE_SHARD_LIMIT_CLUSTER_SETTING_LOOKUP.get(role);
    }

    @Nullable
    public Diagnosis.Definition getIncreaseNodeWithRoleCapacityAction(String role) {
        return ACTION_INCREASE_TIER_CAPACITY_LOOKUP.get(role);
    }

    public class ShardAllocationStatus {
        protected final ShardAllocationCounts primaries;
        protected final ShardAllocationCounts replicas;
        protected final Metadata clusterMetadata;

        public ShardAllocationStatus(Metadata clusterMetadata) {
            this.primaries = new ShardAllocationCounts();
            this.replicas = new ShardAllocationCounts();
            this.clusterMetadata = clusterMetadata;
        }

        void addPrimary(ShardRouting routing, ClusterState state, NodesShutdownMetadata shutdowns, boolean verbose) {
            this.primaries.increment(routing, state, shutdowns, verbose);
        }

        void addReplica(ShardRouting routing, ClusterState state, NodesShutdownMetadata shutdowns, boolean verbose) {
            this.replicas.increment(routing, state, shutdowns, verbose);
        }

        void updateSearchableSnapshotsOfAvailableIndices() {
            this.primaries.searchableSnapshotsState.updateSearchableSnapshotWithAvailableIndices(this.clusterMetadata, this.primaries.indicesWithUnavailableShards);
        }

        public HealthStatus getStatus() {
            if (!this.primaries.areAllAvailable() || !this.primaries.searchableSnapshotsState.getRedSearchableSnapshots().isEmpty()) {
                return HealthStatus.RED;
            }
            if (!this.replicas.areAllAvailable()) {
                return HealthStatus.YELLOW;
            }
            return HealthStatus.GREEN;
        }

        public String getSymptom() {
            StringBuilder builder = new StringBuilder("This cluster has ");
            if (this.primaries.unassigned > 0 || this.primaries.unassigned_new > 0 || this.primaries.unassigned_restarting > 0 || this.replicas.unassigned > 0 || this.replicas.unassigned_new > 0 || this.replicas.unassigned_restarting > 0 || this.primaries.initializing > 0 || this.replicas.initializing > 0) {
                builder.append(Stream.of(ShardAllocationStatus.createMessage(this.primaries.unassigned, "unavailable primary shard", "unavailable primary shards"), ShardAllocationStatus.createMessage(this.primaries.unassigned_new, "creating primary shard", "creating primary shards"), ShardAllocationStatus.createMessage(this.replicas.unassigned_new, "creating replica shard", "creating replica shards"), ShardAllocationStatus.createMessage(this.primaries.unassigned_restarting, "restarting primary shard", "restarting primary shards"), ShardAllocationStatus.createMessage(this.replicas.unassigned, "unavailable replica shard", "unavailable replica shards"), ShardAllocationStatus.createMessage(this.primaries.initializing, "initializing primary shard", "initializing primary shards"), ShardAllocationStatus.createMessage(this.replicas.initializing, "initializing replica shard", "initializing replica shards"), ShardAllocationStatus.createMessage(this.replicas.unassigned_restarting, "restarting replica shard", "restarting replica shards")).flatMap(Function.identity()).collect(Collectors.joining(", "))).append(".");
            } else {
                builder.append("all shards available.");
            }
            if (this.primaries.areAllAvailable() && !this.primaries.searchableSnapshotsState.searchableSnapshotWithOriginalIndexAvailable.isEmpty()) {
                if (this.primaries.unassigned == 1) {
                    builder.append(" This is a mounted shard and the original shard is available, so there are no data availability problems.");
                } else {
                    builder.append(" These are mounted shards and the original shards are available, so there are no data availability problems.");
                }
            }
            return builder.toString();
        }

        private static Stream<String> createMessage(int count, String singular, String plural) {
            return switch (count) {
                case 0 -> Stream.empty();
                case 1 -> Stream.of("1 " + singular);
                default -> Stream.of(count + " " + plural);
            };
        }

        public HealthIndicatorDetails getDetails(boolean verbose) {
            if (!verbose) {
                return HealthIndicatorDetails.EMPTY;
            }
            return new SimpleHealthIndicatorDetails(Map.of("unassigned_primaries", this.primaries.unassigned, "initializing_primaries", this.primaries.initializing, "creating_primaries", this.primaries.unassigned_new, "restarting_primaries", this.primaries.unassigned_restarting, "started_primaries", this.primaries.started + this.primaries.relocating, "unassigned_replicas", this.replicas.unassigned, "initializing_replicas", this.replicas.initializing, "creating_replicas", this.replicas.unassigned_new, "restarting_replicas", this.replicas.unassigned_restarting, "started_replicas", this.replicas.started + this.replicas.relocating));
        }

        public List<HealthIndicatorImpact> getImpacts() {
            Set<String> readOnlyIndicesWithUnavailableShards;
            ArrayList<HealthIndicatorImpact> impacts = new ArrayList<HealthIndicatorImpact>();
            if (!this.primaries.indicesWithUnavailableShards.isEmpty()) {
                String impactDescription = String.format(Locale.ROOT, "Cannot add data to %d %s [%s]. Searches might return incomplete results.", this.primaries.indicesWithUnavailableShards.size(), this.primaries.indicesWithUnavailableShards.size() == 1 ? "index" : "indices", HealthIndicatorDisplayValues.getTruncatedIndices(this.primaries.indicesWithUnavailableShards, this.clusterMetadata));
                impacts.add(new HealthIndicatorImpact(ShardsAvailabilityHealthIndicatorService.NAME, ShardsAvailabilityHealthIndicatorService.PRIMARY_UNASSIGNED_IMPACT_ID, 1, impactDescription, List.of(ImpactArea.INGEST, ImpactArea.SEARCH)));
            }
            if (!(readOnlyIndicesWithUnavailableShards = this.primaries.searchableSnapshotsState.getRedSearchableSnapshots()).isEmpty()) {
                String impactDescription = String.format(Locale.ROOT, "Searching %d %s [%s] might return incomplete results.", readOnlyIndicesWithUnavailableShards.size(), readOnlyIndicesWithUnavailableShards.size() == 1 ? "index" : "indices", HealthIndicatorDisplayValues.getTruncatedIndices(readOnlyIndicesWithUnavailableShards, this.clusterMetadata));
                impacts.add(new HealthIndicatorImpact(ShardsAvailabilityHealthIndicatorService.NAME, ShardsAvailabilityHealthIndicatorService.READ_ONLY_PRIMARY_UNASSIGNED_IMPACT_ID, 1, impactDescription, List.of(ImpactArea.SEARCH)));
            }
            HashSet<String> indicesWithUnavailableReplicasOnly = new HashSet<String>(this.replicas.indicesWithUnavailableShards);
            indicesWithUnavailableReplicasOnly.removeAll(this.primaries.indicesWithUnavailableShards);
            if (!indicesWithUnavailableReplicasOnly.isEmpty()) {
                String impactDescription = String.format(Locale.ROOT, "Searches might be slower than usual. Fewer redundant copies of the data exist on %d %s [%s].", indicesWithUnavailableReplicasOnly.size(), indicesWithUnavailableReplicasOnly.size() == 1 ? "index" : "indices", HealthIndicatorDisplayValues.getTruncatedIndices(indicesWithUnavailableReplicasOnly, this.clusterMetadata));
                impacts.add(new HealthIndicatorImpact(ShardsAvailabilityHealthIndicatorService.NAME, ShardsAvailabilityHealthIndicatorService.REPLICA_UNASSIGNED_IMPACT_ID, 2, impactDescription, List.of(ImpactArea.SEARCH)));
            }
            return impacts;
        }

        public List<Diagnosis> getDiagnosis(boolean verbose, int maxAffectedResourcesCount) {
            if (verbose) {
                HashMap<Diagnosis.Definition, Set<String>> diagnosisToAffectedIndices = new HashMap<Diagnosis.Definition, Set<String>>(this.primaries.diagnosisDefinitions);
                this.replicas.diagnosisDefinitions.forEach((diagnosisDef, indicesWithReplicasUnassigned) -> {
                    Set indicesWithPrimariesUnassigned = (Set)diagnosisToAffectedIndices.get(diagnosisDef);
                    if (indicesWithPrimariesUnassigned == null) {
                        diagnosisToAffectedIndices.put((Diagnosis.Definition)diagnosisDef, (Set<String>)indicesWithReplicasUnassigned);
                    } else {
                        indicesWithPrimariesUnassigned.addAll(indicesWithReplicasUnassigned);
                    }
                });
                if (diagnosisToAffectedIndices.isEmpty()) {
                    return List.of();
                }
                return diagnosisToAffectedIndices.entrySet().stream().map(e -> {
                    List<Diagnosis.Resource> affectedResources = new ArrayList<Diagnosis.Resource>(1);
                    if (((Diagnosis.Definition)e.getKey()).equals(ACTION_RESTORE_FROM_SNAPSHOT)) {
                        Set restoreFromSnapshotIndices = (Set)e.getValue();
                        if (restoreFromSnapshotIndices != null && !restoreFromSnapshotIndices.isEmpty()) {
                            affectedResources = ShardAllocationStatus.getRestoreFromSnapshotAffectedResources(this.clusterMetadata, ShardsAvailabilityHealthIndicatorService.this.systemIndices, restoreFromSnapshotIndices, maxAffectedResourcesCount);
                        }
                    } else {
                        affectedResources.add(new Diagnosis.Resource(Diagnosis.Resource.Type.INDEX, ((Set)e.getValue()).stream().sorted(HealthIndicatorDisplayValues.indicesComparatorByPriorityAndName(this.clusterMetadata)).limit(Math.min(((Set)e.getValue()).size(), maxAffectedResourcesCount)).collect(Collectors.toList())));
                    }
                    return new Diagnosis((Diagnosis.Definition)e.getKey(), affectedResources);
                }).collect(Collectors.toList());
            }
            return List.of();
        }

        static List<Diagnosis.Resource> getRestoreFromSnapshotAffectedResources(Metadata metadata, SystemIndices systemIndices, Set<String> restoreFromSnapshotIndices, int maxAffectedResourcesCount) {
            ArrayList<Diagnosis.Resource> affectedResources = new ArrayList<Diagnosis.Resource>(2);
            HashSet<String> affectedIndices = new HashSet<String>(restoreFromSnapshotIndices);
            HashSet<String> affectedFeatureStates = new HashSet<String>();
            Map<String, Set> featureToSystemIndices = systemIndices.getFeatures().stream().collect(Collectors.toMap(SystemIndices.Feature::getName, feature -> feature.getIndexDescriptors().stream().flatMap(descriptor -> descriptor.getMatchingIndices(metadata).stream()).collect(Collectors.toSet())));
            for (Map.Entry<String, Set> featureToIndices : featureToSystemIndices.entrySet()) {
                for (String featureIndex : featureToIndices.getValue()) {
                    if (!restoreFromSnapshotIndices.contains(featureIndex)) continue;
                    affectedFeatureStates.add(featureToIndices.getKey());
                    affectedIndices.remove(featureIndex);
                }
            }
            Map<String, Set> featureToDsBackingIndices = systemIndices.getFeatures().stream().collect(Collectors.toMap(SystemIndices.Feature::getName, feature -> feature.getDataStreamDescriptors().stream().flatMap(descriptor -> descriptor.getBackingIndexNames(metadata).stream()).collect(Collectors.toSet())));
            for (Map.Entry<String, Set> featureToBackingIndices : featureToDsBackingIndices.entrySet()) {
                for (String featureIndex : featureToBackingIndices.getValue()) {
                    if (!restoreFromSnapshotIndices.contains(featureIndex)) continue;
                    affectedFeatureStates.add(featureToBackingIndices.getKey());
                    affectedIndices.remove(featureIndex);
                }
            }
            if (!affectedIndices.isEmpty()) {
                affectedResources.add(new Diagnosis.Resource(Diagnosis.Resource.Type.INDEX, affectedIndices.stream().limit(maxAffectedResourcesCount).toList()));
            }
            if (!affectedFeatureStates.isEmpty()) {
                affectedResources.add(new Diagnosis.Resource(Diagnosis.Resource.Type.FEATURE_STATE, affectedFeatureStates.stream().limit(maxAffectedResourcesCount).toList()));
            }
            return affectedResources;
        }
    }

    public static class SearchableSnapshotsState {
        private final Set<String> searchableSnapshotWithUnavailableShard = new HashSet<String>();
        private final Set<String> searchableSnapshotWithOriginalIndexAvailable = new HashSet<String>();

        void addSearchableSnapshotWithUnavailableShard(String indexName) {
            this.searchableSnapshotWithUnavailableShard.add(indexName);
        }

        void addSearchableSnapshotWithOriginalIndexAvailable(String indexName) {
            this.searchableSnapshotWithOriginalIndexAvailable.add(indexName);
        }

        public Set<String> getRedSearchableSnapshots() {
            return Sets.difference(this.searchableSnapshotWithUnavailableShard, this.searchableSnapshotWithOriginalIndexAvailable);
        }

        void updateSearchableSnapshotWithAvailableIndices(Metadata clusterMetadata, Set<String> indicesWithUnavailableShards) {
            for (String index : this.searchableSnapshotWithUnavailableShard) {
                assert (clusterMetadata.index(index) != null) : "Index metadata of index '" + index + "' should not be null";
                Settings indexSettings = clusterMetadata.index(index).getSettings();
                String originalIndex = indexSettings.get("index.store.snapshot.index_name");
                if (originalIndex == null || !clusterMetadata.indices().containsKey(originalIndex) || indicesWithUnavailableShards.contains(originalIndex)) continue;
                this.addSearchableSnapshotWithOriginalIndexAvailable(index);
            }
        }
    }

    public class ShardAllocationCounts {
        int unassigned = 0;
        int unassigned_new = 0;
        int unassigned_restarting = 0;
        int initializing = 0;
        int started = 0;
        int relocating = 0;
        public final Set<String> indicesWithUnavailableShards = new HashSet<String>();
        public final Set<String> indicesWithAllShardsUnavailable = new HashSet<String>();
        public SearchableSnapshotsState searchableSnapshotsState = new SearchableSnapshotsState();
        final Map<Diagnosis.Definition, Set<String>> diagnosisDefinitions = new HashMap<Diagnosis.Definition, Set<String>>();

        public void increment(ShardRouting routing, ClusterState state, NodesShutdownMetadata shutdowns, boolean verbose) {
            boolean allUnavailable;
            boolean isNew = ShardsAvailabilityHealthIndicatorService.isUnassignedDueToNewInitialization(routing, state);
            boolean isRestarting = ShardsAvailabilityHealthIndicatorService.isUnassignedDueToTimelyRestart(routing, shutdowns);
            boolean bl = allUnavailable = ShardsAvailabilityHealthIndicatorService.this.areAllShardsOfThisTypeUnavailable(routing, state) && !ShardsAvailabilityHealthIndicatorService.isNewlyCreatedAndInitializingReplica(routing, state);
            if (allUnavailable) {
                this.indicesWithAllShardsUnavailable.add(routing.getIndexName());
            }
            if (!(routing.active() || isRestarting || isNew)) {
                String indexName = routing.getIndexName();
                Settings indexSettings = state.getMetadata().index(indexName).getSettings();
                if (SearchableSnapshotsSettings.isSearchableSnapshotStore(indexSettings)) {
                    this.searchableSnapshotsState.addSearchableSnapshotWithUnavailableShard(indexName);
                } else {
                    this.indicesWithUnavailableShards.add(indexName);
                }
            }
            switch (routing.state()) {
                case UNASSIGNED: {
                    if (isNew) {
                        ++this.unassigned_new;
                        break;
                    }
                    if (isRestarting) {
                        ++this.unassigned_restarting;
                        break;
                    }
                    ++this.unassigned;
                    if (!verbose) break;
                    ShardsAvailabilityHealthIndicatorService.this.diagnoseUnassignedShardRouting(routing, state).forEach(definition -> this.addDefinition((Diagnosis.Definition)definition, routing.getIndexName()));
                    break;
                }
                case INITIALIZING: {
                    ++this.initializing;
                    if (!verbose) break;
                    this.addDefinition(DIAGNOSIS_WAIT_FOR_INITIALIZATION, routing.getIndexName());
                    break;
                }
                case STARTED: {
                    ++this.started;
                    break;
                }
                case RELOCATING: {
                    ++this.relocating;
                }
            }
        }

        public boolean areAllAvailable() {
            return this.indicesWithUnavailableShards.isEmpty();
        }

        public boolean doAnyIndicesHaveAllUnavailable() {
            return !this.indicesWithAllShardsUnavailable.isEmpty();
        }

        private void addDefinition(Diagnosis.Definition diagnosisDefinition, String indexName) {
            this.diagnosisDefinitions.computeIfAbsent(diagnosisDefinition, k -> new HashSet()).add(indexName);
        }
    }
}

