/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;

public class ShardChangesObserver
implements RoutingChangesObserver {
    private static final Logger logger = LogManager.getLogger(ShardChangesObserver.class);

    @Override
    public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
        logger.debug("{} started on node [{}]", (Object)ShardChangesObserver.shardIdentifier(startedShard), (Object)startedShard.currentNodeId());
    }

    @Override
    public void relocationStarted(ShardRouting startedShard, ShardRouting targetRelocatingShard, String reason) {
        logger.debug("{} is relocating ({}) from [{}] to [{}]", (Object)ShardChangesObserver.shardIdentifier(startedShard), (Object)reason, (Object)startedShard.currentNodeId(), (Object)targetRelocatingShard.currentNodeId());
    }

    @Override
    public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
        logger.debug("{} has failed on [{}]: {}", (Object)ShardChangesObserver.shardIdentifier(failedShard), (Object)failedShard.currentNodeId(), (Object)unassignedInfo.reason());
    }

    @Override
    public void replicaPromoted(ShardRouting replicaShard) {
        logger.debug("{} is promoted to primary on [{}]", (Object)ShardChangesObserver.shardIdentifier(replicaShard), (Object)replicaShard.currentNodeId());
    }

    private static String shardIdentifier(ShardRouting shardRouting) {
        return shardRouting.shardId().toString() + "[" + (shardRouting.primary() ? (char)'P' : 'R') + "]";
    }
}

