/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AbstractAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;

public final class MoveDecision
extends AbstractAllocationDecision {
    public static final MoveDecision NOT_TAKEN = new MoveDecision(null, null, AllocationDecision.NO_ATTEMPT, null, null, 0);
    private static final MoveDecision CACHED_STAY_DECISION = new MoveDecision(null, null, AllocationDecision.NO_ATTEMPT, Decision.YES, null, 0);
    private static final MoveDecision CACHED_CANNOT_MOVE_DECISION = new MoveDecision(null, null, AllocationDecision.NO, Decision.NO, null, 0);
    @Nullable
    private final AllocationDecision canMoveDecision;
    @Nullable
    private final Decision canRemainDecision;
    @Nullable
    private final Decision clusterRebalanceDecision;
    private final int currentNodeRanking;

    private MoveDecision(DiscoveryNode targetNode, List<NodeAllocationResult> nodeDecisions, AllocationDecision canMoveDecision, Decision canRemainDecision, Decision clusterRebalanceDecision, int currentNodeRanking) {
        super(targetNode, nodeDecisions);
        this.canMoveDecision = canMoveDecision;
        this.canRemainDecision = canRemainDecision;
        this.clusterRebalanceDecision = clusterRebalanceDecision;
        this.currentNodeRanking = currentNodeRanking;
    }

    public MoveDecision(StreamInput in) throws IOException {
        super(in);
        this.canMoveDecision = in.readOptionalWriteable(AllocationDecision::readFrom);
        this.canRemainDecision = in.readOptionalWriteable(Decision::readFrom);
        this.clusterRebalanceDecision = in.readOptionalWriteable(Decision::readFrom);
        this.currentNodeRanking = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.canMoveDecision);
        out.writeOptionalWriteable(this.canRemainDecision);
        out.writeOptionalWriteable(this.clusterRebalanceDecision);
        out.writeVInt(this.currentNodeRanking);
    }

    public static MoveDecision remain(Decision canRemainDecision) {
        if (canRemainDecision == Decision.YES) {
            return CACHED_STAY_DECISION;
        }
        assert (canRemainDecision.type() != Decision.Type.NO);
        return new MoveDecision(null, null, AllocationDecision.NO_ATTEMPT, canRemainDecision, null, 0);
    }

    public static MoveDecision move(Decision canRemainDecision, AllocationDecision moveDecision, @Nullable DiscoveryNode targetNode, @Nullable List<NodeAllocationResult> nodeDecisions) {
        assert (canRemainDecision != null);
        assert (canRemainDecision.type() != Decision.Type.YES) : "create decision with MoveDecision#stay instead";
        if (nodeDecisions == null && moveDecision == AllocationDecision.NO) {
            return CACHED_CANNOT_MOVE_DECISION;
        }
        assert (targetNode == null == (moveDecision != AllocationDecision.YES));
        return new MoveDecision(targetNode, nodeDecisions, moveDecision, canRemainDecision, null, 0);
    }

    public static MoveDecision rebalance(Decision canRemainDecision, Decision canRebalanceDecision, AllocationDecision canMoveDecision, @Nullable DiscoveryNode targetNode, int currentNodeRanking, List<NodeAllocationResult> nodeDecisions) {
        return new MoveDecision(targetNode, nodeDecisions, canMoveDecision, canRemainDecision, canRebalanceDecision, currentNodeRanking);
    }

    @Override
    public boolean isDecisionTaken() {
        return this.canRemainDecision != null || this.clusterRebalanceDecision != null;
    }

    public boolean forceMove() {
        this.checkDecisionState();
        return !this.canRemain() && this.canMoveDecision == AllocationDecision.YES;
    }

    public boolean canRemain() {
        this.checkDecisionState();
        return this.canRemainDecision.type() == Decision.Type.YES;
    }

    public Decision getCanRemainDecision() {
        this.checkDecisionState();
        return this.canRemainDecision;
    }

    public boolean canRebalanceCluster() {
        this.checkDecisionState();
        return this.clusterRebalanceDecision != null && this.clusterRebalanceDecision.type() == Decision.Type.YES;
    }

    @Nullable
    public Decision getClusterRebalanceDecision() {
        this.checkDecisionState();
        return this.clusterRebalanceDecision;
    }

    @Nullable
    public AllocationDecision getAllocationDecision() {
        return this.canMoveDecision;
    }

    public int getCurrentNodeRanking() {
        this.checkDecisionState();
        return this.currentNodeRanking;
    }

    @Override
    public String getExplanation() {
        this.checkDecisionState();
        if (this.clusterRebalanceDecision != null) {
            if (this.canMoveDecision == AllocationDecision.AWAITING_INFO) {
                return "Elasticsearch is currently retrieving information about this shard from one or more nodes. It will make a rebalancing decision after it receives this information. Please wait.";
            }
            return switch (this.clusterRebalanceDecision.type()) {
                default -> throw new IncompatibleClassChangeError();
                case Decision.Type.NO -> {
                    if (this.atLeastOneNodeWithYesDecision()) {
                        yield "Elasticsearch is allowed to allocate this shard on another node, and there is at least one node to which it could move this shard that would improve the overall cluster balance, but it isn't allowed to rebalance this shard there. If you expect this shard to be rebalanced to another node, check the cluster-wide rebalancing decisions and address any reasons preventing Elasticsearch from rebalancing shards within the cluster, and then find the expected node in the node-by-node explanation and address the reasons which prevent Elasticsearch from moving this shard there.";
                    }
                    yield "Elasticsearch is not allowed to allocate or rebalance this shard to another node. If you expect this shard to be rebalanced to another node, find this node in the node-by-node explanation and address the reasons which prevent Elasticsearch from rebalancing this shard there.";
                }
                case Decision.Type.THROTTLE -> "Elasticsearch is currently busy with other activities. It will rebalance this shard when those activities finish. Please wait.";
                case Decision.Type.YES -> {
                    if (this.getTargetNode() != null) {
                        if (this.canMoveDecision == AllocationDecision.THROTTLED) {
                            yield "Elasticsearch is attempting to rebalance this shard to another node, but the nodes involved are currently busy with other activities. The shard will be rebalanced when those activities finish. Please wait.";
                        }
                        yield "Elasticsearch can rebalance this shard to another node.";
                    }
                    yield "This shard is in a well-balanced location and satisfies all allocation rules so it will remain on this node. Elasticsearch cannot improve the cluster balance by moving it to another node. If you expect this shard to be rebalanced to another node, find the other node in the node-by-node explanation and address the reasons which prevent Elasticsearch from rebalancing this shard there.";
                }
            };
        }
        assert (!this.canRemain());
        return switch (this.canMoveDecision) {
            default -> throw new IncompatibleClassChangeError();
            case AllocationDecision.YES -> "This shard may not remain on its current node. Elasticsearch will move it to another node.";
            case AllocationDecision.THROTTLED -> "This shard may not remain on its current node. Elasticsearch is currently busy with other activities and will move this shard to another node when those activities finish. Please wait.";
            case AllocationDecision.NO -> "This shard may not remain on its current node, but Elasticsearch isn't allowed to move it to another node. Choose a node to which you expect this shard to be allocated, find this node in the node-by-node explanation, and address the reasons which prevent Elasticsearch from allocating this shard there.";
            case AllocationDecision.WORSE_BALANCE, AllocationDecision.AWAITING_INFO, AllocationDecision.ALLOCATION_DELAYED, AllocationDecision.NO_VALID_SHARD_COPY, AllocationDecision.NO_ATTEMPT -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError(this.canMoveDecision);
                }
                yield this.canMoveDecision.toString();
            }
        };
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        this.checkDecisionState();
        return Iterators.concat(Iterators.single((builder, p) -> {
            if (this.targetNode != null) {
                builder.startObject("target_node");
                MoveDecision.discoveryNodeToXContent(this.targetNode, true, builder);
                builder.endObject();
            }
            builder.field("can_remain_on_current_node", this.canRemain() ? "yes" : "no");
            if (!this.canRemain() && !this.canRemainDecision.getDecisions().isEmpty()) {
                builder.startArray("can_remain_decisions");
                this.canRemainDecision.toXContent(builder, params);
                builder.endArray();
            }
            if (this.clusterRebalanceDecision != null) {
                AllocationDecision rebalanceDecision = AllocationDecision.fromDecisionType(this.clusterRebalanceDecision.type());
                builder.field("can_rebalance_cluster", (Enum)rebalanceDecision);
                if (rebalanceDecision != AllocationDecision.YES && !this.clusterRebalanceDecision.getDecisions().isEmpty()) {
                    builder.startArray("can_rebalance_cluster_decisions");
                    this.clusterRebalanceDecision.toXContent(builder, params);
                    builder.endArray();
                }
            }
            if (this.clusterRebalanceDecision != null) {
                builder.field("can_rebalance_to_other_node", (Enum)this.canMoveDecision);
                builder.field("rebalance_explanation", this.getExplanation());
            } else {
                builder.field("can_move_to_other_node", this.forceMove() ? "yes" : "no");
                builder.field("move_explanation", this.getExplanation());
            }
            return builder;
        }), MoveDecision.nodeDecisionsToXContentChunked(this.nodeDecisions));
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof MoveDecision)) {
            return false;
        }
        MoveDecision that = (MoveDecision)other;
        return Objects.equals(this.canMoveDecision, that.canMoveDecision) && Objects.equals(this.canRemainDecision, that.canRemainDecision) && Objects.equals(this.clusterRebalanceDecision, that.clusterRebalanceDecision) && this.currentNodeRanking == that.currentNodeRanking;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.canMoveDecision, this.canRemainDecision, this.clusterRebalanceDecision, this.currentNodeRanking);
    }
}

