/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.indices.FailureIndexNotSupportedException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.SystemIndices;

public class IndexNameExpressionResolver {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(IndexNameExpressionResolver.class);
    public static final String EXCLUDED_DATA_STREAMS_KEY = "es.excluded_ds";
    public static final IndexVersion SYSTEM_INDEX_ENFORCEMENT_INDEX_VERSION = IndexVersions.V_8_0_0;
    private final ThreadContext threadContext;
    private final SystemIndices systemIndices;

    public IndexNameExpressionResolver(ThreadContext threadContext, SystemIndices systemIndices) {
        this.threadContext = Objects.requireNonNull(threadContext, "Thread Context must not be null");
        this.systemIndices = Objects.requireNonNull(systemIndices, "System Indices must not be null");
    }

    public String[] concreteIndexNames(ClusterState state, IndicesRequest request) {
        Context context = new Context(state, request.indicesOptions(), false, false, request.includeDataStreams(), this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndexNames(context, request.indices());
    }

    public String[] concreteIndexNamesWithSystemIndexAccess(ClusterState state, IndicesRequest request) {
        Context context = new Context(state, request.indicesOptions(), false, false, request.includeDataStreams(), SystemIndices.SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY, Predicates.always(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndexNames(context, request.indices());
    }

    public Index[] concreteIndices(ClusterState state, IndicesRequest request) {
        Context context = new Context(state, request.indicesOptions(), false, false, request.includeDataStreams(), this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndices(context, request.indices());
    }

    public String[] concreteIndexNames(ClusterState state, IndicesOptions options, String ... indexExpressions) {
        Context context = new Context(state, options, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndexNames(context, indexExpressions);
    }

    public String[] concreteIndexNames(ClusterState state, IndicesOptions options, boolean includeDataStreams, String ... indexExpressions) {
        Context context = new Context(state, options, false, false, includeDataStreams, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndexNames(context, indexExpressions);
    }

    public String[] concreteIndexNames(ClusterState state, IndicesOptions options, IndicesRequest request) {
        Context context = new Context(state, options, false, false, request.includeDataStreams(), this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndexNames(context, request.indices());
    }

    public List<String> dataStreamNames(ClusterState state, IndicesOptions options, String ... indexExpressions) {
        Context context = new Context(state, options, false, false, true, true, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        Collection<String> expressions = IndexNameExpressionResolver.resolveExpressions(context, indexExpressions);
        return expressions.stream().map(x -> (IndexAbstraction)state.metadata().getIndicesLookup().get(x)).filter(Objects::nonNull).filter(ia -> ia.getType() == IndexAbstraction.Type.DATA_STREAM).map(IndexAbstraction::getName).toList();
    }

    public IndexAbstraction resolveWriteIndexAbstraction(ClusterState state, DocWriteRequest<?> request) {
        boolean includeDataStreams = request.opType() == DocWriteRequest.OpType.CREATE && request.includeDataStreams();
        Context context = new Context(state, request.indicesOptions(), false, false, includeDataStreams, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        Collection<String> expressions = IndexNameExpressionResolver.resolveExpressions(context, request.index());
        if (expressions.size() == 1) {
            Index writeIndex;
            IndexAbstraction ia = (IndexAbstraction)state.metadata().getIndicesLookup().get(expressions.iterator().next());
            if (ia.getType() == IndexAbstraction.Type.ALIAS && (writeIndex = ia.getWriteIndex()) == null) {
                throw new IllegalArgumentException("no write index is defined for alias [" + ia.getName() + "]. The write index may be explicitly disabled using is_write_index=false or the alias points to multiple indices without one being designated as a write index");
            }
            this.checkSystemIndexAccess(context, Set.of(ia.getWriteIndex()));
            return ia;
        }
        throw new IllegalArgumentException("unable to return a single target as the provided expression and options got resolved to multiple targets");
    }

    protected static Collection<String> resolveExpressions(Context context, String ... expressions) {
        if (!context.getOptions().expandWildcardExpressions()) {
            if (expressions == null || expressions.length == 0 || expressions.length == 1 && "_all".equals(expressions[0])) {
                return List.of();
            }
            return ExplicitResourceNameFilter.filterUnavailable(context, DateMathExpressionResolver.resolve(context, List.of(expressions)));
        }
        if (expressions == null || expressions.length == 0 || expressions.length == 1 && ("_all".equals(expressions[0]) || Regex.isMatchAllPattern(expressions[0]))) {
            return WildcardExpressionResolver.resolveAll(context);
        }
        return WildcardExpressionResolver.resolve(context, ExplicitResourceNameFilter.filterUnavailable(context, DateMathExpressionResolver.resolve(context, List.of(expressions))));
    }

    public Index[] concreteIndices(ClusterState state, IndicesOptions options, String ... indexExpressions) {
        return this.concreteIndices(state, options, false, indexExpressions);
    }

    public Index[] concreteIndices(ClusterState state, IndicesOptions options, boolean includeDataStreams, String ... indexExpressions) {
        Context context = new Context(state, options, false, false, includeDataStreams, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndices(context, indexExpressions);
    }

    public Index[] concreteIndices(ClusterState state, IndicesRequest request, long startTime) {
        Context context = new Context(state, request.indicesOptions(), startTime, false, false, request.includeDataStreams(), false, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndices(context, request.indices());
    }

    String[] concreteIndexNames(Context context, String ... indexExpressions) {
        Index[] indexes = this.concreteIndices(context, indexExpressions);
        String[] names = new String[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            names[i] = indexes[i].getName();
        }
        return names;
    }

    Index[] concreteIndices(Context context, String ... indexExpressions) {
        Collection<String> expressions = IndexNameExpressionResolver.resolveExpressions(context, indexExpressions);
        LinkedHashSet<Index> concreteIndicesResult = Sets.newLinkedHashSetWithExpectedSize(expressions.size());
        SortedMap<String, IndexAbstraction> indicesLookup = context.getState().metadata().getIndicesLookup();
        for (String expression : expressions) {
            IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(expression);
            assert (indexAbstraction != null);
            if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS && context.isResolveToWriteIndex()) {
                Index writeIndex = indexAbstraction.getWriteIndex();
                if (writeIndex == null) {
                    throw new IllegalArgumentException("no write index is defined for alias [" + indexAbstraction.getName() + "]. The write index may be explicitly disabled using is_write_index=false or the alias points to multiple indices without one being designated as a write index");
                }
                if (indexAbstraction.isDataStreamRelated()) {
                    DataStream dataStream = ((IndexAbstraction)indicesLookup.get(indexAbstraction.getWriteIndex().getName())).getParentDataStream();
                    IndexNameExpressionResolver.resolveWriteIndexForDataStreams(context, dataStream, concreteIndicesResult);
                    continue;
                }
                if (!IndexNameExpressionResolver.addIndex(writeIndex, null, context)) continue;
                concreteIndicesResult.add(writeIndex);
                continue;
            }
            if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM && context.isResolveToWriteIndex()) {
                IndexNameExpressionResolver.resolveWriteIndexForDataStreams(context, (DataStream)indexAbstraction, concreteIndicesResult);
                continue;
            }
            if (IndexNameExpressionResolver.resolvesToMoreThanOneIndex(indexAbstraction, context) && !context.getOptions().allowAliasesToMultipleIndices()) {
                Object[] indexNames = new String[indexAbstraction.getIndices().size()];
                int i = 0;
                for (Index indexName : indexAbstraction.getIndices()) {
                    indexNames[i++] = indexName.getName();
                }
                throw new IllegalArgumentException(indexAbstraction.getType().getDisplayName() + " [" + expression + "] has more than one index associated with it " + Arrays.toString(indexNames) + ", can't execute a single index op");
            }
            if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
                IndexNameExpressionResolver.resolveIndicesForDataStream(context, (DataStream)indexAbstraction, concreteIndicesResult);
                continue;
            }
            if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS && indexAbstraction.isDataStreamRelated() && DataStream.isFailureStoreFeatureFlagEnabled() && context.getOptions().includeFailureIndices()) {
                HashSet<DataStream> aliasDataStreams = new HashSet<DataStream>();
                for (Index index : indexAbstraction.getIndices()) {
                    aliasDataStreams.add(((IndexAbstraction)indicesLookup.get(index.getName())).getParentDataStream());
                }
                for (DataStream dataStream : aliasDataStreams) {
                    IndexNameExpressionResolver.resolveIndicesForDataStream(context, dataStream, concreteIndicesResult);
                }
                continue;
            }
            for (Index index : indexAbstraction.getIndices()) {
                if (!IndexNameExpressionResolver.shouldTrackConcreteIndex(context, context.getOptions(), index)) continue;
                concreteIndicesResult.add(index);
            }
        }
        if (!context.getOptions().allowNoIndices() && concreteIndicesResult.isEmpty()) {
            throw IndexNameExpressionResolver.notFoundException(indexExpressions);
        }
        this.checkSystemIndexAccess(context, concreteIndicesResult);
        return concreteIndicesResult.toArray(Index.EMPTY_ARRAY);
    }

    private static void resolveIndicesForDataStream(Context context, DataStream dataStream, Set<Index> concreteIndicesResult) {
        if (IndexNameExpressionResolver.shouldIncludeRegularIndices(context.getOptions())) {
            for (Index index : dataStream.getIndices()) {
                if (!IndexNameExpressionResolver.shouldTrackConcreteIndex(context, context.getOptions(), index)) continue;
                concreteIndicesResult.add(index);
            }
        }
        if (IndexNameExpressionResolver.shouldIncludeFailureIndices(context.getOptions()) && (context.getOptions().allowFailureIndices() || !context.getOptions().ignoreUnavailable())) {
            for (Index index : dataStream.getFailureIndices().getIndices()) {
                if (!IndexNameExpressionResolver.shouldTrackConcreteIndex(context, context.getOptions(), index)) continue;
                concreteIndicesResult.add(index);
            }
        }
    }

    private static void resolveWriteIndexForDataStreams(Context context, DataStream dataStream, Set<Index> concreteIndicesResult) {
        Index failureStoreWriteIndex;
        Index writeIndex;
        if (IndexNameExpressionResolver.shouldIncludeRegularIndices(context.getOptions()) && IndexNameExpressionResolver.addIndex(writeIndex = dataStream.getWriteIndex(), null, context)) {
            concreteIndicesResult.add(writeIndex);
        }
        if (IndexNameExpressionResolver.shouldIncludeFailureIndices(context.getOptions()) && (failureStoreWriteIndex = dataStream.getFailureStoreWriteIndex()) != null && IndexNameExpressionResolver.addIndex(failureStoreWriteIndex, null, context)) {
            if (!context.options.allowFailureIndices()) {
                throw new FailureIndexNotSupportedException(failureStoreWriteIndex);
            }
            concreteIndicesResult.add(failureStoreWriteIndex);
        }
    }

    private static boolean shouldIncludeRegularIndices(IndicesOptions indicesOptions) {
        return !DataStream.isFailureStoreFeatureFlagEnabled() || indicesOptions.includeRegularIndices();
    }

    private static boolean shouldIncludeFailureIndices(IndicesOptions indicesOptions) {
        return DataStream.isFailureStoreFeatureFlagEnabled() && indicesOptions.includeFailureIndices();
    }

    private static boolean resolvesToMoreThanOneIndex(IndexAbstraction indexAbstraction, Context context) {
        if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
            DataStream dataStream = (DataStream)indexAbstraction;
            int count = 0;
            if (IndexNameExpressionResolver.shouldIncludeRegularIndices(context.getOptions())) {
                count += dataStream.getIndices().size();
            }
            if (IndexNameExpressionResolver.shouldIncludeFailureIndices(context.getOptions())) {
                count += dataStream.getFailureIndices().getIndices().size();
            }
            return count > 1;
        }
        return indexAbstraction.getIndices().size() > 1;
    }

    private void checkSystemIndexAccess(Context context, Set<Index> concreteIndices) {
        Predicate<String> systemIndexAccessPredicate = context.getSystemIndexAccessPredicate();
        if (systemIndexAccessPredicate == Predicates.always()) {
            return;
        }
        this.doCheckSystemIndexAccess(context, concreteIndices, systemIndexAccessPredicate);
    }

    private void doCheckSystemIndexAccess(Context context, Set<Index> concreteIndices, Predicate<String> systemIndexAccessPredicate) {
        Metadata metadata = context.getState().metadata();
        ArrayList<String> resolvedSystemIndices = new ArrayList<String>();
        ArrayList<String> resolvedNetNewSystemIndices = new ArrayList<String>();
        HashSet<String> resolvedSystemDataStreams = new HashSet<String>();
        SortedMap<String, IndexAbstraction> indicesLookup = metadata.getIndicesLookup();
        boolean matchedIndex = false;
        for (Index concreteIndex : concreteIndices) {
            IndexMetadata idxMetadata = metadata.index(concreteIndex);
            String name = concreteIndex.getName();
            if (!idxMetadata.isSystem() || systemIndexAccessPredicate.test(name)) continue;
            matchedIndex = true;
            IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(name);
            if (indexAbstraction.getParentDataStream() != null) {
                resolvedSystemDataStreams.add(indexAbstraction.getParentDataStream().getName());
                continue;
            }
            if (this.systemIndices.isNetNewSystemIndex(name)) {
                resolvedNetNewSystemIndices.add(name);
                continue;
            }
            resolvedSystemIndices.add(name);
        }
        if (matchedIndex) {
            this.handleMatchedSystemIndices(resolvedSystemIndices, resolvedSystemDataStreams, resolvedNetNewSystemIndices);
        }
    }

    private void handleMatchedSystemIndices(List<String> resolvedSystemIndices, Set<String> resolvedSystemDataStreams, List<String> resolvedNetNewSystemIndices) {
        if (!resolvedSystemIndices.isEmpty()) {
            Collections.sort(resolvedSystemIndices);
            deprecationLogger.warn(DeprecationCategory.API, "open_system_index_access", "this request accesses system indices: {}, but in a future major version, direct access to system indices will be prevented by default", resolvedSystemIndices);
        }
        if (!resolvedSystemDataStreams.isEmpty()) {
            throw SystemIndices.dataStreamAccessException(this.threadContext, resolvedSystemDataStreams);
        }
        if (!resolvedNetNewSystemIndices.isEmpty()) {
            throw SystemIndices.netNewSystemIndexAccessException(this.threadContext, resolvedNetNewSystemIndices);
        }
    }

    private static IndexNotFoundException notFoundException(String ... indexExpressions) {
        IndexNotFoundException infe;
        if (indexExpressions == null || indexExpressions.length == 0 || indexExpressions.length == 1 && "_all".equals(indexExpressions[0])) {
            infe = new IndexNotFoundException("no indices exist", "_all");
            infe.setResources("index_or_alias", "_all");
        } else if (indexExpressions.length == 1) {
            infe = indexExpressions[0].startsWith("-") ? new IndexNotFoundException("if you intended to exclude this index, ensure that you use wildcards that include it before explicitly excluding it", indexExpressions[0]) : new IndexNotFoundException(indexExpressions[0]);
            infe.setResources("index_or_alias", indexExpressions[0]);
        } else {
            infe = new IndexNotFoundException((String)null);
            infe.setResources("index_expression", indexExpressions);
        }
        return infe;
    }

    private static boolean shouldTrackConcreteIndex(Context context, IndicesOptions options, Index index) {
        IndexMetadata imd;
        if (context.systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY && context.netNewSystemIndexPredicate.test(index.getName())) {
            return false;
        }
        if (DataStream.isFailureStoreFeatureFlagEnabled()) {
            DataStream parentDataStream;
            IndexAbstraction indexAbstraction = (IndexAbstraction)context.getState().metadata().getIndicesLookup().get(index.getName());
            if (!context.options.allowFailureIndices() && (parentDataStream = indexAbstraction.getParentDataStream()) != null && parentDataStream.isFailureStoreEnabled() && parentDataStream.isFailureStoreIndex(index.getName())) {
                if (options.ignoreUnavailable()) {
                    return false;
                }
                throw new FailureIndexNotSupportedException(index);
            }
        }
        if ((imd = context.state.metadata().index(index)).getState() == IndexMetadata.State.CLOSE) {
            if (options.forbidClosedIndices() && !options.ignoreUnavailable()) {
                throw new IndexClosedException(index);
            }
            return !options.forbidClosedIndices() && IndexNameExpressionResolver.addIndex(index, imd, context);
        }
        if (imd.getState() == IndexMetadata.State.OPEN) {
            return IndexNameExpressionResolver.addIndex(index, imd, context);
        }
        throw new IllegalStateException("index state [" + index + "] not supported");
    }

    private static boolean addIndex(Index index, IndexMetadata imd, Context context) {
        if (context.options.ignoreThrottled()) {
            imd = imd != null ? imd : context.state.metadata().index(index);
            return imd.getSettings().getAsBoolean("index.frozen", false) == false;
        }
        return true;
    }

    private static IllegalArgumentException aliasesNotSupportedException(String expression) {
        return new IllegalArgumentException("The provided expression [" + expression + "] matches an alias, specify the corresponding concrete indices instead.");
    }

    public Index concreteSingleIndex(ClusterState state, IndicesRequest request) {
        String indexExpression = CollectionUtils.isEmpty(request.indices()) ? null : request.indices()[0];
        Index[] indices = this.concreteIndices(state, request.indicesOptions(), indexExpression);
        if (indices.length != 1) {
            throw new IllegalArgumentException("unable to return a single index as the index and options provided got resolved to multiple indices");
        }
        return indices[0];
    }

    public Index concreteWriteIndex(ClusterState state, IndicesRequest request) {
        if (request.indices() == null || request.indices() != null && request.indices().length != 1) {
            throw new IllegalArgumentException("indices request must specify a single index expression");
        }
        return this.concreteWriteIndex(state, request.indicesOptions(), request.indices()[0], false, request.includeDataStreams());
    }

    public Index concreteWriteIndex(ClusterState state, IndicesOptions options, String index, boolean allowNoIndices, boolean includeDataStreams) {
        IndicesOptions combinedOptions = IndicesOptions.fromOptions(options.ignoreUnavailable(), allowNoIndices, options.expandWildcardsOpen(), options.expandWildcardsClosed(), options.expandWildcardsHidden(), options.allowAliasesToMultipleIndices(), options.forbidClosedIndices(), options.ignoreAliases(), options.ignoreThrottled());
        Context context = new Context(state, combinedOptions, false, true, includeDataStreams, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        Index[] indices = this.concreteIndices(context, index);
        if (allowNoIndices && indices.length == 0) {
            return null;
        }
        if (indices.length != 1) {
            throw new IllegalArgumentException("The index expression [" + index + "] and options provided did not point to a single write-index");
        }
        return indices[0];
    }

    public boolean hasIndexAbstraction(String indexAbstraction, ClusterState state) {
        String resolvedAliasOrIndex = DateMathExpressionResolver.resolveExpression(indexAbstraction);
        return state.metadata().hasIndexAbstraction(resolvedAliasOrIndex);
    }

    public static String resolveDateMathExpression(String dateExpression) {
        return DateMathExpressionResolver.resolveExpression(dateExpression);
    }

    public static String resolveDateMathExpression(String dateExpression, long time) {
        return DateMathExpressionResolver.resolveExpression(dateExpression, () -> time);
    }

    public Set<String> resolveExpressions(ClusterState state, String ... expressions) {
        return this.resolveExpressions(state, IndicesOptions.lenientExpandOpen(), false, expressions);
    }

    public Set<String> resolveExpressions(ClusterState state, IndicesOptions indicesOptions, boolean preserveDataStreams, String ... expressions) {
        Context context = new Context(state, indicesOptions, true, false, true, preserveDataStreams, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        Collection<String> resolved = IndexNameExpressionResolver.resolveExpressions(context, expressions);
        if (resolved instanceof Set) {
            return Collections.unmodifiableSet((Set)resolved);
        }
        return Set.copyOf(resolved);
    }

    public String[] filteringAliases(ClusterState state, String index, Set<String> resolvedExpressions) {
        return this.indexAliases(state, index, AliasMetadata::filteringRequired, DataStreamAlias::filteringRequired, false, resolvedExpressions);
    }

    boolean iterateIndexAliases(int indexAliasesSize, int resolvedExpressionsSize) {
        return indexAliasesSize <= resolvedExpressionsSize;
    }

    public String[] indexAliases(ClusterState state, String index, Predicate<AliasMetadata> requiredAlias, Predicate<DataStreamAlias> requiredDataStreamAlias, boolean skipIdentity, Set<String> resolvedExpressions) {
        if (IndexNameExpressionResolver.isAllIndices(resolvedExpressions)) {
            return null;
        }
        IndexMetadata indexMetadata = state.metadata().getIndices().get(index);
        if (indexMetadata == null) {
            throw new IndexNotFoundException(index);
        }
        if (!skipIdentity && resolvedExpressions.contains(index)) {
            return null;
        }
        IndexAbstraction ia = (IndexAbstraction)state.metadata().getIndicesLookup().get(index);
        DataStream dataStream = ia.getParentDataStream();
        if (dataStream != null) {
            if (!skipIdentity && resolvedExpressions.contains(dataStream.getName())) {
                return null;
            }
            Map<String, DataStreamAlias> dataStreamAliases = state.metadata().dataStreamAliases();
            List<DataStreamAlias> aliasesForDataStream = this.iterateIndexAliases(dataStreamAliases.size(), resolvedExpressions.size()) ? dataStreamAliases.values().stream().filter(dataStreamAlias -> resolvedExpressions.contains(dataStreamAlias.getName())).filter(dataStreamAlias -> dataStreamAlias.getDataStreams().contains(dataStream.getName())).toList() : resolvedExpressions.stream().map(dataStreamAliases::get).filter(dataStreamAlias -> dataStreamAlias != null && dataStreamAlias.getDataStreams().contains(dataStream.getName())).toList();
            ArrayList<String> requiredAliases = null;
            for (DataStreamAlias dataStreamAlias2 : aliasesForDataStream) {
                if (requiredDataStreamAlias.test(dataStreamAlias2)) {
                    if (requiredAliases == null) {
                        requiredAliases = new ArrayList<String>(aliasesForDataStream.size());
                    }
                    requiredAliases.add(dataStreamAlias2.getName());
                    continue;
                }
                return null;
            }
            if (requiredAliases == null) {
                return null;
            }
            return requiredAliases.toArray(Strings.EMPTY_ARRAY);
        }
        Map<String, AliasMetadata> indexAliases = indexMetadata.getAliases();
        AliasMetadata[] aliasCandidates = this.iterateIndexAliases(indexAliases.size(), resolvedExpressions.size()) ? (AliasMetadata[])indexAliases.values().stream().filter(aliasMetadata -> resolvedExpressions.contains(aliasMetadata.alias())).toArray(AliasMetadata[]::new) : (AliasMetadata[])resolvedExpressions.stream().map(indexAliases::get).filter(Objects::nonNull).toArray(AliasMetadata[]::new);
        ArrayList<String> aliases = null;
        for (AliasMetadata aliasMetadata2 : aliasCandidates) {
            if (requiredAlias.test(aliasMetadata2)) {
                if (aliases == null) {
                    aliases = new ArrayList<String>();
                }
            } else {
                return null;
            }
            aliases.add(aliasMetadata2.alias());
        }
        if (aliases == null) {
            return null;
        }
        return aliases.toArray(Strings.EMPTY_ARRAY);
    }

    public Map<String, Set<String>> resolveSearchRouting(ClusterState state, @Nullable String routing, String ... expressions) {
        Context context = new Context(state, IndicesOptions.lenientExpandOpen(), false, false, true, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        Collection<String> resolvedExpressions = IndexNameExpressionResolver.resolveExpressions(context, expressions);
        if (IndexNameExpressionResolver.isAllIndices(resolvedExpressions)) {
            return IndexNameExpressionResolver.resolveSearchRoutingAllIndices(state.metadata(), routing);
        }
        Map<String, Set<String>> routings = null;
        HashSet<String> paramRouting = null;
        HashSet<String> norouting = new HashSet<String>();
        if (routing != null) {
            paramRouting = Sets.newHashSet(Strings.splitStringByCommaToArray(routing));
        }
        for (String expression : resolvedExpressions) {
            IndexAbstraction indexAbstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(expression);
            if (indexAbstraction != null && indexAbstraction.getType() == IndexAbstraction.Type.ALIAS) {
                for (Index index : indexAbstraction.getIndices()) {
                    String concreteIndex = index.getName();
                    if (norouting.contains(concreteIndex)) continue;
                    AliasMetadata aliasMetadata = state.metadata().index(concreteIndex).getAliases().get(indexAbstraction.getName());
                    if (aliasMetadata != null && !aliasMetadata.searchRoutingValues().isEmpty()) {
                        if (routings == null) {
                            routings = new HashMap<String, Set<String>>();
                        }
                        Set r = routings.computeIfAbsent(concreteIndex, k -> new HashSet());
                        r.addAll(aliasMetadata.searchRoutingValues());
                        if (paramRouting != null) {
                            r.retainAll(paramRouting);
                        }
                        if (!r.isEmpty()) continue;
                        routings.remove(concreteIndex);
                        continue;
                    }
                    routings = IndexNameExpressionResolver.collectRoutings(routings, paramRouting, norouting, concreteIndex);
                }
                continue;
            }
            if (indexAbstraction != null && indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
                DataStream dataStream = (DataStream)indexAbstraction;
                if (!dataStream.isAllowCustomRouting() || dataStream.getIndices() == null) continue;
                for (Index index : dataStream.getIndices()) {
                    String concreteIndex = index.getName();
                    routings = IndexNameExpressionResolver.collectRoutings(routings, paramRouting, norouting, concreteIndex);
                }
                continue;
            }
            routings = IndexNameExpressionResolver.collectRoutings(routings, paramRouting, norouting, expression);
        }
        if (routings == null || routings.isEmpty()) {
            return null;
        }
        return routings;
    }

    @Nullable
    private static Map<String, Set<String>> collectRoutings(@Nullable Map<String, Set<String>> routings, @Nullable Set<String> paramRouting, Set<String> noRouting, String concreteIndex) {
        if (noRouting.add(concreteIndex)) {
            if (paramRouting != null) {
                if (routings == null) {
                    routings = new HashMap<String, Set<String>>();
                }
                routings.put(concreteIndex, new HashSet<String>(paramRouting));
            } else if (routings != null) {
                routings.remove(concreteIndex);
            }
        }
        return routings;
    }

    public static Map<String, Set<String>> resolveSearchRoutingAllIndices(Metadata metadata, String routing) {
        if (routing != null) {
            String[] concreteIndices;
            HashSet<String> r = Sets.newHashSet(Strings.splitStringByCommaToArray(routing));
            HashMap<String, Set<String>> routings = new HashMap<String, Set<String>>();
            for (String index : concreteIndices = metadata.getConcreteAllIndices()) {
                routings.put(index, r);
            }
            return routings;
        }
        return null;
    }

    public static boolean isAllIndices(Collection<String> aliasesOrIndices) {
        return aliasesOrIndices == null || aliasesOrIndices.isEmpty() || IndexNameExpressionResolver.isExplicitAllPattern(aliasesOrIndices);
    }

    static boolean isExplicitAllPattern(Collection<String> aliasesOrIndices) {
        return aliasesOrIndices != null && aliasesOrIndices.size() == 1 && "_all".equals(aliasesOrIndices.iterator().next());
    }

    public SystemIndices.SystemIndexAccessLevel getSystemIndexAccessLevel() {
        SystemIndices.SystemIndexAccessLevel accessLevel = SystemIndices.getSystemIndexAccessLevel(this.threadContext);
        assert (accessLevel != SystemIndices.SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY) : "BACKWARDS_COMPATIBLE_ONLY access level should never be used automatically, it should only be used in known special cases";
        return accessLevel;
    }

    public Predicate<String> getSystemIndexAccessPredicate() {
        SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel = this.getSystemIndexAccessLevel();
        Predicate<String> systemIndexAccessLevelPredicate = systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.NONE ? Predicates.never() : (systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY ? this.getNetNewSystemIndexPredicate() : (systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.ALL ? Predicates.always() : this.systemIndices.getProductSystemIndexNamePredicate(this.threadContext)));
        return systemIndexAccessLevelPredicate;
    }

    public Automaton getSystemNameAutomaton() {
        return this.systemIndices.getSystemNameAutomaton();
    }

    public Predicate<String> getNetNewSystemIndexPredicate() {
        return this.systemIndices::isNetNewSystemIndex;
    }

    private static boolean isWildcard(String expression) {
        return Regex.isSimpleMatchPattern(expression);
    }

    public static class Context {
        private final ClusterState state;
        private final IndicesOptions options;
        private final long startTime;
        private final boolean preserveAliases;
        private final boolean resolveToWriteIndex;
        private final boolean includeDataStreams;
        private final boolean preserveDataStreams;
        private final SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel;
        private final Predicate<String> systemIndexAccessPredicate;
        private final Predicate<String> netNewSystemIndexPredicate;

        Context(ClusterState state, IndicesOptions options, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel) {
            this(state, options, systemIndexAccessLevel, Predicates.always(), Predicates.never());
        }

        Context(ClusterState state, IndicesOptions options, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, Predicate<String> systemIndexAccessPredicate, Predicate<String> netNewSystemIndexPredicate) {
            this(state, options, System.currentTimeMillis(), systemIndexAccessLevel, systemIndexAccessPredicate, netNewSystemIndexPredicate);
        }

        Context(ClusterState state, IndicesOptions options, boolean preserveAliases, boolean resolveToWriteIndex, boolean includeDataStreams, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, Predicate<String> systemIndexAccessPredicate, Predicate<String> netNewSystemIndexPredicate) {
            this(state, options, System.currentTimeMillis(), preserveAliases, resolveToWriteIndex, includeDataStreams, false, systemIndexAccessLevel, systemIndexAccessPredicate, netNewSystemIndexPredicate);
        }

        Context(ClusterState state, IndicesOptions options, boolean preserveAliases, boolean resolveToWriteIndex, boolean includeDataStreams, boolean preserveDataStreams, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, Predicate<String> systemIndexAccessPredicate, Predicate<String> netNewSystemIndexPredicate) {
            this(state, options, System.currentTimeMillis(), preserveAliases, resolveToWriteIndex, includeDataStreams, preserveDataStreams, systemIndexAccessLevel, systemIndexAccessPredicate, netNewSystemIndexPredicate);
        }

        Context(ClusterState state, IndicesOptions options, long startTime, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, Predicate<String> systemIndexAccessPredicate, Predicate<String> netNewSystemIndexPredicate) {
            this(state, options, startTime, false, false, false, false, systemIndexAccessLevel, systemIndexAccessPredicate, netNewSystemIndexPredicate);
        }

        protected Context(ClusterState state, IndicesOptions options, long startTime, boolean preserveAliases, boolean resolveToWriteIndex, boolean includeDataStreams, boolean preserveDataStreams, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, Predicate<String> systemIndexAccessPredicate, Predicate<String> netNewSystemIndexPredicate) {
            this.state = state;
            this.options = options;
            this.startTime = startTime;
            this.preserveAliases = preserveAliases;
            this.resolveToWriteIndex = resolveToWriteIndex;
            this.includeDataStreams = includeDataStreams;
            this.preserveDataStreams = preserveDataStreams;
            this.systemIndexAccessLevel = systemIndexAccessLevel;
            this.systemIndexAccessPredicate = systemIndexAccessPredicate;
            this.netNewSystemIndexPredicate = netNewSystemIndexPredicate;
        }

        public ClusterState getState() {
            return this.state;
        }

        public IndicesOptions getOptions() {
            return this.options;
        }

        public long getStartTime() {
            return this.startTime;
        }

        boolean isPreserveAliases() {
            return this.preserveAliases;
        }

        boolean isResolveToWriteIndex() {
            return this.resolveToWriteIndex;
        }

        public boolean includeDataStreams() {
            return this.includeDataStreams;
        }

        public boolean isPreserveDataStreams() {
            return this.preserveDataStreams;
        }

        public Predicate<String> getSystemIndexAccessPredicate() {
            return this.systemIndexAccessPredicate;
        }
    }

    public static final class DateMathExpressionResolver {
        private static final DateFormatter DEFAULT_DATE_FORMATTER = DateFormatter.forPattern("uuuu.MM.dd");
        private static final String EXPRESSION_LEFT_BOUND = "<";
        private static final String EXPRESSION_RIGHT_BOUND = ">";
        private static final char LEFT_BOUND = '{';
        private static final char RIGHT_BOUND = '}';
        private static final char ESCAPE_CHAR = '\\';
        private static final char TIME_ZONE_BOUND = '|';

        private DateMathExpressionResolver() {
        }

        public static List<String> resolve(Context context, List<String> expressions) {
            ArrayList<String> result = new ArrayList<String>(expressions.size());
            for (ExpressionList.Expression expression : new ExpressionList(context, expressions)) {
                result.add(DateMathExpressionResolver.resolveExpression(expression, context::getStartTime));
            }
            return result;
        }

        static String resolveExpression(String expression) {
            return DateMathExpressionResolver.resolveExpression(expression, System::currentTimeMillis);
        }

        static String resolveExpression(ExpressionList.Expression expression, LongSupplier getTime) {
            if (expression.isExclusion()) {
                return "-" + DateMathExpressionResolver.resolveExpression(expression.get(), getTime);
            }
            return DateMathExpressionResolver.resolveExpression(expression.get(), getTime);
        }

        static String resolveExpression(String expression, LongSupplier getTime) {
            if (!expression.startsWith(EXPRESSION_LEFT_BOUND) || !expression.endsWith(EXPRESSION_RIGHT_BOUND)) {
                return expression;
            }
            return DateMathExpressionResolver.doResolveExpression(expression, getTime);
        }

        private static String doResolveExpression(String expression, LongSupplier getTime) {
            boolean escape = false;
            boolean inDateFormat = false;
            boolean inPlaceHolder = false;
            StringBuilder beforePlaceHolderSb = new StringBuilder();
            StringBuilder inPlaceHolderSb = new StringBuilder();
            char[] text = expression.toCharArray();
            boolean from = true;
            int length = text.length - 1;
            block8: for (int i = 1; i < length; ++i) {
                char c;
                boolean escapedChar = escape;
                if (escape) {
                    escape = false;
                }
                if ((c = text[i]) == '\\') {
                    if (escapedChar) {
                        beforePlaceHolderSb.append(c);
                        escape = false;
                        continue;
                    }
                    escape = true;
                    continue;
                }
                if (inPlaceHolder) {
                    switch (c) {
                        case '{': {
                            if (inDateFormat && escapedChar) {
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            if (!inDateFormat) {
                                inDateFormat = true;
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            throw new ElasticsearchParseException("invalid dynamic name expression [{}]. invalid character in placeholder at position [{}]", new String(text, 1, length), i);
                        }
                        case '}': {
                            ZoneId timeZone;
                            DateFormatter dateFormatter;
                            String mathExpression;
                            if (inDateFormat && escapedChar) {
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            if (inDateFormat) {
                                inDateFormat = false;
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            String inPlaceHolderString = inPlaceHolderSb.toString();
                            int dateTimeFormatLeftBoundIndex = inPlaceHolderString.indexOf(123);
                            if (dateTimeFormatLeftBoundIndex < 0) {
                                mathExpression = inPlaceHolderString;
                                dateFormatter = DEFAULT_DATE_FORMATTER;
                                timeZone = ZoneOffset.UTC;
                            } else {
                                String dateFormatterPattern;
                                if (inPlaceHolderString.lastIndexOf(125) != inPlaceHolderString.length() - 1) {
                                    throw new ElasticsearchParseException("invalid dynamic name expression [{}]. missing closing `}` for date math format", inPlaceHolderString);
                                }
                                if (dateTimeFormatLeftBoundIndex == inPlaceHolderString.length() - 2) {
                                    throw new ElasticsearchParseException("invalid dynamic name expression [{}]. missing date format", inPlaceHolderString);
                                }
                                mathExpression = inPlaceHolderString.substring(0, dateTimeFormatLeftBoundIndex);
                                String patternAndTZid = inPlaceHolderString.substring(dateTimeFormatLeftBoundIndex + 1, inPlaceHolderString.length() - 1);
                                int formatPatternTimeZoneSeparatorIndex = patternAndTZid.indexOf(124);
                                if (formatPatternTimeZoneSeparatorIndex != -1) {
                                    dateFormatterPattern = patternAndTZid.substring(0, formatPatternTimeZoneSeparatorIndex);
                                    timeZone = DateUtils.of(patternAndTZid.substring(formatPatternTimeZoneSeparatorIndex + 1));
                                } else {
                                    dateFormatterPattern = patternAndTZid;
                                    timeZone = ZoneOffset.UTC;
                                }
                                dateFormatter = DateFormatter.forPattern(dateFormatterPattern);
                            }
                            DateFormatter formatter = dateFormatter.withZone(timeZone);
                            DateMathParser dateMathParser = formatter.toDateMathParser();
                            Instant instant = dateMathParser.parse(mathExpression, getTime, false, timeZone);
                            String time = formatter.format(instant);
                            beforePlaceHolderSb.append(time);
                            inPlaceHolderSb = new StringBuilder();
                            inPlaceHolder = false;
                            break;
                        }
                        default: {
                            inPlaceHolderSb.append(c);
                            break;
                        }
                    }
                    continue;
                }
                switch (c) {
                    case '{': {
                        if (escapedChar) {
                            beforePlaceHolderSb.append(c);
                            continue block8;
                        }
                        inPlaceHolder = true;
                        continue block8;
                    }
                    case '}': {
                        if (!escapedChar) {
                            throw new ElasticsearchParseException("invalid dynamic name expression [{}]. invalid character at position [{}]. `{` and `}` are reserved characters and should be escaped when used as part of the index name using `\\` (e.g. `\\{text\\}`)", new String(text, 1, length), i);
                        }
                    }
                    default: {
                        beforePlaceHolderSb.append(c);
                    }
                }
            }
            if (inPlaceHolder) {
                throw new ElasticsearchParseException("invalid dynamic name expression [{}]. date math placeholder is open ended", new String(text, 1, length));
            }
            if (beforePlaceHolderSb.length() == 0) {
                throw new ElasticsearchParseException("nothing captured", new Object[0]);
            }
            return beforePlaceHolderSb.toString();
        }
    }

    public static final class ExplicitResourceNameFilter {
        private ExplicitResourceNameFilter() {
        }

        public static List<String> filterUnavailable(Context context, List<String> expressions) {
            ExplicitResourceNameFilter.ensureRemoteIndicesRequireIgnoreUnavailable(context.getOptions(), expressions);
            ArrayList<String> result = new ArrayList<String>(expressions.size());
            for (ExpressionList.Expression expression : new ExpressionList(context, expressions)) {
                ExplicitResourceNameFilter.validateAliasOrIndex(expression);
                if (!expression.isWildcard() && !expression.isExclusion() && !ExplicitResourceNameFilter.ensureAliasOrIndexExists(context, expression.get())) continue;
                result.add(expression.expression());
            }
            return result;
        }

        @Nullable
        private static boolean ensureAliasOrIndexExists(Context context, String name) {
            boolean ignoreUnavailable = context.getOptions().ignoreUnavailable();
            IndexAbstraction indexAbstraction = (IndexAbstraction)context.getState().getMetadata().getIndicesLookup().get(name);
            if (indexAbstraction == null) {
                if (ignoreUnavailable) {
                    return false;
                }
                throw IndexNameExpressionResolver.notFoundException(name);
            }
            if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS && context.getOptions().ignoreAliases()) {
                if (ignoreUnavailable) {
                    return false;
                }
                throw IndexNameExpressionResolver.aliasesNotSupportedException(name);
            }
            if (indexAbstraction.isDataStreamRelated() && !context.includeDataStreams()) {
                if (ignoreUnavailable) {
                    return false;
                }
                IndexNotFoundException infe = IndexNameExpressionResolver.notFoundException(name);
                infe.addMetadata(IndexNameExpressionResolver.EXCLUDED_DATA_STREAMS_KEY, "true");
                throw infe;
            }
            return true;
        }

        private static void validateAliasOrIndex(ExpressionList.Expression expression) {
            if (Strings.isEmpty(expression.expression())) {
                throw IndexNameExpressionResolver.notFoundException(expression.expression());
            }
            if (expression.expression().charAt(0) == '_') {
                throw new InvalidIndexNameException(expression.expression(), "must not start with '_'.");
            }
        }

        private static void ensureRemoteIndicesRequireIgnoreUnavailable(IndicesOptions options, List<String> indexExpressions) {
            if (options.ignoreUnavailable()) {
                return;
            }
            for (String index : indexExpressions) {
                if (!index.contains(":")) continue;
                ExplicitResourceNameFilter.failOnRemoteIndicesNotIgnoringUnavailable(indexExpressions);
            }
        }

        private static void failOnRemoteIndicesNotIgnoringUnavailable(List<String> indexExpressions) {
            ArrayList<String> crossClusterIndices = new ArrayList<String>();
            for (String index : indexExpressions) {
                if (!index.contains(":")) continue;
                crossClusterIndices.add(index);
            }
            throw new IllegalArgumentException("Cross-cluster calls are not supported in this context but remote indices were requested: " + crossClusterIndices);
        }
    }

    static final class WildcardExpressionResolver {
        private WildcardExpressionResolver() {
        }

        public static Collection<String> resolveAll(Context context) {
            List<String> concreteIndices = WildcardExpressionResolver.resolveEmptyOrTrivialWildcard(context);
            if (!context.includeDataStreams() && context.getOptions().ignoreAliases()) {
                return concreteIndices;
            }
            Stream<IndexAbstraction> ias = context.getState().metadata().getIndicesLookup().values().stream().filter(ia -> context.getOptions().expandWildcardsHidden() || !ia.isHidden()).filter(ia -> WildcardExpressionResolver.shouldIncludeIfDataStream(ia, context) || WildcardExpressionResolver.shouldIncludeIfAlias(ia, context)).filter(ia -> !ia.isSystem() || context.systemIndexAccessPredicate.test(ia.getName()));
            Set<String> resolved = WildcardExpressionResolver.expandToOpenClosed(context, ias).collect(Collectors.toSet());
            resolved.addAll(concreteIndices);
            return resolved;
        }

        private static boolean shouldIncludeIfDataStream(IndexAbstraction ia, Context context) {
            return context.includeDataStreams() && ia.getType() == IndexAbstraction.Type.DATA_STREAM;
        }

        private static boolean shouldIncludeIfAlias(IndexAbstraction ia, Context context) {
            return !context.getOptions().ignoreAliases() && ia.getType() == IndexAbstraction.Type.ALIAS;
        }

        public static Collection<String> resolve(Context context, List<String> expressions) {
            ExpressionList expressionList = new ExpressionList(context, expressions);
            if (!expressionList.hasWildcard()) {
                return expressions;
            }
            HashSet<String> result = new HashSet<String>();
            for (ExpressionList.Expression expression : expressionList) {
                if (expression.isWildcard()) {
                    Stream<IndexAbstraction> matchingResources = WildcardExpressionResolver.matchResourcesToWildcard(context, expression.get());
                    Stream<String> matchingOpenClosedNames = WildcardExpressionResolver.expandToOpenClosed(context, matchingResources);
                    AtomicBoolean emptyWildcardExpansion = new AtomicBoolean(false);
                    if (!context.getOptions().allowNoIndices()) {
                        emptyWildcardExpansion.set(true);
                        matchingOpenClosedNames = matchingOpenClosedNames.peek(x -> emptyWildcardExpansion.set(false));
                    }
                    if (expression.isExclusion()) {
                        matchingOpenClosedNames.forEachOrdered(result::remove);
                    } else {
                        matchingOpenClosedNames.forEachOrdered(result::add);
                    }
                    if (!emptyWildcardExpansion.get()) continue;
                    throw IndexNameExpressionResolver.notFoundException(expression.get());
                }
                if (expression.isExclusion()) {
                    result.remove(expression.get());
                    continue;
                }
                result.add(expression.get());
            }
            return result;
        }

        private static IndexMetadata.State excludeState(IndicesOptions options) {
            IndexMetadata.State excludeState;
            if (options.expandWildcardsOpen() && options.expandWildcardsClosed()) {
                excludeState = null;
            } else if (options.expandWildcardsOpen() && !options.expandWildcardsClosed()) {
                excludeState = IndexMetadata.State.CLOSE;
            } else if (options.expandWildcardsClosed() && !options.expandWildcardsOpen()) {
                excludeState = IndexMetadata.State.OPEN;
            } else {
                assert (false) : "this shouldn't get called if wildcards expand to none";
                excludeState = null;
            }
            return excludeState;
        }

        private static Stream<IndexAbstraction> matchResourcesToWildcard(Context context, String wildcardExpression) {
            Stream<IndexAbstraction> matchesStream;
            assert (IndexNameExpressionResolver.isWildcard(wildcardExpression));
            SortedMap<String, IndexAbstraction> indicesLookup = context.getState().getMetadata().getIndicesLookup();
            if (Regex.isSuffixMatchPattern(wildcardExpression)) {
                matchesStream = WildcardExpressionResolver.filterIndicesLookupForSuffixWildcard(indicesLookup, wildcardExpression).values().stream();
            } else {
                matchesStream = indicesLookup.values().stream();
                if (!Regex.isMatchAllPattern(wildcardExpression)) {
                    matchesStream = matchesStream.filter(indexAbstraction -> Regex.simpleMatch(wildcardExpression, indexAbstraction.getName()));
                }
            }
            if (context.getOptions().ignoreAliases()) {
                matchesStream = matchesStream.filter(indexAbstraction -> indexAbstraction.getType() != IndexAbstraction.Type.ALIAS);
            }
            if (!context.includeDataStreams()) {
                matchesStream = matchesStream.filter(indexAbstraction -> !indexAbstraction.isDataStreamRelated());
            }
            matchesStream = matchesStream.filter(indexAbstraction -> !indexAbstraction.isSystem() || indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM && indexAbstraction.getParentDataStream() == null && !context.netNewSystemIndexPredicate.test(indexAbstraction.getName()) || context.systemIndexAccessPredicate.test(indexAbstraction.getName()));
            if (!context.getOptions().expandWildcardsHidden()) {
                matchesStream = wildcardExpression.startsWith(".") ? matchesStream.filter(indexAbstraction -> !indexAbstraction.isHidden() || indexAbstraction.getName().startsWith(".")) : matchesStream.filter(indexAbstraction -> !indexAbstraction.isHidden());
            }
            return matchesStream;
        }

        private static Map<String, IndexAbstraction> filterIndicesLookupForSuffixWildcard(SortedMap<String, IndexAbstraction> indicesLookup, String suffixWildcardExpression) {
            assert (Regex.isSuffixMatchPattern(suffixWildcardExpression));
            String fromPrefix = suffixWildcardExpression.substring(0, suffixWildcardExpression.length() - 1);
            char[] toPrefixCharArr = fromPrefix.toCharArray();
            int n = toPrefixCharArr.length - 1;
            toPrefixCharArr[n] = (char)(toPrefixCharArr[n] + '\u0001');
            String toPrefix = new String(toPrefixCharArr);
            return indicesLookup.subMap(fromPrefix, toPrefix);
        }

        private static Stream<String> expandToOpenClosed(Context context, Stream<IndexAbstraction> resources) {
            IndexMetadata.State excludeState = WildcardExpressionResolver.excludeState(context.getOptions());
            return resources.flatMap(indexAbstraction -> {
                if (context.isPreserveAliases() && indexAbstraction.getType() == IndexAbstraction.Type.ALIAS) {
                    return Stream.of(indexAbstraction.getName());
                }
                if (context.isPreserveDataStreams() && indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
                    return Stream.of(indexAbstraction.getName());
                }
                Stream<IndexMetadata> indicesStateStream = Stream.of(new IndexMetadata[0]);
                if (IndexNameExpressionResolver.shouldIncludeRegularIndices(context.getOptions())) {
                    indicesStateStream = indexAbstraction.getIndices().stream().map(context.state.metadata()::index);
                }
                if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM && IndexNameExpressionResolver.shouldIncludeFailureIndices(context.getOptions())) {
                    DataStream dataStream = (DataStream)indexAbstraction;
                    indicesStateStream = Stream.concat(indicesStateStream, dataStream.getFailureIndices().getIndices().stream().map(context.state.metadata()::index));
                }
                if (excludeState != null) {
                    indicesStateStream = indicesStateStream.filter(indexMeta -> indexMeta.getState() != excludeState);
                }
                return indicesStateStream.map(indexMeta -> indexMeta.getIndex().getName());
            });
        }

        private static List<String> resolveEmptyOrTrivialWildcard(Context context) {
            String[] allIndices = WildcardExpressionResolver.resolveEmptyOrTrivialWildcardToAllIndices(context.getOptions(), context.getState().metadata());
            if (context.systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.ALL) {
                return List.of(allIndices);
            }
            return WildcardExpressionResolver.resolveEmptyOrTrivialWildcardWithAllowedSystemIndices(context, allIndices);
        }

        private static List<String> resolveEmptyOrTrivialWildcardWithAllowedSystemIndices(Context context, String[] allIndices) {
            return Arrays.stream(allIndices).filter(name -> {
                if (name.startsWith(".")) {
                    IndexAbstraction abstraction = (IndexAbstraction)context.state.metadata().getIndicesLookup().get(name);
                    assert (abstraction != null) : "null abstraction for " + name + " but was in array of all indices";
                    if (abstraction.isSystem()) {
                        if (context.netNewSystemIndexPredicate.test((String)name)) {
                            if (SystemIndices.SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY.equals((Object)context.systemIndexAccessLevel)) {
                                return false;
                            }
                            return context.systemIndexAccessPredicate.test((String)name);
                        }
                        if (abstraction.getType() == IndexAbstraction.Type.DATA_STREAM || abstraction.getParentDataStream() != null) {
                            return context.systemIndexAccessPredicate.test((String)name);
                        }
                    } else {
                        return true;
                    }
                }
                return true;
            }).toList();
        }

        private static String[] resolveEmptyOrTrivialWildcardToAllIndices(IndicesOptions options, Metadata metadata) {
            if (!IndexNameExpressionResolver.shouldIncludeRegularIndices(options)) {
                return Strings.EMPTY_ARRAY;
            }
            if (options.expandWildcardsOpen() && options.expandWildcardsClosed() && options.expandWildcardsHidden()) {
                return metadata.getConcreteAllIndices();
            }
            if (options.expandWildcardsOpen() && options.expandWildcardsClosed()) {
                return metadata.getConcreteVisibleIndices();
            }
            if (options.expandWildcardsOpen() && options.expandWildcardsHidden()) {
                return metadata.getConcreteAllOpenIndices();
            }
            if (options.expandWildcardsOpen()) {
                return metadata.getConcreteVisibleOpenIndices();
            }
            if (options.expandWildcardsClosed() && options.expandWildcardsHidden()) {
                return metadata.getConcreteAllClosedIndices();
            }
            if (options.expandWildcardsClosed()) {
                return metadata.getConcreteVisibleClosedIndices();
            }
            return Strings.EMPTY_ARRAY;
        }
    }

    public static final class ResolverContext
    extends Context {
        public ResolverContext() {
            this(System.currentTimeMillis());
        }

        public ResolverContext(long startTime) {
            super(null, null, startTime, false, false, false, false, SystemIndices.SystemIndexAccessLevel.ALL, Predicates.never(), Predicates.never());
        }

        @Override
        public ClusterState getState() {
            throw new UnsupportedOperationException("should never be called");
        }

        @Override
        public IndicesOptions getOptions() {
            throw new UnsupportedOperationException("should never be called");
        }
    }

    public static final class ExpressionList
    implements Iterable<Expression> {
        private final List<Expression> expressionsList;
        private final boolean hasWildcard;

        public ExpressionList(Context context, List<String> expressionStrings) {
            ArrayList<Expression> expressionsList = new ArrayList<Expression>(expressionStrings.size());
            boolean wildcardSeen = false;
            for (String expressionString : expressionStrings) {
                boolean isExclusion;
                boolean bl = isExclusion = expressionString.startsWith("-") && wildcardSeen;
                if (context.getOptions().expandWildcardExpressions() && IndexNameExpressionResolver.isWildcard(expressionString)) {
                    wildcardSeen = true;
                    expressionsList.add(new Expression(expressionString, true, isExclusion));
                    continue;
                }
                expressionsList.add(new Expression(expressionString, false, isExclusion));
            }
            this.expressionsList = expressionsList;
            this.hasWildcard = wildcardSeen;
        }

        public boolean hasWildcard() {
            return this.hasWildcard;
        }

        @Override
        public Iterator<Expression> iterator() {
            return this.expressionsList.iterator();
        }

        public record Expression(String expression, boolean isWildcard, boolean isExclusion) {
            public String get() {
                if (this.isExclusion()) {
                    return this.expression().substring(1);
                }
                return this.expression();
            }
        }
    }
}

