/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class DataStreamGlobalRetention
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "data-stream-global-retention";
    public static final NodeFeature GLOBAL_RETENTION = new NodeFeature("data_stream.lifecycle.global_retention");
    public static final ParseField DEFAULT_RETENTION_FIELD = new ParseField("default_retention", new String[0]);
    public static final ParseField MAX_RETENTION_FIELD = new ParseField("max_retention", new String[0]);
    public static final DataStreamGlobalRetention EMPTY = new DataStreamGlobalRetention(null, null);
    public static final TimeValue MIN_RETENTION_VALUE = TimeValue.timeValueSeconds((long)10L);
    @Nullable
    private final TimeValue defaultRetention;
    @Nullable
    private final TimeValue maxRetention;

    public DataStreamGlobalRetention(TimeValue defaultRetention, TimeValue maxRetention) {
        if (defaultRetention != null && maxRetention != null && defaultRetention.getMillis() > maxRetention.getMillis()) {
            throw new IllegalArgumentException("Default global retention [" + defaultRetention.getStringRep() + "] cannot be greater than the max global retention [" + maxRetention.getStringRep() + "].");
        }
        if (!this.validateRetentionValue(defaultRetention) || !this.validateRetentionValue(maxRetention)) {
            throw new IllegalArgumentException("Global retention values should be greater than " + MIN_RETENTION_VALUE.getStringRep());
        }
        this.defaultRetention = defaultRetention;
        this.maxRetention = maxRetention;
    }

    private boolean validateRetentionValue(@Nullable TimeValue retention) {
        return retention == null || retention.getMillis() >= MIN_RETENTION_VALUE.getMillis();
    }

    public static DataStreamGlobalRetention read(StreamInput in) throws IOException {
        return new DataStreamGlobalRetention(in.readOptionalTimeValue(), in.readOptionalTimeValue());
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ADD_DATA_STREAM_GLOBAL_RETENTION;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalTimeValue(this.defaultRetention);
        out.writeOptionalTimeValue(this.maxRetention);
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return DataStreamGlobalRetention.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.single(this::toXContentFragment);
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.defaultRetention != null) {
            builder.field(DEFAULT_RETENTION_FIELD.getPreferredName(), this.defaultRetention.getStringRep());
        }
        if (this.maxRetention != null) {
            builder.field(MAX_RETENTION_FIELD.getPreferredName(), this.maxRetention.getStringRep());
        }
        return builder;
    }

    @Nullable
    public static DataStreamGlobalRetention getFromClusterState(ClusterState clusterState) {
        return (DataStreamGlobalRetention)clusterState.custom(TYPE);
    }

    @Nullable
    public TimeValue getDefaultRetention() {
        return this.defaultRetention;
    }

    @Nullable
    public TimeValue getMaxRetention() {
        return this.maxRetention;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStreamGlobalRetention that = (DataStreamGlobalRetention)o;
        return Objects.equals(this.defaultRetention, that.defaultRetention) && Objects.equals(this.maxRetention, that.maxRetention);
    }

    public int hashCode() {
        return Objects.hash(this.defaultRetention, this.maxRetention);
    }

    public String toString() {
        return "DataStreamGlobalRetention{defaultRetention=" + (this.defaultRetention == null ? "null" : this.defaultRetention.getStringRep()) + ", maxRetention=" + (this.maxRetention == null ? "null" : this.maxRetention.getStringRep()) + "}";
    }
}

