/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.plugins.PluginsService;

public interface DataStreamFactoryRetention {
    @Nullable
    public TimeValue getMaxRetention();

    @Nullable
    public TimeValue getDefaultRetention();

    default public boolean isDefined() {
        return this.getMaxRetention() != null || this.getDefaultRetention() != null;
    }

    public void init(ClusterSettings var1);

    public static DataStreamFactoryRetention load(PluginsService pluginsService, ClusterSettings clusterSettings) {
        DataStreamFactoryRetention factoryRetention = pluginsService.loadSingletonServiceProvider(DataStreamFactoryRetention.class, DataStreamFactoryRetention::emptyFactoryRetention);
        factoryRetention.init(clusterSettings);
        return factoryRetention;
    }

    public static DataStreamFactoryRetention emptyFactoryRetention() {
        return new DataStreamFactoryRetention(){

            @Override
            public TimeValue getMaxRetention() {
                return null;
            }

            @Override
            public TimeValue getDefaultRetention() {
                return null;
            }

            @Override
            public void init(ClusterSettings clusterSettings) {
            }
        };
    }
}

