/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.FilePermission;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessMode;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Permission;
import java.security.Permissions;
import java.security.Policy;
import java.security.UnresolvedPermission;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.SecuredConfigFileAccessPermission;
import org.elasticsearch.SecuredConfigFileSettingAccessPermission;
import org.elasticsearch.bootstrap.Bootstrap;
import org.elasticsearch.bootstrap.ESPolicy;
import org.elasticsearch.bootstrap.ElasticsearchUncaughtExceptionHandler;
import org.elasticsearch.bootstrap.FilePermissionUtils;
import org.elasticsearch.bootstrap.PluginPolicyInfo;
import org.elasticsearch.bootstrap.PolicyUtil;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.plugins.PluginsUtils;
import org.elasticsearch.secure_sm.SecureSM;
import org.elasticsearch.transport.TcpTransport;

final class Security {
    private static Logger logger;

    private Security() {
    }

    static void setSecurityManager(SecurityManager sm) {
        System.setSecurityManager(sm);
    }

    static void configure(Environment environment, boolean filterBadDefaults, Path pidFile) throws IOException {
        logger = LogManager.getLogger(Security.class);
        Map<String, URL> codebases = PolicyUtil.getCodebaseJarMap(JarHell.parseModulesAndClassPath());
        Policy mainPolicy = PolicyUtil.readPolicy(ESPolicy.class.getResource("security.policy"), codebases);
        Map<URL, Policy> pluginPolicies = Security.getPluginAndModulePermissions(environment);
        Policy.setPolicy(new ESPolicy(mainPolicy, Security.createPermissions(environment, pidFile), pluginPolicies, filterBadDefaults, Security.createRecursiveDataPathPermission(environment), Security.readSecuredConfigFiles(environment, mainPolicy, codebases.values(), pluginPolicies)));
        String[] classesThatCanExit = new String[]{ElasticsearchUncaughtExceptionHandler.PrivilegedHaltAction.class.getName().replace("$", "\\$"), Bootstrap.class.getName()};
        Security.setSecurityManager((SecurityManager)new SecureSM(classesThatCanExit));
        Security.selfTest();
    }

    @SuppressForbidden(reason="proper use of URL")
    static Map<URL, Policy> getPluginAndModulePermissions(Environment environment) throws IOException {
        HashMap map = new HashMap();
        Consumer<PluginPolicyInfo> addPolicy = pluginPolicy -> {
            if (pluginPolicy == null) {
                return;
            }
            for (URL jar : pluginPolicy.jars()) {
                if (map.put(jar, pluginPolicy.policy()) == null) continue;
                throw new IllegalStateException("per-plugin permissions already granted for jar file: " + jar);
            }
        };
        for (Path plugin : PluginsUtils.findPluginDirs(environment.pluginsFile())) {
            addPolicy.accept(PolicyUtil.getPluginPolicyInfo(plugin, environment.tmpFile()));
        }
        for (Path plugin : PluginsUtils.findPluginDirs(environment.modulesFile())) {
            addPolicy.accept(PolicyUtil.getModulePolicyInfo(plugin, environment.tmpFile()));
        }
        return Collections.unmodifiableMap(map);
    }

    static Permissions createPermissions(Environment environment, Path pidFile) throws IOException {
        Permissions policy = new Permissions();
        Security.addClasspathPermissions(policy);
        Security.addFilePermissions(policy, environment, pidFile);
        Security.addBindPermissions(policy, environment.settings());
        return policy;
    }

    private static List<FilePermission> createRecursiveDataPathPermission(Environment environment) throws IOException {
        Permissions policy = new Permissions();
        for (Path path : environment.dataFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_DATA_SETTING.getKey(), path, "read,readlink,write,delete", true);
        }
        return Security.toFilePermissions(policy);
    }

    private static Map<String, Set<URL>> readSecuredConfigFiles(Environment environment, Policy template, Collection<URL> mainCodebases, Map<URL, Policy> pluginPolicies) throws IOException {
        HashMap<String, Set<URL>> securedConfigFiles = new HashMap<String, Set<URL>>();
        HashMap<String, Set<URL>> securedSettingKeys = new HashMap<String, Set<URL>>();
        for (URL uRL : mainCodebases) {
            for (Permission p : PolicyUtil.getPolicyPermissions(uRL, template, environment.tmpFile())) {
                Security.readSecuredConfigFilePermissions(environment, uRL, p, securedConfigFiles, securedSettingKeys);
            }
        }
        for (Map.Entry entry : pluginPolicies.entrySet()) {
            for (Permission p : PolicyUtil.getPolicyPermissions((URL)entry.getKey(), (Policy)entry.getValue(), environment.tmpFile())) {
                Security.readSecuredConfigFilePermissions(environment, (URL)entry.getKey(), p, securedConfigFiles, securedSettingKeys);
            }
        }
        List<Map.Entry> settingPatterns = securedSettingKeys.entrySet().stream().map(e -> Map.entry(Pattern.compile((String)e.getKey()), (Set)e.getValue())).toList();
        for (String setting : environment.settings().keySet()) {
            for (Map.Entry ps : settingPatterns) {
                if (!((Pattern)ps.getKey()).matcher(setting).matches()) continue;
                Path file = environment.configFile().resolve(environment.settings().get(setting));
                if (!file.startsWith(environment.configFile())) {
                    throw new IllegalStateException(ps.getValue() + " tried to grant access to file outside config directory " + file);
                }
                if (logger.isDebugEnabled()) {
                    ((Set)ps.getValue()).forEach(url -> logger.debug("Jar {} securing access to config file {} through setting {}", new Object[]{url, file, setting}));
                }
                securedConfigFiles.computeIfAbsent(file.toString(), k -> new HashSet()).addAll((Collection)ps.getValue());
            }
        }
        Security.addSpeciallySecuredConfigFile(securedConfigFiles, environment.configFile().resolve("elasticsearch.yml").toString());
        Security.addSpeciallySecuredConfigFile(securedConfigFiles, environment.configFile().resolve("jvm.options").toString());
        Security.addSpeciallySecuredConfigFile(securedConfigFiles, environment.configFile().resolve("jvm.options.d/-").toString());
        return Collections.unmodifiableMap(securedConfigFiles);
    }

    private static void readSecuredConfigFilePermissions(Environment environment, URL url, Permission p, Map<String, Set<URL>> securedFiles, Map<String, Set<URL>> securedSettingKeys) {
        String securedKey;
        String securedFileName = Security.extractSecuredName(p, SecuredConfigFileAccessPermission.class);
        if (securedFileName != null) {
            Path securedFile = environment.configFile().resolve(securedFileName);
            if (!securedFile.startsWith(environment.configFile())) {
                throw new IllegalStateException("[" + url + "] tried to grant access to file outside config directory " + securedFile);
            }
            logger.debug("Jar {} securing access to config file {}", new Object[]{url, securedFile});
            securedFiles.computeIfAbsent(securedFile.toString(), k -> new HashSet()).add(url);
        }
        if ((securedKey = Security.extractSecuredName(p, SecuredConfigFileSettingAccessPermission.class)) != null) {
            securedSettingKeys.computeIfAbsent(securedKey, k -> new HashSet()).add(url);
        }
    }

    private static String extractSecuredName(Permission p, Class<? extends Permission> permissionType) {
        UnresolvedPermission up;
        if (permissionType.isInstance(p)) {
            return p.getName();
        }
        if (p instanceof UnresolvedPermission && (up = (UnresolvedPermission)p).getUnresolvedType().equals(permissionType.getCanonicalName())) {
            return up.getUnresolvedName();
        }
        return null;
    }

    private static void addSpeciallySecuredConfigFile(Map<String, Set<URL>> securedFiles, String path) {
        Set attemptedToGrant = securedFiles.put(path, Set.of());
        if (attemptedToGrant != null) {
            throw new IllegalStateException(attemptedToGrant + " tried to grant access to special config file " + path);
        }
    }

    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static void addClasspathPermissions(Permissions policy) throws IOException {
        for (URL url : JarHell.parseClassPath()) {
            Path path;
            try {
                path = PathUtils.get((URI)url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                FilePermissionUtils.addDirectoryPath(policy, "class.path", path, "read,readlink", false);
                continue;
            }
            FilePermissionUtils.addSingleFilePath(policy, path, "read,readlink");
        }
    }

    static void addFilePermissions(Permissions policy, Environment environment, Path pidFile) throws IOException {
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.binFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.libFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.modulesFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.pluginsFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, "path.conf", environment.configFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, "java.io.tmpdir", environment.tmpFile(), "read,readlink,write,delete", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_LOGS_SETTING.getKey(), environment.logsFile(), "read,readlink,write,delete", false);
        if (environment.sharedDataFile() != null) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_SHARED_DATA_SETTING.getKey(), environment.sharedDataFile(), "read,readlink,write,delete", false);
        }
        HashSet<Path> dataFilesPaths = new HashSet<Path>();
        for (Path path : environment.dataFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_DATA_SETTING.getKey(), path, "read,readlink,write,delete", false);
            try {
                Path realPath = path.toRealPath(new LinkOption[0]);
                if (dataFilesPaths.add(realPath)) continue;
                throw new IllegalStateException("path [" + realPath + "] is duplicated by [" + path + "]");
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to access [" + path + "]", e);
            }
        }
        for (Path path : environment.repoFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_REPO_SETTING.getKey(), path, "read,readlink,write,delete", false);
        }
        if (pidFile != null) {
            FilePermissionUtils.addSingleFilePath(policy, pidFile, "delete");
        }
        FilePermissionUtils.addSingleFilePath(policy, environment.configFile().resolve("operator").resolve("settings.json"), "read,readlink,write");
    }

    private static void addBindPermissions(Permissions policy, Settings settings) {
        Security.addSocketPermissionForHttp(policy, settings);
        Security.addSocketPermissionForTransportProfiles(policy, settings);
    }

    private static void addSocketPermissionForHttp(Permissions policy, Settings settings) {
        String httpRange = HttpTransportSettings.SETTING_HTTP_PORT.get(settings).getPortRangeString();
        Security.addSocketPermissionForPortRange(policy, httpRange);
    }

    private static void addSocketPermissionForTransportProfiles(Permissions policy, Settings settings) {
        Set<TcpTransport.ProfileSettings> profiles = TcpTransport.getProfileSettings(settings);
        HashSet<String> uniquePortRanges = new HashSet<String>();
        for (TcpTransport.ProfileSettings profile : profiles) {
            if (!uniquePortRanges.add(profile.portOrRange)) continue;
            Security.addSocketPermissionForPortRange(policy, profile.portOrRange);
        }
    }

    private static void addSocketPermissionForPortRange(Permissions policy, String portRange) {
        policy.add(new SocketPermission("*:" + portRange, "listen,resolve"));
    }

    static void ensureDirectoryExists(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            path.getFileSystem().provider().checkAccess(path.toRealPath(new LinkOption[0]), AccessMode.READ);
        } else {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                NotDirectoryException e2 = new NotDirectoryException(path.toString());
                e2.addSuppressed(e);
                throw e2;
            }
        }
    }

    @SuppressForbidden(reason="accesses jvm default tempdir as a self-test")
    static void selfTest() throws IOException {
        try {
            Path p = Files.createTempFile(null, null, new FileAttribute[0]);
            try {
                Files.delete(p);
            }
            catch (IOException iOException) {}
        }
        catch (SecurityException problem) {
            throw new SecurityException("Security misconfiguration: cannot access java.io.tmpdir", problem);
        }
    }

    static boolean prepopulateSecurityCaller() {
        Field f;
        try {
            f = Security.getDeclaredField(Class.forName("java.lang.System$CallersHolder", true, null), "callers");
        }
        catch (ClassNotFoundException | NoSuchFieldException ignore) {
            return false;
        }
        try {
            Class<?> c = Class.forName("sun.misc.Unsafe");
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(c, MethodHandles.lookup());
            VarHandle handle = lookup.findStaticVarHandle(c, "theUnsafe", c);
            Object theUnsafe = handle.get();
            MethodHandle mh = lookup.findVirtual(c, "staticFieldBase", MethodType.methodType(Object.class, Field.class));
            mh = mh.asType(mh.type().changeParameterType(0, Object.class));
            Object base = mh.invokeExact(theUnsafe, f);
            mh = lookup.findVirtual(c, "staticFieldOffset", MethodType.methodType(Long.TYPE, Field.class));
            mh = mh.asType(mh.type().changeParameterType(0, Object.class));
            long offset = mh.invokeExact(theUnsafe, f);
            mh = lookup.findVirtual(c, "getObject", MethodType.methodType(Object.class, Object.class, Long.TYPE));
            mh = mh.asType(mh.type().changeParameterType(0, Object.class));
            Object callers = mh.invokeExact(theUnsafe, base, offset);
            if (Map.class.isAssignableFrom(callers.getClass())) {
                Map map = (Map)Map.class.cast(callers);
                map.put(Security.class, true);
                return true;
            }
        }
        catch (Throwable t) {
            throw new ElasticsearchException(t);
        }
        return false;
    }

    @SuppressForbidden(reason="access violation required")
    private static Field getDeclaredField(Class<?> c, String name) throws NoSuchFieldException {
        return c.getDeclaredField(name);
    }

    static List<FilePermission> toFilePermissions(Permissions permissions) {
        return permissions.elementsAsStream().map(p -> {
            if (!(p instanceof FilePermission)) {
                throw new AssertionError((Object)("[" + p + "] was not a file permission"));
            }
            return (FilePermission)p;
        }).toList();
    }

    static {
        Security.prepopulateSecurityCaller();
    }
}

