/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.bootstrap.PolicyUtil;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.SuppressForbidden;

final class ESPolicy
extends Policy {
    static final String POLICY_RESOURCE = "security.policy";
    static final String UNTRUSTED_RESOURCE = "untrusted.policy";
    private static final String ALL_FILE_MASK = "read,readlink,write,delete,execute";
    final Policy template;
    final Policy untrusted;
    final Policy system;
    final PermissionCollection dynamic;
    final PermissionCollection dataPathPermission;
    final Map<URL, Policy> plugins;
    final PermissionCollection allSecuredFiles;
    final Map<FilePermission, Set<URL>> securedFiles;
    private static final Permission BAD_DEFAULT_NUMBER_ONE = new BadDefaultPermission(new RuntimePermission("stopThread"), Predicates.always());
    private static final Permission BAD_DEFAULT_NUMBER_TWO = new BadDefaultPermission(new SocketPermission("localhost:0", "listen"), p -> p instanceof SocketPermission && p.getActions().contains("listen"));

    @SuppressForbidden(reason="Need to access and check file permissions directly")
    ESPolicy(Policy template, PermissionCollection dynamic, Map<URL, Policy> plugins, boolean filterBadDefaults, List<FilePermission> dataPathPermissions, Map<String, Set<URL>> securedFiles) {
        this.template = template;
        this.dataPathPermission = ESPolicy.createPermission(dataPathPermissions);
        this.untrusted = PolicyUtil.readPolicy(this.getClass().getResource(UNTRUSTED_RESOURCE), Collections.emptyMap());
        this.system = filterBadDefaults ? new SystemPolicy(Policy.getPolicy()) : Policy.getPolicy();
        this.dynamic = dynamic;
        this.plugins = plugins;
        this.securedFiles = securedFiles.entrySet().stream().collect(Collectors.toUnmodifiableMap(e -> new FilePermission((String)e.getKey(), ALL_FILE_MASK), e -> Set.copyOf((Collection)e.getValue())));
        this.allSecuredFiles = ESPolicy.createPermission(this.securedFiles.keySet());
    }

    private static PermissionCollection createPermission(Collection<FilePermission> permissions) {
        PermissionCollection coll;
        Iterator<FilePermission> it = permissions.iterator();
        if (!it.hasNext()) {
            coll = new Permissions();
        } else {
            Permission p = it.next();
            coll = p.newPermissionCollection();
            coll.add(p);
            it.forEachRemaining(coll::add);
        }
        coll.setReadOnly();
        return coll;
    }

    private static PermissionCollection createPermission(List<FilePermission> permissions) {
        PermissionCollection coll = null;
        for (FilePermission permission : permissions) {
            if (coll == null) {
                coll = permission.newPermissionCollection();
            }
            coll.add(permission);
        }
        if (coll == null) {
            coll = new Permissions();
        }
        coll.setReadOnly();
        return coll;
    }

    @Override
    @SuppressForbidden(reason="fast equals check is desired")
    public boolean implies(ProtectionDomain domain, Permission permission) {
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource == null) {
            return false;
        }
        URL location = codeSource.getLocation();
        if (this.allSecuredFiles.implies(permission)) {
            return this.canAccessSecuredFile(location, new FilePermission(permission.getName(), ALL_FILE_MASK));
        }
        if (location != null) {
            if ("/untrusted".equals(location.getFile())) {
                return this.untrusted.implies(domain, permission);
            }
            Policy plugin = this.plugins.get(location);
            if (plugin != null && plugin.implies(domain, permission)) {
                return true;
            }
        }
        if (this.dataPathPermission.implies(permission)) {
            return true;
        }
        if (permission instanceof FilePermission && "<<ALL FILES>>".equals(permission.getName())) {
            ESPolicy.hadoopHack();
        }
        return this.template.implies(domain, permission) || this.dynamic.implies(permission) || this.system.implies(domain, permission);
    }

    @SuppressForbidden(reason="We get given an URL by the security infrastructure")
    private boolean canAccessSecuredFile(URL location, FilePermission permission) {
        if (location == null) {
            return false;
        }
        Set<URL> accessibleSources = this.securedFiles.get(permission);
        if (accessibleSources != null) {
            return accessibleSources.contains(location);
        }
        return this.securedFiles.entrySet().stream().filter(e -> ((FilePermission)e.getKey()).implies(permission)).anyMatch(e -> ((Set)e.getValue()).contains(location));
    }

    private static void hadoopHack() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!"org.apache.hadoop.util.Shell".equals(element.getClassName()) || !"runCommand".equals(element.getMethodName())) continue;
            ESPolicy.rethrow(new IOException("no hadoop, you cannot do this."));
        }
    }

    private static void rethrow(Throwable t) {
        new Rethrower().rethrow(t);
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!"sun.rmi.server.LoaderHandler".equals(element.getClassName()) || !"loadClass".equals(element.getMethodName())) continue;
            return new Permissions();
        }
        return super.getPermissions(codesource);
    }

    static class SystemPolicy
    extends Policy {
        final Policy delegate;

        SystemPolicy(Policy delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean implies(ProtectionDomain domain, Permission permission) {
            if (BAD_DEFAULT_NUMBER_ONE.implies(permission) || BAD_DEFAULT_NUMBER_TWO.implies(permission)) {
                return false;
            }
            return this.delegate.implies(domain, permission);
        }
    }

    private static class Rethrower<T extends Throwable> {
        private Rethrower() {
        }

        private void rethrow(Throwable t) throws T {
            throw t;
        }
    }

    private static class BadDefaultPermission
    extends Permission {
        private final Permission badDefaultPermission;
        private final Predicate<Permission> preImplies;

        BadDefaultPermission(Permission badDefaultPermission, Predicate<Permission> preImplies) {
            super(badDefaultPermission.getName());
            this.badDefaultPermission = badDefaultPermission;
            this.preImplies = preImplies;
        }

        @Override
        public final boolean implies(Permission permission) {
            return this.preImplies.test(permission) && this.badDefaultPermission.implies(permission);
        }

        @Override
        public final boolean equals(Object obj) {
            return this.badDefaultPermission.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.badDefaultPermission.hashCode();
        }

        @Override
        public String getActions() {
            return this.badDefaultPermission.getActions();
        }
    }
}

