/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.synonyms.GetSynonymRuleAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.synonyms.SynonymsManagementAPIService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetSynonymRuleAction
extends HandledTransportAction<GetSynonymRuleAction.Request, GetSynonymRuleAction.Response> {
    private final SynonymsManagementAPIService synonymsManagementAPIService;

    @Inject
    public TransportGetSynonymRuleAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/synonym_rules/get", transportService, actionFilters, GetSynonymRuleAction.Request::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.synonymsManagementAPIService = new SynonymsManagementAPIService(client);
    }

    @Override
    protected void doExecute(Task task, GetSynonymRuleAction.Request request, ActionListener<GetSynonymRuleAction.Response> listener) {
        this.synonymsManagementAPIService.getSynonymRule(request.synonymsSetId(), request.synonymRuleId(), listener.map(GetSynonymRuleAction.Response::new));
    }
}

