/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.ResolvedIndices;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import org.elasticsearch.action.admin.cluster.shards.TransportClusterSearchShardsAction;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.CCSSingleCoordinatorSearchProgressListener;
import org.elasticsearch.action.search.CanMatchPreFilterSearchPhase;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.action.search.SearchContextIdForNode;
import org.elasticsearch.action.search.SearchDfsQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchResponseMerger;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchShardsGroup;
import org.elasticsearch.action.search.SearchShardsRequest;
import org.elasticsearch.action.search.SearchShardsResponse;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportAPMMetrics;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.search.TransportSearchShardsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.rest.action.search.SearchResponseMetrics;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.profile.SearchProfileShardResult;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentFactory;

public class TransportSearchAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    public static final String NAME = "indices:data/read/search";
    public static final ActionType<SearchResponse> TYPE = new ActionType("indices:data/read/search");
    public static final RemoteClusterActionType<SearchResponse> REMOTE_TYPE = new RemoteClusterActionType<SearchResponse>("indices:data/read/search", SearchResponse::new);
    private static final Logger logger = LogManager.getLogger(TransportSearchAction.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(TransportSearchAction.class);
    public static final String FROZEN_INDICES_DEPRECATION_MESSAGE = "Searching frozen indices [{}] is deprecated. Consider cold or frozen tiers in place of frozen indices. The frozen feature will be removed in a feature release.";
    public static final Setting<Long> SHARD_COUNT_LIMIT_SETTING = Setting.longSetting("action.search.shard_count.limit", Long.MAX_VALUE, 1L, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> DEFAULT_PRE_FILTER_SHARD_SIZE = Setting.intSetting("action.search.pre_filter_shard_size.default", 128, 1, Setting.Property.NodeScope);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final SearchTransportService searchTransportService;
    private final RemoteClusterService remoteClusterService;
    private final SearchPhaseController searchPhaseController;
    private final SearchService searchService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final CircuitBreaker circuitBreaker;
    private final ExecutorSelector executorSelector;
    private final int defaultPreFilterShardSize;
    private final boolean ccsCheckCompatibility;
    private final SearchResponseMetrics searchResponseMetrics;
    private final Client client;

    @Inject
    public TransportSearchAction(ThreadPool threadPool, CircuitBreakerService circuitBreakerService, TransportService transportService, SearchService searchService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedWriteableRegistry namedWriteableRegistry, ExecutorSelector executorSelector, SearchTransportAPMMetrics searchTransportMetrics, SearchResponseMetrics searchResponseMetrics, Client client) {
        super(TYPE.name(), transportService, actionFilters, SearchRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.circuitBreaker = circuitBreakerService.getBreaker("request");
        this.searchPhaseController = searchPhaseController;
        this.searchTransportService = searchTransportService;
        this.remoteClusterService = searchTransportService.getRemoteClusterService();
        SearchTransportService.registerRequestHandler(transportService, searchService, searchTransportMetrics);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.searchService = searchService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.executorSelector = executorSelector;
        this.defaultPreFilterShardSize = DEFAULT_PRE_FILTER_SHARD_SIZE.get(clusterService.getSettings());
        this.ccsCheckCompatibility = SearchService.CCS_VERSION_CHECK_SETTING.get(clusterService.getSettings());
        this.searchResponseMetrics = searchResponseMetrics;
        this.client = client;
    }

    private Map<String, OriginalIndices> buildPerIndexOriginalIndices(ClusterState clusterState, Set<String> indicesAndAliases, String[] indices, IndicesOptions indicesOptions) {
        HashMap<String, OriginalIndices> res = new HashMap<String, OriginalIndices>();
        for (String index : indices) {
            clusterState.blocks().indexBlockedRaiseException(ClusterBlockLevel.READ, index);
            String[] aliases = this.indexNameExpressionResolver.indexAliases(clusterState, index, Predicates.always(), Predicates.always(), true, indicesAndAliases);
            BooleanSupplier hasDataStreamRef = () -> {
                IndexAbstraction ret = (IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(index);
                if (ret == null || ret.getParentDataStream() == null) {
                    return false;
                }
                return indicesAndAliases.contains(ret.getParentDataStream().getName());
            };
            ArrayList<String> finalIndices = new ArrayList<String>();
            if (aliases == null || aliases.length == 0 || indicesAndAliases.contains(index) || hasDataStreamRef.getAsBoolean()) {
                finalIndices.add(index);
            }
            if (aliases != null) {
                finalIndices.addAll(Arrays.asList(aliases));
            }
            res.put(index, new OriginalIndices((String[])finalIndices.toArray(String[]::new), indicesOptions));
        }
        return Collections.unmodifiableMap(res);
    }

    Map<String, AliasFilter> buildIndexAliasFilters(ClusterState clusterState, Set<String> indicesAndAliases, Index[] concreteIndices) {
        HashMap<String, AliasFilter> aliasFilterMap = new HashMap<String, AliasFilter>();
        for (Index index : concreteIndices) {
            clusterState.blocks().indexBlockedRaiseException(ClusterBlockLevel.READ, index.getName());
            AliasFilter aliasFilter = this.searchService.buildAliasFilter(clusterState, index.getName(), indicesAndAliases);
            assert (aliasFilter != null);
            aliasFilterMap.put(index.getUUID(), aliasFilter);
        }
        return aliasFilterMap;
    }

    private Map<String, Float> resolveIndexBoosts(SearchRequest searchRequest, ClusterState clusterState) {
        if (searchRequest.source() == null) {
            return Collections.emptyMap();
        }
        SearchSourceBuilder source = searchRequest.source();
        if (source.indexBoosts() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Float> concreteIndexBoosts = new HashMap<String, Float>();
        for (SearchSourceBuilder.IndexBoost ib : source.indexBoosts()) {
            Index[] concreteIndices;
            for (Index concreteIndex : concreteIndices = this.indexNameExpressionResolver.concreteIndices(clusterState, searchRequest.indicesOptions(), ib.getIndex())) {
                concreteIndexBoosts.putIfAbsent(concreteIndex.getUUID(), Float.valueOf(ib.getBoost()));
            }
        }
        return Collections.unmodifiableMap(concreteIndexBoosts);
    }

    @Override
    protected void doExecute(Task task, SearchRequest searchRequest, final ActionListener<SearchResponse> listener) {
        ActionListener<SearchResponse> loggingAndMetrics = new ActionListener<SearchResponse>(){

            @Override
            public void onResponse(SearchResponse searchResponse) {
                try {
                    TransportSearchAction.this.searchResponseMetrics.recordTookTime(searchResponse.getTookInMillis());
                    SearchResponseMetrics.ResponseCountTotalStatus responseCountTotalStatus = SearchResponseMetrics.ResponseCountTotalStatus.SUCCESS;
                    if (searchResponse.getShardFailures() != null && searchResponse.getShardFailures().length > 0) {
                        ShardOperationFailedException[] groupedFailures;
                        for (ShardOperationFailedException f : groupedFailures = ExceptionsHelper.groupBy(searchResponse.getShardFailures())) {
                            boolean causeHas500Status = false;
                            if (f.getCause() != null) {
                                boolean bl = causeHas500Status = ExceptionsHelper.status(f.getCause()).getStatus() >= 500;
                            }
                            if (f.status().getStatus() < 500 && !causeHas500Status || ExceptionsHelper.isNodeOrShardUnavailableTypeException(f.getCause())) continue;
                            logger.warn("TransportSearchAction shard failure (partial results response)", (Throwable)f);
                            responseCountTotalStatus = SearchResponseMetrics.ResponseCountTotalStatus.PARTIAL_FAILURE;
                        }
                    }
                    listener.onResponse(searchResponse);
                    TransportSearchAction.this.searchResponseMetrics.incrementResponseCount(responseCountTotalStatus);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                TransportSearchAction.this.searchResponseMetrics.incrementResponseCount(SearchResponseMetrics.ResponseCountTotalStatus.FAILURE);
                listener.onFailure(e);
            }
        };
        this.executeRequest((SearchTask)task, searchRequest, loggingAndMetrics, x$0 -> new AsyncSearchActionProvider((ActionListener<SearchResponse>)x$0));
    }

    void executeRequest(SearchTask task, SearchRequest original, ActionListener<SearchResponse> listener, Function<ActionListener<SearchResponse>, SearchPhaseProvider> searchPhaseProvider) {
        ResolvedIndices resolvedIndices;
        long relativeStartNanos = System.nanoTime();
        SearchTimeProvider timeProvider = new SearchTimeProvider(original.getOrCreateAbsoluteStartMillis(), relativeStartNanos, System::nanoTime);
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        if (original.pointInTimeBuilder() != null) {
            resolvedIndices = ResolvedIndices.resolveWithPIT(original.pointInTimeBuilder(), original.indicesOptions(), clusterState, this.namedWriteableRegistry);
        } else {
            resolvedIndices = ResolvedIndices.resolveWithIndicesRequest(original, clusterState, this.indexNameExpressionResolver, this.remoteClusterService, timeProvider.absoluteStartMillis());
            this.frozenIndexCheck(resolvedIndices);
        }
        ActionListener<SearchRequest> rewriteListener = listener.delegateFailureAndWrap((delegate, rewritten) -> {
            if (this.ccsCheckCompatibility) {
                TransportSearchHelper.checkCCSVersionCompatibility(rewritten);
            }
            if (resolvedIndices.getRemoteClusterIndices().isEmpty()) {
                this.executeLocalSearch(task, timeProvider, (SearchRequest)rewritten, resolvedIndices, clusterState, SearchResponse.Clusters.EMPTY, (SearchPhaseProvider)searchPhaseProvider.apply((ActionListener<SearchResponse>)delegate));
            } else {
                TaskId parentTaskId = task.taskInfo(this.clusterService.localNode().getId(), false).taskId();
                if (TransportSearchAction.shouldMinimizeRoundtrips(rewritten)) {
                    AggregationReduceContext.Builder aggregationReduceContextBuilder = rewritten.source() != null && rewritten.source().aggregations() != null ? this.searchService.aggReduceContextBuilder(task::isCancelled, rewritten.source().aggregations()) : null;
                    SearchResponse.Clusters clusters = new SearchResponse.Clusters(resolvedIndices.getLocalIndices(), resolvedIndices.getRemoteClusterIndices(), true, this.remoteClusterService::isSkipUnavailable);
                    if (resolvedIndices.getLocalIndices() == null) {
                        task.getProgressListener().notifyListShards(Collections.emptyList(), Collections.emptyList(), clusters, false, timeProvider);
                    }
                    TransportSearchAction.ccsRemoteReduce(task, parentTaskId, rewritten, resolvedIndices, clusters, timeProvider, aggregationReduceContextBuilder, this.remoteClusterService, this.threadPool, delegate, (r, l) -> this.executeLocalSearch(task, timeProvider, (SearchRequest)r, resolvedIndices, clusterState, clusters, (SearchPhaseProvider)searchPhaseProvider.apply((ActionListener<SearchResponse>)l)));
                } else {
                    SearchContextId searchContext = resolvedIndices.getSearchContextId();
                    SearchResponse.Clusters clusters = new SearchResponse.Clusters(resolvedIndices.getLocalIndices(), resolvedIndices.getRemoteClusterIndices(), false, this.remoteClusterService::isSkipUnavailable);
                    TransportSearchAction.collectSearchShards(rewritten.indicesOptions(), rewritten.preference(), rewritten.routing(), rewritten.source() != null ? rewritten.source().query() : null, Objects.requireNonNullElse(rewritten.allowPartialSearchResults(), this.searchService.defaultAllowPartialSearchResults()), searchContext, resolvedIndices.getRemoteClusterIndices(), clusters, timeProvider, this.transportService, delegate.delegateFailureAndWrap((finalDelegate, searchShardsResponses) -> {
                        List<SearchShardIterator> remoteShardIterators;
                        Map<String, AliasFilter> remoteAliasFilters;
                        BiFunction<String, String, DiscoveryNode> clusterNodeLookup = TransportSearchAction.getRemoteClusterNodeLookup(searchShardsResponses);
                        if (searchContext != null) {
                            remoteAliasFilters = searchContext.aliasFilter();
                            remoteShardIterators = TransportSearchAction.getRemoteShardsIteratorFromPointInTime(searchShardsResponses, searchContext, rewritten.pointInTimeBuilder().getKeepAlive(), resolvedIndices.getRemoteClusterIndices());
                        } else {
                            remoteAliasFilters = new HashMap<String, AliasFilter>();
                            for (SearchShardsResponse searchShardsResponse : searchShardsResponses.values()) {
                                remoteAliasFilters.putAll(searchShardsResponse.getAliasFilters());
                            }
                            remoteShardIterators = TransportSearchAction.getRemoteShardsIterator(searchShardsResponses, resolvedIndices.getRemoteClusterIndices(), remoteAliasFilters);
                        }
                        this.executeSearch(task, timeProvider, (SearchRequest)rewritten, resolvedIndices, remoteShardIterators, clusterNodeLookup, clusterState, remoteAliasFilters, clusters, (SearchPhaseProvider)searchPhaseProvider.apply((ActionListener<SearchResponse>)finalDelegate));
                    }));
                }
            }
        });
        Rewriteable.rewriteAndFetch(original, this.searchService.getRewriteContext(timeProvider::absoluteStartMillis, resolvedIndices), rewriteListener);
    }

    static void adjustSearchType(SearchRequest searchRequest, boolean singleShard) {
        if (searchRequest.hasKnnSearch()) {
            searchRequest.searchType(SearchType.DFS_QUERY_THEN_FETCH);
            return;
        }
        if (searchRequest.isSuggestOnly()) {
            searchRequest.requestCache(false);
            searchRequest.searchType(SearchType.QUERY_THEN_FETCH);
            return;
        }
        if (singleShard) {
            searchRequest.searchType(SearchType.QUERY_THEN_FETCH);
        }
    }

    public static boolean shouldMinimizeRoundtrips(SearchRequest searchRequest) {
        if (!searchRequest.isCcsMinimizeRoundtrips()) {
            return false;
        }
        if (searchRequest.scroll() != null) {
            return false;
        }
        if (searchRequest.pointInTimeBuilder() != null) {
            return false;
        }
        if (searchRequest.searchType() == SearchType.DFS_QUERY_THEN_FETCH) {
            return false;
        }
        if (searchRequest.hasKnnSearch()) {
            return false;
        }
        SearchSourceBuilder source = searchRequest.source();
        return source == null || source.collapse() == null || source.collapse().getInnerHits() == null || source.collapse().getInnerHits().isEmpty();
    }

    static void ccsRemoteReduce(SearchTask task, TaskId parentTaskId, SearchRequest searchRequest, ResolvedIndices resolvedIndices, final SearchResponse.Clusters clusters, final SearchTimeProvider timeProvider, AggregationReduceContext.Builder aggReduceContextBuilder, RemoteClusterService remoteClusterService, ThreadPool threadPool, final ActionListener<SearchResponse> listener, BiConsumer<SearchRequest, ActionListener<SearchResponse>> localSearchConsumer) {
        ExecutorService remoteClientResponseExecutor = threadPool.executor("search_coordination");
        if (resolvedIndices.getLocalIndices() == null && resolvedIndices.getRemoteClusterIndices().size() == 1) {
            Map.Entry<String, OriginalIndices> entry = resolvedIndices.getRemoteClusterIndices().entrySet().iterator().next();
            final String clusterAlias = entry.getKey();
            final boolean skipUnavailable = remoteClusterService.isSkipUnavailable(clusterAlias);
            OriginalIndices indices = entry.getValue();
            SearchRequest ccsSearchRequest = SearchRequest.subSearchRequest(parentTaskId, searchRequest, indices.indices(), clusterAlias, timeProvider.absoluteStartMillis(), true);
            RemoteClusterClient remoteClusterClient = remoteClusterService.getRemoteClusterClient(clusterAlias, remoteClientResponseExecutor, RemoteClusterService.DisconnectedStrategy.RECONNECT_UNLESS_SKIP_UNAVAILABLE);
            remoteClusterClient.execute(REMOTE_TYPE, ccsSearchRequest, new ActionListener<SearchResponse>(){

                @Override
                public void onResponse(SearchResponse searchResponse) {
                    TransportSearchAction.ccsClusterInfoUpdate(searchResponse, clusters, clusterAlias, skipUnavailable);
                    Map<String, SearchProfileShardResult> profileResults = searchResponse.getProfileResults();
                    SearchProfileResults profile = profileResults == null || profileResults.isEmpty() ? null : new SearchProfileResults(profileResults);
                    ActionListener.respondAndRelease(listener, new SearchResponse(searchResponse.getHits(), searchResponse.getAggregations(), searchResponse.getSuggest(), searchResponse.isTimedOut(), searchResponse.isTerminatedEarly(), profile, searchResponse.getNumReducePhases(), searchResponse.getScrollId(), searchResponse.getTotalShards(), searchResponse.getSuccessfulShards(), searchResponse.getSkippedShards(), timeProvider.buildTookInMillis(), searchResponse.getShardFailures(), clusters, searchResponse.pointInTimeId()));
                }

                @Override
                public void onFailure(Exception e) {
                    ShardSearchFailure failure = new ShardSearchFailure(e);
                    TransportSearchAction.logCCSError(failure, clusterAlias, skipUnavailable);
                    TransportSearchAction.ccsClusterInfoUpdate(failure, clusters, clusterAlias, skipUnavailable);
                    if (skipUnavailable) {
                        ActionListener.respondAndRelease(listener, SearchResponse.empty(timeProvider::buildTookInMillis, clusters));
                    } else {
                        listener.onFailure(TransportSearchAction.wrapRemoteClusterFailure(clusterAlias, e));
                    }
                }
            });
        } else {
            SearchResponseMerger searchResponseMerger = TransportSearchAction.createSearchResponseMerger(searchRequest.source(), timeProvider, aggReduceContextBuilder);
            task.setSearchResponseMergerSupplier(() -> TransportSearchAction.createSearchResponseMerger(searchRequest.source(), timeProvider, aggReduceContextBuilder));
            AtomicReference<Exception> exceptions = new AtomicReference<Exception>();
            int totalClusters = resolvedIndices.getRemoteClusterIndices().size() + (resolvedIndices.getLocalIndices() == null ? 0 : 1);
            CountDown countDown = new CountDown(totalClusters);
            for (Map.Entry<String, OriginalIndices> entry : resolvedIndices.getRemoteClusterIndices().entrySet()) {
                String clusterAlias = entry.getKey();
                boolean skipUnavailable = remoteClusterService.isSkipUnavailable(clusterAlias);
                OriginalIndices indices = entry.getValue();
                SearchRequest ccsSearchRequest = SearchRequest.subSearchRequest(parentTaskId, searchRequest, indices.indices(), clusterAlias, timeProvider.absoluteStartMillis(), false);
                ActionListener<SearchResponse> ccsListener = TransportSearchAction.createCCSListener(clusterAlias, skipUnavailable, countDown, exceptions, searchResponseMerger, clusters, task.getProgressListener(), listener);
                RemoteClusterClient remoteClusterClient = remoteClusterService.getRemoteClusterClient(clusterAlias, remoteClientResponseExecutor, RemoteClusterService.DisconnectedStrategy.RECONNECT_UNLESS_SKIP_UNAVAILABLE);
                remoteClusterClient.execute(REMOTE_TYPE, ccsSearchRequest, ccsListener);
            }
            if (resolvedIndices.getLocalIndices() != null) {
                ActionListener<SearchResponse> ccsListener = TransportSearchAction.createCCSListener("", false, countDown, exceptions, searchResponseMerger, clusters, task.getProgressListener(), listener);
                SearchRequest ccsLocalSearchRequest = SearchRequest.subSearchRequest(parentTaskId, searchRequest, resolvedIndices.getLocalIndices().indices(), "", timeProvider.absoluteStartMillis(), false);
                localSearchConsumer.accept(ccsLocalSearchRequest, ccsListener);
            }
        }
    }

    static SearchResponseMerger createSearchResponseMerger(SearchSourceBuilder source, SearchTimeProvider timeProvider, AggregationReduceContext.Builder aggReduceContextBuilder) {
        int trackTotalHitsUpTo;
        int size;
        int from;
        if (source == null) {
            from = 0;
            size = 10;
            trackTotalHitsUpTo = 10000;
        } else {
            from = source.from() == -1 ? 0 : source.from();
            size = source.size() == -1 ? 10 : source.size();
            trackTotalHitsUpTo = source.trackTotalHitsUpTo() == null ? 10000 : source.trackTotalHitsUpTo();
            source.from(0);
            source.size(from + size);
        }
        return new SearchResponseMerger(from, size, trackTotalHitsUpTo, timeProvider, aggReduceContextBuilder);
    }

    static void collectSearchShards(IndicesOptions indicesOptions, String preference, String routing, QueryBuilder query, boolean allowPartialResults, SearchContextId searchContext, Map<String, OriginalIndices> remoteIndicesByCluster, SearchResponse.Clusters clusters, final SearchTimeProvider timeProvider, TransportService transportService, ActionListener<Map<String, SearchShardsResponse>> listener) {
        RemoteClusterService remoteClusterService = transportService.getRemoteClusterService();
        CountDown responsesCountDown = new CountDown(remoteIndicesByCluster.size());
        final ConcurrentHashMap searchShardsResponses = new ConcurrentHashMap();
        AtomicReference exceptions = new AtomicReference();
        for (Map.Entry<String, OriginalIndices> entry : remoteIndicesByCluster.entrySet()) {
            String clusterAlias = entry.getKey();
            boolean skipUnavailable = remoteClusterService.isSkipUnavailable(clusterAlias);
            CCSActionListener<SearchShardsResponse, Map<String, SearchShardsResponse>> singleListener = new CCSActionListener<SearchShardsResponse, Map<String, SearchShardsResponse>>(clusterAlias, skipUnavailable, responsesCountDown, exceptions, clusters, listener){

                @Override
                void innerOnResponse(SearchShardsResponse searchShardsResponse) {
                    assert (ThreadPool.assertCurrentThreadPool("search_coordination"));
                    TransportSearchAction.ccsClusterInfoUpdate(searchShardsResponse, this.clusters, this.clusterAlias, timeProvider);
                    searchShardsResponses.put(this.clusterAlias, searchShardsResponse);
                }

                @Override
                Map<String, SearchShardsResponse> createFinalResponse() {
                    return searchShardsResponses;
                }
            };
            remoteClusterService.maybeEnsureConnectedAndGetConnection(clusterAlias, !skipUnavailable, singleListener.delegateFailureAndWrap((delegate, connection) -> {
                String[] indices = ((OriginalIndices)entry.getValue()).indices();
                ExecutorService responseExecutor = transportService.getThreadPool().executor("search_coordination");
                if (searchContext == null && connection.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
                    SearchShardsRequest searchShardsRequest = new SearchShardsRequest(indices, indicesOptions, query, routing, preference, allowPartialResults, clusterAlias);
                    transportService.sendRequest((Transport.Connection)connection, TransportSearchShardsAction.TYPE.name(), (TransportRequest)searchShardsRequest, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchShardsResponse>((ActionListener<SearchShardsResponse>)delegate, SearchShardsResponse::new, responseExecutor));
                } else {
                    ClusterSearchShardsRequest searchShardsRequest = ((ClusterSearchShardsRequest)new ClusterSearchShardsRequest(indices).indicesOptions(indicesOptions).local(true)).preference(preference).routing(routing);
                    transportService.sendRequest((Transport.Connection)connection, TransportClusterSearchShardsAction.TYPE.name(), (TransportRequest)searchShardsRequest, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<ClusterSearchShardsResponse>(delegate.map(SearchShardsResponse::fromLegacyResponse), ClusterSearchShardsResponse::new, responseExecutor));
                }
            }));
        }
    }

    private static ActionListener<SearchResponse> createCCSListener(String clusterAlias, boolean skipUnavailable, CountDown countDown, AtomicReference<Exception> exceptions, final SearchResponseMerger searchResponseMerger, SearchResponse.Clusters clusters, final SearchProgressListener progressListener, ActionListener<SearchResponse> originalListener) {
        return new CCSActionListener<SearchResponse, SearchResponse>(clusterAlias, skipUnavailable, countDown, exceptions, clusters, ActionListener.releaseAfter(originalListener, searchResponseMerger)){

            @Override
            void innerOnResponse(SearchResponse searchResponse) {
                TransportSearchAction.ccsClusterInfoUpdate(searchResponse, this.clusters, this.clusterAlias, this.skipUnavailable);
                searchResponseMerger.add(searchResponse);
                progressListener.notifyClusterResponseMinimizeRoundtrips(this.clusterAlias, searchResponse);
            }

            @Override
            SearchResponse createFinalResponse() {
                return searchResponseMerger.getMergedResponse(this.clusters);
            }

            @Override
            protected void releaseResponse(SearchResponse searchResponse) {
                searchResponse.decRef();
            }
        };
    }

    static void ccsClusterInfoUpdate(ShardSearchFailure failure, SearchResponse.Clusters clusters, String clusterAlias, boolean skipUnavailable) {
        clusters.swapCluster(clusterAlias, (k, v) -> {
            SearchResponse.Cluster.Status status = skipUnavailable ? SearchResponse.Cluster.Status.SKIPPED : SearchResponse.Cluster.Status.FAILED;
            return new SearchResponse.Cluster.Builder((SearchResponse.Cluster)v).setStatus(status).setFailures(CollectionUtils.appendToCopy(v.getFailures(), failure)).build();
        });
    }

    private static void ccsClusterInfoUpdate(SearchResponse searchResponse, SearchResponse.Clusters clusters, String clusterAlias, boolean skipUnavailable) {
        clusters.swapCluster(clusterAlias, (k, v) -> {
            int totalShards = searchResponse.getTotalShards();
            SearchResponse.Cluster.Status status = totalShards > 0 && searchResponse.getFailedShards() >= totalShards ? (skipUnavailable ? SearchResponse.Cluster.Status.SKIPPED : SearchResponse.Cluster.Status.FAILED) : (searchResponse.isTimedOut() ? SearchResponse.Cluster.Status.PARTIAL : (searchResponse.getFailedShards() > 0 ? SearchResponse.Cluster.Status.PARTIAL : SearchResponse.Cluster.Status.SUCCESSFUL));
            return new SearchResponse.Cluster.Builder((SearchResponse.Cluster)v).setStatus(status).setTotalShards(totalShards).setSuccessfulShards(searchResponse.getSuccessfulShards()).setSkippedShards(searchResponse.getSkippedShards()).setFailedShards(searchResponse.getFailedShards()).setFailures(Arrays.asList(searchResponse.getShardFailures())).setTook(searchResponse.getTook()).setTimedOut(searchResponse.isTimedOut()).build();
        });
    }

    private static void ccsClusterInfoUpdate(SearchShardsResponse response, SearchResponse.Clusters clusters, String clusterAlias, SearchTimeProvider timeProvider) {
        if (response.getGroups().isEmpty()) {
            clusters.swapCluster(clusterAlias, (k, v) -> new SearchResponse.Cluster.Builder((SearchResponse.Cluster)v).setStatus(SearchResponse.Cluster.Status.SUCCESSFUL).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0).setFailures(Collections.emptyList()).setTook(new TimeValue(timeProvider.buildTookInMillis())).setTimedOut(false).build());
        }
    }

    void executeLocalSearch(Task task, SearchTimeProvider timeProvider, SearchRequest searchRequest, ResolvedIndices resolvedIndices, ClusterState clusterState, SearchResponse.Clusters clusterInfo, SearchPhaseProvider searchPhaseProvider) {
        this.executeSearch((SearchTask)task, timeProvider, searchRequest, resolvedIndices, Collections.emptyList(), (clusterName, nodeId) -> null, clusterState, Collections.emptyMap(), clusterInfo, searchPhaseProvider);
    }

    static BiFunction<String, String, DiscoveryNode> getRemoteClusterNodeLookup(Map<String, SearchShardsResponse> searchShardsResp) {
        HashMap<String, Map> clusterToNode = new HashMap<String, Map>();
        for (Map.Entry<String, SearchShardsResponse> entry : searchShardsResp.entrySet()) {
            String clusterAlias2 = entry.getKey();
            for (DiscoveryNode remoteNode : entry.getValue().getNodes()) {
                clusterToNode.computeIfAbsent(clusterAlias2, k -> new HashMap()).put(remoteNode.getId(), remoteNode);
            }
        }
        return (clusterAlias, nodeId) -> {
            Map clusterNodes = (Map)clusterToNode.get(clusterAlias);
            if (clusterNodes == null) {
                throw new IllegalArgumentException("unknown remote cluster: " + clusterAlias);
            }
            return (DiscoveryNode)clusterNodes.get(nodeId);
        };
    }

    static List<SearchShardIterator> getRemoteShardsIterator(Map<String, SearchShardsResponse> searchShardsResponses, Map<String, OriginalIndices> remoteIndicesByCluster, Map<String, AliasFilter> aliasFilterMap) {
        ArrayList<SearchShardIterator> remoteShardIterators = new ArrayList<SearchShardIterator>();
        for (Map.Entry<String, SearchShardsResponse> entry : searchShardsResponses.entrySet()) {
            for (SearchShardsGroup searchShardsGroup : entry.getValue().getGroups()) {
                String[] stringArray;
                ShardId shardId = searchShardsGroup.shardId();
                AliasFilter aliasFilter = aliasFilterMap.get(shardId.getIndex().getUUID());
                String[] aliases = aliasFilter.getAliases();
                String clusterAlias = entry.getKey();
                if (aliases.length == 0) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = shardId.getIndexName();
                } else {
                    stringArray = aliases;
                }
                String[] finalIndices = stringArray;
                OriginalIndices originalIndices = remoteIndicesByCluster.get(clusterAlias);
                assert (originalIndices != null) : "original indices are null for clusterAlias: " + clusterAlias;
                SearchShardIterator shardIterator = new SearchShardIterator(clusterAlias, shardId, searchShardsGroup.allocatedNodes(), new OriginalIndices(finalIndices, originalIndices.indicesOptions()), null, null, searchShardsGroup.preFiltered(), searchShardsGroup.skipped());
                remoteShardIterators.add(shardIterator);
            }
        }
        return remoteShardIterators;
    }

    static List<SearchShardIterator> getRemoteShardsIteratorFromPointInTime(Map<String, SearchShardsResponse> searchShardsResponses, SearchContextId searchContextId, TimeValue searchContextKeepAlive, Map<String, OriginalIndices> remoteClusterIndices) {
        ArrayList<SearchShardIterator> remoteShardIterators = new ArrayList<SearchShardIterator>();
        for (Map.Entry<String, SearchShardsResponse> entry : searchShardsResponses.entrySet()) {
            for (SearchShardsGroup group : entry.getValue().getGroups()) {
                ShardId shardId = group.shardId();
                SearchContextIdForNode perNode = searchContextId.shards().get(shardId);
                if (perNode == null) continue;
                String clusterAlias = entry.getKey();
                assert (clusterAlias.equals(perNode.getClusterAlias())) : clusterAlias + " != " + perNode.getClusterAlias();
                ArrayList<String> targetNodes = new ArrayList<String>(group.allocatedNodes().size());
                targetNodes.add(perNode.getNode());
                if (perNode.getSearchContextId().getSearcherId() != null) {
                    for (String node : group.allocatedNodes()) {
                        if (node.equals(perNode.getNode())) continue;
                        targetNodes.add(node);
                    }
                }
                assert (remoteClusterIndices.get(clusterAlias) != null) : "original indices are null for clusterAlias: " + clusterAlias;
                OriginalIndices finalIndices = new OriginalIndices(new String[]{shardId.getIndexName()}, remoteClusterIndices.get(clusterAlias).indicesOptions());
                SearchShardIterator shardIterator = new SearchShardIterator(clusterAlias, shardId, targetNodes, finalIndices, perNode.getSearchContextId(), searchContextKeepAlive, false, false);
                remoteShardIterators.add(shardIterator);
            }
        }
        assert (TransportSearchAction.checkAllRemotePITShardsWereReturnedBySearchShards(searchContextId.shards(), searchShardsResponses)) : "search shards did not return remote shards that PIT included: " + searchContextId.shards();
        return remoteShardIterators;
    }

    private static boolean checkAllRemotePITShardsWereReturnedBySearchShards(Map<ShardId, SearchContextIdForNode> searchContextIdShards, Map<String, SearchShardsResponse> searchShardsResponses) {
        HashMap<ShardId, SearchContextIdForNode> searchContextIdForNodeMap = new HashMap<ShardId, SearchContextIdForNode>(searchContextIdShards);
        for (SearchShardsResponse searchShardsResponse : searchShardsResponses.values()) {
            for (SearchShardsGroup group : searchShardsResponse.getGroups()) {
                searchContextIdForNodeMap.remove(group.shardId());
            }
        }
        return searchContextIdForNodeMap.values().stream().allMatch(searchContextIdForNode -> searchContextIdForNode.getClusterAlias() == null);
    }

    void frozenIndexCheck(ResolvedIndices resolvedIndices) {
        ArrayList<String> frozenIndices = new ArrayList<String>();
        Map<Index, IndexMetadata> indexMetadataMap = resolvedIndices.getConcreteLocalIndicesMetadata();
        for (Map.Entry<Index, IndexMetadata> entry : indexMetadataMap.entrySet()) {
            if (!entry.getValue().getSettings().getAsBoolean("index.frozen", false).booleanValue()) continue;
            frozenIndices.add(entry.getKey().getName());
        }
        if (!frozenIndices.isEmpty()) {
            DEPRECATION_LOGGER.warn(DeprecationCategory.INDICES, "search-frozen-indices", FROZEN_INDICES_DEPRECATION_MESSAGE, String.join((CharSequence)",", frozenIndices));
        }
    }

    private void executeSearch(SearchTask task, SearchTimeProvider timeProvider, SearchRequest searchRequest, ResolvedIndices resolvedIndices, List<SearchShardIterator> remoteShardIterators, BiFunction<String, String, DiscoveryNode> remoteConnections, ClusterState clusterState, Map<String, AliasFilter> remoteAliasMap, SearchResponse.Clusters clusters, SearchPhaseProvider searchPhaseProvider) {
        List<SearchShardIterator> localShardIterators;
        String[] concreteLocalIndices;
        Map<String, AliasFilter> aliasFilter;
        if (searchRequest.allowPartialSearchResults() == null) {
            searchRequest.allowPartialSearchResults(this.searchService.defaultAllowPartialSearchResults());
        }
        if (resolvedIndices.getSearchContextId() != null) {
            assert (searchRequest.pointInTimeBuilder() != null);
            aliasFilter = resolvedIndices.getSearchContextId().aliasFilter();
            concreteLocalIndices = resolvedIndices.getLocalIndices() == null ? new String[]{} : resolvedIndices.getLocalIndices().indices();
            localShardIterators = TransportSearchAction.getLocalLocalShardsIteratorFromPointInTime(clusterState, searchRequest.indicesOptions(), searchRequest.getLocalClusterAlias(), resolvedIndices.getSearchContextId(), searchRequest.pointInTimeBuilder().getKeepAlive(), searchRequest.allowPartialSearchResults());
        } else {
            Index[] indices = resolvedIndices.getConcreteLocalIndices();
            concreteLocalIndices = (String[])Arrays.stream(indices).map(Index::getName).toArray(String[]::new);
            Set<String> indicesAndAliases = this.indexNameExpressionResolver.resolveExpressions(clusterState, searchRequest.indices());
            aliasFilter = this.buildIndexAliasFilters(clusterState, indicesAndAliases, indices);
            aliasFilter.putAll(remoteAliasMap);
            localShardIterators = this.getLocalShardsIterator(clusterState, searchRequest, searchRequest.getLocalClusterAlias(), indicesAndAliases, concreteLocalIndices);
        }
        GroupShardsIterator<SearchShardIterator> shardIterators = TransportSearchAction.mergeShardsIterators(localShardIterators, remoteShardIterators);
        TransportSearchAction.failIfOverShardCountLimit(this.clusterService, shardIterators.size());
        if (!searchRequest.getWaitForCheckpoints().isEmpty()) {
            if (!remoteShardIterators.isEmpty()) {
                throw new IllegalArgumentException("Cannot use wait_for_checkpoints parameter with cross-cluster searches.");
            }
            TransportSearchAction.validateAndResolveWaitForCheckpoint(clusterState, this.indexNameExpressionResolver, searchRequest, concreteLocalIndices);
        }
        Map<String, Float> concreteIndexBoosts = this.resolveIndexBoosts(searchRequest, clusterState);
        TransportSearchAction.adjustSearchType(searchRequest, shardIterators.size() == 1);
        DiscoveryNodes nodes = clusterState.nodes();
        BiFunction<String, String, Transport.Connection> connectionLookup = TransportSearchAction.buildConnectionLookup(searchRequest.getLocalClusterAlias(), nodes::get, remoteConnections, this.searchTransportService::getConnection);
        Executor asyncSearchExecutor = this.asyncSearchExecutor(concreteLocalIndices);
        boolean preFilterSearchShards = TransportSearchAction.shouldPreFilterSearchShards(clusterState, searchRequest, concreteLocalIndices, localShardIterators.size() + remoteShardIterators.size(), this.defaultPreFilterShardSize);
        searchPhaseProvider.newSearchPhase(task, searchRequest, asyncSearchExecutor, shardIterators, timeProvider, connectionLookup, clusterState, Collections.unmodifiableMap(aliasFilter), concreteIndexBoosts, preFilterSearchShards, this.threadPool, clusters).start();
    }

    Executor asyncSearchExecutor(String[] indices) {
        List<String> executorsForIndices = Arrays.stream(indices).map(this.executorSelector::executorForSearch).toList();
        if (executorsForIndices.size() == 1) {
            return this.threadPool.executor(executorsForIndices.get(0));
        }
        if (executorsForIndices.size() == 2 && executorsForIndices.contains("system_read") && executorsForIndices.contains("system_critical_read")) {
            return this.threadPool.executor("system_read");
        }
        return this.threadPool.executor("search");
    }

    static BiFunction<String, String, Transport.Connection> buildConnectionLookup(String requestClusterAlias, Function<String, DiscoveryNode> localNodes, BiFunction<String, String, DiscoveryNode> remoteNodes, BiFunction<String, DiscoveryNode, Transport.Connection> nodeToConnection) {
        return (clusterAlias, nodeId) -> {
            boolean remoteCluster;
            DiscoveryNode discoveryNode;
            if (clusterAlias == null || requestClusterAlias != null) {
                assert (requestClusterAlias == null || requestClusterAlias.equals(clusterAlias));
                discoveryNode = (DiscoveryNode)localNodes.apply((String)nodeId);
                remoteCluster = false;
            } else {
                discoveryNode = (DiscoveryNode)remoteNodes.apply((String)clusterAlias, (String)nodeId);
                remoteCluster = true;
            }
            if (discoveryNode == null) {
                throw new IllegalStateException("no node found for id: " + nodeId);
            }
            return (Transport.Connection)nodeToConnection.apply(remoteCluster ? clusterAlias : null, discoveryNode);
        };
    }

    static boolean shouldPreFilterSearchShards(ClusterState clusterState, SearchRequest searchRequest, String[] indices, int numShards, int defaultPreFilterShardSize) {
        SearchSourceBuilder source = searchRequest.source();
        Integer preFilterShardSize = searchRequest.getPreFilterShardSize();
        if (preFilterShardSize == null && (TransportSearchAction.hasReadOnlyIndices(indices, clusterState) || FieldSortBuilder.hasPrimaryFieldSort(source))) {
            preFilterShardSize = 1;
        } else if (preFilterShardSize == null) {
            preFilterShardSize = defaultPreFilterShardSize;
        }
        return searchRequest.searchType() == SearchType.QUERY_THEN_FETCH && (SearchService.canRewriteToMatchNone(source) || FieldSortBuilder.hasPrimaryFieldSort(source)) && preFilterShardSize < numShards;
    }

    private static boolean hasReadOnlyIndices(String[] indices, ClusterState clusterState) {
        for (String index : indices) {
            ClusterBlockException writeBlock = clusterState.blocks().indexBlockedException(ClusterBlockLevel.WRITE, index);
            if (writeBlock == null) continue;
            return true;
        }
        return false;
    }

    static GroupShardsIterator<SearchShardIterator> mergeShardsIterators(List<SearchShardIterator> localShardIterators, List<SearchShardIterator> remoteShardIterators) {
        ArrayList<SearchShardIterator> shards = new ArrayList<SearchShardIterator>(remoteShardIterators);
        shards.addAll(localShardIterators);
        return GroupShardsIterator.sortAndCreate(shards);
    }

    private static void validateAndResolveWaitForCheckpoint(ClusterState clusterState, IndexNameExpressionResolver resolver, SearchRequest searchRequest, String[] concreteLocalIndices) {
        HashSet<String> searchedIndices = new HashSet<String>(Arrays.asList(concreteLocalIndices));
        Map<String, long[]> newWaitForCheckpoints = Maps.newMapWithExpectedSize(searchRequest.getWaitForCheckpoints().size());
        for (Map.Entry<String, long[]> waitForCheckpointIndex : searchRequest.getWaitForCheckpoints().entrySet()) {
            Index resolved;
            long[] checkpoints = waitForCheckpointIndex.getValue();
            int checkpointsProvided = checkpoints.length;
            final String target = waitForCheckpointIndex.getKey();
            try {
                resolved = resolver.concreteSingleIndex(clusterState, new IndicesRequest(){

                    @Override
                    public String[] indices() {
                        return new String[]{target};
                    }

                    @Override
                    public IndicesOptions indicesOptions() {
                        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
                    }
                });
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to resolve wait_for_checkpoints target [" + target + "]. Configured target must resolve to a single open index.", e);
            }
            String index = resolved.getName();
            IndexMetadata indexMetadata = clusterState.metadata().index(index);
            if (!searchedIndices.contains(index)) {
                throw new IllegalArgumentException("Target configured with wait_for_checkpoints must be a concrete index resolved in this search. Target [" + target + "] is not a concrete index resolved in this search.");
            }
            if (indexMetadata == null) {
                throw new IllegalArgumentException("Cannot find index configured for wait_for_checkpoints parameter [" + index + "].");
            }
            if (indexMetadata.getNumberOfShards() != checkpointsProvided) {
                throw new IllegalArgumentException("Target configured with wait_for_checkpoints must search the same number of shards as checkpoints provided. [" + checkpointsProvided + "] checkpoints provided. Target [" + target + "] which resolved to index [" + index + "] has [" + indexMetadata.getNumberOfShards() + "] shards.");
            }
            newWaitForCheckpoints.put(index, checkpoints);
        }
        searchRequest.setWaitForCheckpoints(Collections.unmodifiableMap(newWaitForCheckpoints));
    }

    private static void failIfOverShardCountLimit(ClusterService clusterService, int shardCount) {
        long shardCountLimit = clusterService.getClusterSettings().get(SHARD_COUNT_LIMIT_SETTING);
        if ((long)shardCount > shardCountLimit) {
            throw new IllegalArgumentException("Trying to query " + shardCount + " shards, which is over the limit of " + shardCountLimit + ". This limit exists because querying many shards at the same time can make the job of the coordinating node very CPU and/or memory intensive. It is usually a better idea to have a smaller number of larger shards. Update [" + SHARD_COUNT_LIMIT_SETTING.getKey() + "] to a greater value if you really want to query that many shards at the same time.");
        }
    }

    private static void logCCSError(ShardSearchFailure f, String clusterAlias, boolean skipUnavailable) {
        String errorInfo;
        try {
            errorInfo = Strings.toString(f.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
        }
        catch (IOException ex) {
            errorInfo = f.toString();
        }
        logger.debug("CCS remote cluster failure. Cluster [{}]. skip_unavailable: [{}]. Error: {}", (Object)clusterAlias, (Object)skipUnavailable, (Object)errorInfo);
    }

    private static RemoteTransportException wrapRemoteClusterFailure(String clusterAlias, Exception e) {
        return new RemoteTransportException("error while communicating with remote cluster [" + clusterAlias + "]", e);
    }

    static List<SearchShardIterator> getLocalLocalShardsIteratorFromPointInTime(ClusterState clusterState, IndicesOptions indicesOptions, String localClusterAlias, SearchContextId searchContext, TimeValue keepAlive, boolean allowPartialSearchResults) {
        ArrayList<SearchShardIterator> iterators = new ArrayList<SearchShardIterator>(searchContext.shards().size());
        for (Map.Entry<ShardId, SearchContextIdForNode> entry : searchContext.shards().entrySet()) {
            ArrayList<String> targetNodes;
            ShardId shardId;
            SearchContextIdForNode perNode;
            block6: {
                perNode = entry.getValue();
                if (!Strings.isEmpty(perNode.getClusterAlias())) continue;
                shardId = entry.getKey();
                targetNodes = new ArrayList<String>(2);
                try {
                    ShardIterator shards = OperationRouting.getShards(clusterState, shardId);
                    if (clusterState.nodes().nodeExists(perNode.getNode())) {
                        targetNodes.add(perNode.getNode());
                    }
                    if (perNode.getSearchContextId().getSearcherId() != null) {
                        for (ShardRouting shard : shards) {
                            if (shard.currentNodeId().equals(perNode.getNode())) continue;
                            targetNodes.add(shard.currentNodeId());
                        }
                    }
                }
                catch (IndexNotFoundException | ShardNotFoundException e) {
                    if (allowPartialSearchResults) break block6;
                    throw e;
                }
            }
            OriginalIndices finalIndices = new OriginalIndices(new String[]{shardId.getIndexName()}, indicesOptions);
            iterators.add(new SearchShardIterator(localClusterAlias, shardId, targetNodes, finalIndices, perNode.getSearchContextId(), keepAlive, false, false));
        }
        return iterators;
    }

    List<SearchShardIterator> getLocalShardsIterator(ClusterState clusterState, SearchRequest searchRequest, String clusterAlias, Set<String> indicesAndAliases, String[] concreteIndices) {
        Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, searchRequest.routing(), searchRequest.indices());
        GroupShardsIterator<ShardIterator> shardRoutings = this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, searchRequest.preference(), this.searchService.getResponseCollectorService(), this.searchTransportService.getPendingSearchRequests());
        Map<String, OriginalIndices> originalIndices = this.buildPerIndexOriginalIndices(clusterState, indicesAndAliases, concreteIndices, searchRequest.indicesOptions());
        return StreamSupport.stream(shardRoutings.spliterator(), false).map(it -> {
            OriginalIndices finalIndices = (OriginalIndices)originalIndices.get(it.shardId().getIndex().getName());
            assert (finalIndices != null);
            return new SearchShardIterator(clusterAlias, it.shardId(), it.getShardRoutings(), finalIndices);
        }).toList();
    }

    public record SearchTimeProvider(long absoluteStartMillis, long relativeStartNanos, LongSupplier relativeCurrentNanosProvider) {
        public long buildTookInMillis() {
            return TimeUnit.NANOSECONDS.toMillis(this.relativeCurrentNanosProvider.getAsLong() - this.relativeStartNanos);
        }
    }

    static abstract class CCSActionListener<Response, FinalResponse>
    implements ActionListener<Response> {
        protected final String clusterAlias;
        protected final boolean skipUnavailable;
        private final CountDown countDown;
        private final AtomicReference<Exception> exceptions;
        protected final SearchResponse.Clusters clusters;
        private final ActionListener<FinalResponse> originalListener;

        CCSActionListener(String clusterAlias, boolean skipUnavailable, CountDown countDown, AtomicReference<Exception> exceptions, SearchResponse.Clusters clusters, ActionListener<FinalResponse> originalListener) {
            this.clusterAlias = clusterAlias;
            this.skipUnavailable = skipUnavailable;
            this.countDown = countDown;
            this.exceptions = exceptions;
            this.clusters = clusters;
            this.originalListener = originalListener;
        }

        @Override
        public final void onResponse(Response response) {
            this.innerOnResponse(response);
            this.maybeFinish();
        }

        abstract void innerOnResponse(Response var1);

        @Override
        public final void onFailure(Exception e) {
            ShardSearchFailure f = new ShardSearchFailure(e);
            TransportSearchAction.logCCSError(f, this.clusterAlias, this.skipUnavailable);
            SearchResponse.Cluster cluster = this.clusters.getCluster(this.clusterAlias);
            if (this.skipUnavailable) {
                if (cluster != null) {
                    TransportSearchAction.ccsClusterInfoUpdate(f, this.clusters, this.clusterAlias, true);
                }
            } else {
                if (cluster != null) {
                    TransportSearchAction.ccsClusterInfoUpdate(f, this.clusters, this.clusterAlias, false);
                }
                Exception exception = e;
                if (!"".equals(this.clusterAlias)) {
                    exception = TransportSearchAction.wrapRemoteClusterFailure(this.clusterAlias, e);
                }
                if (!this.exceptions.compareAndSet(null, exception)) {
                    this.exceptions.accumulateAndGet(exception, (previous, current) -> {
                        current.addSuppressed((Throwable)previous);
                        return current;
                    });
                }
            }
            this.maybeFinish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeFinish() {
            if (this.countDown.countDown()) {
                Exception exception = this.exceptions.get();
                if (exception == null) {
                    FinalResponse response;
                    try {
                        response = this.createFinalResponse();
                    }
                    catch (Exception e) {
                        this.originalListener.onFailure(e);
                        return;
                    }
                    try {
                        this.originalListener.onResponse(response);
                    }
                    finally {
                        this.releaseResponse(response);
                    }
                }
                this.originalListener.onFailure(this.exceptions.get());
            }
        }

        protected void releaseResponse(FinalResponse response) {
        }

        abstract FinalResponse createFinalResponse();
    }

    static interface SearchPhaseProvider {
        public SearchPhase newSearchPhase(SearchTask var1, SearchRequest var2, Executor var3, GroupShardsIterator<SearchShardIterator> var4, SearchTimeProvider var5, BiFunction<String, String, Transport.Connection> var6, ClusterState var7, Map<String, AliasFilter> var8, Map<String, Float> var9, boolean var10, ThreadPool var11, SearchResponse.Clusters var12);
    }

    private class AsyncSearchActionProvider
    implements SearchPhaseProvider {
        private final ActionListener<SearchResponse> listener;

        AsyncSearchActionProvider(ActionListener<SearchResponse> listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SearchPhase newSearchPhase(SearchTask task, SearchRequest searchRequest, Executor executor, GroupShardsIterator<SearchShardIterator> shardIterators, SearchTimeProvider timeProvider, BiFunction<String, String, Transport.Connection> connectionLookup, ClusterState clusterState, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, boolean preFilter, ThreadPool threadPool, SearchResponse.Clusters clusters) {
            if (preFilter) {
                return new CanMatchPreFilterSearchPhase(logger, TransportSearchAction.this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, threadPool.executor("search_coordination"), searchRequest, shardIterators, timeProvider, task, true, TransportSearchAction.this.searchService.getCoordinatorRewriteContextProvider(timeProvider::absoluteStartMillis), this.listener.delegateFailureAndWrap((l, iters) -> this.newSearchPhase(task, searchRequest, executor, (GroupShardsIterator<SearchShardIterator>)iters, timeProvider, connectionLookup, clusterState, aliasFilter, concreteIndexBoosts, false, threadPool, clusters).start()));
            }
            if (!clusters.isCcsMinimizeRoundtrips().booleanValue() && clusters.hasRemoteClusters() && task.getProgressListener() == SearchProgressListener.NOOP) {
                task.setProgressListener(new CCSSingleCoordinatorSearchProgressListener());
            }
            SearchPhaseResults<SearchPhaseResult> queryResultConsumer = TransportSearchAction.this.searchPhaseController.newSearchPhaseResults(executor, TransportSearchAction.this.circuitBreaker, task::isCancelled, task.getProgressListener(), searchRequest, shardIterators.size(), exc -> TransportSearchAction.this.searchTransportService.cancelSearchTask(task, "failed to merge result [" + exc.getMessage() + "]"));
            boolean success = false;
            try {
                AbstractSearchAsyncAction searchPhase;
                if (searchRequest.searchType() == SearchType.DFS_QUERY_THEN_FETCH) {
                    searchPhase = new SearchDfsQueryThenFetchAsyncAction(logger, TransportSearchAction.this.namedWriteableRegistry, TransportSearchAction.this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, executor, queryResultConsumer, searchRequest, this.listener, shardIterators, timeProvider, clusterState, task, clusters, TransportSearchAction.this.client);
                } else {
                    assert (searchRequest.searchType() == SearchType.QUERY_THEN_FETCH) : searchRequest.searchType();
                    searchPhase = new SearchQueryThenFetchAsyncAction(logger, TransportSearchAction.this.namedWriteableRegistry, TransportSearchAction.this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, executor, queryResultConsumer, searchRequest, this.listener, shardIterators, timeProvider, clusterState, task, clusters, TransportSearchAction.this.client);
                }
                success = true;
                AbstractSearchAsyncAction abstractSearchAsyncAction = searchPhase;
                return abstractSearchAsyncAction;
            }
            finally {
                if (!success) {
                    queryResultConsumer.close();
                }
            }
        }
    }
}

