/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Base64;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class OpenPointInTimeResponse
extends ActionResponse
implements ToXContentObject {
    private final BytesReference pointInTimeId;

    public OpenPointInTimeResponse(BytesReference pointInTimeId) {
        this.pointInTimeId = Objects.requireNonNull(pointInTimeId, "Point in time parameter must be not null");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBytesReference(this.pointInTimeId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", Base64.getUrlEncoder().encodeToString(BytesReference.toBytes(this.pointInTimeId)));
        builder.endObject();
        return builder;
    }

    public BytesReference getPointInTimeId() {
        return this.pointInTimeId;
    }
}

