/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams.lifecycle;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class PutDataStreamLifecycleAction {
    public static final ActionType<AcknowledgedResponse> INSTANCE = new ActionType("indices:admin/data_stream/lifecycle/put");

    private PutDataStreamLifecycleAction() {
    }

    public static final class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest.Replaceable,
    ToXContentObject {
        public static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("put_data_stream_lifecycle_request", args -> new Request(null, (TimeValue)args[0], (Boolean)args[1], (DataStreamLifecycle.Downsampling)args[2]));
        private String[] names;
        private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, true, true, true, false, false, true, false);
        private final DataStreamLifecycle lifecycle;

        public static Request parseRequest(XContentParser parser) {
            return (Request)PARSER.apply(parser, null);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
            this.lifecycle = new DataStreamLifecycle(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
            out.writeWriteable(this.lifecycle);
        }

        public Request(String[] names, @Nullable TimeValue dataRetention) {
            this(names, dataRetention, null, null);
        }

        public Request(String[] names, DataStreamLifecycle lifecycle) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.names = names;
            this.lifecycle = lifecycle;
        }

        public Request(String[] names, @Nullable TimeValue dataRetention, @Nullable Boolean enabled) {
            this(names, dataRetention, enabled, null);
        }

        public Request(String[] names, @Nullable TimeValue dataRetention, @Nullable Boolean enabled, @Nullable DataStreamLifecycle.Downsampling downsampling) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.names = names;
            this.lifecycle = DataStreamLifecycle.newBuilder().dataRetention(dataRetention).enabled(enabled == null || enabled != false).downsampling(downsampling).build();
        }

        public String[] getNames() {
            return this.names;
        }

        public DataStreamLifecycle getLifecycle() {
            return this.lifecycle;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("lifecycle", (ToXContent)this.lifecycle);
            builder.endObject();
            return builder;
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names) && Objects.equals(this.indicesOptions, request.indicesOptions) && this.lifecycle.equals(request.lifecycle);
        }

        public int hashCode() {
            int result = Objects.hash(this.indicesOptions, this.lifecycle);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        @Override
        public IndicesRequest indices(String ... names) {
            this.names = names;
            return this;
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.textOrNull(), (String)DataStreamLifecycle.DATA_RETENTION_FIELD.getPreferredName()), DataStreamLifecycle.DATA_RETENTION_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), DataStreamLifecycle.ENABLED_FIELD);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                    return DataStreamLifecycle.Downsampling.NULL;
                }
                return new DataStreamLifecycle.Downsampling(AbstractObjectParser.parseArray((XContentParser)p, (Object)c, DataStreamLifecycle.Downsampling.Round::fromXContent));
            }, DataStreamLifecycle.DOWNSAMPLING_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_NULL);
        }
    }
}

